; $Id: setup_tia_base.asm bdupeyron.tech@gmail.com(Antichambre)
	LIST R=DEC
;
; Prepared Setup File for TIA base module
;

	;; here you can change the default device ID - if you are using
	;; some cores as slave, set:
	;;    o DEFAULT_DEVICE_ID 0x01	; for the first slave
	;;    o DEFAULT_DEVICE_ID 0x02	; for the second slave
	;;    o DEFAULT_DEVICE_ID 0x03	; for the third slave
#define DEFAULT_DEVICE_ID 0x00

	;; if this option is enabled (1), the DEFAULT_DEVICE_ID won't be used, but
	;; it will be automatically derived from the MIOS Device ID instead
#define AUTO_DEVICE_ID	1
	
	;; default MIDI channel:
#define DEFAULT_MIDI_CHANNEL  1

    ;; if != 0, special variations for cartridge version hardware:
#define DEFAULT_IS_CARTRIDGE  0

    ;; Kit and Wavetable fisrt:
    ;;      positionbanks start at this bankstick address(id):
    ;;      Becarrefull! Change this value may reformat your BankStick
    ;;      look at DEFAULT_BS_FPROTECT Value *!
#define DEFAULT_BS_KBANK_ID   5
    ;; Default BankStick format protection:
    ;;      0: No protection.
    ;;     *1: Protects banks which are not good type or position.
    ;;      Depend on DEFAULT_BS_KBANK_ID.
    ;;      2: Never format at startup (Sysex command available).
#define DEFAULT_BS_FPROTECT   1
    ;; BankStick read only:
#define DEFAULT_BS_READONLY   0

    ;; Default EEPROM Protection:
    ;;      Eeprom read only:
#define DEFAULT_EE_READONLY   0
    ;;      internal patch Protection

    ;; Default Debugger Options:
    ;;      Degug Enabled/disabled
#define DEFAULT_TIA_DEBUG_ON  1
    ;;      BankStick Degug Enabled/disabled
#define DEFAULT_TIA_DEBUG_BS  1
    ;;      BankStick Degug Mode
    ;;      0: Basic.
    ;;      1: Advanced.
#define DEFAULT_TIA_DEBUG_BS_MODE    1
    ;;      Eeprom Degug Enabled/disabled
    ;;      no effect if DEFAULT_TIA_DEBUG_ON == 0
#define DEFAULT_TIA_DEBUG_EE  1

	;; use PORTA and PORTE (J5 of the core module) as output
	;; you can address these pins in cs_menu_io_tables.inc as "shift register" #0
#define ENABLE_J5 0

#define TIA_LEDMTR_ENABLE	0
    ;; define the shift registers (note: HERE the shift register begin with 0: 1st SR is 0, 2nd is 1, 3rd is 2, ...)
#define TIA_LEDMTR_REG	0	; shift register for led metering (HERE: first shift register in the chain)
#define TIA_LEDMTR_SPEED	64	; speed for the led metering (xxx is good one)

    ;; For MIDI activity monitor:
#define DEFAULT_MIDI_MONITOR_ENABLED 0  ; if 1, the Tx/Rx LEDs are enabled
    ;;define the DOUT pins for the Rx and Tx LED:
    ;; if 0: MIDI Rx/Tx LEDs are assigned to the DOUT chain, pin 0x00-0x7f
    ;; if 1: MIDI Rx/Tx LEDs are assigned to specials pins
#define MIDI_RXTX_USE_IO       1	                                  
#if MIDI_RXTX_USE_IO 
#define DEFAULT_MIDI_RX_LAT LATD
#define DEFAULT_MIDI_RX_TRIS TRISD
#define DEFAULT_MIDI_RX_PIN 6	; Pin D.6
#define DEFAULT_MIDI_TX_LAT LATD
#define DEFAULT_MIDI_TX_TRIS TRISD
#define DEFAULT_MIDI_TX_PIN 7	; Pin D.7
#else
#define DEFAULT_MIDI_RX_LED 0x41	; DOUT SR#9, pin D1
#define DEFAULT_MIDI_TX_LED 0x42	; DOUT SR#9, pin D2
#endif

	;; define the AOUT interface which is used here:
	;;   1: one MBHP_AOUT module
	;;   2: up to 4 (chained) MBHP_AOUT_LC modules
	;;   3: one MBHP_AOUT_NG module
	;; all other values invalid!
#define AOUT_INTERFACE_TYPE 0

	;; only relevant if one or more AOUT_LC modules are used:
	;; define the resolution configuration here
	;;   0: first channel 12bit, second channel 4bit
	;;   1: first channel 8bit, second channel 8bit
	;;   2: combines M1,M2 and/or M3/M4: first channel 12bit, second channel 12bit, third channel 8bit, fourth channel ignored!
	;; all other values invalid!
#define AOUT_LC_RESOLUTION_OPTION_M1 0
#define AOUT_LC_RESOLUTION_OPTION_M2 0
#define AOUT_LC_RESOLUTION_OPTION_M3 0
#define AOUT_LC_RESOLUTION_OPTION_M4 0

	;; enable the 6th LFO waveform (analog inputs)
#define ENABLE_AIN_LFO_WAVEFORM 0

#include "src/main.inc"
