; $Id: tia_patch.inc bdupeyron.tech@gmail.com(Antichambre)
;
; TIA Patch routines
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================


;; --------------------------------------------------------------------------
;;  Init Routine for patch parameters
;;  Note that the MIDI events are initialized separately, this routine will
;;  be called on power-on and after a new MIDI dump has been loaded
;; --------------------------------------------------------------------------
TIA_PATCH_Init
	;; disable TIA engine
	bsf	TIA_STAT, TIA_STAT_ENGINE_DISABLE

	;; clear the whole TIA SFR memory space
	movlw	((TIA_SW_CLEAR_END-TIA_SW_CLEAR_BEGIN)+1) & 0xff
	movwf	TMP1
	lfsr	FSR0, TIA_SW_CLEAR_BEGIN
TIA_PATCH_Init_ClearLoop
	clrf	POSTINC0
	decfsz	TMP1, F
	rgoto	TIA_PATCH_Init_ClearLoop

	;; fetch 128 TIA parameters from EEPROM
	clrf	TMP1
    movlw   EEPROM_PATCH & 0xff
	movwf	EEADR
    movlw   (EEPROM_PATCH >> 8) & 0xff
    movwf   EEADRH
    movff   TIA_PBANK, TIA_BANK
    movff   TIA_PATCH, TIA_PRESET
TIA_PATCH_InitEELoop
	movf	TMP1, W
	call	TIA_SYSEX_TABLE_Get; get CC number
	movwf	TMP2		; temporary store number in TMP2

	movff	TMP1, EEADR	; read parameter from current TIA bank
	call	TIA_BANK_Read
    movwf	MIOS_PARAMETER1	; store value in MIOS_PARAMETER1

	;; branch depending on TMP2[7..4]
	BRA_IFSET TMP2, 7, ACCESS, TIA_PATCH_InitEELoopS
TIA_PATCH_InitEELoopN
	;; if TMP2[7] == 0, then set CC parameter
	movf	TMP2, W
	call	TIA_CCIN_Set
	rgoto	TIA_PATCH_InitEELoopC
TIA_PATCH_InitEELoopS
	;; if TMP2[7..4] == 9, then set split point
	movf	TMP2, W
	andlw	0xf0
	xorlw	0x90
	bnz	TIA_PATCH_InitEELoopC
	movf	TMP2, W
	rcall	TIA_PATCH_GetSplitPointer
	movff	MIOS_PARAMETER1, INDF1
TIA_PATCH_InitEELoopC

	incf	TMP1, F		; increment CC counter, loop until 0x80
	BRA_IFCLR TMP1, 7, ACCESS, TIA_PATCH_InitEELoop

	;; get and store the MIDI channels
	movlw	EEPROM_CFG_BASE & 0xff
	movwf	EEADR
	call	MIOS_EEPROM_Read
	movff	WREG, TIA_V2_BASE + TIA_Vx_MIDI_CHANNEL
	call	MIOS_EEPROM_Read
	movff	WREG, TIA_V1_BASE + TIA_Vx_MIDI_CHANNEL
	;; get and store the device ID
	call	MIOS_EEPROM_Read	
#if AUTO_DEVICE_ID
	;; if AUTO_ID enabled, derive the TIA device ID from the MIOS device ID instead
	call	MIOS_MIDI_DeviceIDGet
#endif
	movwf	TIA_MIDI_DEVICE
    
    call	MIOS_EEPROM_Read
    ;; Empty

	;; force a refresh of all registers
	bsf	TIA_STAT, TIA_STAT_FORCE_REFRESH

	;; enable TIA engine again
	bcf	TIA_STAT, TIA_STAT_ENGINE_DISABLE

#if DEFAULT_TIA_DEBUG_ON == 1 
    bsf TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_PINIT
    call    TIA_Debug_EE_Do
    bsf TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_PINIT
    call    TIA_Debug_BS_Do
#endif
	return



;; --------------------------------------------------------------------------
;;  This help routine returns the pointer to TIA_Vx_SPLIT_xxx depending
;;  on WREG
;;  OUT: pointer in FSR1
;; --------------------------------------------------------------------------
TIA_PATCH_GetSplitPointer
	lfsr	FSR1, TIA_V1_BASE + TIA_Vx_SPLIT_LOWER
	btfsc	WREG, 0
	lfsr	FSR1, TIA_V1_BASE + TIA_Vx_SPLIT_UPPER
	
	rrf	WREG, W
	andlw	0x01
	mullw	TIA_Vx_RECORD_LEN
	movf	PRODL, W
	addwf	FSR1L, F
	return
