; $Id: app_defines.h bdupeyron.tech@gmail.com(Antichambre)
;
; Specific Defines and variables of MIOS Application
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================

#define TIA_STAT_ENGINE_DISABLE		0   ; if set, TIA tick and TIA interrupt will not be processed
#define TIA_STAT_FORCE_REFRESH		1   ; if set, a refresh will be forced with next TIA_Tick
#define TIA_STAT_CC_DUMP_REQ		2   ; if set, a CC dump will be sent
#define TIA_STAT_SAVED_GIE          3   ; save the GIE bit for nested interrupt disables
#define TIA_STAT_TRIGGER_RESET		4   ; if set, the TIA will be reset with next TIA_Tick

;; ==========================================================================

#define TIA_PLAY_MODE_POLY          0
#define TIA_PLAY_MODE_SUS_KEY		1
#define TIA_PLAY_MODE_LEGATO_OFF	2
#define TIA_PLAY_MODE_ONLY_WT_OFF	3

;; ==========================================================================
#define TIA_MIDI_SYNC_SEND_CLK		0	; send MIDI clock
#define TIA_MIDI_SYNC_F8            4	; bit 4 notifies a received MIDI clock
#define	TIA_MIDI_SYNC_FA            5	; bit 5 notifies a received MIDI clock start
#define TIA_MIDI_SYNC_TICK_1        6   ; bit 6 notifies that the TIA_SW engine should be clocked with common resolution
#define TIA_MIDI_SYNC_TICK_2        7   ; bit 7 notifies that the TIA_SW engine should be clocked with double resolution

;; ==========================================================================

#define TIA_MOD_SYNC_LFO1           0	; sync LFO1
#define TIA_MOD_SYNC_LFO2           1	; sync LFO2
#define TIA_MOD_SYNC_LFO3           2	; sync LFO3
#define TIA_MOD_SYNC_LFO4           3	; sync LFO4
#define TIA_MOD_SYNC_ENV1           4	; sync ENV1
#define	TIA_MOD_SYNC_ENV2           5	; sync ENV2

;; ==========================================================================

#define BANKSTICK_MAGIC0	0x83; magic numbers - if they don't exists in bankstick at BANK_MAGIC_ADDRESS,
#define BANKSTICK_MAGICP	0x12 ; the stick will be ignored until it has been formatted
#define BANKSTICK_MAGICK	BANKSTICK_MAGICP+1 ; the stick will be ignored until it has been formatted

;; ==========================================================================

#define REG_TEMP_TEST_FLAG	0
#define REG_TEMP_UP_FLAG	1
#define REG_TEMP_DOWN_FLAG	2

#if DEFAULT_TIA_DEBUG_ON == 1 
;;#if DEFAULT_TIA_DEBUG_BS == 1   ;; for BankStick
#define TIA_DEBUG_EE_FLAG		0   ;;REGA flag
#define TIA_DEBUG_EE_RW 		1   ;;REGA RW:0=Read/1=Write
#define TIA_DEBUG_EE_PAGE 		2   ;;REGA RW:0=One byte/1=One Page(64 bytes)
#define TIA_DEBUG_EE_ERROR		3   ;;REGA 0=No Error/1=Error
#define TIA_DEBUG_EE_READONLY   4   ;;REGA RW:0=No Error/1=Error
#define TIA_DEBUG_EE_WRERR      5   ;;REGA 0=No Error/1=Error
#define TIA_DEBUG_EE_PINIT      6   ;;REGA RW:0=No Error/1=Error
#define TIA_DEBUG_EE_SYX        7   ;;REGA RW:0=No Error/1=Error

#define TIA_DEBUG_EE_PK			0   ;;REGB 0=Patch/1=Kit/Wavetable
#define TIA_DEBUG_EE_WT         1   ;;REGB 0=Kit/1=Wavetable
#define TIA_DEBUG_BS_RWCHK		2   ;;REGB 0=Read/Write/1=Check
#define TIA_DEBUG_BS_SIZE		3   ;;REGB 0=Internal/1=External
#define TIA_DEBUG_BS_INTEXT		4   ;;REGB Chk:0=32k/1=64k
#define TIA_DEBUG_BS_FORMAT		5   ;;REGB Chk:0=Connected! Ok/1=Reformated!
#define TIA_DEBUG_BS_FPROTECT   6   ;;REGB Chk:format protected
#define TIA_DEBUG_BS_TPROTECT	7   ;;REGB Chk:type protected
#define TIA_DEBUG_BS_READY      5   ;;REGB Chk:bankstick ready     
;;#endif
#endif

;; ==========================================================================
	;; free memory for user applications:	
	;; 0x010-0x37f

;; ==========================================================================
;;  General TIA Control Variables in ACCESS page
;; ==========================================================================
TIA_STAT		EQU	0x010

TIA_BANK                EQU	0x011
TIA_PRESET              EQU	0x012
TIA_PATCH               EQU	0x013
TIA_PBANK               EQU	0x014
TIA_KIT                 EQU	0x015
TIA_KBANK               EQU	0x016
TIA_WT                  EQU	0x017
TIA_WBANK               EQU	0x018
TIA_BANKSTICK_CHK_CTR	EQU	0x019
TIA_BANKSTICK_ID        EQU	0x01a
TIA_BANKSTICK_RDY       EQU	0x01b
TIA_BANKSTICK_STAT      EQU	0x01c
TIA_BANKSTICK_SIZE      EQU	0x01d

TIA_MIDI_DEVICE         EQU	0x020

;; ==========================================================================
;;  Variables used by the MIDI processor in tia_sysex.inc
;; ==========================================================================
TIA_SYSEX_STATE		EQU	0x021
TIA_SYSEX_ACTION	EQU	0x022
TIA_SYSEX_IN		EQU	0x023
TIA_SYSEX_CHECKSUM	EQU	0x024
TIA_SYSEX_ADDRESS	EQU	0x025
TIA_SYSEX_ERROR     EQU 0x026

;; ==========================================================================
;; free: 0x27-0x5a

;;temporary
REG_TEMP	EQU	0x030
REG_TEMP2	EQU	0x031
REG_TEMP3	EQU	0x032
REG_TEMP4	EQU	0x033

REG_TEMP5	EQU	0x034
REG_TEMP6	EQU	0x035
;; ==========================================================================

#if DEFAULT_TIA_DEBUG_ON == 1
#if DEFAULT_TIA_DEBUG_BS == 1   ;; for BankStick
TIA_DEBUG_BS_REGA		EQU	0x05b
TIA_DEBUG_BS_REG1       EQU	0x05c
TIA_DEBUG_BS_REG2       EQU	0x05d
TIA_DEBUG_BS_REG3		EQU	0x05e
TIA_DEBUG_BS_REG4		EQU	0x05f
TIA_DEBUG_BS_REG5		EQU	0x060
TIA_DEBUG_BS_REG6		EQU	0x061
TIA_DEBUG_BS_REGB		EQU	0x062
TIA_DEBUG_BS_REG9		EQU	0x063
#endif
#if DEFAULT_TIA_DEBUG_EE == 1   ;; for BankStick
TIA_DEBUG_EE_REGA		EQU	0x064
TIA_DEBUG_EE_REG1       EQU	0x065
TIA_DEBUG_EE_REG2		EQU	0x066
#endif
#endif

;; ==========================================================================

MIDI_RXTX_RX_CTR	EQU	0x067
MIDI_RXTX_TX_CTR	EQU	0x068
MIDI_RXTX_BEAT_CTR	EQU	0x069

;; ==========================================================================

TIA_LEDMTR_STAT     EQU	0x06a
TIA_LEDMTR_VALUE	EQU	0x06b

;; ==========================================================================

AOUT_FILTER_TMP_L	EQU	0x06c	; used in tia_sw.inc as temporary storage for [filter value
AOUT_FILTER_TMP_H	EQU	0x06d

;; ==========================================================================

AOUT_INVERTED		EQU	0x06e
AOUT_UPDATE_REQ		EQU	0x06f
AOUT_VALUES		EQU	0x070  ; ..0x07f (8 * 16bit words)

;; ==========================================================================
	;; note: 0x080-0x0ff used by CS_TIAS1
;; ==========================================================================
;;  a lot of TIA control variables in BANKED page
;; ==========================================================================
TIA_SW_CLEAR_BEGIN	EQU	0x100		; used to initialize the whole TIA_SW memory
TIA_SW_CLEAR_END		EQU	0x1ff		; also used as 256 byte download buffer (!)                                                            
                                                            
TIA_BASE          EQU	0x100           ; address space of TIA chip (used: 0x00-0x05)

TIA_AUDC0      EQU TIA_BASE+0x00	;; control. for voice 1 (Aud0)
TIA_AUDC1      EQU TIA_BASE+0x01	;; control. for voice 2 (Aud1)
TIA_AUDF0      EQU TIA_BASE+0x02	;; freq. for voice 1 (Aud0)
TIA_AUDF1      EQU TIA_BASE+0x03	;; freq. for voice 2 (Aud1)
TIA_AUDV0      EQU TIA_BASE+0x04	;; vol. for voice 1 (Aud0)
TIA_AUDV1      EQU TIA_BASE+0x05	;; vol. for voice 2 (Aud1)
                                                              
TIA_MASTER_VOL          EQU	TIA_BASE+0x0b	; internal TIA_SW register
TIA_PLAY_MODE           EQU	TIA_BASE+0x0c	; internal TIA_SW register
TIA_SE_OPTION           EQU	TIA_BASE+0x0d	; internal TIA_SW register
TIA_SW_VOICE            EQU	TIA_BASE+0x0e 	; internal TIA_SW register
TIA_SW_LFO_NUMBER       EQU	TIA_BASE+0x0f 	; internal TIA_SW register
TIA_SW_ENV_NUMBER       EQU	TIA_SW_LFO_NUMBER

TIA_BASE_END		EQU	0x10f

;; ==========================================================================

TIA_SHADOW_BASE		EQU	0x110		; shadow addresses, necessary to determine changes (used: 0x00-0x05)

	;; (TIA_SHADOW_BASE + 0x00) to (TIA_SHADOW_BASE + 0x05) allocated by shadow registers

TIA_LFO_RANDOM_SEED_L	EQU	TIA_SHADOW_BASE+0x0c	; internal TIA_SW register
TIA_LFO_RANDOM_SEED_H	EQU	TIA_SHADOW_BASE+0x0d	; internal TIA_SW register
TIA_ENVx_CURVES         EQU	TIA_SHADOW_BASE+0x0e	; internal TIA_SW register
TIA_MOD_SYNC            EQU	TIA_SHADOW_BASE+0x0f	; internal TIA_SW register

TIA_SHADOW_END		EQU	0x11f

;; ==========================================================================

TIA_Vx_RECORD_LEN	EQU	64      ;; 64 Max

TIA_Vx_MIDI_CHANNEL       EQU	0x00
TIA_Vx_SPLIT_LOWER        EQU	0x01
TIA_Vx_SPLIT_UPPER        EQU	0x02
TIA_Vx_STAT               EQU	0x03
TIA_Vx_MODE               EQU	0x04    ; Always follow TIA_Vx_STAT
TIA_Vx_KEY_OFFSET         EQU	0x05
TIA_Vx_KEY_LENGTH         EQU	0x06
TIA_Vx_TARGET_FRQ_L       EQU	0x07
TIA_Vx_TARGET_FRQ_H       EQU	0x08
TIA_Vx_FRQ_L              EQU	0x09
TIA_Vx_FRQ_H              EQU	0x0a
TIA_Vx_PITCHBENDER        EQU	0x0b
TIA_Vx_TRANSPOSE          EQU	0x0c
TIA_Vx_PITCHRANGE         EQU	0x0d
TIA_Vx_PORTA_RATE         EQU	0x0e
TIA_Vx_VOLUME             EQU	0x0f
TIA_Vx_NOTE               EQU	0x10
TIA_Vx_NOTE_DELAY         EQU	0x11
TIA_Vx_NOTE_DELAY_CTR     EQU	0x12
TIA_Vx_ARP_RATE           EQU	0x13
TIA_Vx_ARP_NOTE_NUMBER    EQU	0x14
TIA_Vx_ARP_CTR            EQU	0x15
TIA_Vx_PITCH_MOD          EQU	0x16
TIA_Vx_AMP_MOD            EQU	0x17
TIA_Vx_SPARE              EQU	0x18
               
TIA_Vx_SPARE1             EQU	0x19	; allocated
TIA_Vx_SPARE2             EQU	0x1a	; only free of constant time portamento not activated
TIA_Vx_SPARE3             EQU	0x1b	; only free of constant time portamento not activated
TIA_Vx_SPARE4             EQU	0x1c	; only free of constant time portamento not activated
TIA_Vx_SPARE5             EQU	0x1d	; only free of constant time portamento not activated

TIA_Vx_PORTA_CTR_L        EQU   TIA_Vx_SPARE2
TIA_Vx_PORTA_CTR_H        EQU	TIA_Vx_SPARE3
TIA_Vx_PORTA_FRQ_L        EQU   TIA_Vx_SPARE4
TIA_Vx_PORTA_FRQ_H        EQU	TIA_Vx_SPARE5
                                                              
TIA_Vx_ARP_NOTE_0         EQU	0x1e
TIA_Vx_ARP_NOTE_1         EQU	0x1f
TIA_Vx_ARP_NOTE_2         EQU	0x20
TIA_Vx_ARP_NOTE_3         EQU	0x21
TIA_Vx_NOTE_STACK_0       EQU	0x22
TIA_Vx_NOTE_STACK_1       EQU	0x23
TIA_Vx_NOTE_STACK_2       EQU	0x24
TIA_Vx_NOTE_STACK_3       EQU	0x25
TIA_NOTE_STACK_LEN        EQU	TIA_Vx_NOTE_STACK_3-TIA_Vx_NOTE_STACK_0+1

TIA_Vx_ASSIGN_VELOCITY    EQU	0x26
TIA_Vx_INIT_VELOCITY      EQU	0x27
TIA_Vx_LAST_VELOCITY      EQU	0x28
TIA_Vx_DEPTH_VELOCITY     EQU	0x29

TIA_Vx_ENV_OPTION         EQU	0x2a
TIA_Vx_OPTION             EQU	0x2b
TIA_Vx_WBANK              EQU	0x2c
TIA_Vx_WT                 EQU	0x2d
TIA_Vx_WT_STATE           EQU	0x2e
TIA_Vx_WT_RATE            EQU	0x2f
TIA_Vx_WT_CLK_REQ_CTR     EQU	0x30
TIA_Vx_WT_CTR             EQU	0x31
TIA_Vx_WT_POS             EQU	0x32
TIA_Vx_WT_SAVED_PATCH	  EQU	0x33 ;; a eliminer
TIA_Vx_WT_ASSIGN_P1       EQU	0x34
TIA_Vx_WT_ASSIGN_P2       EQU	0x35
TIA_Vx_WT_ASSIGN_P3       EQU	0x36
TIA_Vx_KBANK              EQU	0x37
TIA_Vx_KIT                EQU	0x38
TIA_Vx_KIT_STATE          EQU	0x39
TIA_Vx_KIT_RATE           EQU	0x3a
TIA_Vx_KIT_CLK_REQ_CTR    EQU	0x3b
TIA_Vx_KIT_CTR            EQU	0x3c
TIA_Vx_KIT_POS            EQU	0x3d

TIA_Vx_FREE1              EQU	0x3e
TIA_Vx_FREE2              EQU	0x3f
                                                                               
TIA_V1_BASE		EQU	0x120 + 0 * TIA_Vx_RECORD_LEN	; 0x0120-0x15f
TIA_V2_BASE		EQU	0x120 + 1 * TIA_Vx_RECORD_LEN	; 0x0160-0x19f

;; ==========================================================================

TIA_LFOx_RECORD_LEN	EQU	7
TIA_LFOx_MODE       EQU	0x00
TIA_LFOx_RATE       EQU	0x01
TIA_LFOx_CTR        EQU	0x02
TIA_LFOx_VALUE		EQU	0x03
TIA_LFOx_DEPTH		EQU	0x04
TIA_LFOx_RVALUE_L   EQU	0x05
TIA_LFOx_RVALUE_H   EQU	0x06

TIA_LFO1_BASE		EQU	0x1a0 + 0 * TIA_LFOx_RECORD_LEN	; 0x1a0-0x1a6
TIA_LFO2_BASE		EQU	0x1a0 + 1 * TIA_LFOx_RECORD_LEN	; 0x1a7-0x1ad
TIA_LFO3_BASE		EQU	0x1a0 + 2 * TIA_LFOx_RECORD_LEN	; 0x1ae-0x1b4
TIA_LFO4_BASE		EQU	0x1a0 + 3 * TIA_LFOx_RECORD_LEN	; 0x1b5-0x1bb

;; ==========================================================================

TIA_ENVx_RECORD_LEN	EQU	11
TIA_ENVx_MODE       EQU	0x00
TIA_ENVx_CTR_L		EQU	0x01

TIA_ENVx_CTR_H		EQU	0x02
TIA_ENVx_ATTACK		EQU	0x03
TIA_ENVx_DECAY		EQU	0x04
TIA_ENVx_SUSTAIN    EQU	0x05
TIA_ENVx_RELEASE    EQU	0x06
TIA_ENVx_CURVE		EQU	0x07
TIA_ENVx_DEPTH		EQU	0x08
TIA_ENVx_RVALUE_L   EQU	0x09
TIA_ENVx_RVALUE_H   EQU	0x0a

TIA_ENVAUD0_BASE	EQU	0x1bc + 0 * TIA_ENVx_RECORD_LEN	; 0x1bc-0x1c6
TIA_ENVAUD1_BASE	EQU	0x1bc + 1 * TIA_ENVx_RECORD_LEN	; 0x1c7-0x1d1
TIA_ENV1_BASE		EQU	0x1bc + 2 * TIA_ENVx_RECORD_LEN	; 0x1d2-0x1dc
TIA_ENV2_BASE		EQU	0x1bc + 3 * TIA_ENVx_RECORD_LEN	; 0x1dd-0x1e7

;; ==========================================================================

TIA_CTRLx_RECORD_LEN	EQU	4
TIA_CTRLx_ASSIGN        EQU	0x00
TIA_CTRLx_INIT          EQU	0x01
TIA_CTRLx_LAST          EQU	0x02
TIA_CTRLx_DEPTH         EQU	0x03

TIA_CTRL_AFTERTOUCH_BASE	EQU	0x1e8 + 0 * TIA_CTRLx_RECORD_LEN	; 0x1e8-0x1eb
TIA_CTRL_MODWHEEL_BASE		EQU	0x1e8 + 1 * TIA_CTRLx_RECORD_LEN	; 0x1ec-0x1ef

;; ==========================================================================

TIA_MIDI_SYNC		EQU	0x1f0
TIA_MIDI_SYNC_CTR	EQU	0x1f1
TIA_MIDI_SYNC_CTR_REG	EQU	0x1f2
                                                                               
;; ==========================================================================
                                                                               
; free 0x1f4-0x1f5
;; ==========================================================================

SAVED_PRODL		EQU	0x1f6	; used by tia_sw.inc
SAVED_PRODH		EQU	0x1f7	; used by tia_sw.inc

;; ==========================================================================
MUL_A_L			EQU	0x1f8	; used by math_mul16_16.inc
MUL_A_H			EQU	0x1f9
MUL_B_L			EQU	0x1fa
MUL_B_H			EQU	0x1fb
MUL_R_0			EQU	0x1fc
MUL_R_1			EQU	0x1fd
MUL_R_2			EQU	0x1fe
MUL_R_3			EQU	0x1ff

                                                              
DIV_A_0			EQU	MUL_A_L	; used by math_div16_16.inc
DIV_A_1			EQU	MUL_A_H
DIV_A_2			EQU	MUL_B_L
DIV_B_0			EQU	MUL_B_H
DIV_B_1			EQU	MUL_R_0
DIV_COUNT		EQU	MUL_R_1
DIV_REM_0		EQU	MUL_R_2
DIV_REM_1		EQU	MUL_R_3


;; ==========================================================================
BANKSTICK_FORMAT_BEGIN	EQU	0x700		; buffer temporary used to format the BankStick
BANKSTICK_FORMAT_END	EQU	0x7ff           ; CS variables have to be initialized again after formatting


                             


                             
;; ==========================================================================

                             
                             
                             ;;free 0x3c8-0x37f
