; $Id: tia_cc_table.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; CC Table
; used by tia_ccin.inc and tia_ccout.inc
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================


SET_CC_NOP          EQU	0x00
SET_CC_V12		EQU	0x01
SET_CC_7BIT         EQU	0x02
SET_CC_7BIT_W_PORTA	EQU	0x03
SET_CC_7BIT_4L		EQU	0x04
SET_CC_7BIT_4U		EQU	0x05
SET_CC_SUSKEY		EQU	0x06
SET_CC_VELOCITY		EQU	0x07
SET_CC_AFTERTOUCH	EQU	0x08
SET_CC_MODWHEEL		EQU	0x09
SET_CC_WAVEFORM		EQU	0x0a
SET_CC_CTRL_4L      EQU	0x0b
SET_CC_CTRL_4U      EQU	0x0c
SET_CC_PLAY_MODE    EQU	0x0d
SET_CC_DEBUG        EQU	0x0e
SET_CC_PLAY_NOTE    EQU 0x0f

;; --------------------------------------------------------------------------
;;  IN: index of CC parameter in WREG
;;  OUT: reads CC table and returns command in MIOS_PARAMETER2 and parameter
;; --------------------------------------------------------------------------
TIA_CC_TABLE_Get
	SET_BSR	TIA_BASE		; prepare BSR for TIA register access
	lfsr	FSR1, TIA_BASE		; prepare FSR1

	clrc
	rlf	WREG, W
	addlw	TIA_CC_TABLE & 0xff
	movwf	TBLPTRL
	clrf	TBLPTRH
	movlw	TIA_CC_TABLE >> 8
	addwfc	TBLPTRH, F

	tblrd*+
	movff	TABLAT, MIOS_PARAMETER2	; -> command
	tblrd*+
	movff	TABLAT, FSR1L		; -> parameter
	return


; ==========================================================================

TIA_CC_TABLE
	;; 0x00-0x0f
	db	SET_CC_NOP,				0x00
	db	SET_CC_MODWHEEL,				(TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_LAST) & 0xff
	db	SET_CC_MODWHEEL,				(TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_INIT) & 0xff
	db	SET_CC_AFTERTOUCH,				(TIA_CTRL_AFTERTOUCH_BASE + TIA_CTRLx_INIT) & 0xff
	db	SET_CC_V12,                 0x05
	db	SET_CC_VELOCITY,                (TIA_V1_BASE + TIA_Vx_INIT_VELOCITY) & 0xff
	db	SET_CC_VELOCITY,				(TIA_V2_BASE + TIA_Vx_INIT_VELOCITY) & 0xff
	db	SET_CC_7BIT,					TIA_MASTER_VOL & 0xff    
	db	SET_CC_V12,                 0x09
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_VOLUME) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_VOLUME) & 0xff
	db	SET_CC_MODWHEEL,				(TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_DEPTH) & 0xff
	db	SET_CC_AFTERTOUCH,				(TIA_CTRL_AFTERTOUCH_BASE + TIA_CTRLx_DEPTH) & 0xff
	db	SET_CC_V12,                 0x0e
	db	SET_CC_7BIT,                    (TIA_V1_BASE + TIA_Vx_DEPTH_VELOCITY) & 0xff
	db	SET_CC_7BIT,                    (TIA_V2_BASE + TIA_Vx_DEPTH_VELOCITY) & 0xff

	;; 0x10-0x1f
	db	SET_CC_V12,                 0x11
	db	SET_CC_WAVEFORM,                TIA_AUDC0 & 0x0f
	db	SET_CC_WAVEFORM,                TIA_AUDC1 & 0x0f
	db	SET_CC_V12,                 0x14
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_MODE) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_MODE) & 0xff
	db	SET_CC_V12,                 0x17
	db	SET_CC_7BIT_W_PORTA,			(TIA_V1_BASE + TIA_Vx_TRANSPOSE) & 0xff
	db	SET_CC_7BIT_W_PORTA,			(TIA_V2_BASE + TIA_Vx_TRANSPOSE) & 0xff
	db	SET_CC_V12,                 0x1a
	db	SET_CC_7BIT_W_PORTA,			(TIA_V1_BASE + TIA_Vx_PITCHRANGE) & 0xff
	db	SET_CC_7BIT_W_PORTA,			(TIA_V2_BASE + TIA_Vx_PITCHRANGE) & 0xff
	db	SET_CC_V12,                 0x1d
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_PORTA_RATE) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_PORTA_RATE) & 0xff
	db	SET_CC_V12,                 0x20

	;; 0x20-0x2f
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_ARP_RATE) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_ARP_RATE) & 0xff
	db	SET_CC_V12,                 0x23
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_NOTE_DELAY) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_NOTE_DELAY) & 0xff
	db	SET_CC_V12,                 0x26
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_KEY_OFFSET) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_KEY_OFFSET) & 0xff
	db	SET_CC_V12,                 0x29
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_KEY_LENGTH) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_KEY_LENGTH) & 0xff
	db	SET_CC_V12,                 0x2c
	db	SET_CC_7BIT,                    (TIA_V1_BASE + TIA_Vx_ASSIGN_VELOCITY) & 0xff
	db	SET_CC_7BIT,                    (TIA_V2_BASE + TIA_Vx_ASSIGN_VELOCITY) & 0xff
	db	SET_CC_V12,                 0x2f
	db	SET_CC_7BIT,                    (TIA_V1_BASE + TIA_Vx_ENV_OPTION) & 0xff
 
    ;; 0x30-0x3f    
	db	SET_CC_7BIT,                    (TIA_V2_BASE + TIA_Vx_ENV_OPTION) & 0xff
    db	SET_CC_V12,                 0x32
	db	SET_CC_7BIT,                    (TIA_ENVAUD0_BASE + TIA_ENVx_DEPTH) & 0xff
	db	SET_CC_7BIT,                    (TIA_ENVAUD1_BASE + TIA_ENVx_DEPTH) & 0xff
    db	SET_CC_V12,					0x35
	db	SET_CC_7BIT,                    (TIA_ENVAUD0_BASE + TIA_ENVx_CURVE) & 0xff
	db	SET_CC_7BIT,                    (TIA_ENVAUD1_BASE + TIA_ENVx_CURVE) & 0xff
    db	SET_CC_V12,					0x38
	db	SET_CC_7BIT,                    (TIA_ENVAUD0_BASE + TIA_ENVx_ATTACK) & 0xff
    db	SET_CC_7BIT,                    (TIA_ENVAUD1_BASE + TIA_ENVx_ATTACK) & 0xff
    db	SET_CC_V12,					0x3b
    db	SET_CC_7BIT,                    (TIA_ENVAUD0_BASE + TIA_ENVx_DECAY) & 0xff
	db	SET_CC_7BIT,                    (TIA_ENVAUD1_BASE + TIA_ENVx_DECAY) & 0xff  
	db	SET_CC_V12,					0x3e
	db	SET_CC_7BIT,                    (TIA_ENVAUD0_BASE + TIA_ENVx_SUSTAIN) & 0xff
	db	SET_CC_7BIT,                    (TIA_ENVAUD1_BASE + TIA_ENVx_SUSTAIN) & 0xff
    
    ;; 0x40-0x4f 
	db	SET_CC_V12,					0x41
	db	SET_CC_7BIT,                    (TIA_ENVAUD0_BASE + TIA_ENVx_RELEASE) & 0xff
	db	SET_CC_7BIT,                    (TIA_ENVAUD1_BASE + TIA_ENVx_RELEASE) & 0xff
    db	SET_CC_NOP,					0x44
    db	SET_CC_NOP,                     (TIA_V1_BASE + TIA_Vx_OPTION) & 0xff
    db	SET_CC_7BIT,                    (TIA_V2_BASE + TIA_Vx_OPTION) & 0xff
	db	SET_CC_V12,                 0x47
    db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_WBANK) & 0xff
    db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_WBANK) & 0xff
	db	SET_CC_V12,                 0x4a
    db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_WT) & 0xff
    db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_WT) & 0xff
	db	SET_CC_V12,                 0x4d
    db	SET_CC_7BIT,                    (TIA_V1_BASE + TIA_Vx_WT_RATE) & 0xff
    db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_WT_RATE) & 0xff
    db	SET_CC_V12,                 0x50
    
    ;; 0x40-0x4f 
    db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_KBANK) & 0xff
    db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_KBANK) & 0xff
	db	SET_CC_V12,                 0x53
    db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_KIT) & 0xff
    db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_KIT) & 0xff
    db	SET_CC_NOP,                     0x00
	db	SET_CC_7BIT,					TIA_MOD_SYNC & 0xff
	db	SET_CC_V12,					0x58
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_AMP_MOD) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_AMP_MOD) & 0xff
	db	SET_CC_V12,					0x5b
	db	SET_CC_7BIT,					(TIA_V1_BASE + TIA_Vx_PITCH_MOD) & 0xff
	db	SET_CC_7BIT,					(TIA_V2_BASE + TIA_Vx_PITCH_MOD) & 0xff
    db	SET_CC_7BIT,				(TIA_LFO1_BASE + TIA_LFOx_MODE) & 0xff
	db	SET_CC_7BIT,				(TIA_LFO2_BASE + TIA_LFOx_MODE) & 0xff  
	db	SET_CC_7BIT,				(TIA_LFO3_BASE + TIA_LFOx_MODE) & 0xff
    
	;; 0x60-0x6f
	db	SET_CC_7BIT,				(TIA_LFO4_BASE + TIA_LFOx_MODE) & 0xff
	db	SET_CC_7BIT,                (TIA_LFO1_BASE + TIA_LFOx_RATE) & 0xff
	db	SET_CC_7BIT,				(TIA_LFO2_BASE + TIA_LFOx_RATE) & 0xff
	db	SET_CC_7BIT,				(TIA_LFO3_BASE + TIA_LFOx_RATE) & 0xff
	db	SET_CC_7BIT,				(TIA_LFO4_BASE + TIA_LFOx_RATE) & 0xff      
	db	SET_CC_7BIT,				(TIA_LFO1_BASE + TIA_LFOx_DEPTH) & 0xff
	db	SET_CC_7BIT,				(TIA_LFO2_BASE + TIA_LFOx_DEPTH) & 0xff
	db	SET_CC_7BIT,				(TIA_LFO3_BASE + TIA_LFOx_DEPTH) & 0xff
	db	SET_CC_7BIT,				(TIA_LFO4_BASE + TIA_LFOx_DEPTH) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV1_BASE + TIA_ENVx_DEPTH) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV2_BASE + TIA_ENVx_DEPTH) & 0xff
    db	SET_CC_7BIT,				(TIA_ENV1_BASE + TIA_ENVx_CURVE) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV2_BASE + TIA_ENVx_CURVE) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV1_BASE + TIA_ENVx_ATTACK) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV2_BASE + TIA_ENVx_ATTACK) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV1_BASE + TIA_ENVx_DECAY) & 0xff
    
	;; 0x70-0x7f 
	db	SET_CC_7BIT,				(TIA_ENV2_BASE + TIA_ENVx_DECAY) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV1_BASE + TIA_ENVx_SUSTAIN) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV2_BASE + TIA_ENVx_SUSTAIN) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV1_BASE + TIA_ENVx_RELEASE) & 0xff
	db	SET_CC_7BIT,				(TIA_ENV2_BASE + TIA_ENVx_RELEASE) & 0xff
	db	SET_CC_7BIT,                    TIA_ENVx_CURVES & 0xff
    db	SET_CC_NOP,					0x00
    db	SET_CC_7BIT,                    (TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_ASSIGN) & 0xff
	db	SET_CC_7BIT,                    (TIA_CTRL_AFTERTOUCH_BASE + TIA_CTRLx_ASSIGN) & 0xff
	db	SET_CC_V12,					0x7a
	db	SET_CC_PLAY_NOTE,				0x00; (Voice 1)
	db	SET_CC_PLAY_NOTE,				0x01; (Voice 2)
    db	SET_CC_NOP,					0x00
	db	SET_CC_7BIT_4L,					TIA_MIDI_SYNC & 0xff
    db	SET_CC_NOP,					0x00
	db	SET_CC_PLAY_MODE,				0x00

; ==========================================================================
