; $Id: tia_debug.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; TIA Debugging Service Routine
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================


;; --------------------------------------------------------------------------
;;  Initialize the TIA Debugger module
;; --------------------------------------------------------------------------
TIA_Debug_Init
    return

;; --------------------------------------------------------------------------
;;  Check for changes in TIA registers, transfer values to TIA
;;  and handle Wavetable
;; --------------------------------------------------------------------------
TIA_Debug_Handler

#if DEFAULT_TIA_DEBUG_BS 
    rcall   TIA_Debug_BS_Check
#endif

#if 0   
    BRA_IFCLR REG_TEMP, 0, ACCESS, TIA_Debug_Handler_Jump0
    bcf REG_TEMP, 0
    call	DEBUG_MSG_SendHeader
    call	DEBUG_MSG_SendASMString
    db	"env mode:", 0
    movf    REG_TEMP2, W
    call	DEBUG_MSG_SendBCD3

	call	DEBUG_MSG_SendASMString
    db	" Modulation:", 0
    BRA_IFSET REG_TEMP, 3, ACCESS, TIA_Debug_Handler_test_neg
TIA_Debug_Handler_test_pos
	call	DEBUG_MSG_SendASMString
    db	"+", 0
    bra     TIA_Debug_Handler_test_Cont
TIA_Debug_Handler_test_neg
    call	DEBUG_MSG_SendASMString
	db	"-", 0
TIA_Debug_Handler_test_Cont  

    movf    REG_TEMP3, W
    call	DEBUG_MSG_SendBCD3

	call	DEBUG_MSG_SendFooter
TIA_Debug_Handler_Jump0
#endif  
#if 0
    BRA_IFCLR REG_TEMP, 0, ACCESS, TIA_Debug_Handler_Jump0
    bcf REG_TEMP, 0
    call	DEBUG_MSG_SendHeader
    call	DEBUG_MSG_SendASMString
    db	" bank read!:", 0
	call	DEBUG_MSG_SendFooter
TIA_Debug_Handler_Jump0

    BRA_IFCLR REG_TEMP, 1, ACCESS, TIA_Debug_Handler_Jump1
    bcf REG_TEMP, 1
    call	DEBUG_MSG_SendHeader
    call	DEBUG_MSG_SendASMString
    db	" bank write!:", 0
	call	DEBUG_MSG_SendFooter
TIA_Debug_Handler_Jump1

#endif  

#if 0    

    BRA_IFCLR REG_TEMP, REG_TEMP_TEST_FLAG, ACCESS, TIA_Debug_Handler_Cont
    bcf REG_TEMP, REG_TEMP_TEST_FLAG
    call	DEBUG_MSG_SendHeader
    call	DEBUG_MSG_SendASMString
    db	" tune test:", 0
	call	DEBUG_MSG_SendFooter
    
    call    TIA_TUNE_Play_Fanfare
#endif 

#if 0    

    BRA_IFCLR REG_TEMP, 1, ACCESS, TIA_Debug_Handler_Cont
    bcf REG_TEMP, 1
    call	DEBUG_MSG_SendHeader
    call	DEBUG_MSG_SendASMString
    db	" tune test passed:", 0
	call	DEBUG_MSG_SendFooter
#endif 

#if 0    

    BRA_IFCLR REG_TEMP, REG_TEMP_TEST_FLAG, ACCESS, TIA_Debug_Handler_Cont
    bcf REG_TEMP, REG_TEMP_TEST_FLAG

    
    call	DEBUG_MSG_SendHeader
    

	call	DEBUG_MSG_SendASMString
    db	" waveform:", 0

    movlw   0x11
	call	TIA_CCOUT_Get		; get CC parameter value
    call	DEBUG_MSG_SendBCD3

	call	DEBUG_MSG_SendFooter
#endif 


#if 0    

    BRA_IFCLR REG_TEMP, REG_TEMP_TEST_FLAG, ACCESS, TIA_Debug_Handler_Cont
    bcf REG_TEMP, REG_TEMP_TEST_FLAG
    
    call	DEBUG_MSG_SendHeader
    

	call	DEBUG_MSG_SendASMString
    db	" Env:", 0
    BRA_IFSET REG_TEMP, 3, ACCESS, TIA_Debug_Handler_vel_neg
TIA_Debug_Handler_vel_pos
	call	DEBUG_MSG_SendASMString
    db	"+", 0
    bra     TIA_Debug_Handler_vel_Cont
TIA_Debug_Handler_vel_neg
    call	DEBUG_MSG_SendASMString
	db	"-", 0
TIA_Debug_Handler_vel_Cont   

    movf	REG_TEMP2, W
    call	DEBUG_MSG_SendBCD3

	call	DEBUG_MSG_SendFooter
#endif 

#if 0   

    BRA_IFCLR REG_TEMP, REG_TEMP_TEST_FLAG, ACCESS, TIA_Debug_Handler_Cont
    bcf REG_TEMP, REG_TEMP_TEST_FLAG
    call	DEBUG_MSG_SendHeader
    
	call	DEBUG_MSG_SendASMString
    db	"Value:", 0
    movf	REG_TEMP2, W
    call	DEBUG_MSG_SendBCD3

	call	DEBUG_MSG_SendASMString
    db	" /CC:", 0
    movf	REG_TEMP3, W
    call	DEBUG_MSG_SendBCD3

	call	DEBUG_MSG_SendFooter
#endif 
    
#if 0    
    BRA_IFCLR REG_TEMP, REG_TEMP_TEST_FLAG, ACCESS, TIA_Debug_Handler_Cont
    bcf REG_TEMP, REG_TEMP_TEST_FLAG
    call	DEBUG_MSG_SendHeader
	call	DEBUG_MSG_SendASMString
    db	"ctr:", 0
    
    movf	REG_TEMP3, W, ACCESS
    movwf   MIOS_PARAMETER1
    movf	REG_TEMP2, W, ACCESS
	call	DEBUG_MSG_SendBCD5
    BRA_IFSET REG_TEMP, 4, ACCESS, TIA_Debug_Handler_ctr_c
TIA_Debug_Handler_ctr_nc
	call	DEBUG_MSG_SendASMString
    db	"", 0
    bra     TIA_Debug_Handler_ctr_Cont
TIA_Debug_Handler_ctr_c
    call	DEBUG_MSG_SendASMString
	db	" overflow", 0
TIA_Debug_Handler_ctr_Cont

	call	DEBUG_MSG_SendASMString
    db	" /current:", 0
    
    movf	REG_TEMP7, W, ACCESS
    movwf   MIOS_PARAMETER1
    movf	REG_TEMP6, W, ACCESS
	call	DEBUG_MSG_SendBCD5

	call	DEBUG_MSG_SendASMString
    db	" /target:", 0
    
    movf	REG_TEMP5, W, ACCESS
    movwf   MIOS_PARAMETER1
    movf	REG_TEMP4, W, ACCESS
	call	DEBUG_MSG_SendBCD5
    
    	call	DEBUG_MSG_SendASMString
    db	" /delta:", 0
        movf	REG_TEMP13, W, ACCESS
    movwf   MIOS_PARAMETER1
    movf	REG_TEMP12, W, ACCESS
	call	DEBUG_MSG_SendBCD5
    BRA_IFSET REG_TEMP, 3, ACCESS, TIA_Debug_Handler_delta_neg
TIA_Debug_Handler_delta_pos
	call	DEBUG_MSG_SendASMString
    db	"+", 0
    bra     TIA_Debug_Handler_delta_Cont
TIA_Debug_Handler_delta_neg
    call	DEBUG_MSG_SendASMString
	db	"-", 0
TIA_Debug_Handler_delta_Cont    
    movf	REG_TEMP9, W, ACCESS
    movwf   MIOS_PARAMETER1
    movf	REG_TEMP8, W, ACCESS
	call	DEBUG_MSG_SendBCD5

    	call	DEBUG_MSG_SendASMString
    db	" /result:", 0
    
    movf	REG_TEMP11, W, ACCESS
    movwf   MIOS_PARAMETER1
    movf	REG_TEMP10, W, ACCESS
	call	DEBUG_MSG_SendBCD5
	call	DEBUG_MSG_SendFooter
#endif 

TIA_Debug_Handler_Cont


TIA_Debug_Handler_End
	return


;; --------------------------------------------------------------------------
;;  MACRO
;;  '0' or '1' for send binary number
;; --------------------------------------------------------------------------
TIA_Debug_WRITEBINx MACRO REG, FLAG_b 
	LOCAL	TIA_Debug_WRITEBINx_1
	LOCAL	TIA_Debug_WRITEBINx_0
	LOCAL	TIA_Debug_WRITEBINx_End
    
    btfss   REG, FLAG_b
    rgoto   TIA_Debug_WRITEBINx_0
TIA_Debug_WRITEBINx_1
    call	DEBUG_MSG_SendASMString
    db	"1", 0
    rgoto   TIA_Debug_WRITEBINx_End
TIA_Debug_WRITEBINx_0
    call	DEBUG_MSG_SendASMString
    db	"0", 0
TIA_Debug_WRITEBINx_End
	ENDM
    
    
;; --------------------------------------------------------------------------
;;  Check for changes in TIA registers, transfer values to/Volumes/AV 1/Projets Live/live Library/Presets/MIDI Effects/Max MIDI Effect/MB-TIA Mgr v1_Beta/MB-TIA_Mgr_1b .maxpat TIA
;;  and handle Wavetable
;; --------------------------------------------------------------------------
TIA_Debug_EE_Do
    BRA_IFCLR TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_FLAG, ACCESS, TIA_Debug_EE_Do_End
    bcf TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_FLAG  
    
    call	DEBUG_MSG_SendHeader

	call	DEBUG_MSG_SendASMString
    db	"Int. EE R/W Debug:", 0
    
TIA_Debug_EE_Do_Read
    BRA_IFSET TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_RW, ACCESS, TIA_Debug_EE_Do_Write
	call	DEBUG_MSG_SendASMString
    db	" Read Int. Preset", 0
    rgoto   TIA_Debug_EE_Do_ReadWrite_End
    
TIA_Debug_EE_Do_Write
    call	DEBUG_MSG_SendASMString
    db	" Write Int. Preset", 0
TIA_Debug_EE_Do_Write_byte
    BRA_IFSET TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_PAGE, ACCESS, TIA_Debug_EE_Do_Write_Page
    call	DEBUG_MSG_SendASMString
    db	" - byte", 0    
    rgoto   TIA_Debug_EE_Do_ReadWrite_End
TIA_Debug_EE_Do_Write_Page    
    call	DEBUG_MSG_SendASMString
    db	" - page", 0    
TIA_Debug_EE_Do_ReadWrite_End

TIA_Debug_EE_Do_PInit
    BRA_IFCLR TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_PINIT, ACCESS, TIA_Debug_EE_Do_PInit_End
    bcf TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_PINIT
	call	DEBUG_MSG_SendASMString
    db	" (Patch Init)", 0
    rgoto   TIA_Debug_EE_Do_Sysex_End
TIA_Debug_EE_Do_PInit_End

TIA_Debug_EE_Do_Sysex
    BRA_IFCLR TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_SYX, ACCESS, TIA_Debug_EE_Do_Sysex_End
    bcf TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_SYX
	call	DEBUG_MSG_SendASMString
    db	" (Sysex Action)", 0
TIA_Debug_EE_Do_Sysex_End

TIA_Debug_EE_Do_Read_Cont
    BRA_IFSET TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_RW, ACCESS, TIA_Debug_EE_Do_Read_Cont_End
	call	DEBUG_MSG_SendASMString
    db	".", 0
TIA_Debug_EE_Do_Read_Cont_End

TIA_Debug_EE_Do_Write_Ok
    BRA_IFCLR TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_RW, ACCESS, TIA_Debug_EE_Do_WriteError_End
    BRA_IFSET TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_ERROR, ACCESS, TIA_Debug_EE_Do_Write_Error
	call	DEBUG_MSG_SendASMString
    db	" - Ok.", 0
    rgoto   TIA_Debug_EE_Do_WriteError_End
    
TIA_Debug_EE_Do_Write_Error
    call	DEBUG_MSG_SendASMString
    db	" - Error:", 0
TIA_Debug_EE_Do_Write_ErrorReadonly
    BRA_IFCLR TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_READONLY, ACCESS, TIA_Debug_EE_Do_Write_ErrorBS
    call	DEBUG_MSG_SendASMString
    db	" EE in ReadOnly Mode.", 0    
    rgoto   TIA_Debug_EE_Do_WriteError_End
TIA_Debug_EE_Do_Write_ErrorBS  
    BRA_IFCLR TIA_DEBUG_EE_REGA, TIA_DEBUG_EE_WRERR, ACCESS, TIA_Debug_EE_Do_WriteError_End 
    movf	TIA_DEBUG_EE_REG2, W
    call	DEBUG_MSG_SendBCD3
    call	DEBUG_MSG_SendASMString
    db	" EE Write problem(s)", 0   
TIA_Debug_EE_Do_WriteError_Mismatch
    BRA_IFCLR TIA_DEBUG_EE_REG1, 0, ACCESS, TIA_Debug_EE_Do_WriteError_End 
    call	DEBUG_MSG_SendASMString
    db	"(byte mismatch).", 0      
TIA_Debug_EE_Do_WriteError_End


TIA_Debug_EE_Do_Footer
	call	DEBUG_MSG_SendFooter
    clrf    TIA_DEBUG_EE_REGA
    ;clrf    TIA_DEBUG_EE_REGB
    clrf    TIA_DEBUG_EE_REG1
    clrf    TIA_DEBUG_EE_REG2    
    ;;rgoto TIA_Debug_EE_Do_End   

TIA_Debug_EE_Do_End    
    return

;; --------------------------------------------------------------------------
;;  Check for changes in TIA registers, transfer values to TIA
;;  and handle Wavetable
;; --------------------------------------------------------------------------
TIA_Debug_BS_Do 
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_RWCHK, ACCESS, TIA_Debug_BS_Do_End
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_FLAG, ACCESS, TIA_Debug_BS_Do_Clr
    bcf TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_FLAG
    call	DEBUG_MSG_SendHeader

	call	DEBUG_MSG_SendASMString
    db	"Ext. BS R/W Debug:", 0
    
TIA_Debug_BS_Do_Read
    BRA_IFSET TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_RW, ACCESS, TIA_Debug_BS_Do_Write
	call	DEBUG_MSG_SendASMString
    db	" Read Bank:", 0
    movf	TIA_DEBUG_BS_REG3, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	" Preset:", 0
    movf	TIA_DEBUG_BS_REG4, W
    call	DEBUG_MSG_SendBCD3
    rgoto   TIA_Debug_BS_Do_ReadWrite_End
TIA_Debug_BS_Do_Write
    call	DEBUG_MSG_SendASMString
    db	" Write Bank:", 0
    movf	TIA_DEBUG_BS_REG3, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	" Preset:", 0
    movf	TIA_DEBUG_BS_REG4, W
    call	DEBUG_MSG_SendBCD3
TIA_Debug_BS_Do_Write_byte
    BRA_IFSET TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_PAGE, ACCESS, TIA_Debug_BS_Do_Write_Page
    call	DEBUG_MSG_SendASMString
    db	" - byte", 0    
    rgoto   TIA_Debug_BS_Do_ReadWrite_End
TIA_Debug_BS_Do_Write_Page    
    call	DEBUG_MSG_SendASMString
    db	" - page", 0    
TIA_Debug_BS_Do_ReadWrite_End
    
TIA_Debug_BS_Do_PInit
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_PINIT, ACCESS, TIA_Debug_BS_Do_PInit_End
	call	DEBUG_MSG_SendASMString
    db	" (Preset Init)", 0
TIA_Debug_BS_Do_PInit_End

TIA_Debug_BS_Do_Sysex
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_SYX, ACCESS, TIA_Debug_BS_Do_Sysex_End
	call	DEBUG_MSG_SendASMString
    db	" (Sysex Action)", 0
TIA_Debug_BS_Do_Sysex_End

TIA_Debug_BS_Do_Read_Cont
    BRA_IFSET TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_RW, ACCESS, TIA_Debug_BS_Do_Read_Cont_End
	call	DEBUG_MSG_SendASMString
    db	".", 0
TIA_Debug_BS_Do_Read_Cont_End

TIA_Debug_BS_Do_Write_Ok
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_RW, ACCESS, TIA_Debug_BS_Do_WriteError_End
    BRA_IFSET TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_ERROR, ACCESS, TIA_Debug_BS_Do_Write_Error
	call	DEBUG_MSG_SendASMString
    db	" - Ok.", 0
    rgoto   TIA_Debug_BS_Do_WriteError_End
    
TIA_Debug_BS_Do_Write_Error
    call	DEBUG_MSG_SendASMString
    db	" - Error:", 0
TIA_Debug_BS_Do_Write_ErrorReadonly
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_READONLY, ACCESS, TIA_Debug_BS_Do_Write_ErrorBS
    call	DEBUG_MSG_SendASMString
    db	" BS in ReadOnly Mode.", 0    
    rgoto   TIA_Debug_BS_Do_WriteError_End
TIA_Debug_BS_Do_Write_ErrorBS  
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_WRERR, ACCESS, TIA_Debug_BS_Do_WriteError_End 
    movf	TIA_DEBUG_BS_REG2, W
    call	DEBUG_MSG_SendBCD3
    call	DEBUG_MSG_SendASMString
    db	" BS Write problem(s)", 0   
TIA_Debug_BS_Do_WriteError_Mismatch
    BRA_IFCLR TIA_DEBUG_BS_REG1, 0, ACCESS, TIA_Debug_BS_Do_WriteError_BSAbsent 
    call	DEBUG_MSG_SendASMString
    db	"(byte mismatch).", 0    
TIA_Debug_BS_Do_WriteError_BSAbsent
    BRA_IFCLR TIA_DEBUG_BS_REG1, 1, ACCESS, TIA_Debug_BS_Do_WriteError_End 
    call	DEBUG_MSG_SendASMString
    db	"(BS not available).", 0    
TIA_Debug_BS_Do_WriteError_End

    
TIA_Debug_BS_Do_Footer
	call	DEBUG_MSG_SendFooter
TIA_Debug_BS_Do_Clr
    clrf TIA_DEBUG_BS_REGA
    clrf TIA_DEBUG_BS_REGB
    clrf TIA_DEBUG_BS_REG1
    clrf TIA_DEBUG_BS_REG2
    ;;rgoto TIA_Debug_BS_End   
    
TIA_Debug_BS_Do_End


    return



;; --------------------------------------------------------------------------
;;  Check for changes in TIA registers, transfer values to TIA
;;  and handle Wavetable
;; --------------------------------------------------------------------------

TIA_Debug_BS_Check 
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_RWCHK, ACCESS, TIA_Debug_BS_Check_End
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_FLAG, ACCESS, TIA_Debug_BS_Check_End
    bcf TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_FLAG
    call	DEBUG_MSG_SendHeader

	call	DEBUG_MSG_SendASMString
    db	"BS Check Debug:", 0
#if DEFAULT_TIA_DEBUG_BS_MODE    
    ;; checked Bank    
	call	DEBUG_MSG_SendASMString
    db	" Bank:", 0
    movf    TIA_BANKSTICK_CHK_CTR, W
    call	DEBUG_MSG_SendBCD3

	call	DEBUG_MSG_SendASMString
    db	", BS addr:", 0
    movf	TIA_BANKSTICK_ID, W
    call	DEBUG_MSG_SendBCD3
    
    call	DEBUG_MSG_SendASMString
    db	", Box Status:", 0
    movf	TIA_DEBUG_BS_REG1, W
    call	DEBUG_MSG_SendBCD3


    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_INTEXT, ACCESS, TIA_Debug_BS_Check_IntExt
	call	DEBUG_MSG_SendASMString
    db	", Bank addr:", 0
    movf	TIA_DEBUG_BS_REG2, W
    call	DEBUG_MSG_SendBCD3
    
	call	DEBUG_MSG_SendASMString
    db	", Magic0:", 0
    movf	TIA_DEBUG_BS_REG3, W
    call	DEBUG_MSG_SendBCD3
    
	call	DEBUG_MSG_SendASMString
    db	" Magic1:", 0
    movf	TIA_DEBUG_BS_REG4, W
    call	DEBUG_MSG_SendBCD3
  
	call	DEBUG_MSG_SendASMString
    db	", BS Status:", 0
    movf	TIA_BANKSTICK_STAT, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	"/", 0
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 7
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 6 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 5
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 4 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 3
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 2 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 1
	TIA_Debug_WRITEBINx TIA_BANKSTICK_STAT, 0 
    ;movf	TIA_BANKSTICK_STAT, W
    ;call	DEBUG_MSG_SendBCD3
    
    
    call	DEBUG_MSG_SendASMString
    db	", BS Type:", 0
    movf	TIA_DEBUG_BS_REG9, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	"/", 0
    TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 7
	TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 6 
	TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 5
	TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 4 
	TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 3
	TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 2 
	TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 1
	TIA_Debug_WRITEBINx TIA_DEBUG_BS_REG9, 0 
    ;movf	TIA_BANKSTICK_SIZE, W
    ;call	DEBUG_MSG_SendBCD3
   

    call	DEBUG_MSG_SendASMString
    db	", BS Size:", 0
    movf	TIA_BANKSTICK_SIZE, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	"/", 0
    TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 7
	TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 6 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 5
	TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 4 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 3
	TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 2 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 1
	TIA_Debug_WRITEBINx TIA_BANKSTICK_SIZE, 0 
    ;movf	TIA_BANKSTICK_SIZE, W
    ;call	DEBUG_MSG_SendBCD3
    
	call	DEBUG_MSG_SendASMString
    db	", BS Ready:", 0
    movf	TIA_BANKSTICK_RDY, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	"/", 0
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 7
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 6 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 5
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 4 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 3
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 2 
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 1
	TIA_Debug_WRITEBINx TIA_BANKSTICK_RDY, 0 
    
	call	DEBUG_MSG_SendASMString
    db	", ", 0    
#endif  
   
TIA_Debug_BS_Check_IntExt
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_INTEXT, ACCESS, TIA_Debug_BS_Check_Ext
	call	DEBUG_MSG_SendASMString
    db	" Int. Patch /BS:", 0
    movf	TIA_BANKSTICK_ID, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	" disconnected.", 0
    rgoto   TIA_Debug_BS_Check_Footer
TIA_Debug_BS_Check_Ext
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_INTEXT, ACCESS, TIA_Debug_BS_Check_IntExt_End
    call	DEBUG_MSG_SendASMString
    db	" Ext.", 0
TIA_Debug_BS_Check_IntExt_End
    
TIA_Debug_BS_Check_Size
    ;;BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FPROTECT, ACCESS, TIA_Debug_BS_Check_Size_End
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_INTEXT, ACCESS, TIA_Debug_BS_Check_Size_End
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_SIZE, ACCESS, TIA_Debug_BS_Check_64k
    call	DEBUG_MSG_SendASMString
    db	"32k", 0
TIA_Debug_BS_Check_64k
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_SIZE, ACCESS, TIA_Debug_BS_Check_Size_End
    call	DEBUG_MSG_SendASMString
    db	"64k", 0
TIA_Debug_BS_Check_Size_End

TIA_Debug_BS_Check_Type
    ;;BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FPROTECT, ACCESS, TIA_Debug_BS_Check_Type_End
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_EE_PK, ACCESS, TIA_Debug_BS_Check_KWT
    call	DEBUG_MSG_SendASMString
    db	"  PBank", 0
    movf    TIA_BANKSTICK_CHK_CTR, W
    btfsc   TIA_DEBUG_BS_REGA, TIA_DEBUG_BS_READY, ACCESS
    andlw   0x1c
    call	DEBUG_MSG_SendBCD3  
TIA_Debug_BS_Check_KWT
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_EE_PK, ACCESS, TIA_Debug_BS_Check_Type_End
TIA_Debug_BS_Check_K
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_EE_WT, ACCESS, TIA_Debug_BS_Check_WT
    call	DEBUG_MSG_SendASMString
    db	"  KBank", 0
    movf    TIA_BANKSTICK_CHK_CTR, W
    btfsc   TIA_DEBUG_BS_REGA, TIA_DEBUG_BS_READY, ACCESS
    andlw   0x1c
    call	DEBUG_MSG_SendBCD3  
TIA_Debug_BS_Check_WT    
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_EE_WT, ACCESS, TIA_Debug_BS_Check_Type_End
    bcf     TIA_DEBUG_BS_REGB, TIA_DEBUG_EE_WT
    call	DEBUG_MSG_SendASMString
    db	" WTBank", 0
    movf    TIA_BANKSTICK_CHK_CTR, W
    btfsc   TIA_DEBUG_BS_REGA, TIA_DEBUG_BS_READY, ACCESS
    andlw   0x1c
    call	DEBUG_MSG_SendBCD3  
TIA_Debug_BS_Check_Type_End



TIA_Debug_BS_Check_Ready
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FORMAT, ACCESS, TIA_Debug_BS_Check_Ready_End
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FPROTECT, ACCESS, TIA_Debug_BS_Check_Ready_End
    BRA_IFSET TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_TPROTECT, ACCESS, TIA_Debug_BS_Check_Ready_End
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_INTEXT, ACCESS, TIA_Debug_BS_Check_Ready_End
    BRA_IFSET TIA_DEBUG_BS_REGA, TIA_DEBUG_BS_READY, ACCESS, TIA_Debug_BS_Check_ReadyOk
	call	DEBUG_MSG_SendASMString
    db	" loaded Ok", 0
TIA_Debug_BS_Check_ReadyOk
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_BS_READY, ACCESS, TIA_Debug_BS_Check_Ready_End
	call	DEBUG_MSG_SendASMString
    db	"-", 0
    movf    TIA_BANKSTICK_CHK_CTR, W
    andlw   0x1c
    addlw   0x03
    call	DEBUG_MSG_SendBCD3  
	call	DEBUG_MSG_SendASMString
    db	" loaded Ok /BS:", 0
    movf	TIA_BANKSTICK_ID, W
    call	DEBUG_MSG_SendBCD3
	call	DEBUG_MSG_SendASMString
    db	" ready!", 0
    bcf     TIA_DEBUG_BS_REGA, TIA_DEBUG_BS_READY
TIA_Debug_BS_Check_Ready_End


TIA_Debug_BS_Check_Format
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FORMAT, ACCESS, TIA_Debug_BS_Check_Format_End
    bcf     TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FORMAT
    call	DEBUG_MSG_SendASMString
    db	" Reformated!", 0
TIA_Debug_BS_Check_Format_End

TIA_Debug_BS_Check_FormatProtect
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FPROTECT, ACCESS, TIA_Debug_BS_Check_FormatProtect_End
    bcf TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FPROTECT
	call	DEBUG_MSG_SendASMString
    db	"-", 0
    movf    TIA_BANKSTICK_CHK_CTR, W
    andlw   0x1c
    addlw   0x03
    call	DEBUG_MSG_SendBCD3  
	call	DEBUG_MSG_SendASMString
    db	" not valid /BS:", 0
    movf	TIA_BANKSTICK_ID, W
    call	DEBUG_MSG_SendBCD3
    call	DEBUG_MSG_SendASMString
    db	" (format inhibit)", 0
TIA_Debug_BS_Check_FormatProtect_End

TIA_Debug_BS_Check_TypeProtect
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_TPROTECT, ACCESS, TIA_Debug_BS_Check_TypeProtect_End
    bcf TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_TPROTECT
	call	DEBUG_MSG_SendASMString
    db	"-", 0
    movf    TIA_BANKSTICK_CHK_CTR, W
    andlw   0x1c
    addlw   0x03
    call	DEBUG_MSG_SendBCD3  
	call	DEBUG_MSG_SendASMString
    db	" not valid /BS:", 0
    movf	TIA_BANKSTICK_ID, W
    call	DEBUG_MSG_SendBCD3
    call	DEBUG_MSG_SendASMString
    db	" (type protected)", 0
TIA_Debug_BS_Check_TypeProtect_End

TIA_Debug_BS_Check_Error
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_INTEXT, ACCESS, TIA_Debug_BS_Check_Error_End
    BRA_IFCLR TIA_DEBUG_BS_REGB, TIA_DEBUG_BS_FORMAT, ACCESS, TIA_Debug_BS_Check_Error_End
    BRA_IFCLR TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_ERROR, ACCESS, TIA_Debug_BS_Check_NoError
    movf	TIA_DEBUG_BS_REG5, W
    call	DEBUG_MSG_SendBCD3
    call	DEBUG_MSG_SendASMString
    db	" Error(s), Last:", 0
    movf	TIA_DEBUG_BS_REG6, W
    call	DEBUG_MSG_SendBCD3
    bcf     TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_ERROR
TIA_Debug_BS_Check_NoError
    BRA_IFSET TIA_DEBUG_BS_REGA, TIA_DEBUG_EE_ERROR, ACCESS, TIA_Debug_BS_Check_Error_End
    call	DEBUG_MSG_SendASMString
    db	" No error.", 0
TIA_Debug_BS_Check_Error_End
    clrf    TIA_DEBUG_BS_REG5
    
TIA_Debug_BS_Check_Footer
	call	DEBUG_MSG_SendFooter
TIA_Debug_BS_Check_Clr
    clrf TIA_DEBUG_BS_REGA
    clrf TIA_DEBUG_BS_REGB

    ;;rgoto TIA_Debug_BS_Check_End
  
TIA_Debug_BS_Check_End
    return



