; $Id: tia_led_meter.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; TIA Cartridge Led Meter Module
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================
;
; define the pins to which the Leds Meters are connected
;

TIA_LEDMTR0     EQU	7
TIA_LEDMTR1     EQU	6
TIA_LEDMTR2     EQU	5
TIA_LEDMTR3     EQU	4

TIA_LEDMTR4     EQU	3
TIA_LEDMTR5     EQU	2
TIA_LEDMTR6     EQU	1
TIA_LEDMTR7     EQU	0

TIA_LEDMTR_AUDX_REQ   EQU 0
TIA_LEDMTR_TIA_MODE   EQU 0      ;; Swith between Normal & Sampler Mode


;; --------------------------------------------------------------------------
;;  Initialize the LEDMTR module
;; --------------------------------------------------------------------------
TIA_LEDMTR_Init
    clrf    TIA_LEDMTR_STAT
    clrf    TIA_LEDMTR_VALUE
    return
	;; reset will be released with first call of TIA_SR_Handler

;; --------------------------------------------------------------------------
;;  LEDMTR module Handler
;; --------------------------------------------------------------------------
TIA_LEDMTR_Handler
	SET_BSR	TIA_BASE		; prepare BSR for TIA register access
    ;; Template run prioity
    BRA_IFCLR TIA_LEDMTR_STAT, TIA_LEDMTR_AUDX_REQ, ACCESS, TIA_LEDMTR_Handler_End
    
TIA_LEDMTR_Handler_Meter_Norm     
    ;;BRA_IFSET TIA_LEDMTR_STAT, TIA_LEDMTR_TIA_MODE, ACCESS, TIA_LEDMTR_Handler_Meter_Sampler
    bcf     TIA_LEDMTR_STAT, TIA_LEDMTR_AUDX_REQ

    clrf    TIA_LEDMTR_VALUE
    movlw   0x01
    cpfslt  TIA_AUDV0
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR0
    movlw   0x07
    cpfslt  TIA_AUDV0
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR1
    movlw   0x0b
    cpfslt  TIA_AUDV0
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR2
    movlw   0x0e
    cpfslt  TIA_AUDV0
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR3
    
    movlw   0x01
    cpfslt  TIA_AUDV1
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR4
    movlw   0x07
    cpfslt  TIA_AUDV1
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR5
    movlw   0x0b
    cpfslt  TIA_AUDV1
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR6
    movlw   0x0e
    cpfslt  TIA_AUDV1
    bsf     TIA_LEDMTR_VALUE, TIA_LEDMTR7 

    movf    TIA_LEDMTR_VALUE, W
    movwf   MIOS_PARAMETER1
    rgoto   TIA_LEDMTR_Handler_Set
    
TIA_LEDMTR_Handler_Meter_Sampler 
    clrf    MIOS_PARAMETER1
;; To Do
    ;;rgoto   TIA_LEDMTR_Handler_Set

TIA_LEDMTR_Handler_Set
    movlw   TIA_LEDMTR_REG
    rcall    TIA_LEDMTR_Write

TIA_LEDMTR_Handler_End
	return

;; --------------------------------------------------------------------------
;;  TIA_LEDMTR Led Pattern orange to green
;; --------------------------------------------------------------------------
TIA_LEDMTR_PlayFormat
	rcall	TIA_LEDMTR_Player_Init

TIA_LEDMTR_PlayFormat_R
	rcall	TIA_LEDMTR_Player_Init
	movlw	0x11
	rcall	TIA_LEDMTR_Player_On_Wait01
	movlw	0x03
	rcall	TIA_LEDMTR_Wait
	rgoto	TIA_LEDMTR_End

TIA_LEDMTR_PlayFormat_O
	rcall	TIA_LEDMTR_Player_Init
	movlw	0x33
	rcall	TIA_LEDMTR_Player_On_Wait01
	movlw	0x01
	rcall	TIA_LEDMTR_Wait
	rgoto	TIA_LEDMTR_End

TIA_LEDMTR_PlayFormat_G1
	rcall	TIA_LEDMTR_Player_Init
	movlw	0x77
	rcall	TIA_LEDMTR_Player_On_Wait01
	movlw	0x03
	rcall	TIA_LEDMTR_Wait
	rgoto	TIA_LEDMTR_End

TIA_LEDMTR_PlayFormat_G2
	rcall	TIA_LEDMTR_Player_Init
	movlw	0xff
	rcall	TIA_LEDMTR_Player_On_Wait01
	movlw	0x03
	rcall	TIA_LEDMTR_Wait
	rgoto	TIA_LEDMTR_End
    
;; --------------------------------------------------------------------------
;;  TIA_LEDMTR Led Pattern orange to green
;; --------------------------------------------------------------------------
TIA_LEDMTR_PlayOtoG
	rcall	TIA_LEDMTR_Player_Init

	movlw	0x22
	rcall	TIA_LEDMTR_Player_On_Wait01
	movlw	0x03
	rcall	TIA_LEDMTR_Wait
	movlw	0x44
	rcall	TIA_LEDMTR_Player_On_Wait01
	movlw	0x03
	rcall	TIA_LEDMTR_Wait
	movlw	0x88
	rcall	TIA_LEDMTR_Player_On_Wait01

	rgoto	TIA_LEDMTR_End
    
;; --------------------------------------------------------------------------
;;  TIA_LEDMTR Led Pattern orange to red
;; --------------------------------------------------------------------------
TIA_LEDMTR_PlayOtoR
	rcall	TIA_LEDMTR_Player_Init

	movlw	0x22
	rcall	TIA_LEDMTR_Player_On_Wait01
	movlw	0x03
	rcall	TIA_LEDMTR_Wait
	movlw	0x11
	rcall	TIA_LEDMTR_Player_On_Wait01

	rgoto	TIA_LEDMTR_End
    


;; --------------------------------------------------------------------------
;;  TIA_LEDMTR End 
;; --------------------------------------------------------------------------
TIA_LEDMTR_End
	bcf	TIA_STAT, TIA_STAT_ENGINE_DISABLE; turn on TIA software synth part again
	goto	TIA_PATCH_Init			; init patch and exit
    return

TIA_LEDMTR_Write


call    MIOS_DOUT_SRSet

return


;; --------------------------------------------------------------------------
;;  TIA_LEDMTR Initialization routine
;; --------------------------------------------------------------------------
TIA_LEDMTR_Player_Init
	bsf	TIA_STAT, TIA_STAT_ENGINE_DISABLE; turn off TIA software synth part

	SET_BSR TIA_BASE
    clrf    MIOS_PARAMETER1
    movlw   TIA_LEDMTR_REG
    call    TIA_LEDMTR_Write
    return
;; --------------------------------------------------------------------------
;;  TIA_LEDMTR a note (in: Note Number)
;; --------------------------------------------------------------------------
TIA_LEDMTR_Player_On
	SET_BSR	TIA_BASE
    movwf   MIOS_PARAMETER1
    movlw   TIA_LEDMTR_REG
    rcall    TIA_LEDMTR_Write
    return

TIA_LEDMTR_Player_Off
	SET_BSR	TIA_BASE
    clrf    MIOS_PARAMETER1
    movlw   TIA_LEDMTR_REG
    rcall    TIA_LEDMTR_Write
    return
    
TIA_LEDMTR_Player_On_Wait01
	rcall	TIA_LEDMTR_Player_On
	movlw	0x01
	rgoto	TIA_LEDMTR_Wait
    

;; --------------------------------------------------------------------------
;;  TIA_LEDMTR wait for a certain time and poll TIA_SR Handler
;; --------------------------------------------------------------------------
TIA_LEDMTR_Wait
	movwf	TMP1
	clrwdt
TIA_LEDMTR_WaitLoop
	movlw	10
	call	MIOS_Delay
	decfsz	TMP1, F
	rgoto	TIA_LEDMTR_WaitLoop
	return

    
