; $Id: tia_sysex_table.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; SysEx reference table
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================

;; --------------------------------------------------------------------------
;;  IN: index of SysEx entry (0x00-0xff) in WREG
;;  OUT: appr. CC number in WREG - if [7] set, no CC available
;; --------------------------------------------------------------------------
TIA_SYSEX_TABLE_Get
	btfsc	WREG, 7; Wavtable area: return 0xff
	retlw 0xff			

	addlw	TIA_SYSEX_TABLE & 0xff			; calc: TIA_SYSEX_TABLE + index
	movwf	TBLPTRL					; result in TBLPTR[LH]
	clrf	TBLPTRH
	movlw	(TIA_SYSEX_TABLE >> 8) & 0xff
	addwfc	TBLPTRH, F
	tblrd*						; read from table
	movf	TABLAT, W				; return table entry
	return


	;; SyxTab maps the SysEx offset to the CC number
TIA_SYSEX_TABLE
	;; 0x00-0x0f
	db	0x80, 0x81	; Patch Name
	db	0x82, 0x83
	db	0x84, 0x85
	db	0x86, 0x87
	db	0x88, 0x89
	db	0x8a, 0x8b
	db	0x8c, 0x8d
	db	0x8e, 0x8f

	;; 0x10-0x1f
	db	0x07, 0x7f	; Master Volume, Play Mode
	db	0x7b, 0x73	; SusKey, ENVx curves
	db	0x7d, 0x56	; MIDI Sync, Modulation Sync 
	db	0xff, 0xff	; 
    db	0xff, 0xff	; 
	db	0x77, 0x02	; Modulation Assign, Modulation Init Value
	db	0x0b, 0x78	; Modulation Depth, Aftertouch Assign
    db	0x03, 0x0c	; Aftertouch Init Value, Aftertouch Depth	

	;; 0x20-0x2f 
    ;; Voice 1 (AUD0)
	db	0x09, 0x17	; V1 Volume, V1 Transpose
	db	0x11, 0x14	; V1 Waveform, V1 Mo0x24de
	db	0x1a, 0x1d	; V1 PitchRange, V1 Portamento
	db	0x20, 0x23	; V1 Arp Rate, V1 Delay
	db	0x26, 0x29	; V1 Key Offset, V1 Key Length
	db	0x90, 0x91	; Split V1 Lower, Split V1 Upper
	db	0x2c, 0x05	; V1 Velocity Assign, V1 Velocity Init Value
	db	0x0e, 0x2f	; V1 Velocity Depth, ENVAUD0 Options
    ;; 0x30-0x3f    
    db	0x32, 0x35	; ENVAUD0 Depth, ENVAUD0 Curve
    db	0x38, 0x3b	; ENVAUD0 Attack, ENVAUD0 Decay
	db	0x3e, 0x41	; ENVAUD0 Sustain, ENVAUD0 Release
	db	0x44, 0x47	; V1 Sofware Options, V1 Wavetable Bank
	db	0x4a, 0x4d	; V1 Wavetable Patch, V1 Wavetable Rate
	db	0x50, 0x53	; V1 Kit Bank, V1 Kit Patch
	db	0x58, 0x5b	; V1 Assigned Amplitude Mods, V1 Assigned Pitch Mods
	db	0xff, 0xff	;
    
    ;; Voice 2 (AUD1)
	;; 0x40-0x4f
	db	0x0a, 0x18	; V2 Volume, V2 Transpose
	db	0x12, 0x15	; V2 Waveform, V2 Mode
	db	0x1b, 0x1e	; V2 PitchRange, V2 Portamento
	db	0x21, 0x24	; V2 Arp Rate, V2 Delay
	db	0x27, 0x2a	; V2 Key Offset, V2 Key Length
	db	0x91, 0x92	; Split V2 Lower, Split V2 Upper
	db	0x2d, 0x06	; V2 Velocity Assign, V2 Velocity Init Value
	db	0x0f, 0x30	; V2 Velocity Depth, ENVAUD1 Options
    ;; 0x50-0x5f    
    db	0x33, 0x36	; ENVAUD1 Depth, ENVAUD1 Curve
    db	0x39, 0x3c	; ENVAUD1 Attack, ENVAUD1 Decay
	db	0x3f, 0x42	; ENVAUD1 Sustain, ENVAUD1 Release
	db	0x45, 0x48	; V2 Sofware Options, V2 Wavetable Bank
	db	0x4b, 0x4e	; V2 Wavetable Patch, V2 Wavetable Rate
	db	0x51, 0x54	; V2 Kit Bank, V2 Kit Patch
	db	0x59, 0x5c	; V2 Assigned Amplitude Mods, V2 Assigned Pitch Mods
    db	0xff, 0xff	;

	;; 0x60-0x77
	db	0x5d, 0x61	; LFO1 Mode, LFO1 Rate
	db	0x65, 0x5e	; LFO1 Depth, LFO2 Mode
	db	0x62, 0x66	; LFO2 Rate, LFO2 Depth
	db	0x5f, 0x63	; LFO3 Mode, LFO3 Rate
	db	0x67, 0x60	; LFO3 Depth, LFO4 Mode
	db	0x64, 0x68	; LFO4 Rate, LFO4 Depth
    
	db	0x69, 0x6b	; ENV1 Depth, ENV1 Curve
	db	0x6d, 0x6f	; ENV1 Attack, ENV1 Decay
	db	0x71, 0x73	; ENV1 Sustain, ENV1 Release
	db	0x6a, 0x6c	; ENV2 Depth, ENV2 Curve
	db	0x6e, 0x70	; ENV2 Attack, ENV2 Decay
	db	0x72, 0x74	; ENV2 Sustain, ENV2 Release


	db	0xff, 0xff	;
	db	0xff, 0xff	;
    
	db	0xff, 0xff	; CFG Reserved
	db	0xff, 0xff  ; CFG Reserved
    
        	