; $Id: tia_sr.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; TIA Shift Register Service Routine
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================
;
; define the pins to which the MBHPS_TIA module is connected
;
#if DEFAULT_IS_CARTRIDGE==1
TIA_SR_LAT_SCLK	EQU	LATC
TIA_SR_PIN_SCLK	EQU	0		; Pin C.0
TIA_SR_LAT_RCLK	EQU	LATC
TIA_SR_PIN_RCLK	EQU	2		; Pin C.2
TIA_SR_LAT_OUT	EQU	LATC
TIA_SR_PIN_OUT	EQU	3		; Pin C.3

TIA_SR_LAT_WR     EQU	LATC
TIA_SR_PIN_WR     EQU	1	; Pin C.1
#else    
TIA_SR_LAT_SCLK	EQU	LATD
TIA_SR_PIN_SCLK	EQU	5		; Pin D.5
TIA_SR_LAT_RCLK	EQU	LATC
TIA_SR_PIN_RCLK	EQU	4		; Pin C.4
TIA_SR_LAT_OUT	EQU	LATD
TIA_SR_PIN_OUT	EQU	6		; Pin D.6

TIA_SR_LAT_WR	EQU	LATC
TIA_SR_PIN_WR	EQU	5		; Pin C.5
#endif

;; --------------------------------------------------------------------------
;;  Initialize the MBHP_TIA module
;; --------------------------------------------------------------------------
TIA_SR_Init
	;; reset the TIA
    clrf	MIOS_PARAMETER1
	clrf	MIOS_PARAMETER2
	rcall	TIA_SR_Write
    return

;; --------------------------------------------------------------------------
;;  TIA Write: write to TIA register
;; --------------------------------------------------------------------------
TIA_SR_Write
	;; TIA signals:
	;; MIOS_PARAMETER2[4..0]: Data
	;; MIOS_PARAMETER1[3..0]: Address
	;; temporary used as counter: MIOS_PARAMETER3

    bcf     TIA_SR_LAT_SCLK, TIA_SR_PIN_SCLK	; clear clock

	;; superfast transfer with unrolled loop (takes some memory, but guarantees the
	;; lowest system load :)
TIA_SR_WRITE_BIT MACRO reg, bit
	bcf	TIA_SR_LAT_OUT, TIA_SR_PIN_OUT	; set out pin depending on register content (reg.bit)
	btfsc	reg, bit
	bsf	TIA_SR_LAT_OUT, TIA_SR_PIN_OUT
        bsf     TIA_SR_LAT_SCLK, TIA_SR_PIN_SCLK	; rising clock edge
        bcf     TIA_SR_LAT_SCLK, TIA_SR_PIN_SCLK	; falling clock edge
	ENDM
#if DEFAULT_IS_CARTRIDGE==1
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 4     ; IC8.O0
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 3     ; IC8.O1
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 2     ; IC8.O2
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 1     ; IC8.O3
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 0     ; IC8.O4
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC8.O5
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC8.O6
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC8.O7

	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 3     ; IC7.O0
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 2     ; IC7.O1
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 1     ; IC7.O2
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 0     ; IC7.O3
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O4
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O5
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O6
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC7.O7

#else    
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 0     ; IC2.O0
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 1     ; IC2.O1
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 2     ; IC2.O2
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 3     ; IC2.O3
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 4     ; IC2.O4
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O5
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O6
	TIA_SR_WRITE_BIT MIOS_PARAMETER2, 7     ; IC2.O7

	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 3     ; IC3.O0
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 2     ; IC3.O1
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 1     ; IC3.O2
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 0     ; IC3.O3
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O4
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O5
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O6
	TIA_SR_WRITE_BIT MIOS_PARAMETER1, 7     ; IC3.O7
#endif
    bsf     TIA_SR_LAT_RCLK, TIA_SR_PIN_RCLK	; latch TIA values

	bcf     TIA_SR_LAT_WR, TIA_SR_PIN_WR	; enable write (MBHP_TIA: chip select)
	bcf     TIA_SR_LAT_OUT, TIA_SR_PIN_OUT      ; clear out pin (standby)
    bcf     TIA_SR_LAT_RCLK, TIA_SR_PIN_RCLK	; release latch

    bcf	TIA_SR_LAT_WR, TIA_SR_PIN_WR	; enable write (MBHP_TIA: chip select)
	bra	$+2				; to ensure compatibility with on-board oscillator,
	bra	$+2				; wait for 0.840 uS (1 us) (> one TIA clock cycle)
	bra	$+2
	bra	$+2
	bra	$+2
	bsf	TIA_SR_LAT_WR, TIA_SR_PIN_WR	; disable write (MBHP_TIA: chip select)
    
	return

    
    
    
    