;
; MIOS Definitions file
;

;; ==========================================================================
;;  Assembler & PICstart directives
;; ==========================================================================

	LIST P=PIC18F452, R=DEC
#include <p18f452.inc>
	
;; ==========================================================================
;;  General constants
;; ==========================================================================

;; used by MIOS_MIDI_Interface*
MIOS_MIDI_INTERFACE_COMMON	EQU	0x00
MIOS_MIDI_INTERFACE_TO_HOST	EQU	0x01

;; used by MIOS_MIDI_Merger*
MIOS_MIDI_MERGER_DISABLED	EQU	0x00
MIOS_MIDI_MERGER_ENABLED	EQU	0x01
MIOS_MIDI_MERGER_MBLINK_EP	EQU	0x02
MIOS_MIDI_MERGER_MBLINK_FP	EQU	0x03

;; used by MIOS_ENC_PIN_TABLE
MIOS_ENC_MODE_NON_DETENTED	EQU	0x00
MIOS_ENC_MODE_DETENTED		EQU	0x80

;; used by MIOS_ENC_Speed*
MIOS_ENC_SPEED_SLOW		EQU	0
MIOS_ENC_SPEED_NORMAL		EQU	1
MIOS_ENC_SPEED_FAST		EQU	2

;; used by MIOS_LCD_Type*
MIOS_LCD_TYPE_CLCD		EQU	0x00
MIOS_LCD_TYPE_GLCD0		EQU	0x01

;; location of default 5x8 font for graphical displays
MIOS_GLCD_FONT			EQU	0x28fc

;; general config flags (never overwrite this flags directly!!!)
MIOS_BOX_CFG0_USE_GLCD		EQU 0	; if 1, use graphical LCD
MIOS_BOX_CFG0_MERGER		EQU 4	; if 1, MIDI merger is enabled
MIOS_BOX_CFG0_MBLINK		EQU 5	; if 1, MIDIbox Link is enabled
MIOS_BOX_CFG0_TO_HOST		EQU 6	; if 1, MIDI interface will run with 38400 baud instead of 31250
MIOS_BOX_CFG0_20MHz		EQU 7	; if 1, it is assumed that box is running with 20 MHz, else with 40 MHz

;; general status flags (never overwrite this flags directly!!!)
MIOS_BOX_STAT_BS_AVAILABLE	EQU 0	; if 1, BankStick is available
MIOS_BOX_STAT_MBLINK_TUNNEL_PASS EQU 1  ; if 1, a MBLinked event will be tunnled
MIOS_BOX_STAT_SUSPEND_ALL       EQU 2   ; if 1, all system and user tasks are suspended
MIOS_BOX_STAT_SUSPEND_USER      EQU 3   ; if 1, all user tasks are suspended

;; ==========================================================================
;;  MIOS Special Function Registers
;; ==========================================================================

MIOS_BOX_CFG0	EQU	0x000
MIOS_BOX_CFG1	EQU	0x001
MIOS_BOX_STAT	EQU	0x002
MIOS_PARAMETER1	EQU	0x003
MIOS_PARAMETER2	EQU	0x004
MIOS_PARAMETER3	EQU	0x005

;; ==========================================================================
;;  temporary registers for main programs
;; ==========================================================================
TMP1		EQU	0x006
TMP2		EQU	0x007
TMP3		EQU	0x008
TMP4		EQU	0x009
TMP5		EQU	0x00a

;; ==========================================================================
;;  temporary registers for IRQs
;; ==========================================================================
IRQ_TMP1	EQU	0x00b
IRQ_TMP2	EQU	0x00c
IRQ_TMP3	EQU	0x00d
IRQ_TMP4	EQU	0x00e
IRQ_TMP5	EQU	0x00f

;; ==========================================================================
;;  free memory space for user application:
;; ==========================================================================
	;; 0x010-0x37f

;; ==========================================================================
;;  MIOS System Registers -- not defined here -- 
;;  never use these memory locations!
;; ==========================================================================
	;; 0x380-0x6ff
