; ==========================================================================
;
; MIOS Audio Mixer
;
; (C)2007, 2008 Lyle Hazelwood (lylehaze@bellsouth.net)
; Based on example code Copyright (C) 2005  Pilo Chambert (pilo.c@wanadoo.fr)
; 
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================
;
; PGA driver for daisychained PGA2310/PGA2311/PGA4311 (maybe wolfson or other gain control chip)
;
; This include file provides following functions:
;    o PGA_Init:       initializes the connected PGA modules
;    o PGA_PinSet:     user function to set a pin to a given 12-bit value
;    o PGA_Pin7bitSet: user function to set a pin to a given 7-bit value
;    o PGA_GatePinSet: user function to set the gate pin
;
; The pins to which the first PGA module is connected have to be defined here:
;
#define PGA_LAT_CS	LATC	; The chip select pin CS#
#define PGA_TRIS_CS	TRISC	; is connected to Port C.5
#define PGA_PIN_CS	5	; (CANNOT be shared with other outputs!)
;
#define PGA_LAT_DIN	LATC	; The data input pin DIN
#define PGA_TRIS_DIN	TRISC	; is connected to Port C.4
#define PGA_PIN_DIN	4	; (can be shared with other outputs)
;
#define PGA_LAT_SCLK	LATD	; The shift clock input pin SCLK
#define PGA_TRIS_SCLK	TRISD	; is connected to Port D.3
#define PGA_PIN_SCLK	3	; (can be shared with other outputs)
;
; Number of stereo pairs connected (ie 1 for each 2311/2310, 2 for each 4311)
;
#define channels 16
#define PGA_NUMBER_OF_CHANNEL channels * 4 
;64 is "full rack 16 channels with FX".
;to go beyond this will require  a bit of editing.

#define start_flags 0xC0    ;MUST have bit 7&6 set to init calculations
#define start_volume d'33'
;This is close to 0db gain when using Log curve
#define start_expression 0x7f   ;max, in case you're not using this
#define start_balance d'64' ;centered
#define start_fx 0          ;FX loops start out at zero
#define start_mastr 0x7f    ;maxed, in case you're not using this
;
; ==========================================================================
;
; Copyright (C) 2005  Pilo Chambert (pilo.c@wanadoo.fr)
;  Modified a bit by Lyle Hazelwood (lylehaze@bellsouth.net) Feb 2007
;
; ==========================================================================
;
; This file is part of an MIOS application
;
; This application is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This application is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this application; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
; ==========================================================================

PGA_Init
	;; enable pin drivers
	bcf	PGA_TRIS_CS, PGA_PIN_CS
	bcf	PGA_TRIS_DIN, PGA_PIN_DIN
	bcf	PGA_TRIS_SCLK, PGA_PIN_SCLK

	;; init table to defaults
	; all defaults are defined at the top of this file
	;I may add a "load preset zero" later to replace this.
	movlw	0
	call	loadboard
	btfsc	MIDI1,6
	bra	startup
	
	movlw	16		; init outer loop counter
	movwf	PGA_SR_CTR

	lfsr	FSR0, MIDI1
PGA_InitGain_Loop
	movlw	start_flags
	movwf	POSTINC0
	movlw	start_volume
	movwf	POSTINC0
	movlw	start_expression
	movwf	POSTINC0
	movlw	start_balance
	movwf	POSTINC0
	movlw	start_fx
	movwf	POSTINC0
	movwf	POSTINC0
	movlw   0
	movwf	POSTINC0
	movwf	POSTINC0

	;; loop until last register reached
	decf	PGA_SR_CTR, F
	bnz	PGA_InitGain_Loop
startup
	movlw	.127
	movwf	mastr

	;convert MIDI Volume and Balance settings to audio levels	
	call	Mid2Gain
	;and send those to the volume chips
	call	PGA_SEND_GAIN
	
	call    sendall     ;send current settings out MIDI port.

	return 	

;;-------------------------------
;; send all channels of setup as MIDI data

sendall	
    clrf    PGA_SR      ; we start at channel zero
nextall
    movf    PGA_SR,W    ;get channel number into W
    call    txchan      ;send this channels data
    incf    PGA_SR      ;increment channel number
    movlw   0xF0
    andwf   PGA_SR,W    ;is it still in bounds?
    bz      nextall
	return
;; --------------------------------------------------------------------------
;;  FUNCTION: txchan	
;;  IN: channel number to send in W
;;  OUT: MIDI data transmitted
;;  USES: FSR0,W
;; --------------------------------------------------------------------------
txchan  ;send channel settings to MIDI out	
    movwf   PGA_SR_CTR  ;hold our channel setting
    andlw   0xF0        ;test for valid channel number
    bz      goodchan    ;yes, we have a good channel
    retlw   0xFF        ;channel number > 15 not available, exit in disgrace
goodchan
    lfsr    0,MIDI1     ;point FSR0 at the first MIDI channel
    swapf   PGA_SR_CTR,W ;get the desired channel number * 16
    rrncf   WREG        ; divide by two, now channel * 8
    addwf   FSR0L,f     ;add channel offset to FSR0, now points to data channel
    movlw   0xB0        ;control change
    iorwf   PGA_SR_CTR,f ;now is status byte for any control change on this channel
    
    ;everything is in place, let's dump some data!
	call	MIOS_MIDI_BeginStream   ;the beginning of a bunch of stuff

    ;first, the bits for CC80 to CC83
    movf    PGA_SR_CTR,W
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw   .80
	call	MIOS_MIDI_TxBufferPut	;Control Change 80 is FX1 Pre/Post
	clrf    WREG
	btfsc   INDF0,0
	movlw   .127
	call	MIOS_MIDI_TxBufferPut	;Data is 64=ON, 0=OFF

    movf    PGA_SR_CTR,W
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw   .81
	call	MIOS_MIDI_TxBufferPut	;Control Change 81 is FX2 Pre/Post
	clrf    WREG
	btfsc   INDF0,1
	movlw   .127
	call	MIOS_MIDI_TxBufferPut	;Data is 64=ON, 0=OFF

    movf    PGA_SR_CTR,W
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw   .82
	call	MIOS_MIDI_TxBufferPut	;Control Change 82 is FX1 Mute
	clrf    WREG
	btfsc   INDF0,2
	movlw   .127
	call	MIOS_MIDI_TxBufferPut	;Data is 64=ON, 0=OFF

    movf    PGA_SR_CTR,W
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw   .83
	call	MIOS_MIDI_TxBufferPut	;Control Change 83 is FX2 Mute
	clrf    WREG
	btfsc   INDF0,3
	movlw   .127
	call	MIOS_MIDI_TxBufferPut	;Data is 64=ON, 0=OFF

    movf    PGA_SR_CTR,W
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw   .15                     ;test "withFX" bit
	call	MIOS_MIDI_TxBufferPut	;Control Change 15 is withFX
	clrf	WREG
	btfsc   INDF0,4
	movlw   .127
	call	MIOS_MIDI_TxBufferPut	;Data is 0=OFF, 64=ON

	movf    PGA_SR_CTR,W    ;get our channel number
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw	0x07					;MIDI VOLUME
	call	MIOS_MIDI_TxBufferPut
	movf	PREINC0,W               ;current setting
	call	MIOS_MIDI_TxBufferPut
    
	movf    PGA_SR_CTR,W    ;get our channel number
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw	0x0B					;MIDI Expression
	call	MIOS_MIDI_TxBufferPut
	movf	PREINC0,W               ;current setting
	call	MIOS_MIDI_TxBufferPut
    
	movf    PGA_SR_CTR,W    ;get our channel number
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw	0x0A					;MIDI Balance
	call	MIOS_MIDI_TxBufferPut
	movf	PREINC0,W               ;current setting
	call	MIOS_MIDI_TxBufferPut
        
	movf    PGA_SR_CTR,W    ;get our channel number
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw	0x0C					;MIDI FX1 Level
	call	MIOS_MIDI_TxBufferPut
	movf	PREINC0,W               ;current setting
	call	MIOS_MIDI_TxBufferPut
        
	movf    PGA_SR_CTR,W    ;get our channel number
	call	MIOS_MIDI_TxBufferPut	;Control Change + Channel
	movlw	0x0D					;MIDI FX2 Level
	call	MIOS_MIDI_TxBufferPut
	movf	PREINC0,W               ;current setting
	call	MIOS_MIDI_TxBufferPut

	call	MIOS_MIDI_EndStream
    
    retlw   0
;; --------------------------------------------------------------------------
;;  FUNCTION: PGA_SEND_GAIN
;;  DESCRIPTION: This function set for all channel (CHANNEL_GAIN_0 to CHANNEL_GAIN_31)
;;  IN:   o gain value in CHANNEL_GAIN_0 to CHANNEL_GAIN_31
;;  OUT:  -
;;  USES: BSR --- PGA_SR contains unknown values after the load procedure
;; --------------------------------------------------------------------------
PGA_SEND_GAIN
;	IRQ_DISABLE				; disable interrupts
	;; (for the case that interrupt driven pins are used)
	
;	call	MIOS_SystemSuspend

	call	MIOS_SRIO_NumberGet
	movwf	holdsr
	clrf	WREG
	call	MIOS_SRIO_NumberSet

    bcf		PGA_LAT_SCLK, PGA_PIN_SCLK	; clear clock
	bcf		PGA_LAT_CS, PGA_PIN_CS	; activate chip select


	movlw	PGA_NUMBER_OF_CHANNEL		; init outer loop counter
	movwf	PGA_SR_CTR

	lfsr	FSR0, CHANNEL_GAIN_0
	movlw	PGA_NUMBER_OF_CHANNEL-1
	addwf	FSR0L, F

PGA_LoadSR_OuterLoop
	clrf	PGA_SR_BIT_CTR	; clear inner loop counter

	;; pointer = current pga channel (*PGA_SR = *CHANNEL_GAIN_3)
	movff	POSTDEC0, PGA_SR


PGA_LoadSR_Value
PGA_LoadSR_Value_Loop
	btfss	PGA_SR,7
	bcf	PGA_LAT_DIN, PGA_PIN_DIN	; set DIN depending on current MSB
	btfsc	PGA_SR, 7
	bsf	PGA_LAT_DIN, PGA_PIN_DIN

	rlncf	PGA_SR, F		; start to shift the 8-bit value

	bsf	PGA_LAT_SCLK, PGA_PIN_SCLK	; rising clock edge
	incf	PGA_SR_BIT_CTR, F	; loop 8 times
	bcf	PGA_LAT_SCLK, PGA_PIN_SCLK	; falling clock edge

	btfss	PGA_SR_BIT_CTR, 3 ; if PGA_SR_BIT_CTR reach 8 then go for next channel
	rgoto   PGA_LoadSR_Value_Loop

PGA_LoadSR_Next
	;; loop until last register reached
	decf	PGA_SR_CTR, F
	bnz	PGA_LoadSR_OuterLoop

	bsf	PGA_LAT_CS, PGA_PIN_CS	; deactivate chip select

;	IRQ_ENABLE				; enable interrupts again
;	call	MIOS_SystemResume

	movf	holdsr,W
	call	MIOS_SRIO_NumberSet
	return
