; ==========================================================================
;
; MIOS Audio Mixer
;
; (C)2007, 2008 Lyle Hazelwood (lylehaze@bellsouth.net)
; Based on example code Copyright (C) 2005  Pilo Chambert (pilo.c@wanadoo.fr)
; 
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================

;; --------------------------------------------------------------------------
;;  This function is called in the mainloop when no temporary message is shown
;;  on screen. Print the realtime messages here
;; --------------------------------------------------------------------------
USER_DISPLAY_Tick
	;; leave routine if update has not been requested
	IFCLR	DISPLAY_UPDATE_REQ, 0, return

	;; clear the request flag so that this routine will not be processed
	;; until the flag has been set again
	bcf	DISPLAY_UPDATE_REQ, 0

	rgoto	DISPLAY_GAIN


DISPLAY_GAIN
	;; clear screen
	call	MIOS_LCD_Clear
	movlw	0x00
	call	MIOS_LCD_CursorSet

								; Top Line: channel:SourceName
	incf	MIDI_DISP_CHAN,W	;get the channel number (+1)
	call 	MIOS_LCD_PrintBCD2	;print in two spaces
	movlw	':'
	call	MIOS_LCD_PrintChar	;add a Colon
	movlw	' '
	call	MIOS_LCD_PrintChar	;and a space

	movf	MIDI_DISP_CHAN,W	;take the channel number
	call	channame			;to select the proper name
	call	MIOS_LCD_PrintString	;and print it
	
						;now we prepare the bottom line
	lfsr	FSR0,CHANNEL_GAIN_0
	rlncf	MIDI_DISP_CHAN,w	;2X the current channel
	addwf	FSR0L				;points to correct channel audio

;	call	StereoMeter			;this does the bargraph meter
	call	DBMeter				;this does a dB display
;FIN
	return


	;this will select the proper name for a given channel (in W)
channame
	movwf	ChanScan	;store our channel target
	TABLE_ADDR TEXT_CHAN_0	;point to first name
	movf	ChanScan,F
	btfsc	STATUS,Z		;if the channel number is Zero,
	return					;return
	TABLE_ADDR TEXT_CHAN_1		;point to second name
	dcfsnz	ChanScan			;decrement the channel number. If the result is zero,
	return						;return
	TABLE_ADDR TEXT_CHAN_2	;point to the third name
	dcfsnz	ChanScan		;dec the channel number. If the result is zero,
	return					;return
	TABLE_ADDR TEXT_CHAN_3		;point to the fourth name
	dcfsnz	ChanScan			;dec the channel number. If the result is Zero,
	return						;return
	TABLE_ADDR TEXT_CHAN_4
	dcfsnz	ChanScan		;repeat until a name is found
	return
	TABLE_ADDR TEXT_CHAN_5
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_6
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_7
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_8
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_9
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_10
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_11
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_12
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_13
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_14
	dcfsnz	ChanScan
	return
	TABLE_ADDR TEXT_CHAN_15
	return

	;Name your channels here
		;remember to change the number to the length of the new name
			;the 0x04 means to skip the first four places on the first line
			;we do that because of the 2 digit channel number, the Colon, and the space.
TEXT_CHAN_0 STRING 11,0x04,"Thunderbird"
TEXT_CHAN_1 STRING 8,0x04,"AmigaOne"
TEXT_CHAN_2 STRING 9,0x04,"CD Player"
TEXT_CHAN_3 STRING 12,0x04,"Yamaha MU90R"
TEXT_CHAN_4 STRING 9,0x04,"Channel 5"
TEXT_CHAN_5 STRING 9,0x04,"Channel 6"
TEXT_CHAN_6 STRING 9,0x04,"Channel 7"
TEXT_CHAN_7 STRING 9,0x04,"Channel 8"
TEXT_CHAN_8 STRING 9,0x04,"Channel 9"
TEXT_CHAN_9 STRING 10,0x04,"Channel 10"
TEXT_CHAN_10 STRING 10,0x04,"Channel 11"
TEXT_CHAN_11 STRING 10,0x04,"Channel 12"
TEXT_CHAN_12 STRING 10,0x04,"Channel 13"
TEXT_CHAN_13 STRING 10,0x04,"Channel 14"
TEXT_CHAN_14 STRING 10,0x04,"Channel 15"
TEXT_CHAN_15 STRING 10,0x04,"Channel 16"


;; Here comes my rather ugly code to simulate a Meter on the bottom line of the LCD
; It assumes that you have a 20 character wide display (could be changed with some work)
; It also assumes that character codes 16 to 24 (decimal) will show as vertical
; bars, starting at 16 with one bar on the left, then two(left) then three (left),
; then four(left), Five bars, Four(right), Three(right), two(right), and a single 
; bar on the right.

; The effect is that the left and right levels will "grow" out from the center of the
; display as the level increases, and will be off center if Balance is not in the middle.

; If it doesn't work for you, gee, that sucks. Looks good here on my Noritake VFD display.
; It lists character set CG57103

#define topmeter d'50'	;the number of elements in each channels meter
#define perdigit d'5'	;the number of elements per display digit
#define charperside d'10'	;the number of digits per side
;
;registers for our use include:
; meterchars, to count how many characters to go.
; meterlevel, the number of elements to light for this reading
;
StereoMeter
	movlw	0x40
	call	MIOS_LCD_CursorSet	;beginning of bottom line
	movlw	charperside			;how many characters to go for left meter
	movwf	meterchars
	movf	POSTINC0,W			;get left channel level in W (0-255)
	call	AntiLog				;convert from Log to Linear
	mullw	d'51'				;multiply level by 51
	movf	PRODH,W
	movwf   meterlevel			;divide result by 256, store in meterlevel
								;meterlevel should now be 50 to 0 describing the level (max to min)
	movlw	topmeter			;counting down from the top of the meter (left to right)
	movwf	metertrip			;
nxblank
	movlw	perdigit			; look down one more digit
	subwf	metertrip,f			;(45)(40)(35)(30)...
	movf	meterlevel,w
	cpfslt	metertrip			;skip if metertrip is less than meterlevel
	bra		doblank
	subwf	metertrip,w			;subtract meter level from trip, result=-1 to -5
	addlw	d'25'				;this offset should give the correct character
blockout							;finish left side with solid blocks
	call	MIOS_LCD_PrintChar
	movlw	d'20'				;solid block
	decfsz	meterchars
	bra		blockout
	bra		doright
doblank
	movlw	' '
	call	MIOS_LCD_PrintChar
	decfsz	meterchars
	bra		nxblank
	bra		doright
	
doright				;since we are going left to right, the right meter is "backwards" from the left one
	movlw	charperside			;how many characters to go for right meter
	movwf	meterchars
	movf	POSTINC0,W			;get right channel level in W (0-255)
	call	AntiLog
	mullw	d'51'				;multiply level by 51
	movf	PRODH,W
	movwf   meterlevel			;divide result by 256, store in meterlevel
								;meterlevel should now be 50 to 0 describing the level
	clrf	metertrip			;start at the bottom
nxblock
	movlw	perdigit			;look up one more digit
	addwf	metertrip,f			;(5)(10)(15)(20)...
	movf	metertrip,w
	cpfslt	meterlevel			;skip if meterlevel is less than metertrip
	bra		doblock
	subwf	meterlevel,w		;subtract metertrip from meterlevel, result is negative
	addlw	d'20'
	btfss	WREG,4				;test for blank underflow
	movlw	' '
fillblanks
	call	MIOS_LCD_PrintChar
	movlw	' '
	decfsz	meterchars
	bra		fillblanks
	return
doblock
	movlw	d'20'
	call	MIOS_LCD_PrintChar
	decfsz	meterchars
	bra		nxblock
	return

;;Pilos original Db display routine

	;; pointer = CHANNEL_GAIN_0 + CHANNEL_NUMBER
	lfsr	FSR0, CHANNEL_GAIN_0
	movf	CHANNEL_NUMBER, W
	addwf	FSR0L, F	; FSR0H is already set by lfsr FSR0, CHANNEL_GAIN_0

DBMeter
	movlw	0x40
	call	MIOS_LCD_CursorSet
	;; print the + or - or mute
	movlw 0
	cpfsgt INDF0
	BRA MUTE
	movlw 192
	cpfslt INDF0
	BRA PLUS
	cpfsgt INDF0
	BRA MOINS

MUTE
	TABLE_ADDR TEXT_MUTE_LEFT
	call MIOS_LCD_PrintString
	BRA FIN
	
PLUS
	movlw	192
	cpfsgt	INDF0
	BRA	ZERO
	;; Positive value
	movlw '+'
	call MIOS_LCD_PrintChar
	;; sub 192
	movlw 191
	subwfb INDF0, 0
	BRA SUITE

MOINS
	;; Negative value
	movlw '-'
	call MIOS_LCD_PrintChar
	movlw 193
	subfwb INDF0,0
	BRA SUITE

ZERO
	movlw	' '
	call MIOS_LCD_PrintChar
	;; sub 192
	movlw 191
	subwfb INDF0, 0

SUITE
	movwf DB_VALUE
	rrncf DB_VALUE, W
	andlw 0x7f
	call MIOS_LCD_PrintBCD2

	movlw '.'
	call MIOS_LCD_PrintChar

	movf DB_VALUE, W
	andlw 0x01
	btfsc DB_VALUE, 0
	movlw '5'
	btfss DB_VALUE, 0
	movlw '0'
	call MIOS_LCD_PrintChar


;	TABLE_ADDR TEXT_DB
;	call MIOS_LCD_PrintString
	movlw	' '
	call	MIOS_LCD_PrintChar
	movlw	'd'
	call	MIOS_LCD_PrintChar
	movlw	'B'
	call	MIOS_LCD_PrintChar

FIN
	movlw	0x4a
	call	MIOS_LCD_CursorSet
	;; print the + or - or mute
	movlw 0
	cpfsgt PREINC0
	BRA RMUTE
	movlw 192
	cpfslt INDF0
	BRA RPLUS
	cpfsgt INDF0
	BRA RMOINS

RMUTE
	TABLE_ADDR TEXT_MUTE_RIGHT
	call MIOS_LCD_PrintString
	BRA RFIN
	
RPLUS
	movlw	192
	cpfsgt	INDF0
	BRA	RZERO
	;; Positive value
	movlw '+'
	call MIOS_LCD_PrintChar
	;; sub 192
	movlw 191
	subwfb INDF0, 0
	BRA RSUITE

RMOINS
	;; Negative value
	movlw '-'
	call MIOS_LCD_PrintChar
	movlw 193
	subfwb INDF0,0
	BRA RSUITE

RZERO
	movlw	' '
	call MIOS_LCD_PrintChar
	;; sub 192
	movlw 191
	subwfb INDF0, 0

RSUITE
	movwf DB_VALUE
	rrncf DB_VALUE, W
	andlw 0x7f
	call MIOS_LCD_PrintBCD2

	movlw '.'
	call MIOS_LCD_PrintChar

	movf DB_VALUE, W
	andlw 0x01
	btfsc DB_VALUE, 0
	movlw '5'
	btfss DB_VALUE, 0
	movlw '0'
	call MIOS_LCD_PrintChar


;	TABLE_ADDR TEXT_DB
;	call MIOS_LCD_PrintString
	movlw	' '
	call	MIOS_LCD_PrintChar
	movlw	'd'
	call	MIOS_LCD_PrintChar
	movlw	'B'
	call	MIOS_LCD_PrintChar
RFIN
	return

;TEXT_CHANNEL STRING 7, 0x40, "Channel"
;TEXT_DB STRING 2, 0x4f, "dB"
TEXT_MUTE_LEFT STRING 8, 0x40, "  Mute  "
TEXT_MUTE_RIGHT STRING 8,0x48, "  Mute  "
;TEXT_GAIN_CONTROL STRING 12, 0x00, "Gain Control"
