// BLM16x16+X
// TRIO-Remote-Version
////////////////////////////////////////////////////////////////////////
#include <mios32.h>
#include "app.h"
#include "blm_scalar.h"
#include "sysex.h"
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include "tasks.h"
#include <portmacro.h>
#include <semphr.h>
#include <string.h>
#include "ainser.h"
#include "tasks.h"
//#include "file.h"

#define PRIORITY_TASK_BLM_CHECK		( tskIDLE_PRIORITY + 2 )

static void TASK_BLM_Check(void *pvParameters);


// send layout informations or ping each 5 seconds
static u32 sysexRequestTimer;
static u8 midiDataReceived;
static u8 testmode;

//CC-Variables
u8 seqPort = 16;
u8 sysexPort = 16;
u8 ccPort = 16;
u8 CH_CC = 0;

u8 SysExSend[7] = { 240,77, 0, 0, 0, 0, 247 };


void APP_Init(void){ //called once after startup



	MIOS32_BOARD_LED_Init(0xffffffff);  // initialize all LEDs
	
	BLM_SCALAR_Init(0);   // initialize BLM_SCALAR driver
	SYSEX_Init(0);   // initialize SysEx parser
	
	sysexRequestTimer = 0;
	midiDataReceived = 0;
	testmode = 1;
	
	xTaskCreate(TASK_BLM_Check, (signed portCHAR *)"BLM_Check", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_BLM_CHECK, NULL);
	AINSER_Init(0);
	
	// install SysEx callback
	MIOS32_MIDI_SysExCallback_Init(APP_SYSEX_Parser);
	
	
	
	// init some variables
	Auftrag.upd_BLM_V 			= 1;
	Auftrag.upd_BLM_H 			= 1;
	Auftrag.upd_BLM_1 			= 1;
	Auftrag.BLMView = 1;	// should be 0 at the beginning
}


/////////////////////////////////////////////////////////////////////////////
// This function notifies received BLM data and exits testmode
/////////////////////////////////////////////////////////////////////////////
static void notifyDataReceived(void) {
  midiDataReceived = 1;
  testmode = 0;
}







static void BLM_LED_OFF(u8 id) { 

	// Verticals - working - tested! 
	if(id==2){
				// colors
			    blm_scalar_led[4][0][0][0] = 0x00; // Clear LEDs at row 0, column 0
			    blm_scalar_led[4][0][1][0] = 0x00; // Clear LEDs at row 0, column 1
			    blm_scalar_led[4][2][0][0] = 0x00; // Clear LEDs at row 2, column 0
			    blm_scalar_led[4][2][1][0] = 0x00; // Clear LEDs at row 2, column 1
			    blm_scalar_led[4][4][0][0] = 0x00; // Clear LEDs at row 4, column 0
			    blm_scalar_led[4][4][1][0] = 0x00; // Clear LEDs at row 4, column 1
			    blm_scalar_led[4][6][0][0] = 0x00; // Clear LEDs at row 6, column 0
			    blm_scalar_led[4][6][1][0] = 0x00; // Clear LEDs at row 6, column 1
			    
			    // blink
				blm_scalar_led[4][0][0][1] = 0x00; // Clear LEDs at row 0, column 0
			    blm_scalar_led[4][0][1][1] = 0x00; // Clear LEDs at row 0, column 1
			    blm_scalar_led[4][2][0][1] = 0x00; // Clear LEDs at row 2, column 0
			    blm_scalar_led[4][2][1][1] = 0x00; // Clear LEDs at row 2, column 1
			    blm_scalar_led[4][4][0][1] = 0x00; // Clear LEDs at row 4, column 0
			    blm_scalar_led[4][4][1][1] = 0x00; // Clear LEDs at row 4, column 1
			    blm_scalar_led[4][6][0][1] = 0x00; // Clear LEDs at row 6, column 0
			    blm_scalar_led[4][6][1][1] = 0x00; // Clear LEDs at row 6, column 1
				}
  
  // Horizontals - not tested - might not work
  else if(id==1){ 
				
				// colors
			    blm_scalar_led[4][1][0][0] = 0b00010000; // Clear LEDs at row 1, column 0
			    blm_scalar_led[4][1][1][0] = 0b00010000; // Clear LEDs at row 1, column 1
			    blm_scalar_led[4][3][0][0] = 0b00010000; // Clear LEDs at row 3, column 0
			    blm_scalar_led[4][3][1][0] = 0b00010000; // Clear LEDs at row 3, column 1
			    blm_scalar_led[4][5][0][0] = 0b00010000; // Clear LEDs at row 5, column 0
			    blm_scalar_led[4][5][1][0] = 0b00010000; // Clear LEDs at row 5, column 1
			    blm_scalar_led[4][7][0][0] = 0b00010000; // Clear LEDs at row 7, column 0
			    blm_scalar_led[4][7][1][0] = 0b00010000; // Clear LEDs at row 7, column 1
			    
				// blink
				blm_scalar_led[4][1][0][1] = 0b00010000; // Clear LEDs at row 1, column 0
				blm_scalar_led[4][1][1][1] = 0b00010000; // Clear LEDs at row 1, column 1
			    blm_scalar_led[4][3][0][1] = 0b00010000; // Clear LEDs at row 3, column 0
			    blm_scalar_led[4][3][1][1] = 0b00010000; // Clear LEDs at row 3, column 1
			    blm_scalar_led[4][5][0][1] = 0b00010000; // Clear LEDs at row 5, column 0
			    blm_scalar_led[4][5][1][1] = 0b00010000; // Clear LEDs at row 5, column 1
			    blm_scalar_led[4][7][0][1] = 0b00010000; // Clear LEDs at row 7, column 0
			    blm_scalar_led[4][7][1][1] = 0b00010000; // Clear LEDs at row 7, column 1
				}
				



// Turn off ALL (XY + Extras)
if(id==5) {
	
	// COLORS //////////////////////////////////////////////////////////
    // Turn off LEDs manually for the 16x16 matrix
    blm_scalar_led[0][0][0][0] = 0x00; // Clear LEDs at row 0, column 0
    blm_scalar_led[0][0][1][0] = 0x00; // Clear LEDs at row 0, column 1
    blm_scalar_led[0][1][0][0] = 0x00; // Clear LEDs at row 1, column 0
    blm_scalar_led[0][1][1][0] = 0x00; // Clear LEDs at row 1, column 1
    blm_scalar_led[0][2][0][0] = 0x00; // Clear LEDs at row 2, column 0
    blm_scalar_led[0][2][1][0] = 0x00; // Clear LEDs at row 2, column 1
    blm_scalar_led[0][3][0][0] = 0x00; // Clear LEDs at row 3, column 0
    blm_scalar_led[0][3][1][0] = 0x00; // Clear LEDs at row 3, column 1
    blm_scalar_led[0][4][0][0] = 0x00; // Clear LEDs at row 4, column 0
    blm_scalar_led[0][4][1][0] = 0x00; // Clear LEDs at row 4, column 1
    blm_scalar_led[0][5][0][0] = 0x00; // Clear LEDs at row 5, column 0
    blm_scalar_led[0][5][1][0] = 0x00; // Clear LEDs at row 5, column 1
    blm_scalar_led[0][6][0][0] = 0x00; // Clear LEDs at row 6, column 0
    blm_scalar_led[0][6][1][0] = 0x00; // Clear LEDs at row 6, column 1
    blm_scalar_led[0][7][0][0] = 0x00; // Clear LEDs at row 7, column 0
    blm_scalar_led[0][7][1][0] = 0x00; // Clear LEDs at row 7, column 1
    blm_scalar_led[1][0][0][0] = 0x00; // Clear LEDs at row 8, column 0
    blm_scalar_led[1][0][1][0] = 0x00; // Clear LEDs at row 8, column 1
    blm_scalar_led[1][1][0][0] = 0x00; // Clear LEDs at row 9, column 0
    blm_scalar_led[1][1][1][0] = 0x00; // Clear LEDs at row 9, column 1
    blm_scalar_led[1][2][0][0] = 0x00; // Clear LEDs at row 10, column 0
    blm_scalar_led[1][2][1][0] = 0x00; // Clear LEDs at row 10, column 1
    blm_scalar_led[1][3][0][0] = 0x00; // Clear LEDs at row 11, column 0
    blm_scalar_led[1][3][1][0] = 0x00; // Clear LEDs at row 11, column 1
    blm_scalar_led[1][4][0][0] = 0x00; // Clear LEDs at row 12, column 0
    blm_scalar_led[1][4][1][0] = 0x00; // Clear LEDs at row 12, column 1
    blm_scalar_led[1][5][0][0] = 0x00; // Clear LEDs at row 13, column 0
    blm_scalar_led[1][5][1][0] = 0x00; // Clear LEDs at row 13, column 1
    blm_scalar_led[1][6][0][0] = 0x00; // Clear LEDs at row 14, column 0
    blm_scalar_led[1][6][1][0] = 0x00; // Clear LEDs at row 14, column 1
    blm_scalar_led[1][7][0][0] = 0x00; // Clear LEDs at row 15, column 0
    blm_scalar_led[1][7][1][0] = 0x00; // Clear LEDs at row 15, column 1
    
    // Turn off LEDs manually for the remaining part of the matrix
    blm_scalar_led[2][0][0][0] = 0x00; // Clear LEDs in the first color at row 0, module 2
    blm_scalar_led[2][0][1][0] = 0x00; // Clear LEDs in the second color at row 0, module 2
    blm_scalar_led[2][1][0][0] = 0x00; // Clear LEDs in the first color at row 1, module 2
    blm_scalar_led[2][1][1][0] = 0x00; // Clear LEDs in the second color at row 1, module 2
    blm_scalar_led[2][2][0][0] = 0x00; // Clear LEDs in the first color at row 2, module 2
    blm_scalar_led[2][2][1][0] = 0x00; // Clear LEDs in the second color at row 2, module 2
    blm_scalar_led[2][3][0][0] = 0x00; // Clear LEDs in the first color at row 3, module 2
    blm_scalar_led[2][3][1][0] = 0x00; // Clear LEDs in the second color at row 3, module 2
    blm_scalar_led[2][4][0][0] = 0x00; // Clear LEDs in the first color at row 4, module 2
    blm_scalar_led[2][4][1][0] = 0x00; // Clear LEDs in the second color at row 4, module 2
    blm_scalar_led[2][5][0][0] = 0x00; // Clear LEDs in the first color at row 5, module 2
    blm_scalar_led[2][5][1][0] = 0x00; // Clear LEDs in the second color at row 5, module 2
    blm_scalar_led[2][6][0][0] = 0x00; // Clear LEDs in the first color at row 6, module 2
    blm_scalar_led[2][6][1][0] = 0x00; // Clear LEDs in the second color at row 6, module 2
    blm_scalar_led[2][7][0][0] = 0x00; // Clear LEDs in the first color at row 7, module 2
    blm_scalar_led[2][7][1][0] = 0x00; // Clear LEDs in the second color at row 7, module 2
    
    blm_scalar_led[3][0][0][0] = 0x00; // Clear LEDs in the first color at row 0, module 3
    blm_scalar_led[3][0][1][0] = 0x00; // Clear LEDs in the second color at row 0, module 3
    blm_scalar_led[3][1][0][0] = 0x00; // Clear LEDs in the first color at row 1, module 3
    blm_scalar_led[3][1][1][0] = 0x00; // Clear LEDs in the second color at row 1, module 3
    blm_scalar_led[3][2][0][0] = 0x00; // Clear LEDs in the first color at row 2, module 3
    blm_scalar_led[3][2][1][0] = 0x00; // Clear LEDs in the second color at row 2, module 3
    blm_scalar_led[3][3][0][0] = 0x00; // Clear LEDs in the first color at row 3, module 3
    blm_scalar_led[3][3][1][0] = 0x00; // Clear LEDs in the second color at row 3, module 3
    blm_scalar_led[3][4][0][0] = 0x00; // Clear LEDs in the first color at row 4, module 3
    blm_scalar_led[3][4][1][0] = 0x00; // Clear LEDs in the second color at row 4, module 3
    blm_scalar_led[3][5][0][0] = 0x00; // Clear LEDs in the first color at row 5, module 3
    blm_scalar_led[3][5][1][0] = 0x00; // Clear LEDs in the second color at row 5, module 3
    blm_scalar_led[3][6][0][0] = 0x00; // Clear LEDs in the first color at row 6, module 3
    blm_scalar_led[3][6][1][0] = 0x00; // Clear LEDs in the second color at row 6, module 3
    blm_scalar_led[3][7][0][0] = 0x00; // Clear LEDs in the first color at row 7, module 3
    blm_scalar_led[3][7][1][0] = 0x00; // Clear LEDs in the second color at row 7, module 3
    
    blm_scalar_led[4][0][0][0] = 0x00; // Clear LEDs in the first color at row 0, module 4
    blm_scalar_led[4][0][1][0] = 0x00; // Clear LEDs in the second color at row 0, module 4
    blm_scalar_led[4][1][0][0] = 0x00; // Clear LEDs in the first color at row 1, module 4
    blm_scalar_led[4][1][1][0] = 0x00; // Clear LEDs in the second color at row 1, module 4
    blm_scalar_led[4][2][0][0] = 0x00; // Clear LEDs in the first color at row 2, module 4
    blm_scalar_led[4][2][1][0] = 0x00; // Clear LEDs in the second color at row 2, module 4
    blm_scalar_led[4][3][0][0] = 0x00; // Clear LEDs in the first color at row 3, module 4
    blm_scalar_led[4][3][1][0] = 0x00; // Clear LEDs in the second color at row 3, module 4
    blm_scalar_led[4][4][0][0] = 0x00; // Clear LEDs in the first color at row 4, module 4
    blm_scalar_led[4][4][1][0] = 0x00; // Clear LEDs in the second color at row 4, module 4
    blm_scalar_led[4][5][0][0] = 0x00; // Clear LEDs in the first color at row 5, module 4
    blm_scalar_led[4][5][1][0] = 0x00; // Clear LEDs in the second color at row 5, module 4
    blm_scalar_led[4][6][0][0] = 0x00; // Clear LEDs in the first color at row 6, module 4
    blm_scalar_led[4][6][1][0] = 0x00; // Clear LEDs in the second color at row 6, module 4
    blm_scalar_led[4][7][0][0] = 0x00; // Clear LEDs in the first color at row 7, module 4
    blm_scalar_led[4][7][1][0] = 0x00; // Clear LEDs in the second color at row 7, module 4
    
    
    
	// BLINK ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Turn off LEDs manually for the 16x16 matrix
    blm_scalar_led[0][0][0][1] = 0x00; // Clear LEDs at row 0, column 0
    blm_scalar_led[0][0][1][1] = 0x00; // Clear LEDs at row 0, column 1
    blm_scalar_led[0][1][0][1] = 0x00; // Clear LEDs at row 1, column 0
    blm_scalar_led[0][1][1][1] = 0x00; // Clear LEDs at row 1, column 1
    blm_scalar_led[0][2][0][1] = 0x00; // Clear LEDs at row 2, column 0
    blm_scalar_led[0][2][1][1] = 0x00; // Clear LEDs at row 2, column 1
    blm_scalar_led[0][3][0][1] = 0x00; // Clear LEDs at row 3, column 0
    blm_scalar_led[0][3][1][1] = 0x00; // Clear LEDs at row 3, column 1
    blm_scalar_led[0][4][0][1] = 0x00; // Clear LEDs at row 4, column 0
    blm_scalar_led[0][4][1][1] = 0x00; // Clear LEDs at row 4, column 1
    blm_scalar_led[0][5][0][1] = 0x00; // Clear LEDs at row 5, column 0
    blm_scalar_led[0][5][1][1] = 0x00; // Clear LEDs at row 5, column 1
    blm_scalar_led[0][6][0][1] = 0x00; // Clear LEDs at row 6, column 0
    blm_scalar_led[0][6][1][1] = 0x00; // Clear LEDs at row 6, column 1
    blm_scalar_led[0][7][0][1] = 0x00; // Clear LEDs at row 7, column 0
    blm_scalar_led[0][7][1][1] = 0x00; // Clear LEDs at row 7, column 1
    blm_scalar_led[1][0][0][1] = 0x00; // Clear LEDs at row 8, column 0
    blm_scalar_led[1][0][1][1] = 0x00; // Clear LEDs at row 8, column 1
    blm_scalar_led[1][1][0][1] = 0x00; // Clear LEDs at row 9, column 0
    blm_scalar_led[1][1][1][1] = 0x00; // Clear LEDs at row 9, column 1
    blm_scalar_led[1][2][0][1] = 0x00; // Clear LEDs at row 10, column 0
    blm_scalar_led[1][2][1][1] = 0x00; // Clear LEDs at row 10, column 1
    blm_scalar_led[1][3][0][1] = 0x00; // Clear LEDs at row 11, column 0
    blm_scalar_led[1][3][1][1] = 0x00; // Clear LEDs at row 11, column 1
    blm_scalar_led[1][4][0][1] = 0x00; // Clear LEDs at row 12, column 0
    blm_scalar_led[1][4][1][1] = 0x00; // Clear LEDs at row 12, column 1
    blm_scalar_led[1][5][0][1] = 0x00; // Clear LEDs at row 13, column 0
    blm_scalar_led[1][5][1][1] = 0x00; // Clear LEDs at row 13, column 1
    blm_scalar_led[1][6][0][1] = 0x00; // Clear LEDs at row 14, column 0
    blm_scalar_led[1][6][1][1] = 0x00; // Clear LEDs at row 14, column 1
    blm_scalar_led[1][7][0][1] = 0x00; // Clear LEDs at row 15, column 0
    blm_scalar_led[1][7][1][1] = 0x00; // Clear LEDs at row 15, column 1
    
    // Turn off LEDs manually for the remaining part of the matrix
    blm_scalar_led[2][0][0][1] = 0x00; // Clear LEDs in the first color at row 0, module 2
    blm_scalar_led[2][0][1][1] = 0x00; // Clear LEDs in the second color at row 0, module 2
    blm_scalar_led[2][1][0][1] = 0x00; // Clear LEDs in the first color at row 1, module 2
    blm_scalar_led[2][1][1][1] = 0x00; // Clear LEDs in the second color at row 1, module 2
    blm_scalar_led[2][2][0][1] = 0x00; // Clear LEDs in the first color at row 2, module 2
    blm_scalar_led[2][2][1][1] = 0x00; // Clear LEDs in the second color at row 2, module 2
    blm_scalar_led[2][3][0][1] = 0x00; // Clear LEDs in the first color at row 3, module 2
    blm_scalar_led[2][3][1][1] = 0x00; // Clear LEDs in the second color at row 3, module 2
    blm_scalar_led[2][4][0][1] = 0x00; // Clear LEDs in the first color at row 4, module 2
    blm_scalar_led[2][4][1][1] = 0x00; // Clear LEDs in the second color at row 4, module 2
    blm_scalar_led[2][5][0][1] = 0x00; // Clear LEDs in the first color at row 5, module 2
    blm_scalar_led[2][5][1][1] = 0x00; // Clear LEDs in the second color at row 5, module 2
    blm_scalar_led[2][6][0][1] = 0x00; // Clear LEDs in the first color at row 6, module 2
    blm_scalar_led[2][6][1][1] = 0x00; // Clear LEDs in the second color at row 6, module 2
    blm_scalar_led[2][7][0][1] = 0x00; // Clear LEDs in the first color at row 7, module 2
    blm_scalar_led[2][7][1][1] = 0x00; // Clear LEDs in the second color at row 7, module 2
    
    blm_scalar_led[3][0][0][1] = 0x00; // Clear LEDs in the first color at row 0, module 3
    blm_scalar_led[3][0][1][1] = 0x00; // Clear LEDs in the second color at row 0, module 3
    blm_scalar_led[3][1][0][1] = 0x00; // Clear LEDs in the first color at row 1, module 3
    blm_scalar_led[3][1][1][1] = 0x00; // Clear LEDs in the second color at row 1, module 3
    blm_scalar_led[3][2][0][1] = 0x00; // Clear LEDs in the first color at row 2, module 3
    blm_scalar_led[3][2][1][1] = 0x00; // Clear LEDs in the second color at row 2, module 3
    blm_scalar_led[3][3][0][1] = 0x00; // Clear LEDs in the first color at row 3, module 3
    blm_scalar_led[3][3][1][1] = 0x00; // Clear LEDs in the second color at row 3, module 3
    blm_scalar_led[3][4][0][1] = 0x00; // Clear LEDs in the first color at row 4, module 3
    blm_scalar_led[3][4][1][1] = 0x00; // Clear LEDs in the second color at row 4, module 3
    blm_scalar_led[3][5][0][1] = 0x00; // Clear LEDs in the first color at row 5, module 3
    blm_scalar_led[3][5][1][1] = 0x00; // Clear LEDs in the second color at row 5, module 3
    blm_scalar_led[3][6][0][1] = 0x00; // Clear LEDs in the first color at row 6, module 3
    blm_scalar_led[3][6][1][1] = 0x00; // Clear LEDs in the second color at row 6, module 3
    blm_scalar_led[3][7][0][1] = 0x00; // Clear LEDs in the first color at row 7, module 3
    blm_scalar_led[3][7][1][1] = 0x00; // Clear LEDs in the second color at row 7, module 3
    
    blm_scalar_led[4][0][0][1] = 0x00; // Clear LEDs in the first color at row 0, module 4
    blm_scalar_led[4][0][1][1] = 0x00; // Clear LEDs in the second color at row 0, module 4
    blm_scalar_led[4][1][0][1] = 0x00; // Clear LEDs in the first color at row 1, module 4
    blm_scalar_led[4][1][1][1] = 0x00; // Clear LEDs in the second color at row 1, module 4
    blm_scalar_led[4][2][0][1] = 0x00; // Clear LEDs in the first color at row 2, module 4
    blm_scalar_led[4][2][1][1] = 0x00; // Clear LEDs in the second color at row 2, module 4
    blm_scalar_led[4][3][0][1] = 0x00; // Clear LEDs in the first color at row 3, module 4
    blm_scalar_led[4][3][1][1] = 0x00; // Clear LEDs in the second color at row 3, module 4
    blm_scalar_led[4][4][0][1] = 0x00; // Clear LEDs in the first color at row 4, module 4
    blm_scalar_led[4][4][1][1] = 0x00; // Clear LEDs in the second color at row 4, module 4
    blm_scalar_led[4][5][0][1] = 0x00; // Clear LEDs in the first color at row 5, module 4
    blm_scalar_led[4][5][1][1] = 0x00; // Clear LEDs in the second color at row 5, module 4
    blm_scalar_led[4][6][0][1] = 0x00; // Clear LEDs in the first color at row 6, module 4
    blm_scalar_led[4][6][1][1] = 0x00; // Clear LEDs in the second color at row 6, module 4
    blm_scalar_led[4][7][0][1] = 0x00; // Clear LEDs in the first color at row 7, module 4
    blm_scalar_led[4][7][1][1] = 0x00; // Clear LEDs in the second color at row 7, module 4  
    
}



// Turn off 16x16
if(id==0) {
	
	// color ///////////////////////////////////////////////////////////////////////////////////
    blm_scalar_led[0][0][0][0] = 0x00; // Clear LEDs at row 0, column 0
    blm_scalar_led[0][0][1][0] = 0x00; // Clear LEDs at row 0, column 1
    blm_scalar_led[0][1][0][0] = 0x00; // Clear LEDs at row 1, column 0
    blm_scalar_led[0][1][1][0] = 0x00; // Clear LEDs at row 1, column 1
    blm_scalar_led[0][2][0][0] = 0x00; // Clear LEDs at row 2, column 0
    blm_scalar_led[0][2][1][0] = 0x00; // Clear LEDs at row 2, column 1
    blm_scalar_led[0][3][0][0] = 0x00; // Clear LEDs at row 3, column 0
    blm_scalar_led[0][3][1][0] = 0x00; // Clear LEDs at row 3, column 1
    blm_scalar_led[0][4][0][0] = 0x00; // Clear LEDs at row 4, column 0
    blm_scalar_led[0][4][1][0] = 0x00; // Clear LEDs at row 4, column 1
    blm_scalar_led[0][5][0][0] = 0x00; // Clear LEDs at row 5, column 0
    blm_scalar_led[0][5][1][0] = 0x00; // Clear LEDs at row 5, column 1
    blm_scalar_led[0][6][0][0] = 0x00; // Clear LEDs at row 6, column 0
    blm_scalar_led[0][6][1][0] = 0x00; // Clear LEDs at row 6, column 1
    blm_scalar_led[0][7][0][0] = 0x00; // Clear LEDs at row 7, column 0
    blm_scalar_led[0][7][1][0] = 0x00; // Clear LEDs at row 7, column 1
    blm_scalar_led[1][0][0][0] = 0x00; // Clear LEDs at row 8, column 0
    blm_scalar_led[1][0][1][0] = 0x00; // Clear LEDs at row 8, column 1
    blm_scalar_led[1][1][0][0] = 0x00; // Clear LEDs at row 9, column 0
    blm_scalar_led[1][1][1][0] = 0x00; // Clear LEDs at row 9, column 1
    blm_scalar_led[1][2][0][0] = 0x00; // Clear LEDs at row 10, column 0
    blm_scalar_led[1][2][1][0] = 0x00; // Clear LEDs at row 10, column 1
    blm_scalar_led[1][3][0][0] = 0x00; // Clear LEDs at row 11, column 0
    blm_scalar_led[1][3][1][0] = 0x00; // Clear LEDs at row 11, column 1
    blm_scalar_led[1][4][0][0] = 0x00; // Clear LEDs at row 12, column 0
    blm_scalar_led[1][4][1][0] = 0x00; // Clear LEDs at row 12, column 1
    blm_scalar_led[1][5][0][0] = 0x00; // Clear LEDs at row 13, column 0
    blm_scalar_led[1][5][1][0] = 0x00; // Clear LEDs at row 13, column 1
    blm_scalar_led[1][6][0][0] = 0x00; // Clear LEDs at row 14, column 0
    blm_scalar_led[1][6][1][0] = 0x00; // Clear LEDs at row 14, column 1
    blm_scalar_led[1][7][0][0] = 0x00; // Clear LEDs at row 15, column 0
    blm_scalar_led[1][7][1][0] = 0x00; // Clear LEDs at row 15, column 1
    blm_scalar_led[2][0][0][0] = 0x00; // Clear LEDs in the first color at row 0, module 2
    blm_scalar_led[2][0][1][0] = 0x00; // Clear LEDs in the second color at row 0, module 2
    blm_scalar_led[2][1][0][0] = 0x00; // Clear LEDs in the first color at row 1, module 2
    blm_scalar_led[2][1][1][0] = 0x00; // Clear LEDs in the second color at row 1, module 2
    blm_scalar_led[2][2][0][0] = 0x00; // Clear LEDs in the first color at row 2, module 2
    blm_scalar_led[2][2][1][0] = 0x00; // Clear LEDs in the second color at row 2, module 2
    blm_scalar_led[2][3][0][0] = 0x00; // Clear LEDs in the first color at row 3, module 2
    blm_scalar_led[2][3][1][0] = 0x00; // Clear LEDs in the second color at row 3, module 2
    blm_scalar_led[2][4][0][0] = 0x00; // Clear LEDs in the first color at row 4, module 2
    blm_scalar_led[2][4][1][0] = 0x00; // Clear LEDs in the second color at row 4, module 2
    blm_scalar_led[2][5][0][0] = 0x00; // Clear LEDs in the first color at row 5, module 2
    blm_scalar_led[2][5][1][0] = 0x00; // Clear LEDs in the second color at row 5, module 2
    blm_scalar_led[2][6][0][0] = 0x00; // Clear LEDs in the first color at row 6, module 2
    blm_scalar_led[2][6][1][0] = 0x00; // Clear LEDs in the second color at row 6, module 2
    blm_scalar_led[2][7][0][0] = 0x00; // Clear LEDs in the first color at row 7, module 2
    blm_scalar_led[2][7][1][0] = 0x00; // Clear LEDs in the second color at row 7, module 2
    blm_scalar_led[3][0][0][0] = 0x00; // Clear LEDs in the first color at row 0, module 3
    blm_scalar_led[3][0][1][0] = 0x00; // Clear LEDs in the second color at row 0, module 3
    blm_scalar_led[3][1][0][0] = 0x00; // Clear LEDs in the first color at row 1, module 3
    blm_scalar_led[3][1][1][0] = 0x00; // Clear LEDs in the second color at row 1, module 3
    blm_scalar_led[3][2][0][0] = 0x00; // Clear LEDs in the first color at row 2, module 3
    blm_scalar_led[3][2][1][0] = 0x00; // Clear LEDs in the second color at row 2, module 3
    blm_scalar_led[3][3][0][0] = 0x00; // Clear LEDs in the first color at row 3, module 3
    blm_scalar_led[3][3][1][0] = 0x00; // Clear LEDs in the second color at row 3, module 3
    blm_scalar_led[3][4][0][0] = 0x00; // Clear LEDs in the first color at row 4, module 3
    blm_scalar_led[3][4][1][0] = 0x00; // Clear LEDs in the second color at row 4, module 3
    blm_scalar_led[3][5][0][0] = 0x00; // Clear LEDs in the first color at row 5, module 3
    blm_scalar_led[3][5][1][0] = 0x00; // Clear LEDs in the second color at row 5, module 3
    blm_scalar_led[3][6][0][0] = 0x00; // Clear LEDs in the first color at row 6, module 3
    blm_scalar_led[3][6][1][0] = 0x00; // Clear LEDs in the second color at row 6, module 3
    blm_scalar_led[3][7][0][0] = 0x00; // Clear LEDs in the first color at row 7, module 3
    blm_scalar_led[3][7][1][0] = 0x00; // Clear LEDs in the second color at row 7, module 3


	// blink ///////////////////////////////////////////////////////////////////////////////////
    blm_scalar_led[0][0][0][1] = 0x00; // Clear LEDs at row 0, column 0
    blm_scalar_led[0][0][1][1] = 0x00; // Clear LEDs at row 0, column 1
    blm_scalar_led[0][1][0][1] = 0x00; // Clear LEDs at row 1, column 0
    blm_scalar_led[0][1][1][1] = 0x00; // Clear LEDs at row 1, column 1
    blm_scalar_led[0][2][0][1] = 0x00; // Clear LEDs at row 2, column 0
    blm_scalar_led[0][2][1][1] = 0x00; // Clear LEDs at row 2, column 1
    blm_scalar_led[0][3][0][1] = 0x00; // Clear LEDs at row 3, column 0
    blm_scalar_led[0][3][1][1] = 0x00; // Clear LEDs at row 3, column 1
    blm_scalar_led[0][4][0][1] = 0x00; // Clear LEDs at row 4, column 0
    blm_scalar_led[0][4][1][1] = 0x00; // Clear LEDs at row 4, column 1
    blm_scalar_led[0][5][0][1] = 0x00; // Clear LEDs at row 5, column 0
    blm_scalar_led[0][5][1][1] = 0x00; // Clear LEDs at row 5, column 1
    blm_scalar_led[0][6][0][1] = 0x00; // Clear LEDs at row 6, column 0
    blm_scalar_led[0][6][1][1] = 0x00; // Clear LEDs at row 6, column 1
    blm_scalar_led[0][7][0][1] = 0x00; // Clear LEDs at row 7, column 0
    blm_scalar_led[0][7][1][1] = 0x00; // Clear LEDs at row 7, column 1
    blm_scalar_led[1][0][0][1] = 0x00; // Clear LEDs at row 8, column 0
    blm_scalar_led[1][0][1][1] = 0x00; // Clear LEDs at row 8, column 1
    blm_scalar_led[1][1][0][1] = 0x00; // Clear LEDs at row 9, column 0
    blm_scalar_led[1][1][1][1] = 0x00; // Clear LEDs at row 9, column 1
    blm_scalar_led[1][2][0][1] = 0x00; // Clear LEDs at row 10, column 0
    blm_scalar_led[1][2][1][1] = 0x00; // Clear LEDs at row 10, column 1
    blm_scalar_led[1][3][0][1] = 0x00; // Clear LEDs at row 11, column 0
    blm_scalar_led[1][3][1][1] = 0x00; // Clear LEDs at row 11, column 1
    blm_scalar_led[1][4][0][1] = 0x00; // Clear LEDs at row 12, column 0
    blm_scalar_led[1][4][1][1] = 0x00; // Clear LEDs at row 12, column 1
    blm_scalar_led[1][5][0][1] = 0x00; // Clear LEDs at row 13, column 0
    blm_scalar_led[1][5][1][1] = 0x00; // Clear LEDs at row 13, column 1
    blm_scalar_led[1][6][0][1] = 0x00; // Clear LEDs at row 14, column 0
    blm_scalar_led[1][6][1][1] = 0x00; // Clear LEDs at row 14, column 1
    blm_scalar_led[1][7][0][1] = 0x00; // Clear LEDs at row 15, column 0
    blm_scalar_led[1][7][1][1] = 0x00; // Clear LEDs at row 15, column 1
    blm_scalar_led[2][0][0][1] = 0x00; // Clear LEDs in the first color at row 0, module 2
    blm_scalar_led[2][0][1][1] = 0x00; // Clear LEDs in the second color at row 0, module 2
    blm_scalar_led[2][1][0][1] = 0x00; // Clear LEDs in the first color at row 1, module 2
    blm_scalar_led[2][1][1][1] = 0x00; // Clear LEDs in the second color at row 1, module 2
    blm_scalar_led[2][2][0][1] = 0x00; // Clear LEDs in the first color at row 2, module 2
    blm_scalar_led[2][2][1][1] = 0x00; // Clear LEDs in the second color at row 2, module 2
    blm_scalar_led[2][3][0][1] = 0x00; // Clear LEDs in the first color at row 3, module 2
    blm_scalar_led[2][3][1][1] = 0x00; // Clear LEDs in the second color at row 3, module 2
    blm_scalar_led[2][4][0][1] = 0x00; // Clear LEDs in the first color at row 4, module 2
    blm_scalar_led[2][4][1][1] = 0x00; // Clear LEDs in the second color at row 4, module 2
    blm_scalar_led[2][5][0][1] = 0x00; // Clear LEDs in the first color at row 5, module 2
    blm_scalar_led[2][5][1][1] = 0x00; // Clear LEDs in the second color at row 5, module 2
    blm_scalar_led[2][6][0][1] = 0x00; // Clear LEDs in the first color at row 6, module 2
    blm_scalar_led[2][6][1][1] = 0x00; // Clear LEDs in the second color at row 6, module 2
    blm_scalar_led[2][7][0][1] = 0x00; // Clear LEDs in the first color at row 7, module 2
    blm_scalar_led[2][7][1][1] = 0x00; // Clear LEDs in the second color at row 7, module 2
    blm_scalar_led[3][0][0][1] = 0x00; // Clear LEDs in the first color at row 0, module 3
    blm_scalar_led[3][0][1][1] = 0x00; // Clear LEDs in the second color at row 0, module 3
    blm_scalar_led[3][1][0][1] = 0x00; // Clear LEDs in the first color at row 1, module 3
    blm_scalar_led[3][1][1][1] = 0x00; // Clear LEDs in the second color at row 1, module 3
    blm_scalar_led[3][2][0][1] = 0x00; // Clear LEDs in the first color at row 2, module 3
    blm_scalar_led[3][2][1][1] = 0x00; // Clear LEDs in the second color at row 2, module 3
    blm_scalar_led[3][3][0][1] = 0x00; // Clear LEDs in the first color at row 3, module 3
    blm_scalar_led[3][3][1][1] = 0x00; // Clear LEDs in the second color at row 3, module 3
    blm_scalar_led[3][4][0][1] = 0x00; // Clear LEDs in the first color at row 4, module 3
    blm_scalar_led[3][4][1][1] = 0x00; // Clear LEDs in the second color at row 4, module 3
    blm_scalar_led[3][5][0][1] = 0x00; // Clear LEDs in the first color at row 5, module 3
    blm_scalar_led[3][5][1][1] = 0x00; // Clear LEDs in the second color at row 5, module 3
    blm_scalar_led[3][6][0][1] = 0x00; // Clear LEDs in the first color at row 6, module 3
    blm_scalar_led[3][6][1][1] = 0x00; // Clear LEDs in the second color at row 6, module 3
    blm_scalar_led[3][7][0][1] = 0x00; // Clear LEDs in the first color at row 7, module 3
    blm_scalar_led[3][7][1][1] = 0x00; // Clear LEDs in the second color at row 7, module 3
}



}


static void BLM_LED(u8 element_id, u8 v, u8 h, u8 color, u8 blink) {

    static u8 led_mod_ix = 1;
    static u8 led_row_ix = 9;
    static u8 led_column_ix = 1;
    static u8 modify_led = 0;

    ////////////////////////////
    // calculate H - V - PINs //

         if( element_id == 0 ) {    // BLM16x16 LEDs
                                    led_mod_ix = h >> 2;
                                    led_row_ix = ((h&3) << 1) + ((v >> 3) & 1);
                                    led_column_ix = v & 0x7; //vertical (AND = equal Bits) 7
                                    modify_led = 1;}




    else if( element_id == 2 ) {   // VERTICAL = Y = 2   extra column LEDs
                                    led_mod_ix = 4;
                                    led_row_ix = (h&3) << 1;
                                    led_column_ix = h >> 2;
                                    modify_led = 1; }



    else if( element_id == 1 ) {    // HORIZONTAL = X = 1 extra row LEDs // Chn0, v >= 96, v <= 0111   // h == 0 && v >= 0x60 && v <= 0x6f
                                    v = v + 96; // ?
                                    led_mod_ix = 4;
                                    led_row_ix = 1 + ((v >> 1) & 6);
                                    led_column_ix = v & 3;
                                    modify_led = 1; }


    else if( element_id == 3 ) {    // SHIFT-BUTTON   // Chn15, v>=96, v>0111
                                    v = v + 96; // ?
                                    led_mod_ix = 4;
                                    led_row_ix = 1 + ((v >> 1) & 6);
                                    led_column_ix = 4 + (v & 3);
                                    modify_led = 1; }


    if( modify_led ) {  // set LEDs
			            u8 led_mask = 1 << led_column_ix;
						u8 blink_mask = led_mask;


			            if( color == 0 )	{	// 0 CLEAR	Not blinking										// CLEAR
												blm_scalar_led[led_mod_ix][led_row_ix][0][0] &= ~led_mask; 		// blue		0			~: toggles value 0/1
												blm_scalar_led[led_mod_ix][led_row_ix][1][0] &= ~led_mask;		// green	0
												blm_scalar_led[led_mod_ix][led_row_ix][0][1] &= ~blink_mask;
												blm_scalar_led[led_mod_ix][led_row_ix][1][1] &= ~blink_mask;
												}

			            else if( color == 1 ){	// 1 BLUE	Not blinking										// BLUE
												blm_scalar_led[led_mod_ix][led_row_ix][0][0] |= led_mask;		// blue		1
												blm_scalar_led[led_mod_ix][led_row_ix][1][0] &= ~led_mask;	 	// green	0

												if(blink==0) {	// no blinking
												blm_scalar_led[led_mod_ix][led_row_ix][0][1] &= ~blink_mask; 	// blue		0
												blm_scalar_led[led_mod_ix][led_row_ix][1][1] &= ~blink_mask; }	// green	0

												if(blink==1) {	// blinking
												blm_scalar_led[led_mod_ix][led_row_ix][0][1] |= blink_mask; 	// blue		1
												blm_scalar_led[led_mod_ix][led_row_ix][1][1] &= ~blink_mask; }	// green	0

												}

			            else if( color == 2 ){	// 1 GREEN	Not blinking										// GREEN
												blm_scalar_led[led_mod_ix][led_row_ix][0][0] &= ~led_mask;		// blue		0
												blm_scalar_led[led_mod_ix][led_row_ix][1][0] |= led_mask;	 	// green	1

												if(blink==0) {	// no blinking
												blm_scalar_led[led_mod_ix][led_row_ix][0][1] &= ~blink_mask; 	// blue		0
												blm_scalar_led[led_mod_ix][led_row_ix][1][1] &= ~blink_mask; }	// green	0

												if(blink==1) {	// blinking
												blm_scalar_led[led_mod_ix][led_row_ix][0][1] &= ~blink_mask; 	// blue		0
												blm_scalar_led[led_mod_ix][led_row_ix][1][1] |=  blink_mask; }	// green	1
												 }

			            else {                  // 2 CYAN	Not blinking										// CYAN
												blm_scalar_led[led_mod_ix][led_row_ix][0][0] |= led_mask;		// blue		1
												blm_scalar_led[led_mod_ix][led_row_ix][1][0] |= led_mask;		// green	1

												if(blink==0) {	// no blinking
												blm_scalar_led[led_mod_ix][led_row_ix][0][1] &= ~blink_mask; 	// blue		0
												blm_scalar_led[led_mod_ix][led_row_ix][1][1] &= ~blink_mask; }	// green	0

												if(blink==1) {	// blinking
												blm_scalar_led[led_mod_ix][led_row_ix][0][1] |=  blink_mask;  	// blue		1
												blm_scalar_led[led_mod_ix][led_row_ix][1][1] |=  blink_mask; }	// green	1
												}
}
}




// BLM-DIN States  +  BLM-Keyboard
static void DIN_BLM_NotifyToggle(u32 pin, u32 pin_value){

// MIOS32_MIDI_SendDebugMessage("BLM working-input");

	// determine row and column (depends on the way how the matrix has been connected)
	u8 blm_row = pin >> 3;
	u8 blm_column = pin & 7;

	u8 h = (blm_row >> 1);
	u8 v = blm_column | ((blm_row&1) << 3);
	u8 val = pin_value; //? 0x00 : 0x7f;

	u8 extra_h = 0;
	u8 extra_v = 0;


            
            
     // Normal Use with Midiphy/Midibox SeqV4
	if(!Auftrag.BLMView){      
						
						u8 velocity = pin_value ? 0x00 : 0x7f;
						
						// send pin number and value as Note On Event
						u8 chn = 0;
						u8 note = 0;
						
						//MIOS32_MIDI_SendDebugMessage("pin: %d   value: %d   blm_row %d     blm_column %d    row %d    column %d    velocity %d", pin, pin_value, blm_row, blm_column, row, column, velocity);
						
						if( blm_row < 16 ) {
											// BLM 16x16
											chn = blm_row;
											note = blm_column;
											}
										
						else if( (blm_row & 0xf9) == 0x20 && blm_column < 4 ) {
																				// Extra column
																				u8 extra_row = ((blm_row >> 1) & 3) | (blm_column << 2);
																				chn = extra_row;
																				note = 0x40;
																				}
						
						else if( (blm_row & 0xf9) == 0x21 ){
															
															u8 extra_column = ((blm_row << 1) & 0x0c) | (blm_column & 0x3);
															if( blm_column < 4 ) {
																					// Extra row
																					chn = 0x0;
																					note = 0x60 + extra_column;
																}
																
															else {	// Additional extra buttons
																	chn = 0xf;
																	note = 0x60 + extra_column;
																	}
															}
						MIOS32_MIDI_SendNoteOn(seqPort, chn, note, velocity);
						}
			
	
	// TM as Sysex-Controller (M4L)
	if(Auftrag.BLMView==1){	
		// MIOS32_MIDI_SendDebugMessage("BLMView=1");
		
            // Extra Leftmost - Buttommost
            if(pin == 268){		
							SysExSend[2] = 53;	// ID
							SysExSend[3] = h;
							SysExSend[4] = v;
							SysExSend[5] = val;
							
							MIOS32_MIDI_SendSysEx(sysexPort, (u8 *)SysExSend, 7); // 19 USB-Port 4
							}

            // Alle Anderen Taster
            else{
															
			        // 16x16 Matrix
					if(h<16){	
								SysExSend[2] = 50;	// ID
								SysExSend[3] = h;
								SysExSend[4] = v;
								SysExSend[5] = val;
								//MIOS32_MIDI_SendDebugMessage("%d %d %d %d %d %d %d", SysExSend[0],SysExSend[1],SysExSend[2],SysExSend[3],SysExSend[4],SysExSend[5],SysExSend[6]);
								MIOS32_MIDI_SendSysEx(sysexPort, (u8 *)SysExSend, 7); 
								}
													
		
		            // VERTIKAL - EXTRA
		            else if( (blm_row & 0xf9) == 0x20 && blm_column < 4 ){	extra_h = ((blm_row >> 1) & 3) | (blm_column << 2);
						
																			SysExSend[2] = 51;	// ID
																			SysExSend[3] = 0;	// not in use
																			SysExSend[4] = extra_h;
																			SysExSend[5] = val;
																			
																			MIOS32_MIDI_SendSysEx(sysexPort, (u8 *)SysExSend, 7); 
																			}
		
		            // HORIZONTAL - EXTRA
		            else if( (blm_row & 0xf9) == 0x21 ){
															extra_v = ((blm_row << 1) & 0x0c) | (blm_column & 0x3);
															
															SysExSend[2] = 52;	// ID
															SysExSend[3] = extra_v;
															SysExSend[4] = 0;	// not in use
															SysExSend[5] = val;
															
															MIOS32_MIDI_SendSysEx(sysexPort, (u8 *)SysExSend, 7);
															}
					}
			}				

	// TM as CC-Controller
	if(Auftrag.BLMView==2){	
		
            // Extra Leftmost - Buttommost
            if(pin == 268){
							// toggle between SysExMode  &  CC-Mode
							if(val){
										if(Auftrag.BLMView == 2) { Auftrag.BLMView = 1; }
										else if(Auftrag.BLMView == 1) { Auftrag.BLMView = 2; } 
										}
										
							SysExSend[2] = 52;	// ID
							SysExSend[3] = h;
							SysExSend[4] = v;
							SysExSend[5] = val;
							
							MIOS32_MIDI_SendSysEx(ccPort, (u8 *)SysExSend, 7);
							}

            // Alle Anderen Taster
            else{
															
			        // 16x16 Matrix
					if(h<16){	MIOS32_MIDI_SendCC (ccPort,  h, v, val); 	} // 18 USB 3
													
		
		            // VERTIKAL - EXTRA
		            else if( (blm_row & 0xf9) == 0x20 && blm_column < 4 ){	extra_h = ((blm_row >> 1) & 3) | (blm_column << 2);

																			MIOS32_MIDI_SendCC (ccPort,  0, (extra_h+16), val); 
																			}
		
		            // HORIZONTAL - EXTRA
		            else if( (blm_row & 0xf9) == 0x21 ){	extra_v = ((blm_row << 1) & 0x0c) | (blm_column & 0x3);

															MIOS32_MIDI_SendCC (ccPort,  1, (extra_v+16), val);
															}
					}
			}
}





//AIN - - Potentiometer has mooved - - Analog InPut
static void APP_AINSER_NotifyChange(u8 pin, u8 value)	{

	// MIOS32_MIDI_SendDebugMessage("pin: %d   value: %d", pin, value);
	
	// PINOUT
	// PIN 2
	// PIN 3
	// PIN 1
	// PIN 0

	
	
	// Normal TM - not use with Ableton
	if(!Auftrag.BLMView){	MIOS32_MIDI_SendCC(seqPort, pin & 0x0F, 1, value);	}



	// TM as Sysex-Controller (m4l)
	if(Auftrag.BLMView==1){			
							SysExSend[2] = pin + 60;
							SysExSend[3] = value;
							SysExSend[4] = 0;	// not in use
							SysExSend[5] = 0;	// not in use
							
							MIOS32_MIDI_SendSysEx(sysexPort, (u8 *)SysExSend, 7); 
							}

	// TM as CC-Controller
	if(Auftrag.BLMView==2){	MIOS32_MIDI_SendCC (ccPort,  0, (pin+60), value); }

	
	
	
}



void APP_Background(void){

/*
// USB-OUT-Test
static u32 counter = 0;
counter++;

if(counter> 60000) {	counter = 0;

						static u32 c = 0;
						c++;
						if(c>100) { c = 0;
									MIOS32_MIDI_SendCC(34, 1, 1, 64);
									}
					}
*/
AINSER_Handler(APP_AINSER_NotifyChange);

	}

void APP_Tick(void) { // @ mS rate, from main task which also handles DIN, ENC and AIN events.  dont do more than 300uS!
	
	
	  // send layout informations each 5 seconds if BLM hasn't been updated
  if( sysexRequestTimer > 5000 ) {
								    // INTCONbits.GIE = 0;
								    sysexRequestTimer = 0;
								    // INTCONbits.GIE = 1;
								
								    if( midiDataReceived )
								      SYSEX_SendAck(seqPort, SYSEX_ACK, 0x00);
								   // else
								    SYSEX_SendLayoutInfo(seqPort);
								
								    midiDataReceived = 0;
								  }
}



// Funktion zum Verarbeiten der MIDI-CC-Nachricht und Aktualisieren der LEDs
void process16x16(u8 row, u8 controlByte, u8 pattern) {
	
	#define CELLS_PER_ROW 8
	#define GREEN 0
	#define RED 1
	
	u8 cell = 0;
	
	// Array zur Speicherung der Zustände der grünen und roten LEDs
	static u8 color[16][2][8][2] = {{{{0}}}}; // 16 Zeilen, 2 Bereiche von 8 Zellen pro Zeile, 2 für grün und rot
	
	// Bestimmen der Farbe (Grün oder Rot) basierend auf dem Control Byte
	u8 colorType = 0;
	if 		((controlByte & 0xF0) == 0x10) { colorType = GREEN; }
	else if ((controlByte & 0xF0) == 0x20) { colorType = RED; }

	// Bestimmen des Bereichs (first oder second) basierend auf dem Control Byte
	u8 range;
	if ((controlByte & 0x0F) < 8) { range = 0; } // Bereich 0 für Zeilen 0-7
	else  						  { range = 1; } // Bereich 1 für Zeilen 8-15
	

	// Aktualisieren des Farbarrays basierend auf dem Muster (pattern)
	for(cell=0; cell<CELLS_PER_ROW; cell++) {	color[row][range][cell][colorType] = (pattern >> cell) & 0x01; } // 0 oder 1 für aus oder an

	
	// Durchlaufen der aktualisierten Zellen und Aktualisieren der LEDs
	for(cell=0; cell<CELLS_PER_ROW; cell++) {
												// Kombinierte Farbe berechnen
												u8 combinedColor = 0; // 0: OFF, 1: Grün, 2: Rot, 3: Grün und Rot
												
												if (color[row][range][cell][GREEN] && color[row][range][cell][RED]) {	combinedColor = 3; } // Grün und Rot
												
												else if (color[row][range][cell][RED]) { combinedColor = 2; } // Nur Rot
												
												else if (color[row][range][cell][GREEN]) {combinedColor = 1; }// Nur Grün
												
												// LED-Zustand an BLM_LED übergeben
												BLM_LED(2, row, ((range * CELLS_PER_ROW) + cell), combinedColor, 0); // Beispiel: Annahme von Blink=0
												}
	}

// Funktion zur Verarbeitung der MIDI-CC-Nachricht für Extra Column
void processExtraColumn(u8 controlByte, u8 pattern) {
	
	u8 cell = 0;
	static u8 color[2][8][2] = {{{0}}}; // Static Deklaration für persistente Speicherung der Farben
	
	// Extrahieren der Farbe (Grün oder Rot) aus dem Control Byte
	u8 colorType;
	if ((controlByte & 0xF0) == 0x40) 		{ colorType = GREEN; }
	else if ((controlByte & 0xF0) == 0x48)	{ colorType = RED; }

	
	// Extrahieren der vertikalen Koordinate (v) aus dem Control Byte
	u8 v = controlByte & 0x0F;
	
	// Bestimmen des Offsets für die Zellennummer (cell)
	u8 cellOffset = (v == 1) ? 8 : 0;
	
	// Speichern der Farbe für die aktuelle Spalte
	for(cell=0; cell<8; cell++){	color[v][cell][colorType] = pattern & (1 << cell);	}
	
	// Aktualisieren der LEDs in der Extra Column basierend auf dem Muster (pattern)
	for(cell=0; cell<8; cell++){
		
								// Kombinierte Farbe für die aktuelle Zelle berechnen
								u8 combinedColor = 0;
								if (color[v][cell][0] && color[v][cell][1]) { combinedColor = 3; }// Cyan
								
								else if (color[v][cell][1])					{ combinedColor = 2; }// Rot
								
								else if (color[v][cell][0]) 				{ combinedColor = 1; }// Grün
								
								else  										{ combinedColor = 0; } // Aus

								// LED-Zustand an BLM_LED übergeben
								BLM_LED(1, cell + cellOffset, 0, combinedColor, 0); // ID1, Zellennummer mit Offset, 0 (festgelegt), Farbe, Blinken (0 für nicht blinkend)
								}
}


// Funktion zur Verarbeitung der MIDI-CC-Nachricht für Extra Row
void processExtraRow(u8 controlByte, u8 pattern) {

	u8 cell;
	
	static u8 color[2][8][2] = {{{0}}}; // Static Deklaration für persistente Speicherung der Farben
	
	// Extrahieren der Farbe (Grün oder Rot) aus dem Control Byte
	u8 colorType;
	if ((controlByte & 0xF0) == 0x60) 		{ colorType = GREEN; }
	else if ((controlByte & 0xF0) == 0x68)	{ colorType = RED;	}
	
	// Extrahieren der horizontalen Koordinate (i) aus dem Control Byte
	u8 i = controlByte & 0x0F;
	
	// Bestimmen des Offsets für die Zellennummer (cell)
	u8 cellOffset = (i == 1) ? 8 : 0;
	
	// Speichern der Farbe für die aktuelle Zeile
	for(cell=0; cell<8; cell++) { color[i][cell][colorType] = pattern & (1 << cell); }
	
	// Aktualisieren der LEDs in der Extra Row basierend auf dem Muster (pattern)
	for (cell=0; cell<8; cell++){
									// Kombinierte Farbe für die aktuelle Zelle berechnen
									u8 combinedColor = 0;
									if (color[i][cell][0] && color[i][cell][1]) { combinedColor = 3; } // Cyan
									
									else if (color[i][cell][1]) 				{ combinedColor = 2; } // Rot
									
									else if (color[i][cell][0]) 				{ combinedColor = 1; } // Grün
									
									else  										{ combinedColor = 0; } // Aus
									
									
									// LED-Zustand an BLM_LED übergeben
									BLM_LED(2, 0, cell + cellOffset, combinedColor, 0); // ID2, 0 (festgelegt), Zellennummer mit Offset, Farbe, Blinken (0 für nicht blinkend)
									}
	}
	



void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){
	
	//MIOS32_MIDI_SendDebugMessage("port: %d    chn: %d    note: %d    velocity: %d", port, midi_package.chn, midi_package.note, midi_package.velocity);

  // control the Duo-LEDs via Note On/Off Events
  // The colour is controlled with velocity value:
  // 0x00:       both LEDs off 0
  // 0x01..0x3f  green LED on  01-63:
  // 0x40..0x5f: red LED on    64-95
  // 0x60..0x7f: both LEDs on  96-127

  // MIDI event assignments: see README.txt
      u8 blink = 0;

  if( midi_package.event == NoteOff || midi_package.event == NoteOn ) {
	  
    u8 chn = midi_package.chn;
    u8 note = midi_package.note;
    u8 velo = midi_package.velocity;

    u8 h = 0;
    u8 v = 0;

    
	// get color //////////////////////////////////////////////////////////
	u8 color = 0;
	if(velo == 0) 						{ color = 0; }	// none - LED = OFF
	else if(velo >= 1 && velo <= 63)	{ color = 1; }	// BLUE
	else if(velo >= 64 && velo <= 96)	{ color = 2; }	// GREEN
	else  								{ color = 3; }	// CYAN

	// BLM16x16 /////////////////////////////////////////////
    if( note <= 15 ){
							h = chn;
							v = note;

							// Change LED-Status
							BLM_LED(0, h, v, color, blink); 
							}
						
						
    // Extra V - Leds (16 x 1) //////////////////////////////
    else if( note == 64 ){
							v = chn;
							
							// Change LED-Status
							BLM_LED(2, 0, v, color, blink);
							}
	
    // Extra H - Leds (16 x 1)
	else if( chn == 0 && note >= 96 && note <= 111) {
														h = note - 96;
														
														// Change LED-Status
														BLM_LED(1, h, 0, color, blink);
														}
	
	// Extra 1x1 Button
	else if( chn == 15 && note >= 96 && note <= 111 ) { 
														// Change LED-Status
														BLM_LED(3, 3, 0, color, blink);
														}
  }




/*
	BLM16x16 optimized LED pattern transfer
+-----------------------------------------------+---------------------+
| column LEDs 0..6, green colour, 8th LED off   | B<row> 10 <pattern> |
| column LEDs 0..6, green colour, 8th LED on    | B<row> 11 <pattern> |
| column LEDs 8..14, green colour, 16th LED off | B<row> 12 <pattern> |
| column LEDs 8..14, green colour, 16th LED on  | B<row> 13 <pattern> |
+-----------------------------------------------+---------------------+
| column LEDs 0..6, red colour, 8th LED off     | B<row> 20 <pattern> |
| column LEDs 0..6, red colour, 8th LED on      | B<row> 21 <pattern> |
| column LEDs 8..14, red colour, 16th LED off   | B<row> 22 <pattern> |
| column LEDs 8..14, red colour, 16th LED on    | B<row> 23 <pattern> |
+-----------------------------------------------+---------------------+



Extra Column optimized LED pattern transfer
NOTE: in distance to single LED access, we always sent over the same channel!
+--------------------------------------------+-----------------+
| row LEDs 0..6, green colour, 8th LED off   | B0 40 <pattern> |
| row LEDs 0..6, green colour, 8th LED on    | B0 41 <pattern> |
| row LEDs 8..14, green colour, 16th LED off | B0 42 <pattern> |
| row LEDs 8..14, green colour, 16th LED on  | B0 43 <pattern> |
+--------------------------------------------+-----------------+
| row LEDs 0..6, red colour, 8th LED off     | B0 48 <pattern> |
| row LEDs 0..6, red colour, 8th LED on      | B0 49 <pattern> |
| row LEDs 8..14, red colour, 16th LED off   | B0 4A <pattern> |
| row LEDs 8..14, red colour, 16th LED on    | B0 4B <pattern> |
+--------------------------------------------+-----------------+


Extra Row optimized LED pattern transfer
+-----------------------------------------------+-----------------+
| column LEDs 0..6, green colour, 8th LED off   | B0 60 <pattern> |
| column LEDs 0..6, green colour, 8th LED on    | B0 61 <pattern> |
| column LEDs 8..14, green colour, 16th LED off | B0 62 <pattern> |
| column LEDs 8..14, green colour, 16th LED on  | B0 63 <pattern> |
+-----------------------------------------------+-----------------+
| column LEDs 0..6, red colour, 8th LED off     | B0 68 <pattern> |
| column LEDs 0..6, red colour, 8th LED on      | B0 69 <pattern> |
| column LEDs 8..14, red colour, 16th LED off   | B0 6A <pattern> |
| column LEDs 8..14, red colour, 16th LED on    | B0 6B <pattern> |
+-----------------------------------------------+-----------------+


Additional extra LEDs, optimized LED pattern transfer (prefered usage):
+-----------------------------------------------+-----------------+
| extra  LEDs 0..6, green colour, 8th LED off   | BF 60 <pattern> |
| extra  LEDs 0..6, green colour, 8th LED on    | BF 61 <pattern> |
+-----------------------------------------------+-----------------+
| extra LEDs 0..6, red colour, 8th LED off      | BF 68 <pattern> |
| extra LEDs 0..6, red colour, 8th LED on       | BF 69 <pattern> |
+-----------------------------------------------+-----------------+
*/

else if(midi_package.event == CC){
									// Extrahiere den MIDI-Kanal aus der MIDI-Paketstruktur
									u8 row = midi_package.chn;
									
									// Steuerbyte und Muster aus der MIDI-Nachricht
									u8 controlByte = midi_package.cc_number;
									u8 pattern = midi_package.value;
									
									// Interpretiere das MIDI-Protokoll für die LED-Musterübertragung
									// Protokoll für 16x16 Matrix
									if(row >= 0 && row <= 15){	
																// grün //////////////////////////////////////////////////////
																// column LEDs 0..6, green colour, 8th LED off
																if (controlByte == 16) 		{ process16x16(row, 0, pattern); }
																
																// column LEDs 0..6, green colour, 8th LED on
																else if (controlByte == 17) { process16x16(row, 0, pattern); }
																
																// column LEDs 8..14, green colour, 16th LED off
																else if (controlByte == 18) { process16x16(row, 0, pattern); }
																
																// column LEDs 8..14, green colour, 16th LED on
																else if (controlByte == 19) { process16x16(row, 0, pattern); }
																
																
																// rot ///////////////////////////////////////////////////////
																// column LEDs 0..6, red colour, 8th LED off
																else if (controlByte == 32) { process16x16(row, 1, pattern); }
																
																// column LEDs 0..6, red colour, 8th LED on
																else if (controlByte == 33) { process16x16(row, 1, pattern); }
																
																// column LEDs 8..14, red colour, 16th LED off
																else if (controlByte == 34) { process16x16(row, 1, pattern); }

																// column LEDs 8..14, red colour, 16th LED on
																else if (controlByte == 35) { process16x16(row, 1, pattern);}
																}
																
									// Protokoll für Extra Column (1x16 Matrix)
									else if (row == 0 && controlByte >= 64 && controlByte <= 75) { processExtraColumn(controlByte, pattern); }
									
									// Protokoll für Extra Row (1x16 Matrix)
									else if (row == 0 && controlByte >= 96 && controlByte <= 107) { processExtraRow(controlByte, pattern); }
									}
notifyDataReceived();
}
	



s32 APP_SYSEX_Parser(mios32_midi_port_t port, u8 midi_in){

// aka get midinotes from Ableton midiclip via SYSEX
//MIOS32_MIDI_SendDebugMessage("received sysex");

/* NEW Color
0 OFF
1 Blue
2 Green
3 Cyan

4 Blink  Blue <> Off
5 Blink  Green <> Off
6 Blink  Cyan <> Off
*/

static u8 function;
static u8 ab;
static u8 listen = 0;
static u16 cnt = 0;


	// BLM Controll //////////////////////////////////////////////////
	typedef struct {	unsigned char farbe: 3;	} blm_t;

	static blm_t BLM[16] = { {0},{0},{0},{0}, {0},{0},{0},{0}, {0},{0},{0},{0}, {0},{0},{0},{0} }; // 0-15 BLM, 16 Extra H, 17 Extra V   - 8 colors
	
	static u8 onetimer = 1;
	if(onetimer) { onetimer = 0;	// kill Flag
		
					u8 x; for(x=0;x<16;x++){ BLM[x].farbe = 0; 	}
					}

	static u8 row = 0;

	
	if(port==sysexPort) {	//MIOS32_MIDI_SendDebugMessage("midi_in.%d", midi_in);  // DEBUG
							
							// port 19 = USB4   //MIOS32_MIDI_SendDebugMessage("midi_in.%d", midi_in);  // DEBUG

							if(listen==1)	{	cnt++;	}	// count to index the next byte

							// Check ID   first bit		 id is not 0      stop listen
							if(listen==1 &&	cnt==1) { 	if(midi_in != 77)	{ listen = 0; }
														//else { MIOS32_MIDI_SendDebugMessage(" got id %d", midi_in);}
														}


							// Set Function
							if(listen==1 && cnt==2)	{	if(midi_in < 127) {	function = midi_in;	// set Function
																			//MIOS32_MIDI_SendDebugMessage(" had set Function %d", function);
																			}

														else{listen = 0; cnt = 0; }					// stop listen, because off wrong Sysexformat
														}

							// BLM View TM <> Ableton	 /////////////////////////////////////////////////////////
							if(function==1){


												if(listen==1 && cnt==3){	if(midi_in==1){			Auftrag.BLMView = 1; }
																			else if(midi_in==2){	Auftrag.BLMView = 2; }
																			
																			else{ 			Auftrag.BLMView = 0;
																							Auftrag.upd_BLM_16x16 = 1;
																							Auftrag.upd_BLM_H = 1;
																							Auftrag.upd_BLM_V = 1;
																							//Auftrag.LCD0 = 1;
																							//Auftrag.LCD1 = 1;
																							//Auftrag.LCDH = 1;
																							//Auftrag.LCDV = 1;
																							}

																			listen = 0; cnt = 0; 	// stop listen
																		}
												}
	
	
							// Clear 16x16 LEDS	 ////////////////////////////////////////////////////////////////
							else if(function==2){

												if(listen==1 && cnt==3){	if(midi_in){	BLM_LED_OFF(0); }

																			listen = 0; cnt = 0; 	// stop listen
																		}
												}
												
							// Clear V LEDS	 ////////////////////////////////////////////////////////////////
							else if(function==3){

												if(listen==1 && cnt==3){	if(midi_in){	BLM_LED_OFF(1); }

																			listen = 0; cnt = 0; 	// stop listen
																		}
												}
												
							// Clear H LEDS	 ////////////////////////////////////////////////////////////////
							else if(function==4){

												if(listen==1 && cnt==3){	if(midi_in){	BLM_LED_OFF(2); }

																			listen = 0; cnt = 0; 	// stop listen
																		}
												}
	
							// Clear ALL LEDS	 ////////////////////////////////////////////////////////////////
							else if(function==5){

												if(listen==1 && cnt==3){	if(midi_in){	BLM_LED_OFF(5);
																							MIOS32_BOARD_LED_Init(0xffffffff);
																							}

																			listen = 0; cnt = 0; 	// stop listen
																		}
												}
	

																
									
							// BLM 16x16 - 8@Once
							else if(function==9){

											if(listen){
														switch(cnt){
																		// row
																		case 3:		if(midi_in < 16)	{	row = midi_in;			
																											//MIOS32_MIDI_SendDebugMessage("row %d", row); 
																											break;}	
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// a or b  (first 8 or 2nd 8 cells)
																		case 4:		if(midi_in < 2)		{	if(midi_in) {	ab = 1;  break;}
																											else { 			ab = 0;	 break;}
																										}
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat
																					
																		// 0. LED
																		case 5:		if(midi_in < 8)	{	BLM[0].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color1:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat

																		// 1. LED
																		case 6:		if(midi_in < 8)	{	BLM[1].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color2:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 2. LED
																		case 7:		if(midi_in < 8)	{	BLM[2].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color3:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 3. LED
																		case 8:	if(midi_in < 8)	{	BLM[3].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color4:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 4. LED
																		case 9:	if(midi_in < 8)	{	BLM[4].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color5:  %d", midi_in);
																										break;}	// set color
																					else 			{	listen = 0; cnt = 0;	break;}

																		// 5. LED
																		case 10:	if(midi_in < 8)	{	BLM[5].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color6:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 6. LED
																		case 11:	if(midi_in < 8)	{	BLM[6].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color7:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 7. LED	&&  Dump out all 8 LEDs
																		case 12:	if(midi_in < 8)	{	BLM[7].farbe = midi_in;
																										//MIOS32_MIDI_SendDebugMessage("color8:  %d", midi_in);
																										listen = 0; cnt = 0; 	// stop listen - avoid to much characters)
																										
																										// Dump-out
																										u8 x; for(x=0; x<8; x++){	
																																	// get color;
																																	u8 color = BLM[x].farbe;
																																	u8 blink = 0;
																																	if( color >= 4 && color <= 6){  color = color - 3;
																																									blink = 1; }
																																	if( color >= 7) { color = 3; }	// clip 
																																	if(ab){	BLM_LED(0,  x+8, row, color, blink); } // LED 8-15
																																	else{ 	BLM_LED(0,  x,   row, color, blink); } // LED 0- 7
																																	//MIOS32_MIDI_SendDebugMessage("ab %d   row %d   x %d   color %d   blink %d ", ab, row, x, color, blink); 
																																	}
																										break;
																										}

																					else{					listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat
																		break;
																		}
															}
											}
																	
																							
							// BLM Extra V - 8@Once
							else if(function==10){

											if(listen){
														switch(cnt){
																		// row
																		case 3:		if(midi_in < 16)	{	row = midi_in;			break;}	
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// a or b  (first 8 or 2nd 8 cells)
																		case 4:		if(midi_in < 2)		{	if(midi_in) {	ab = 1;	break;}
																											else { 			ab = 0;	break;}
																										}
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat
																					
																		// 0. LED
																		case 5:		if(midi_in < 8)	{	BLM[0].farbe = midi_in;	break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat

																		// 1. LED
																		case 6:		if(midi_in < 8)	{	BLM[1].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 2. LED
																		case 7:		if(midi_in < 8)	{	BLM[2].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 3. LED
																		case 8:	if(midi_in < 8)	{	BLM[3].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 4. LED
																		case 9:	if(midi_in < 8)	{	BLM[4].farbe = midi_in;	break;}
																					else 			{	listen = 0; cnt = 0;	break;}

																		// 5. LED
																		case 10:	if(midi_in < 8)	{	BLM[5].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 6. LED
																		case 11:	if(midi_in < 8)	{	BLM[6].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 7. LED	&&  Dump out all 8 LEDs
																		case 12:	if(midi_in < 8)	{	BLM[7].farbe = midi_in;
																										listen = 0; cnt = 0; 	// stop listen - avoid to much characters)
																										
																										// Dump-out
																										u8 x; for(x=0; x<8; x++){	
																																	// get color;
																																	u8 color = BLM[x].farbe;
																																	u8 blink = 0;
																																	if( color >= 4 && color <= 6){  color = color - 3;
																																									blink = 1; }
																																	if( color >= 7) { color = 3; }	// clip 
																																	
																																	if(ab){	BLM_LED(2, 0, x+8, color, blink); } // LED 8-15
																																	else{ 	BLM_LED(2, 0, x,   color, blink); } // LED 0- 7
																																	}
																										break;
																										}

																					else{					listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat
																		break;
																		}
															}


											}
	
							// BLM Extra V - 8@Once
							else if(function==11){

											if(listen){
														switch(cnt){
																		// row
																		case 3:		if(midi_in < 16)	{	row = midi_in;			break;}	
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// a or b  (first 8 or 2nd 8 cells)
																		case 4:		if(midi_in < 2)		{	if(midi_in) {	ab = 1;	break;}
																											else { 			ab = 0;	break;}
																										}
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat
																					
																		// 0. LED
																		case 5:		if(midi_in < 8)	{	BLM[0].farbe = midi_in;	break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat

																		// 1. LED
																		case 6:		if(midi_in < 8)	{	BLM[1].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 2. LED
																		case 7:		if(midi_in < 8)	{	BLM[2].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 3. LED
																		case 8:	if(midi_in < 8)	{	BLM[3].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 4. LED
																		case 9:	if(midi_in < 8)	{	BLM[4].farbe = midi_in;	break;}
																					else 			{	listen = 0; cnt = 0;	break;}

																		// 5. LED
																		case 10:	if(midi_in < 8)	{	BLM[5].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 6. LED
																		case 11:	if(midi_in < 8)	{	BLM[6].farbe = midi_in;	break;}
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 7. LED	&&  Dump out all 8 LEDs
																		case 12:	if(midi_in < 8)	{	BLM[7].farbe = midi_in;
																										listen = 0; cnt = 0; 	// stop listen - avoid to much characters)
																										
																										// Dump-out
																										u8 x; for(x=0; x<8; x++){	
																																	// get color;
																																	u8 color = BLM[x].farbe;
																																	u8 blink = 0;
																																	if( color >= 4 && color <= 6){  color = color - 3;
																																									blink = 1; }
																																	if( color >= 7) { color = 3; }	// clip 
																																									
																																	if(ab){	BLM_LED(1, x+8, 0, color, blink); } // LED 8-15
																																	else{ 	BLM_LED(1, x,   0, color, blink); } // LED 0- 7
																																	}
																										break;
																										}

																					else{					listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat
																		break;
																		}
															}


											}
	


							// BLM 16x16 - 1 Cell
							else if(function==12){

											if(listen){
														switch(cnt){
																		// H Position
																		case 3:		if(midi_in < 16)	{	ab = midi_in;	break;}	
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// V Position
																		case 4:		if(midi_in < 16)	{	row = midi_in;  break;}
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// LED-Color	&&  Dump out
																		case 5:		if(midi_in < 8)	{	BLM[0].farbe = midi_in;
																										listen = 0; cnt = 0; 	// stop listen - avoid to much characters)
																										
																										// get color;
																										u8 color = BLM[0].farbe;
																										u8 blink = 0;
																										if( color >= 4 && color <= 6){  color = color - 3;
																																		blink = 1; }
																										if( color >= 7) { color = 3; }	// clip 
																										
																										BLM_LED(0, ab, row, color, blink); 

																										break;
																										}

																					else{				listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat
																		break;
																		}
															}
											}

							// BLM Extra V - 1 Cell
							else if(function==13){

											if(listen){
														switch(cnt){
																		// H Position
																		case 3:		if(midi_in < 16)	{	ab = midi_in;	break;}	
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// V Position
																		case 4:		if(midi_in < 16)	{	row = midi_in;  break;}
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// LED-Color	&&  Dump out
																		case 5:		if(midi_in < 8)	{	BLM[0].farbe = midi_in;
																										listen = 0; cnt = 0; 	// stop listen - avoid to much characters)
																										
																										// get color;
																										u8 color = BLM[0].farbe;
																										u8 blink = 0;
																										if( color >= 4 && color <= 6){  color = color - 3;
																																		blink = 1; }
																										if( color >= 7) { color = 3; }	// clip 
																										
																										BLM_LED(2, 0, row, color, blink);

																										break;
																										}

																					else{				listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat
																		break;
																		}
															}
											}							

							// BLM Extra H - 1 Cell
							else if(function==14){

											if(listen){
														switch(cnt){
																		// H Position
																		case 3:		if(midi_in < 16)	{	ab = midi_in;	break;}	
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// V Position
																		case 4:		if(midi_in < 16)	{	row = midi_in;  break;}
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat

																		// LED-Color	&&  Dump out
																		case 5:		if(midi_in < 8)	{	BLM[0].farbe = midi_in;
																										listen = 0; cnt = 0; 	// stop listen - avoid to much characters)
																										
																										// get color;
																										u8 color = BLM[0].farbe;
																										u8 blink = 0;
																										if( color >= 4 && color <= 6){  color = color - 3;
																																		blink = 1; }
																										if( color >= 7) { color = 3; }	// clip 
																										
																										BLM_LED(1, ab, 0, color, blink);

																										break;
																										}

																					else{				listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat
																		break;
																		}
															}
											}		
	
							// BLM 16x16 - 12@Once (columns)
							else if(function==20){

											if(listen){
														switch(cnt){
																		// column
																		case 3:		if(midi_in < 16)	{	row = midi_in;			
																											//MIOS32_MIDI_SendDebugMessage("row %d", row); 
																											break;}	
																					else 				{	listen = 0; cnt = 0;	break;}	// stop listen,wrong Sysexformat
																					
																		// 0. LED
																		case 4:		if(midi_in < 8)	{	BLM[0].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color1:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat

																		// 1. LED
																		case 5:		if(midi_in < 8)	{	BLM[1].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color2:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 2. LED
																		case 6:		if(midi_in < 8)	{	BLM[2].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color3:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 3. LED
																		case 7:	if(midi_in < 8)	{	BLM[3].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color4:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 4. LED
																		case 8:	if(midi_in < 8)	{	BLM[4].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color5:  %d", midi_in);
																										break;}	// set color
																					else 			{	listen = 0; cnt = 0;	break;}

																		// 5. LED
																		case 9:		if(midi_in < 8)	{	BLM[5].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color6:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 6. LED
																		case 10:	if(midi_in < 8)	{	BLM[6].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color7:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 7. LED
																		case 11:	if(midi_in < 8)	{	BLM[7].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color7:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 8. LED
																		case 12:	if(midi_in < 8)	{	BLM[8].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color7:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 9. LED
																		case 13:	if(midi_in < 8)	{	BLM[9].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color7:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}

																		// 10. LED
																		case 14:	if(midi_in < 8)	{	BLM[10].farbe = midi_in;	
																										//MIOS32_MIDI_SendDebugMessage("color7:  %d", midi_in);
																										break;}	// set color
																					else  			{	listen = 0; cnt = 0;	break;}


																		// 11. LED	&&  Dump out all 8 LEDs
																		case 15:	if(midi_in < 8)	{	BLM[11].farbe = midi_in;
																										//MIOS32_MIDI_SendDebugMessage("color8:  %d", midi_in);
																										listen = 0; cnt = 0; 	// stop listen - avoid to much characters)
																										
																										// Dump-out
																										u8 x; for(x=0; x<12; x++){	
																																	// get color;
																																	u8 color = BLM[x].farbe;
																																	u8 blink = 0;
																																	if( color >= 4 && color <= 6){  color = color - 3;
																																									blink = 1; }
																																	if( color >= 7) { color = 3; }	// clip 
																																	BLM_LED(0,  row, x, color, blink);
																																	//MIOS32_MIDI_SendDebugMessage("ab %d   row %d   x %d   color %d   blink %d ", ab, row, x, color, blink); 
																																	}
																										break;
																										}

																					else{					listen = 0; cnt = 0;	break;}	// stop listen, wrong Sysexformat
																		break;
																		}
															}
											}
									
										



							// start listen to the Sysex-Stream
							if( midi_in == 240)  {	listen = 1;
													cnt = 0;	// to indicate the first bit
													//MIOS32_MIDI_SendDebugMessage("startet stream");
													}

							// stop listen to the Sysex-Stream
							if( midi_in == 247)  {	listen = 0;
													cnt = 0; // reset counter
													//MIOS32_MIDI_SendDebugMessage("stopped stream");
													}
							
							//MIOS32_MIDI_SendDebugMessage("port %d     listen %d   midi_in %d  function %d  counter %d ", port, listen, midi_in, function, cnt); 

}


										
										
										



  return 0; // no error

 
}


void APP_SRIO_ServicePrepare(void){// This hook is called before the shift register chain is scanned
  BLM_SCALAR_PrepareCol();   // prepare DOUT registers to drive the column
  //MIOS32_MIDI_SendDebugMessage("scalar precall");
}

void APP_SRIO_ServiceFinish(void){// This hook is called after the shift register chain has been scanned /
  BLM_SCALAR_GetRow();  // call the BLM_GetRow function after scan is finished to capture the read DIN values
  //MIOS32_MIDI_SendDebugMessage("service finish");
    // increment request timer counter
  ++sysexRequestTimer;
}

void APP_DIN_NotifyToggle(u32 pin, u32 pin_value) {MIOS32_MIDI_SendDebugMessage("DIN-button-pressed");}//pin_value is 1 = button released, 0 button pressed



/*
// This hook is called when a pot has been moved ///////////////////////
void APP_AIN_NotifyChange(u32 pin, u32 pin_value){
u8 value_7bit = pin_value >> 5; //scale to 0-127
if(pin == 0) { MIOS32_MIDI_SendCC(33, 0, 0, value_7bit);} //32=MidiA, 33=MidiB
if(pin == 1) { MIOS32_MIDI_SendCC(33, 1, 0, value_7bit);}
if(pin == 2) { MIOS32_MIDI_SendCC(33, 2, 0, value_7bit);}
if(pin == 3) { MIOS32_MIDI_SendCC(33, 3, 0, value_7bit);}}

*/
/////////////////////////////////////////////////////////////////////////////
// This task is called each mS to check the BLM button states
// will be called on BLM pin changes (see TASK_BLM_Check)







static void TASK_BLM_Check(void *pvParameters){

  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // check for BLM pin changes, call DIN_BLM_NotifyToggle on each toggled pin
    BLM_SCALAR_ButtonHandler(DIN_BLM_NotifyToggle);
    // MIOS32_MIDI_SendDebugMessage("BLM-Check");
  }
}
