//CC LOOPER V1       NordRack 3  Edition     ======================================//

#include <mios32.h>
#include "app.h"
#include "tasks.h"
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <seq_bpm.h>
#include <wchar.h> // to copy pattern-memory


xSemaphoreHandle xSDCardSemaphore; 	// take and give access to SD-Card

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//System Variables
////////////////////////////////////////////////

    // Note, Clock, PC  SOURCE  &&  DESTINATION
    #define  PCChIN 6  			// ProgramChange Input Channel
    #define  CC_PC_Bank 32 		// Bank for Program-Change in order to use more then 128 songs....
    #define  CC_Tact_mono 23 	// 3/4,   4/4 tact system receive for external sequencers
    #define  CC_Save_mono 24 	// external store signal, so this app save @ same time like external (only one save button in setup...)
    const    u8 MeloCh[4]   = {0,1,2,3};   // receive Triggers (4 Melody Morph)  &  send the CCs to this CHannels  //ACT ALSO AS MIDIFILTER! avoid to much traffic!
    
    
    #define  TrigMidiThruClock 1 //MeloPort send Midiclock reroute that to the UART-Outputs
  
    #define  SD_Check_Time 1310       // (us?)
    #define  PC_Load_Timer 250          // (ms)  //505 once was 500
    #define  PC_Save_Timer 250          // (ms)  //505 once was 500

    // Task Prioritys	
    #define PRIORITY_MSQ	            ( tskIDLE_PRIORITY + 3 ) //4:high            
    #define PRIORITY_APP_Tick	        ( tskIDLE_PRIORITY + 2 ) //2 lower then midi
    
    // local prototype of the task function
    static void TASK_FLAG(void *pvParameters);
    void SD(u16 clip, u16 job);
    static void TASK_SEQ(void *pvParameters);
    static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 byte);
    u8 CC_Tact_Ext_Storage = 0;
    u32 PIN_REVERT(u32 pin);
    

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Coding only Variables --- No normally user Settings here
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


    u8 channel 			= 0; 
    u8 part				= 0;   	// soll channel ersetzen 303
	u8 encmode 			= 0;
    u8 Ring[4] 			= {};	// 	hardwareside Ledrings (value dividet by 8 for 16 LEDs...)
    u8 Ring_Style[4] 	= {};   // 	blink types, static led and so on
	u8 IND_loop[4]		= {};	//	Indicate Loop-Position

    u8 MSQ_Clear_Sel   	= 0;
    u8 MSQ_Clear_All   	= 0;
    u8 shift 			= 1;
    
    u8 Rec_CC[4] 	 	= {128,128,128,128}; // Internal ControlChange Number // 128 means NOTHING/BLANK
	u8 Rec_VAL[4]		= {128,128,128,128}; // Internal ControlChange Value  // 128 means Nothing
	u8 LastMoved[4]		= {128,128,128,128}; // Last touched ControlChange Number //128=nothing
	u8 Rec[4]			= {0,0,0,0}; // Dont Record by default
	
    // Store-Load Variables
    u16 SongNrStor 		= 0; 	// store song
    u16 SongNrLoad 		= 0;	// load  song
    u16 PCIN 			= 0;   	// received Programchange Value
    s16	song			= 0;	// load, store Song Number
    
    // CC Status LEDs
	u8 cc_led[4] = {1,1,1,1};
	
	// Blinkers
	u16 blink500 = 0;
	u16 blink250 = 0;
	u16 blink100 = 0;
	
    // LED Matrix DOUT Routine
    u8 LED[4][19]={{}};
    
    u8 beatles = 0;
    u8 LED_Gestic=128; // 128 Mean Nothing - do nothing
    
    
void APP_Init(void){	 u16 x = 0, y = 0, z = 0;  // for FOR loops

	// MSQ //////////////////////////////////////////////////////////////////////////////////////
    for(x=0; x<4; x++){    	msq[x].rythm           	= 4;    // 4x4=16, 5x3=15 usw... maximal duration per matrix page
							msq[x].PAGE_Steps		= 16;	// calculate from 0 on....so 0-15 are 16 Steps  
							msq[x].bpm				= 100; 	
							msq[x].loop_lenght_set	= 1; 	// 0-15 = Value of LED of a ring
							msq[x].Active			= 1;
							
							for(y=0; y<32; y++){	msq[x].Index[y] = 128;
							
													for(z=0; z<256; z++) { msq[x].SEQ[y][z] = 128; } // Clear Motion Sequence
							}				
						}
	MainLoop = 32;
    part     = 0;
    
    /////////////////////////////////////////////////////////////////////////
    // Initate Flags
    flag.PCLoad        		= 0;
    flag.PCSave        		= 0;
    flag.Tact_Ex_Load  		= 0;
    flag.NeedSync      		= 1; // to indicate that PAGE length has changed
    flag.FirstTic      		= 1;
    flag.copy          		= 0;
    flag.paste         		= 0;
    flag.msq_clear_sel 		= 0;
    flag.msq_clear_all 		= 0;
    flag.beatled			= 0;
    //
    ///////////////////////////////////////////////////////////////////////////////////////////////////////
	
    
    // init all LEDs
    MIOS32_BOARD_LED_Init(0xffffffff);
    
    // Encoder - Menue
    mios32_enc_config_t enc_config = MIOS32_ENC_ConfigGet(0);
	enc_config.cfg.type=DETENTED1;
	enc_config.cfg.speed=SLOW; 
	enc_config.cfg.speed_par=7; 
	enc_config.cfg.sr=1; 
	enc_config.cfg.pos=0;
	MIOS32_ENC_ConfigSet(0, enc_config);


    MIOS32_MIDI_DirectRxCallback_Init(NOTIFY_MIDI_Rx);
    xTaskCreate(TASK_SEQ,  (const portCHAR *)"TASK_SEQ",  128, NULL, 4, NULL);
    xTaskCreate(TASK_FLAG, (const portCHAR *)"TASK_FLAG", 128, NULL, 2, NULL);   // my own tasks jobs to do
    
	
    xSDCardSemaphore 	= xSemaphoreCreateRecursiveMutex(); // sd-card	create semaphores
    FILE_Init(0);	// init SD-CaRD
    SEQ_Init(0);
    
    rythm_count = 2; // 1= 4/4 tact
    
    // Board - UI - Lighting!
    MIOS32_BOARD_LED_Set(0, 1);
    MIOS32_BOARD_LED_Set(1, 1);
}


void APP_Background(void){    // lo-Priority 
    ///////////////////////////////////////////////////////////////////////////////////////////7        
    static u32 SDCardCount = 0;
    SDCardCount++; //  send Check-SDCard-Commant to StoreLoad-Function (track, clip, job)
    if (SDCardCount > SD_Check_Time) { SDCardCount = 0; SD(0, 3); }   
    ////////////////////////////////////////////////////////////////////////////////////////////

    flag.Seq_is_running = SEQ_BPM_IsRunning(); // get seq-running status, and save it into variable	
}


static void TASK_FLAG(void *pvParameters) { //  die vorhandenen aufgaben hier sinnvoll?
    
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS); // 505 welche rate für diese operation?



    // Copy Paste Single Synth-Voices
    if(flag.copy  == 1) { 	flag.copy  = 0; memcpy ( &msq_cpy,  &msq[part],  sizeof (store_t) ); } // COPY

    if(flag.paste == 1) { 	flag.paste = 0; 
							memcpy ( &msq[part],  &msq_cpy,  sizeof (store_t) ); // PASTE
							flag.NeedSync = 1;}

    if(flag.msq_clear_sel  == 1) { 	flag.msq_clear_sel = 0; 
									u16 x; for(x=0; x<256; x++) 	{ msq[part].SEQ[LastMoved[part]] [x] = 128; }}
                
    if(flag.msq_clear_all == 1) { 	flag.msq_clear_all = 0; 
									u16 x,y; for(x=0; x<32; x++) 	{ for(y=0; y<256; y++) {msq[part].SEQ[x][y]=128;}}}
}

}//End Hook


void APP_Tick(void){ // some Timers
	
	// Blinkers //
	// 500ms
	static u16 bl500 = 0;
	bl500++;
	if (bl500 > 499) {bl500 = 0; blink500 =! blink500;}
	// 250ms
	static u16 bl250 = 0;
	bl250++;
	if (bl250 > 249) {bl250 = 0; blink250 =! blink250;}
	// 100ms
	static u16 bl100 = 0;
	bl100++;
	if (bl100 > 99) {bl100 = 0; blink100 =! blink100;}
		
	// 4Bar Beat Impulse LED
	static u16 btd = 0;
	if(flag.beatled == 1) { btd++; }
	if(btd >= 12) { btd = 0; flag.beatled = 0; }
	
	if(flag.Seq_is_running == 0)	{   MIOS32_DOUT_PinSet	( 7, 0           );	}
	if(flag.Seq_is_running == 1)	{   MIOS32_DOUT_PinSet	( 7, flag.beatled);	}
	
	// BOARD-LED-Gestics
	if(LED_Gestic == 0) {	static u16 GestCount1 = 0;
							if(GestCount1 < 3000) 	{ GestCount1++;						MIOS32_BOARD_LED_Set(0, blink500);		MIOS32_BOARD_LED_Set(1, blink500);	} 	// Blink 2secs @ 500ms Rate aka "its done"
							if(GestCount1 > 2999) 	{ GestCount1=0;	LED_Gestic = 128;	MIOS32_BOARD_LED_Set(0, 1);				MIOS32_BOARD_LED_Set(1, 1);			} }	// Switch On Board Leds --- "back to normal"

	// BOARD-LED-Gestics
	if(LED_Gestic == 3) {	static u16 GestCount3 = 0;
							if(GestCount3 < 2000) 	{ GestCount3++;						MIOS32_BOARD_LED_Set(0, blink100);		MIOS32_BOARD_LED_Set(1, blink100);	} 	// Blink 2secs @ 100ms Rate aka "problem"
							if(GestCount3 > 1999) 	{ GestCount3=0;	LED_Gestic = 128;	MIOS32_BOARD_LED_Set(0, 1);				MIOS32_BOARD_LED_Set(1, 1);			} }	// Switch On Board Leds --- "back to normal"	
	
	// BOARD-LED-Gestic: Infinite   8
	static u16 GestCount1 = 0;
	if(LED_Gestic == 1)	{	if(GestCount1 < 400)	{ GestCount1++;						MIOS32_BOARD_LED_Set(0, 0);		MIOS32_BOARD_LED_Set(1, 0);					}
							if(GestCount1 > 399)	{ GestCount1++;						MIOS32_BOARD_LED_Set(0, 1);		MIOS32_BOARD_LED_Set(1, 1);					}						
							if(GestCount1 > 1000)	{ GestCount1=0;	} }// begin from new
								
	// BOARD-LED-Gestic: Reset to normal
	if(LED_Gestic == 2)	{ LED_Gestic = 128;		GestCount1=0; 	MIOS32_BOARD_LED_Set(0, 1); 	MIOS32_BOARD_LED_Set(1, 1);	}
	
    // CC-LED Flicker (turn off automaticly
    if ( cc_led[0] == 1 ) {		static u16 cnt_led0 = 0;
								cnt_led0++;
								if (cnt_led0++ >= 250) 	{ cnt_led0 = 0;		cc_led[0] = 0;  } }
    
    if ( cc_led[1] == 1 ) {		static u16 cnt_led1 = 0;
								cnt_led1++;
								if (cnt_led1++ >= 250) 	{ cnt_led1 = 0;		cc_led[1] = 0;  } }
    
    if ( cc_led[2] == 1 ) {		static u16 cnt_led2 = 0;
								cnt_led2++;
								if (cnt_led2++ >= 250) 	{ cnt_led2 = 0;		cc_led[2] = 0;  } }
    
    if ( cc_led[3] == 1 ) {		static u16 cnt_led3 = 0;
								cnt_led3++;
								if (cnt_led3++ >= 250) 	{ cnt_led3 = 0;		cc_led[3] = 0;  } }
							
							
	if( flag.Tact_Ex_Load == 1 )  {
		
            static u32 x = 0;
            x++; 
            if( x >  PC_Load_Timer  + 10 ) {
				
                                        x                  = 0;         // init counter for the next run
                                        flag.Tact_Ex_Load  = 0;         // Kill Flag to avoid double triggering events
                                        
                                        u8 y; for(y=0; y<4;   y++) {
											
													msq[y].rythm = CC_Tact_Ext_Storage;   // external received Tact over-ruling internal saved Tact
													
								                    switch(CC_Tact_Ext_Storage) {
									                        case 3:  msq[y].PAGE_Steps = 12;	MainLoop = msq[y].rythm * 8; 	flag.NeedSync = 1;	break;
									                        case 4:  msq[y].PAGE_Steps = 16; 	MainLoop = msq[y].rythm * 8; 	flag.NeedSync = 1;	break;
									                        case 5:  msq[y].PAGE_Steps = 10; 	MainLoop = msq[y].rythm * 8; 	flag.NeedSync = 1;	break;
									                        case 7:  msq[y].PAGE_Steps = 14; 	MainLoop = msq[y].rythm * 8; 	flag.NeedSync = 1;	break;
									                        case 9:  msq[y].PAGE_Steps =  9; 	MainLoop = msq[y].rythm * 8; 	flag.NeedSync = 1;	break;
									                        case 11: msq[y].PAGE_Steps = 11; 	MainLoop = msq[y].rythm * 8; 	flag.NeedSync = 1;	break;
									                        case 13: msq[y].PAGE_Steps = 13; 	MainLoop = msq[y].rythm * 8;	flag.NeedSync = 1; 	break;
								                    }}}} // Done	
	                    
                    					
	/*
        // Programchange Load when Stopped turning the Wheel (from External Source)
    if( flag.PCLoad == 1 )  {
            static u32 x = 0;
            x++; 
            if( x > PC_Load_Timer ) {   x            = 0;       // init counter for the next run
                                        flag.PCLoad  = 0;       // Kill Flag to avoid double triggering events
                                        SD(SongNrLoad, 1); }}   // LOAD

    if( flag.PCSave == 1 )  {
            static u32 x = 0;
            x++;

            if( x > PC_Save_Timer ) {   x            = 0;     // init counter for the next run
                                        flag.PCSave  = 0;     // Kill Flag to avoid double triggering events
                                        SD(SongNrStor, 2);
                                        }} // Store
                                        
*/
    } // called each mS from main task which also handles DIN, ENC and AIN events. You could add more jobs here - dont do more than 300uS!

       
void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){

	if 	( midi_package.chn  ==  MeloCh[0]  ||  midi_package.chn  ==  MeloCh[1]   ||  midi_package.chn  ==  MeloCh[2]   ||  midi_package.chn  ==  MeloCh[3] ) {
		
			
			// Thru Notes clock and so on...
			if (midi_package.type != CC)	{ MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
	
			// 505 To do Pitchchange thru
			
			
			// Control Change
			 if( midi_package.type == CC	&& 	 port == Port_IN2		&&		midi_package.evnt1 < 128) {
					
					// CC-Input- LED - Indicator
					cc_led[2]  = 1;
				
				
					// Replace Midi-Channel[0-15] with Index [0-3]
					u8 Chann =  0;							// Index CH  Actual Edit Part   Turn Off Record
					if ( midi_package.chn == MeloCh[0] )	{ Chann = 0; part = 0; 			Rec[1] = 0; Rec[2] = 0; Rec[3] = 0; }
					if ( midi_package.chn == MeloCh[1] )	{ Chann = 1; part = 1; 			Rec[0] = 0; Rec[2] = 0; Rec[3] = 0; }
					if ( midi_package.chn == MeloCh[2] )	{ Chann = 2; part = 2; 			Rec[0] = 0; Rec[1] = 0; Rec[3] = 0; }
					if ( midi_package.chn == MeloCh[3] )	{ Chann = 3; part = 3; 			Rec[0] = 0; Rec[1] = 0; Rec[2] = 0; }
					
					// Record, make index....
	
					u8 new = 1;
					u8 cc  = 128;
					u8 x   = 0;
					
					// NEW  or OLD ?
					for (x=0; x<32; x++) {	if ( msq[Chann].Index[x] == midi_package.evnt1 )	{ new = 0; } }	
										
					// NEW INDEX!  				
					if ( new == 1 )	{	// Find a Free mapping
										// 128 = not mapped			The last mapped Index	Save Index Nr   &   close While-loop	
										x= 0; while( x < 32) {	if (msq[Chann].Index[x] == 128 )	{ cc = x; 		x = 126; } 
															x++;	} // increment counter
										// Write Index Mapping
										if( Rec[Chann] == 1 )	{	msq[Chann].Index[cc] = midi_package.evnt1;  } }
	
	
					// OLD CC                                            - cc=Index
					if ( new == 0) {	for (x=0; x<32; x++) 	{  if(msq[Chann].Index[x] == midi_package.evnt1 )  { cc =  x; }	} }	
					
					if( Rec[Chann] == 1 )	{	// Save CC & Value,		2 Record it in MSQ-Task
													Rec_CC[Chann] 	=	cc; // Internal ControlChange Number
													Rec_VAL[Chann]	=	midi_package.evnt2; }//ControlChange Value
					
					// Write Last Moved Control Change Nr
					if( msq[Chann].Index[cc] != 128 ) {	LastMoved[Chann] = cc; }
	
			
		//MIOS32_MIDI_SendDebugMessage("new:%d   rec:%d   cc:%d   val:%d", new, Rec[Chann], midi_package.evnt1, midi_package.evnt2);
		
		//for (x=0; x<32; x++) {	MIOS32_MIDI_SendDebugMessage("cc:  %d", msq[0].Index[x]);}
		}	}
	
/*
    // Midi CCs
    switch(port) {
        
        case MeloPort: /////////////////////////////////////////////////////////////////////////////////////////////////////////

                // forwarding Midiclock & Transport     //    248CLK,250Strt,251Cont,252Stp
                if( TrigMidiThruClock==1  &&  (midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252) )
                        { MIOS32_MIDI_SendPackage(MeloPort,  midi_package); break; }


                if( midi_package.chn == PCChIN  &&  midi_package.type == CC) {
                    
                            switch( midi_package.cc_number ) {
                                         
                                        case CC_PC_Bank:    Bank = midi_package.value * 128;  break; // Bank0:0-127, Bank1:1-255...
                                        case CC_Tact_mono:  CC_Tact_Ext_Storage = midi_package.value;  flag.Tact_Ex_Load = 1;  break;  // set Rythm
                                        case CC_Save_mono:  SongNrLoad  = midi_package.value + Bank; // generate ProgramChange message via SAVE dialog
                                                            SongNrStor  = SongNrLoad;   
                                                            flag.PCSave = 1;  break; // Save after a while
                            }}
                                    
                            switch(midi_package.evnt0) {
                                    //  Midi CH         PC-Channel         Song-Nr   =              PC-Nr + Bank   Load after a while    also set Store-Number 
                                        case 192:   if( PCChIN == 0 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 193:   if( PCChIN == 1 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 194:   if( PCChIN == 2 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 195:   if( PCChIN == 3 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 196:   if( PCChIN == 4 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 197:   if( PCChIN == 5 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 198:   if( PCChIN == 6 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 199:   if( PCChIN == 7 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 200:   if( PCChIN == 8 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 201:   if( PCChIN == 9 )   { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 202:   if( PCChIN == 10 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 203:   if( PCChIN == 11 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 204:   if( PCChIN == 12 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 205:   if( PCChIN == 13 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 206:   if( PCChIN == 14 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                                        case 207:   if( PCChIN == 15 )  { SongNrLoad = midi_package.evnt1 + Bank;  flag.PCLoad = 1;  SongNrStor = SongNrLoad;  break; }
                            }
                            


              //forwarding Notes
              if(midi_package.evnt0==144) {//Note @ Midi Channel 1
                     if(MeloCh[0]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==145) {//Note @ Midi Channel 2
                     if(MeloCh[0]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}}
         else if(midi_package.evnt0==146) {//Note @ Midi Channel 3
                     if(MeloCh[0]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}}
         else if(midi_package.evnt0==147) {//Note @ Midi Channel 4
                     if(MeloCh[0]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}}
         else if(midi_package.evnt0==148) {//Note @ Midi Channel 5
                     if(MeloCh[0]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==149) {//Note @ Midi Channel 6
                     if(MeloCh[0]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==150) {//Note @ Midi Channel 7
                     if(MeloCh[0]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==151) {//Note @ Midi Channel 8
                     if(MeloCh[0]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}	}
         else if(midi_package.evnt0==152) {//Note @ Midi Channel 9
                     if(MeloCh[0]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==153) {//Note @ Midi Channel 10
                     if(MeloCh[0]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==154) {//Note @ Midi Channel 11
                     if(MeloCh[0]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}   
                else if(MeloCh[3]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}	}
         else if(midi_package.evnt0==155) {//Note @ Midi Channel 12
                     if(MeloCh[0]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}	}
         else if(midi_package.evnt0==156) {//Note @ Midi Channel 13
                     if(MeloCh[0]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==157) {//Note @ Midi Channel 14
                     if(MeloCh[0]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==158) {//Note @ Midi Channel 15
                     if(MeloCh[0]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
         else if(midi_package.evnt0==159) {//Note @ Midi Channel 16
                     if(MeloCh[0]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
                else if(MeloCh[1]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[2]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
                else if(MeloCh[3]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}	} 
        }
        */
    }    


void APP_SRIO_ServicePrepare(void){

	static u8 count  = 0;

    // Vertical Lines
	if(count == 0)	{ 	MIOS32_DOUT_PinSet( 3,	1); 
						MIOS32_DOUT_PinSet( 4,  0);
						MIOS32_DOUT_PinSet( 5,  0);
						MIOS32_DOUT_PinSet( 6,  0); }
		
	if(count == 1)	{ 	MIOS32_DOUT_PinSet( 3,	0); 
						MIOS32_DOUT_PinSet( 4,  1);
						MIOS32_DOUT_PinSet( 5,  0);
						MIOS32_DOUT_PinSet( 6,  0); }
		
	if(count == 2)	{ 	MIOS32_DOUT_PinSet( 3,	0); 
						MIOS32_DOUT_PinSet( 4,  0);
						MIOS32_DOUT_PinSet( 5,  1);
						MIOS32_DOUT_PinSet( 6,  0); }
		
	if(count == 3)	{ 	MIOS32_DOUT_PinSet( 3,	0); 
						MIOS32_DOUT_PinSet( 4,  0);
						MIOS32_DOUT_PinSet( 5,  0);
						MIOS32_DOUT_PinSet( 6,  1); }		
		
    // Activate Horizontal Lines  
	// 0 - 7  	8 - 15	  16 - 23

	MIOS32_DOUT_PinSet(2,    LED[count][0]); // SR1
	MIOS32_DOUT_PinSet(1,    LED[count][1]);
	MIOS32_DOUT_PinSet(0,    LED[count][2]);
	
	MIOS32_DOUT_PinSet(15,   LED[count][3]); // SR2
	MIOS32_DOUT_PinSet(14,   LED[count][4]);
	MIOS32_DOUT_PinSet(13,   LED[count][5]);
	MIOS32_DOUT_PinSet(12,   LED[count][6]); // schuldig?
	MIOS32_DOUT_PinSet(11,   LED[count][7]);
	MIOS32_DOUT_PinSet(10,   LED[count][8]);
	MIOS32_DOUT_PinSet(9,    LED[count][9]);
	MIOS32_DOUT_PinSet(8,    LED[count][10]); // SR2
	
	MIOS32_DOUT_PinSet(23,   LED[count][11]); // SR3
	MIOS32_DOUT_PinSet(22,   LED[count][12]);
	MIOS32_DOUT_PinSet(21,   LED[count][13]);
	MIOS32_DOUT_PinSet(20,   LED[count][14]);
	MIOS32_DOUT_PinSet(19,   LED[count][15]);
	MIOS32_DOUT_PinSet(18,   LED[count][16]);
	MIOS32_DOUT_PinSet(17,   LED[count][17]);
	MIOS32_DOUT_PinSet(16,   LED[count][18]); // SR3

    count++;
    if (count >= 4) 	{ count = 0; }
}
	


void APP_SRIO_ServiceFinish(void){

	//Transfair UI-Data to LED-Matrix

	u8 x; for(x=0; x<4; x++)	{	u8 y; for(y=0; y<19; y++)	{   LED[x][y] = 1; } }
	switch (encmode)	{
						case 0:	// Length Selection / PLAY MODE
								// CC-LED
								LED[0][0] =! cc_led[0];
								LED[1][0] =! cc_led[1];
								LED[2][0] =! cc_led[2];
								LED[3][0] =! cc_led[3];
								
								
								// Loop-Position Indication
								LED[0][IND_loop[0]+1] =! msq[0].Active; 	// Activate Step LED
								LED[1][IND_loop[1]+1] =! msq[1].Active; 	// Activate Step LED
								LED[2][IND_loop[2]+1] =! msq[2].Active; 	// Activate Step LED
								LED[3][IND_loop[3]+1] =! msq[3].Active; 	// Activate Step LED
								
								
								LED[0][msq[0].loop_lenght_set+1] =! 1;	// Show Loop Length Multiplicator
								LED[1][msq[1].loop_lenght_set+1] =! 1;	// Show Loop Length Multiplicator	
								LED[2][msq[2].loop_lenght_set+1] =! 1;	// Show Loop Length Multiplicator	
								LED[3][msq[3].loop_lenght_set+1] =! 1;	// Show Loop Length Multiplicator	
								
								// Record
								LED[0][17] =! Rec[0];
								LED[1][17] =! Rec[1];
								LED[2][17] =! Rec[2];
								LED[3][17] =! Rec[3];
								
								// Active Part "PLAY" / Focus
								LED[0][18] =! msq[0].Active;
								LED[1][18] =! msq[1].Active;
								LED[2][18] =! msq[2].Active;
								LED[3][18] =! msq[3].Active;
									
								if ( msq[part].Active == 1 ) { LED[part][18] = blink500; }	// Play/Focus
								if ( msq[part].Active == 0 ) { LED[part][18] = 1 ; }		// Stop/Focus
								break;
								
						case 1:	// PRESET / PLAY MODE
								// CC-LED
								LED[0][0] =! cc_led[0];
								LED[1][0] =! cc_led[1];
								LED[2][0] =! cc_led[2];
								LED[3][0] =! cc_led[3];
								
								
								// Preset Indication
								if ( song <= 63 )				{	LED[0][1] = blink500; 	//	we have only 63 LEDs here... so this is bank 0
																	if(song <= 15)					{ LED[0][song+1]   = 0;		}
																	if(song >= 16 && song < 32)		{ LED[1][song-15]  = 0;		}
																	if(song >= 32 && song < 48)		{ LED[2][song-31]  = 0;		}
																	if(song >= 48 && song < 64)		{ LED[3][song-47]  = 0;		}	}

								if ( song >= 64 && song <= 127)	{	LED[0][1] = 0;
																	LED[0][2] = blink500;
																	if(song <= 79)					{ LED[0][song-63]  = 0;		}
																	if(song >= 80 && song < 96)		{ LED[1][song-79]  = 0;		}
																	if(song >= 96 && song < 112)	{ LED[2][song-95]  = 0;		}
																	if(song >=112 && song < 128)	{ LED[3][song-111] = 0;		}	}
									
								if ( song >= 128 && song <= 191) {	LED[0][1] = 0;
																	LED[0][2] = 0;
																	LED[0][3] = blink500;
																	if(song <= 143)					{ LED[0][song-127] = 0;		}
																	if(song >= 144 && song < 160)	{ LED[1][song-143] = 0;		}
																	if(song >= 160 && song < 176)	{ LED[2][song-159] = 0;		}
																	if(song >= 176 && song < 192)	{ LED[3][song-175] = 0;		}	}		
									
								if ( song >= 192 && song <= 255) {	LED[0][1] = 0;
																	LED[0][2] = 0;
																	LED[0][3] = 0;
																	LED[0][4] = blink500;
																	if(song <  208)					{ LED[0][song-191] = 0;		}
																	if(song >= 208 && song < 224)	{ LED[1][song-207] = 0;		}
																	if(song >= 224 && song < 240)	{ LED[2][song-223] = 0;		}
																	if(song >= 240 && song < 256)	{ LED[3][song-239] = 0;		}	}	

								// Record
								LED[0][17] =! Rec[0];
								LED[1][17] =! Rec[1];
								LED[2][17] =! Rec[2];
								LED[3][17] =! Rec[3];
								
								// Active Part "PLAY" / Focus
								LED[0][18] =! msq[0].Active;
								LED[1][18] =! msq[1].Active;
								LED[2][18] =! msq[2].Active;
								LED[3][18] =! msq[3].Active;
									
								if ( msq[part].Active == 1 ) { LED[part][18] = blink500; }	// Play/Focus
								if ( msq[part].Active == 0 ) { LED[part][18] = 1 ; }		// Stop/Focus
								break;
								
						case 2:	// TACT / PLAY MODE
								// CC-LED
								LED[0][0] =! cc_led[0];
								LED[1][0] =! cc_led[1];
								LED[2][0] =! cc_led[2];
								LED[3][0] =! cc_led[3];
								
								
								// TACT	
								LED[0][msq[0].rythm] = 0; 	// Activate Step LED
								
								// Loop-Position Indication
								LED[1][IND_loop[1]+1] =! msq[1].Active; 	// Activate Step LED
								LED[2][IND_loop[2]+1] =! msq[2].Active; 	// Activate Step LED
								LED[3][IND_loop[3]+1] =! msq[3].Active; 	// Activate Step LED
								
								// Record
								LED[0][17] =! Rec[0];
								LED[1][17] =! Rec[1];
								LED[2][17] =! Rec[2];
								LED[3][17] =! Rec[3];
								
								// Active Part "PLAY" / Focus
								LED[0][18] =! msq[0].Active;
								LED[1][18] =! msq[1].Active;
								LED[2][18] =! msq[2].Active;
								LED[3][18] =! msq[3].Active;
									
								if ( msq[part].Active == 1 ) { LED[part][18] = blink500; }	// Play/Focus
								if ( msq[part].Active == 0 ) { LED[part][18] = 1 ; }		// Stop/Focus
								break;	
						break;}
	}


void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){	 // DEBUG
 MIOS32_MIDI_SendDebugMessage("pin: %d", pin);  // DEBUG 
    switch (pin) {
        // MSQ
        
        case 2:  	if(pin_value == 0  &&  shift == 0  &&  flag.Seq_is_running == 0) 	{	 SEQ_BPM_Start(); break;} // 2: Encoders Pushbutton + Shiftbutton = Start/Stop internal-Sequencer
                    if(pin_value == 0  &&  shift == 0  &&  flag.Seq_is_running == 1) 	{	 SEQ_BPM_Stop();  break;}   

        case 3:  	shift = pin_value;	break;      
        case 4:  	encmode = 0;		break;
        case 6:  	encmode = 1;		break;
        case 5:  	encmode = 2;		break;

        case 8:   	if(pin_value == 0 &&  shift == 1) 	{	flag.msq_clear_all = 1; 		break; }		// MSQ Clear ALL 		Rotary Encoders 
					if(pin_value == 0 &&  shift == 0) 	{  	flag.msq_clear_sel = 1;			break; } 		// MSQ Clear Selected  	Rotary Encoder
        
        case 9:   	if(pin_value == 0 && encmode == 0) 	{	flag.copy   = 1; 	break; }					// Shift copy select cc
					if(pin_value == 0 && encmode == 1) 	{	SD(2,song); 		break; }					// Store Patch
						
        case 10:   	if(pin_value == 0 && encmode == 0) 	{	flag.paste  = 1; 	break; }					// shift paste selected cc
					if(pin_value == 0 && encmode == 1) 	{	SD(1,song); 		break; }					// Load/Reload Patch
        
        // 		RECORD   &    PLAY    && 	FOCUS-Part
					//	REC		Part 0
        case 11:   	if(pin_value == 0 &&  shift == 0) 	{ 	u8 state = Rec[0]; 							
															u8 x; for (x=0; x<4; x++) { Rec[x] = 0; } 	// Clear Record BTNs
															Rec[0] =! state;		
															part = 0;				break; }				// Focused Part
					//	PLAY	Part 0							
					if(pin_value == 0 &&  shift == 1) 	{ 	u8 state = msq[0].Active; 						
															msq[0].Active =! state;		
															part = 0;				break; }				// Focused Part										
					//	REC		Part 1
        case 12:   	if(pin_value == 0 &&  shift == 0) 	{ 	u8 state = Rec[1]; 							
															u8 x; for (x=0; x<4; x++) { Rec[x] = 0; } 	// Clear Record BTNs
															Rec[1] =! state;		
															part = 1;				break; }
					//	PLAY	Part 1										
					if(pin_value == 0 &&  shift == 1) 	{ 	u8 state = msq[1].Active; 						
															msq[1].Active =! state;		
															part = 1;				break; }				// Focused Part
					//	REC		Part 2
        case 13:   	if(pin_value == 0 &&  shift == 0) 	{ 	u8 state = Rec[2]; 							
															u8 x; for (x=0; x<4; x++) { Rec[x] = 0; } 	// Clear Record BTNs
															Rec[2] =! state;		
															part = 2;				break; }
					//	PLAY	Part 2									
					if(pin_value == 0 &&  shift == 1) 	{ 	u8 state = msq[2].Active; 						
															msq[2].Active =! state;		
															part = 2;				break; }				// Focused Part
					//	REC		Part 3
        case 14:   	if(pin_value == 0 &&  shift == 0) 	{ 	u8 state = Rec[3]; 							
															u8 x; for (x=0; x<4; x++) { Rec[x] = 0; } 	// Clear Record BTNs
															Rec[3] =! state;		
															part = 3;				break; }
					//	PLAY	Part 3								
					if(pin_value == 0 &&  shift == 1) 	{ 	u8 state = msq[3].Active;
															msq[3].Active =! state;		
															part = 3;				break; }				// Focused Part																																						
        break; 
    }
     
}

void APP_ENC_NotifyChange(u32 encoder, s32 incrementer) { 
		s16 cc = 0;
		s8 ccold = 0;
	    switch(encmode) {   case 0:	// Loop Length
									cc = msq[part].loop_lenght_set - incrementer;
						            if ( cc <  0 ) 	{ cc =  0;  }  		// fix minimal value
						            if ( cc >  15 ) { cc =  15; }  		// fix maximalvalue
						            msq[part].loop_lenght_set = cc;
						            flag.NeedSync = 1; 					// Set Loop Length when reaching next "0 Main-Loop"-Step
									break; 
				          
							case 1:	// Preset
									cc = song - incrementer;
						            if ( cc <  0 ) 		{ cc =  0;  }  	// fix minimal value
						            if ( cc >  255 ) 	{ cc =  255; }  // fix maximalvalue
									song = cc;
									break;
							
					        default:	// Tactsystem 3/4, 4/4, 5/4, 7/4, 9/4, 11/4, 13/4
										ccold 	= msq[0].rythm;
										cc 		= msq[0].rythm - incrementer;
										
										if(cc <= 3)	{	cc = 3;
														msq[0].rythm = 3;	msq[0].PAGE_Steps = 12;
														msq[1].rythm = 3;	msq[1].PAGE_Steps = 12;
														msq[2].rythm = 3;	msq[2].PAGE_Steps = 12;
														msq[3].rythm = 3;	msq[3].PAGE_Steps = 12;		}
														
										if(cc == 4)	{	msq[0].rythm = 4;	msq[0].PAGE_Steps = 16;
														msq[1].rythm = 4;	msq[1].PAGE_Steps = 16;
														msq[2].rythm = 4;	msq[2].PAGE_Steps = 16;
														msq[3].rythm = 4;	msq[3].PAGE_Steps = 16;		}

										if(cc == 6 && ccold > 6)	{	cc = 5; }	// round down

										if(cc == 5)	{	msq[0].rythm = 5;	msq[0].PAGE_Steps = 10;
														msq[1].rythm = 5;	msq[1].PAGE_Steps = 10;
														msq[2].rythm = 5;	msq[2].PAGE_Steps = 10;
														msq[3].rythm = 5;	msq[3].PAGE_Steps = 10;		}
														
										if(cc == 6 && ccold <= 5)	{	cc = 7; }	// round up
										
										if(cc == 8 && ccold > 8)	{	cc = 7; }	// round down
																
										if(cc == 7)					{	msq[0].rythm = 7;	msq[0].PAGE_Steps = 14;
																		msq[1].rythm = 7;	msq[1].PAGE_Steps = 14;
																		msq[2].rythm = 7;	msq[2].PAGE_Steps = 14;
																		msq[3].rythm = 7;	msq[3].PAGE_Steps = 14;		}
																															
										if(cc == 8 && ccold <= 8)	{	cc = 9; }	// round up	
										
										if(cc == 10 && ccold > 10)	{	cc = 9; }	// round down
										
										if(cc == 9)					{	msq[0].rythm = 9;	msq[0].PAGE_Steps = 9;
																		msq[1].rythm = 9;	msq[1].PAGE_Steps = 9;
																		msq[2].rythm = 9;	msq[2].PAGE_Steps = 9;
																		msq[3].rythm = 9;	msq[3].PAGE_Steps = 9;		}	
																			
										if(cc == 10 && ccold <= 10)	{	cc = 11; }	// round up								

										if(cc == 12 && ccold > 12)	{	cc = 11; }	// round down
										
										if(cc == 11)				{	msq[0].rythm = 11;	msq[0].PAGE_Steps = 11;
																		msq[1].rythm = 11;	msq[1].PAGE_Steps = 11;
																		msq[2].rythm = 11;	msq[2].PAGE_Steps = 11;
																		msq[3].rythm = 11;	msq[3].PAGE_Steps = 11;		}	
																						
										if(cc == 12 && ccold <= 12)	{	cc = 13; }	// round up

										if(cc >= 13)				{	cc = 13;
																		msq[0].rythm = 13;	msq[0].PAGE_Steps = 13;
																		msq[1].rythm = 13;	msq[1].PAGE_Steps = 13;
																		msq[2].rythm = 13;	msq[2].PAGE_Steps = 13;
																		msq[3].rythm = 13;	msq[3].PAGE_Steps = 13;		}												
																												
										MainLoop = msq[0].rythm * 8;	
										flag.NeedSync = 1;
										break;  
					        break; }// Tact     303

	MIOS32_MIDI_SendDebugMessage("looplength:%d", msq[part].loop_lenght_set);  // DEBUG
}


static void TASK_SEQ(void *pvParameters){ // called each mS > seuecer request
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // execute sequencer handler
    SEQ_Handler();

  }
}

// SEQ --- Installed via MIOS32_MIDI_DirectRxCallback_Init
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 midi_byte){//filter Midiclock Port and rerout it to SEQUENCER-BPM
if(port == MeloPort) { SEQ_BPM_NotifyMIDIRx(midi_byte); }
  return 0; // no error, no filtering
}




u8 MSQ(u8 port, u8 step) {  //  CC Automation  -  Motion Sequencer  -  Send CC 2 Synths


// if(port == 0) {MIOS32_MIDI_SendDebugMessage("rec:%d play:%d step: %d, ind:%d, port:%d", msq[0].Rec, msq[0].Active, step, IND_loop[0],port);}

    // REC MSQ
    if(Rec[port] == 1	&&	Rec_VAL[port] != 128	&&	Rec_CC[port] != 128) 	{	msq[port].SEQ[ Rec_CC[port] ] [step]	=	Rec_VAL[port]; }
		
		
		//msq[port].SEQ[msq[channel].LastMoved][step] = msq[channel].SEQ[msq[channel].LastMoved];
		
    // show Loop Position on 4 LED-Bars                scale LoopLength to 0-15 LEDs
    if( msq[port].Active )		{	IND_loop[port]   =   (  (10000  *  step / (msq[port].PAGE_Steps  *  (msq[port].loop_lenght_set+1)))  *  16)  /  10000;	} 	
    
    
    
 // Play MSQ @ SYNTH
 if( port < 4  &&  msq[port].Active == 1 ) {
	                  
	        int x; for(x=0; x<32; x++) {
				
							
				            // Is there any CC-Value @ Step?    &&  Is the Index mapped? 
				            if( msq[port].SEQ[x][step] != 128	&&	msq[port].Index[x] != 128) { u8 value =  msq[port].SEQ[x][step];
						        
																			// Map From Index [0-32]  to  external CCs[0-128] 
																			u8 cc    = msq[port].Index[x];
																			
																			//Talk to SYNTH
																			MIOS32_MIDI_SendCC( MeloPort,  MeloCh[port],   cc,  value ); 	
																			
																			// CC-OUT-LED-Indicator
																			cc_led[0] = 1;	}
		    }}
  return 0; // no error,
}


// S T O R A G E - SD - C A R D      ///        // read write clips/programchanges
void SD(u16 clip, u16 job){           // Job1=load, Job2=store, Job3=initalize card

    const static char file_type[4] = "sigl";    // definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header
    static char file_path[16] =  {};            // STORE-path - Number of Pathsymbols tm/512.tm    
    static s8 statusSD;			                // Status of the SDCard--connected? fat?
    static s8 statusDir;			            // Status "is" your direction "sdcard/t" there?
    static file_t midifile_fi;                  // used to read files from SD-Card
    
                             
    switch(job) {   
 
// R E A D /////////////////////////////////////////////////////////////////////////////////////////////////////// 
          
            case 1:
                    // L O A D Clip
                    sprintf         ( file_path, "cl/%d.cl", clip );
                    
                    MUTEX_SDCARD_TAKE;  
                        FILE_ReadOpen   ( &midifile_fi, file_path );
                        FILE_ReadBuffer ( (u8 *)&file_type, sizeof(file_type) ); 
                        FILE_ReadBuffer ( (u8 *)&msq, 4 * sizeof(store_t) );
                        FILE_ReadClose  ( &midifile_fi );
                    MUTEX_SDCARD_GIVE;
                    
                    LED_Gestic=0;
                    
                    flag.NeedSync = 1; //update ClockCounter when ready...
                break;
                	
                    
// S T O R E /////////////////////////////////////////////////////////////////////////////////////////////////////               
  
            case 2:
                    // S A V E Clip
                    sprintf(file_path, "cl/%d.cl", clip);
                     
                    MUTEX_SDCARD_TAKE;
                            //Write to File           
                            FILE_WriteOpen	( file_path,        sizeof(file_path) );   
                            FILE_WriteBuffer( (u8  *)&file_type,sizeof(file_type) ); //"SIGL" = 4 Positons                                                     
                            FILE_WriteBuffer( (u8  *)&msq, 4 * sizeof(store_t) );                                                             
                            FILE_WriteClose	(); 
                    MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                    
                    LED_Gestic=0;
                break;
                    

//  I N I T - S D - CARD //////////////////////////////////////////////////////////////////////////////////7//////   
  // THIS WILL TAKE 10minutes//
            case 3: //check SD-Card
					
                    MUTEX_SDCARD_TAKE;					//SD-Card is now only for the following LINES reserved:
                      statusSD = FILE_CheckSDCard();
                      switch(statusSD) {
                          case 2:
                                MIOS32_MIDI_SendDebugMessage("no card");
                                LED_Gestic=3; // Problem Blinking
                            break;
                            
                          case 1: // YES CARD!  >>> next: check Card-content
                             statusDir = FILE_DirExists("cl");	 // ask file.c: exist a folder "t/" on the CARD? // 
                             if (statusDir == 1){                                         
                                    //MIOS32_MIDI_SendDebugMessage("SD OK");
                                    LED_Gestic=0; // OK Blinking
                                  break;} 
                             
                             if (statusDir == 0){
                                   SEQ_BPM_Stop();	// Stop Sequencer                                       
                                   MIOS32_MIDI_SendDebugMessage("Init Card, take a minute");
                                        // Board - UI - Lighting!
										LED_Gestic=1; // Infinite Blinking
                                                      
            
                                        FILE_MakeDir("cl");                           

                                        // calculate file path
                                        sprintf(file_path, "cl/%d.cl", clip);
                                        
                                        //C L I P > Write to File           
                                        FILE_WriteOpen	( file_path,                sizeof(file_path) );                 
                                                FILE_WriteBuffer( (u8  *)&file_type,sizeof(file_type) ); //"SIGL" = 4 Positons     
                                                FILE_WriteBuffer( (u8  *)&msq, 4 * sizeof(store_t) ); 
                                        FILE_WriteClose	();

                                                            
                                            //copy-prototype file to 256clip files on SD-Card
                                                u16 clipco;  // declare clip Counter 
                                                for(clipco = 0; clipco<256; clipco++){  //countes 2 255 and do following commandos 255 times in a loop:

                                                    char copyfilepath[16];
                                                    sprintf   (copyfilepath, "cl/%d.cl", clipco);  // make a new filename depending on the counter value 1.cl, 2.cl, 3.cl...255.cl
                                                    FILE_Copy ( (char *)"cl/0.cl", (char *)copyfilepath );} // copy the File 0.cl to all other 255 files...

                                    MIOS32_MIDI_SendDebugMessage("Init Done");
                                    
									// Board - UI - Lighting!
									MIOS32_BOARD_LED_Set(0, 1);
									MIOS32_BOARD_LED_Set(1, 1); 
									LED_Gestic = 2; // Clear all Gestics                               
                                    
                                    break;} 
                        }
                        MUTEX_SDCARD_GIVE;
                        }

}
