#ifndef _APP_H
#define _APP_H

    #define  MeloPort 32 		// connect there @IN SEQUENCER    @OUT SYNTHESIZERs ... it also handles ProgramChange
    #define  Port_IN1 32   		// CC from a seq or a remote   
    #define  Port_IN2 33   		// CC from a synth
    
extern s32 SEQ_Init(u32 mode);
extern s32 SEQ_Reset(void);
extern s32 SEQ_Handler(void);
extern void APP_Init(void);
extern void APP_Background(void);
extern void APP_Tick(void);
extern void APP_MIDI_Tick(void);
extern void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package);
extern void APP_SRIO_ServicePrepare(void);
extern void APP_SRIO_ServiceFinish(void);
extern void APP_DIN_NotifyToggle(u32 pin, u32 pin_value);
extern void APP_ENC_NotifyChange(u32 encoder, s32 incrementer);
extern void APP_AIN_NotifyChange(u32 pin, u32 pin_value);
extern u8 MSQ(u8 port, u8 step);
       s8 Activ_CH; //selected Synthpart-Remote
       u16 loop_step_pos[4]; // straight step position
       u8 rythm_count;
       s8 IND; 
       u8 blink_32;
       u8 blink_64;
       u8 blink_tic;
       u8 blink_mod;
       u8 blink_bar;
       u8 blink_4bar;
       u8 blink_8bar;
       u8 blink_main_seq;
      u16 main_step_pos;
       u16 MainLoop;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Patch Variables >>> Saved on SDCard
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 typedef struct storage {   // to optimize SD-Load-Time, each clips data is stored in this struct
     
        u8      SEQ[32][256];   // [Parts][CCs][Step>Value] 
        u8		Index[32];
        
        u8      Last;           // Last Step
        u8      loop_lenght_set; //>Loop Length - END        

        u8      Active;

        u16     bpm; 
        u8      rythm;          // 4x4=16, 5x3=15 usw... to calculate maximal duration per UI-matrix page
        u8      PAGE_Steps;     // calculate from 0 on....so 0-15 are 16 Steps that are visible with a 4/4Beat
} store_t;

 store_t msq[4];     // Data for  beat.clips
 store_t msq_cpy;


 // Struct for different flags
 typedef struct flags {     // to optimize Memory usage and data, i fill all 1bit flags into a struct
   unsigned PCLoad 			: 1;	// init 0   // flag.PCLoad      // ProgramChange via Midi received!
   unsigned PCSave 			: 1;	// init 0   // flag.PCSave      // Save Program on SD- from external Device
   unsigned NeedSync 		: 1;	// init 0   // flag.NeedSync    // Update Loop-Length and other Sequencer Variables
   unsigned FirstTic 		: 1;	// init 1   // flag.FirstTic    // Initalize Sequencer Sync and Init-Operations....
   unsigned Tact_Ex_Load	: 1;	// init 0 	// flag.Tact_Ex_Load  // when the external Sequencer can Transmit x/4 Rythm Data then overrule
   unsigned Seq_is_running	: 1;
   unsigned copy			: 1;
   unsigned paste			: 1;
   unsigned msq_clear_sel	: 1;
   unsigned msq_clear_all	: 1;
   unsigned beatled			: 1;   

}flag_t;

 flag_t flag;

#endif /* _APP_H */
