//TM+SEQ 4 BLM=========================================================================//
//======TriggerMatrix for Button-LED-Matrix 16*16+X====================================//
//============2015 by Michael Sigl aka "Phatline,GreatFullTekk,GuteSigl,Technomiliz..."//
//non-commercial use only. All other rights reserved. Mios32 Based > www.ucapps.de=====//
//thx credits and all the best to TK...who have made all this possible...==============//
//thx to: //BLM16x16+x @latigid on // MB-SEQ-CS @Wilba // MB-LRE8x2CS @Fairlightiii// 
//=====================================================================================//

#include <mios32.h>
#include "app.h"
#include <blm_scalar_master.h>
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
//Sequencer tasks headers variables...
#include <seq_bpm.h>
#include <seq_midi_out.h>
#include "seq.h"
#include <app_lcd.h>
//BLM-SEQ-PCB
#include <blm_x.h>
static void TASK_BLM_Check(void *pvParameters);

u16 song_step_pos_counter;

static void TASK_SEQ(void *pvParameters);
#define PRIORITY_TASK_SEQ		( tskIDLE_PRIORITY + 4 ) // higher priority than MIDI receive task!
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 byte);
static s32 APP_SYSEX_Parser(mios32_midi_port_t port, u8 midi_in);
static s32 APP_MIDI_TimeOut(mios32_midi_port_t port);
static void TASK_Period1mS(void *pvParameters); // periodic task
#define PRIORITY_TASK_PERIOD1MS          ( tskIDLE_PRIORITY + 2 ) // lower than MIDI

xSemaphoreHandle xSDCardSemaphore; 	// take and give access to SD-Card
xSemaphoreHandle xLCDSemaphore;		// take and give access to LCD
xSemaphoreHandle xMIDIOUTSemaphore; // this semaphore (resp. mutex) ensures exclusive access to the MIDI Out port
#define MUTEX_MIDIOUT_TAKE { TASKS_MUTEX_MIDIOUT_Take(); } // simplify access to this mutex
#define MUTEX_MIDIOUT_GIVE { TASKS_MUTEX_MIDIOUT_Give(); }

static file_t midifile_fi; //used to read files from SD-Card
static file_t midifile_sy; //used to read files from SD-Card

#define MUTEX_LCD_TAKE { while( xSemaphoreTakeRecursive(xLCDSemaphore, (portTickType)0) != pdTRUE ); }  //a Mutex reserve a Resoure (LCD or SD-Card) for a task, until it is given away...
#define MUTEX_LCD_GIVE { xSemaphoreGiveRecursive(xLCDSemaphore); }

// CLCD,default special character set (vertical bars)
static const u8 charset_vert_bars[8*8] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f,
  0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f,
  0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
  0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
  0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
  0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
};
// CLCDalternative character set (horizontal bars)
static const u8 charset_horiz_bars[8*8] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00,
  0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00,
  0x00, 0x00, 0x04, 0x06, 0x06, 0x04, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//System Variables >>> SD-Card-System-File "sys"
////////////////////////////////////////////////
//Drum-Trigger - The Trigger Matrix is feed with DrumData.... Without Drums --- Nothing happens @ all
  u8 ClockPortIN= 32;    //Midiclock Input Port (Midiclock Slave)
  u8 TrigPortIN= 35;     //DrumTrigger Midi-Port, [32=UART0=Midi-A, 33=UART1=Midi-B]
  u8 TrigInCh = 11; //Midi-Input-Channel for the whole Trigger thing

  u8 MelPortOut= 35;     //MeloTrigger Midi-Port, [32=UART0=Midi-A, 33=UART1=Midi-B]...
  u8 MeloOutCh[16]   ={0,1,2,3,4,5, 6,7,8,9,10,11, 12,12,12,12};  //Midi-Output-Channel Set...0-5 Poly-Melody, 6-11 MonoMelo, rest not used.

  u8 TrigPortOUT= 35;     //DrumTrigger Midi-Port, [32=UART0=Midi-A, 33=UART1=Midi-B]...
  u8 TrigOutCh[16]   ={14,14,14,14,14, 14,14,14,14,14,14,14, 14,14,14,15};   //Midi-Output-Channel Set for MonoOneNoteTriggers (paralel 2 Melo-Channel)
  u8 TrigOutNote[16] ={59,60,61,62,63, 64,65,66,67,68,69,70, 71,72,73,74};   //Trigger-Out-Notes 
  u8 TrigInNote[16] = {27,28,29,30,31, 32,33,34,35,36,37,38, 39,40,41,42};   //Trigger-In-Notes

  u8 TrigMidiThruClock[4] = {0,0,0,1}; //Drum-Port UART0 send Midiclock reroute that to the UART-Outputs
  u8 TrigMidiThruTransport[4] = {0,0,0,1}; //If you have massive jitter, its maybe better to use the synths internal Clock and start it via Midi.

  //ControllChange - external Midi Controller
  u8 BLMport = 34;  //Connect BLM here	34= Port C
  u8 RemotePort = 33;  

  //ProgramChange //Send Receive  		
  u8 PCType[17] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; //Modis: 0=CC32, 1=CC0, 2=MSB, 3=LSB.... Here: 0-4=0-Nordlead, 5=2-JP8080, 6=1-Pulse(no banks), NordDrum
  //Type 17 is for Trigger Out Channel
  u8 PCPortIN = 32; //Receives ProgramChange Messages on Port?
  u8 PCSend = 1;    //Activate Programchange Send
  u8 PCReceive = 1; //Activate Programchange Receive
  u8 PCChIN = 11;   //ProgramChange Input Channel

//Melody/Retrigger - will be ReTriggered by the Drum Input...
  u8 MelPortIn = 32;	//MidiPort - Melody-Line-Input
  u8 MelPortIn2 = 35;	//second Melody inport...eg. Keyboard
//MidiChannel is set above "MeloOutCh[0-5]"
  u8 DecayMulti[16] =   {2,2,2,2,2,2, 2,2,2,2,2,2, 2,2,2,2};//Mulitplicator * Rotary = Decaytime >>> e.g. 6x127=762millisecons max...  when Drum Rolls then no Multi is used (*1)-
  u8 PitchbendPWR[16] = {1,1,1,1,1,1, 0,0,0,0,0,0, 0,0,0,0}; //only Activate Channels you really need! otherwhise midioutput is messed up...
  u8 CCThruPort[16] =   {1,1,1,1,1,1, 0,0,0,0,0,0, 0,0,0,0}; //only activate channels you really need... its better to ADD CC-automations after this Device...

//BLM
  u8 ID = 0; //React on Buttons, Send LED-States only to BLM with ID 0

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Patch Variables >>> Saved on SDCards (511 Patches)
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
s8 CCBank4[16][4] = //this is for a 2x40LCD with 4 Encoders with much place to turn around with....
	{{127,10,64,0}, //[0][0]Poly RandomKill, [0][1]Poly  Decay, [0][2]Poly Velocity Offset	
	 {127,10,64,0}, //[1][0]Mono RandomKill, [1][1]Mono Decay,  [1][2]Mono+Trig Velocity Offset,  [1][3]Trigger RandomKill
	 {0,0,0,0},  
	 {0,0,0,0},  
	 {0,0,0,0},  
	 {0,0,0,0},
	 {0,0,0,0},  
     {0,0,0,0},  
     {0,0,0,0},  
     {0,0,0,0},  
     {0,0,0,0},  
     {0,0,0,0},  
     {0,0,0,0}, 
     {0,0,0,0},
     {0,0,0,0},
	 {0,0,0,0}};
	 
u8 MtxFunction[16][16][16]= {{{}}}; //Just a nother Placholder on the SD-Card

//Extra VAL Y/X 4 TriggerMatrix-Mode (SongPartSelect, and Roll-BTNs)
u8 EXTRA[16][2]   = {{1,0},
                     {0,0},
                     {0,0},
                     {0,0},
                     {0,0},
                     {0,0},
                     {0,0},
                     {1,0},
                     {1,0},
                     {1,0},
                     {1,0},
                     {1,0},
                     {0,0},
                     {1,0},
                     {1,0},
                     {1,0}};

u8 MATRIX[17][16][16]={//0-15Trigger-Routing-LED-16x16-Matrix // 16: Copy Paste Matrix/Container
	{{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},//Part0    //Routing Matrix 1:1 IO (sequencer0-15 = 0-15midiouts)
	 {0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
	 {0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
	 {1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0}, //ok not 100% 1:1 
	 {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0},
	 {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
     {0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},
     {0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
     {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
     {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
	 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1}}};//The Other Parts are easely copied during the runtime, no need to intialize more.

//Control Diverse Functions of the Programs... while [0][x][y] = the Main Trigger Matrix CC and [16][x][y]=copy Paste memory, the others: Placeholder
u8 CCMtx[17][16][16] ={ //BLM as Control-Switch-Board to Controll importend Performance Variables
//1,2,3,4,5,  6,7,8,9,0,11,2,3,4,5,16  -- OutputChannelStrips
{{1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,1},   //Melody-IO-Matrix, MidiInCh 1
 {0,1,0,0,0,  0,0,0,0,0, 0,0,0,0,0,0},   //Melody-IO-Matrix, MidiInCh 2
 {0,0,1,0,0,  0,0,0,0,0, 0,0,0,0,0,0},   //Melody-IO-Matrix, MidiInCh 3
 {0,0,0,1,0,  0,0,0,0,0, 0,0,0,0,0,0},   //Melody-IO-Matrix, MidiInCh 4
 {0,0,0,0,1,  0,0,0,0,0, 0,0,0,0,0,0},   //Melody-IO-Matrix, MidiInCh 5
 {0,0,0,0,1,  0,0,0,0,0, 0,0,0,0,0,0},   //Melody-IO-Matrix, MidiInCh 6
 {0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,0},   //Melody-IO-Matrix, Mute MidiInChannels (Hold Note)
 {0,0,0,0,0,  0,1,1,1,1, 1,1,1,1,1,1},   //Pitch+1OCT
 {1,0,0,0,0,  0,0,0,0,0, 1,0,0,0,0,0},   //Pitch+1OCT
 {0,0,1,1,1,  0,0,0,0,0, 0,0,0,0,0,0},   //Pitch-1OCT
 {0,0,0,1,1,  0,0,0,0,0, 0,0,0,0,0,0},   //Pitch-1OCT
 {0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,0},   //For Mono-Tracks: Lowest-HighestNote
 {0,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,1},   //Lowest/Highest Velocity
 {1,1,1,1,1,  1,0,1,1,1, 1,1,1,1,1,1},   //Kill-Effect, does the Kill-rotary has Effekt on Channel?
 {0,0,0,0,0,  0,0,0,0,0, 0,0,0,0,0,0},   //Solo Output
 {1,1,1,1,1,  1,1,1,1,1, 1,1,1,1,1,1}}}; //Mute Output

u8 CC_SD[128] = {}; //Save all other Variables into this Array - for SD-Card...


//Melody
    u8  NoteBuff[16][10]=            //NoteBuffer: Save Incoming 10xPoly-Notes - waiting for Drumtrigger input to be played....        
    {{0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 0
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 1
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 2
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 3
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 4
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 5
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 6
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 7
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 8
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 9
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 10
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 11
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 12 
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 13 
     {0,48,60,0,0,0,0,0,0,0},       //NoteBuffer MelodyRetrigger-Track 14 
     {0,48,60,0,0,0,0,0,0,0}};      //NoteBuffer MelodyRetrigger-Track 15 

//TriggerMatrix
  u8 VeloKill[3] = {1,1,1}; //VeloKill Velocity Ranges //Kill low notes (velocity values from incoming drum-trigger) hi notes, & all between
  u8 VeloInvert = 0;        //Invert Velocity Value (lo get hi, and hi get low...)

   //Sequencer Stuff
   u8  Rythm = 4;       //4x4=16, 5x3=15 usw... to calculate maximal duration per matrix page
   u8  RythmRepeat = 4; //4x4=16 === to get to a maximal loop length
   s16 velo[16] = {}; //calculate Velocity for 16 output channels
   u8  VelSel = 2; // 0, 1, 2, --- where 0 is between 0-45, 1 45-90, 2 90-127 //you have 3 BTNs which represent 3 Vel-Presets, which are set via 3 Encoders...
   s16 VelSelValue[3] = {40, 80, 127};  //set via 3 Encoders... these 3 States -lo, mid, hi - are here to set quicker Notes in the Step-Sequencer-Matrix-Grid
   s16 Fullvelo = 64;
   u8  StepVelo = 127; // Velocity off the Currently Pressed Matrix Button
   u8  Rec =  0;
   u8  MatrixUse = 0;   //SQ-Steps, SQ-Swing, TM-Router, TM-CC
   u8  focusMatrixUse[4] = {}; //focus tracks to copy paste them individual
       //Loop Stuff
   u8  PageFirst = 0;   //Loop START PAGE
   u8  PageLast  = 0;   //Loop END PAGE
   u8  SyncFlag = 0;    //to indicate that PageFirst/Last has changed, or the DIRECTION, or Loop LengthBtn....
   u8  Page = 0;        // Step Page, in 4/4 Mode one Page has 16 Step     
   u16 StepPerPage = 16;//calculate from 0 on....so 0-15 are 16 Steps that are visible on the BLM with a 4/4Beat  
   u8  direction = 1;   //0: <, 1>, 2<>   SEQUENCER STEP-COUNTER-DIRECTION   
   u8  LoopLengthBtn = 0;  //Loop-Set 0 or 1 ---to call 2 different Loop Length, i would say, 0: short, 1: long  
   u8  SyncType = 1;   //0 Bar Sync,   1;/home/triggermatrix/c/TM+SEQonGeneric/project.hexMain Sync   
   s16 SyncRate = 0;   //0-15 when SyncType is 0 - then this is the value off BARs which it Syncs when Direction or Loop Switching...   
   u16 MainLoop = 32;   //max Length of the mainloop, if you always play shorter then 256 then you should set this to shorter values!!! (sync...)

   u8  LoopSetCount = 0;   //only to count the number of pressed buttons (first button last button thing....)
   u8  btn; //to memory the Start Page
   
   u8  EncPage = 0;    //0: Velocity Page,   1:Timing Page (Delay, Swing)
   s16 MainDelay = 0; //the main TIC-Delay
   s16 Swing16th = 0;  //swing on Steps, which are marked as 16th
   s16 Swing8th = 0;   //swing on Steps, which are marked as 8th
   u8  SwingSwitch = 1; //Activate Swing-Step-Settings and Rotarys

  //SongMode-Stuff
  u8 StepLCD = 0; //song-Step-Nr
  u8 MenueEncoderMode = 0; //

  //Tact-Related Sequencer Stuff @ 384 PPQN
  s8  BaseTicCount = 1; //count from 0-3 ---equals 8 12 18
  s16 BaseTic = 12;  // 128th    12    Dotted 128th     18   128th Triplet     8   //32x12=384 tics
  s16 Tic = 384;  //32x12=384 tics between 2 Notes -- not to be saved ... just to calculate
  s8  PpqnDivider = 4; //4=16th speed, 2:8th speed
  s8  PpqnDividerCount = 1; //only to calculate....
  u8 BPM = 100;

   // Whole  1536    Dotted Whole   2304   Whole Triplet  1024
   // Half    768    Dotted Half    1152   Half  Triplet   512 
   // Quarter 384    Dotted Quarter  576   Quarter Triplet 256  
   // Eighth  192    Dotted Eighth   288   Eighth Triplet  128 
   // 16th     96    Dotted 16th     144   16th Triplet     64 
   // 32nd     48    Dotted 32nd      72   32nd Triplet     32  
   // 64th     24    Dotted 64th      36   64th Triplet     16
   // 128th    12    Dotted 128th     18   128th Triplet     8

   s16  SwingAmmountFactor =   6; //use for BLM additional Swing > 8th/2=96    96/15=6,5 (where 15 are the Ammount of Switches to represent )
   u8   SwingAmmountFactor8 =  4;
   u8   SwingAmmountFactor16 = 2;
   u8   SwingBLM[16][16] ={{}}; //use to avoid to much midi Traffic, 2 calculate the SWING-AMMOUNT-BARS for Swing Value....

   u8 InputTrigger[16] = {}; //use to calculate the Sequencer-Output Data Pattern.

   int test = 0;
   u8 seqMATRIXcopy[18][16]={{}}; //just a memory container to copy paste Sequencer Pages
   u8 seqMATRIXfocus[256] = {};    //Just a memory container to copy paste Sequencer Tracks
   u8 seqMATRIXfocus16[16] = {};    //Just a memory container to copy paste Sequencer Tracks
   u8 Seq[18][256]={//Sequencer-INITAL-preset Pattern
    //  1   2   3   4   5   6   7   8    9  10  11  12  13  14  15  16, NEXT PAGE....
	 {127,  0,  0,  0,127,  0,  0,  0, 127,  0,  0,  0,127,  0,  0,  0,127,},//1
	 {  0,  0, 66,  0,  0,  0, 66,  0,   0,  0, 66,  0,  0,  0, 66,  0,127,},//2
	 {  1,  0,  1,  0,  1,  0,  1,  0,   1,  0,  1,  0,  1,  0,  1,  0,127,},//3
	 { 40, 10,127, 10, 40, 10,127, 10,  40, 10,127, 10, 40, 10,127, 10, 64,},//4
	 {  0,  0,  0, 40,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,127,},//5
	 {  0,  0, 10, 10,  0,  0,  0,  0,   0,  0, 10,  0, 20,  0,  0,  0, 30,},//6
	 {127,  0,  0,  0,127,  0,  0,  0, 127,  0,  0,  0,127,  0,  0,  0,127,},//7
	 {127,  0,  0,  0, 12,  0,  0,  0, 127,  0,  0,  0,  5,  2, 10,  0,127,},//8
	 {  0,  0,  0,  0,127,  0,  0,  0,   0,  0,  0,  0,127,  0,  0,  0,  0,},//9
	 {  0,  0,  0, 10,  0,  0,  0,  0,   0,  0, 10,  0, 10,  0,  0,  0,  0,},//10
	 {  0,  0,  0,  0,  0,  0,  0,  0,   0,  0, 10,  0, 10,  0,  0,  0, 10,},//11
	 { 66, 12,127, 12, 66, 12,127, 12,  66, 12,127, 12, 99, 63,127, 12,127,},//12
	 {  0,  0,  0, 32,  0,  0,  0,  0,   0,  0, 32,  0, 32,  0,  0,  0, 33,},//13
	 {  0,  0,  0, 32,  0,  0,  0,  0,   0,  0, 32,  0, 32,  0,  0,  0, 33,},//14
	 {  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,},//15
	 {  0,  0,  0, 32,  0,  0,  0,  0,   0,  0, 32,  0, 32,  0,  0,  0,  0,},//16
	 {  0,  0,  2,  0,  0,  0,  2,  0,   0,  0,  2,  0,  0,  1,  2,  0,  0,},//0:SwingOFF 1:Swing ON16th, 2:SwingON8th (4wholeStep@AllTracks)
	 {  0,  0,  3,  0,  0,  0,  3,  0,   0,  0,  5,  0,  0,  2,  3,  0,  0,}};//Swing Ammount

   u8 SeqTic[18][256]={{}};  //TicOffset for Seq[x][y]
   u8 SeqTicDelay[18]={};  //TicOffset for Seq calculated from SeqTic+Delays
   u8 SeqTicView = 0;  //0:SeqStep16th View or 1:96Tic View
   s16 SeqFocusStep = 0; //the focused Step from Stepsequencer
   u8 SeqTicCopy[18][16] = {{}};//just a memory containter to copy paste Sequencer-Tic-Pages
   u8 SeqTicFocus[256] = {};    //Just a memory container to copy paste Sequencer Tic Tracks
   u8 SeqTicFocus16[16] = {};    //Just a memory container to copy paste Sequencer Tic Tracks

   u8 AutQuntActive = 1; // AutoQuantize while Recording is ON
   u8 QuantRate = 0; //Quantize Rate 16th or 32th
   //ENCODERs
   s16 MeloKILL  = 127;    //CCBank[0][0] //Kill Melody
   s16 MeloDecay =  10;    //CCBank[0][1] //Decay Melody
   s16 MeloVelo  =  64;    //CCBank[0][2] //Velocity Melody
   s16 MonoKILL  = 127;    //CCBank[1][0] KILL Drum
   s16 MonoDecay =  10;    //CCBank[1][1] DCY DRUM
   s16 MonoVelo  =  64;    //CCBank[1][2] VEL DRUM
   s16 TrigKILL  = 127;    //CCBank4[1][3] Kill Trigger

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////should not be saved in Patchfile on SD
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    u16 PCIN = 0; //received Programchange Value 

//BLM_Interface Vari     X Y XInv YInv
   u8 COLORex[16][4] = {{2,2,2,5},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,4},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,2},
                        {2,2,2,1},
                        {2,2,2,5},
                        {2,2,2,5},
                        {2,2,2,5}};

   u8 COLOR[8][16][16]={// Color Patterns for the CCMtx[][][]
	{{4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //Part7    CC-Toggle
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //when toggling button states, u get State 0/1, 0 is OFF, and 1 is LED-ON RED..
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //want different colors? u have to interprete them via a MASK - tada! "COLOR" Mask
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //Here are the interpretation for every Cell saved.
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //COLOR val:  MATRIX val=0,  MATRIX val=1
	 {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4}, //     0         0 > OFF      1 > BLUE
	 {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2}, //     1         0 > OFF      2 > GREEN 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     2         0 > OFF      3 > CYAN 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     3         1 > BLUE     1 > BLUE 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     4         1 > BLUE     2 > GREEN 
     {4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5}, //     5         1 > BLUE     3 > CYAN
     {6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1}, //     6         0 > OFF      0 > OFF
     {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},  
     {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},  
     {4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},
	 {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}}};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Coding only Variables >>>No Settings here<<<
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//BLM
   u8 BLM_Mode = 0;  //0=Part0-6 >>> TriggerRouting,   1=Perform: Mutes, Solo, MeloRoute...,
//Retrigger
   u8 MtxLoad[16][16]={{}}; //Represent actual loadet Trigger-Routing - it will decide which Input trigger goes to which output
   u8 AnySolo = 0;   //is any of the 16 Tracks Solo?
   u8 MtxPartNr = 0; //Which MtxPart is displayd on the BLM
   
    u16 MeloDecayTIMER[16][128] ={{}};//MidiDecayCounter --- Note OFF Handling
    u16 Decay = 400; //only initial... later processed via CC
    u8  NoteCount[16]={};
    s8  MelOctShiftFactor[16]={};
    u8  NoteCalc[16]={};           //incoming note + MelOctShiftFactor[0]
    u8  TrigOutOldNote[16] = {};
    u8  MeloOutNote[16] ={};
    u16 pitchbend[16] = {8192};    // inital No Pitchbend!
    
//Drum
    u16 DrumDecayTimer[17] = {};     //Monophonic - Drum - Note- Timer
    u16 DrumDecayTIME[17] = {};      //DecayTime with Additonal Time (4xTime-Switches on BLM)

//Random Trigger Kill
    int random1 = 0;                    //1st Kill Function (Operator only -used 4 coding)
    int random_seed_l = 0;              //depend on the CController and its range
    int random_seed_h = 127;            //depens on the CController and its range...
    int random_tmp = 64;				
    int random_nr = 127;                //depends on the Controller and its range...
    u8 MeloRandGate = 1;                //if that flag is 0 - no MeloTrigger will come thru....
    u8 MonoRandGate = 1;                //if that flag is 0 - no MonoMeloTrigger will come thru....
    u8 TrigRandGate = 1;                //if that flag is 0 - no DrumTrigger will come thru....
    int TMR0L = 0;                      //TMR0L = Timer - Random -Roll Variable
    u8 velocity = 0;

    u8 OverRoll = 1; //All Sequencer Notes to all Outputs
    u8 RollLock = 1; //Lock Individual Rolls (normaly they are Pushbuttons...with this active they are toggle buttons 

//MENUE Store-Load SYSTEM Variables
   u16 SYSNrLoad = 0;				
   u16 SYSNrStor = 0;
   s8  SYSNameChar = 0;			//Change the SYSname via Encoder you select the Characters
   s8  SYSNameStore[8] = {32}; //This is the SystemSetting Name that will be stored if you hit store
   u8  SYSNamecount;               //to transfair data from Load to Store SYSnames...
   u8  SYS_SD[128] = {};        //to save single Variables in a array placed on the sd-card
   s8  SYSNameLoad[8]  = {32}; //This is the load name only, once loadet we work with the STORE Variables
   char file_typeBanksys[4] = "TM01";	//should always be 4, and not longer then 4 chars!!! //definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header (use Text/Hex-Editor to proove)
   char filepathSsys[8];				//STORE-path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code	
   char filepathLsys[8];				//LOAD -path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code
   u8  SYSLoadFlag =  1; //Load SYS-Settings from SD after Startup
   u8  SONGLoadFlag = 1; //Load SONG-Settings from SD after Startup, after loading System Settings,
   u16 LoadCount = 200;
   u16 StoreCount = 200;
    u8 StoreFlag = 0;
    u8 LoadFlag =  0;

   u8 PlayMode = 0; //Song-Mode, JAM-Mode
   u8 SongLine = 1; //LCD -1st and 2nd Row/Line ---1st: RoutingNR, 2nd: How Often Played (mulitiplciator)

   
   
//MENUE Store-Load Variables
   u16 SongNrLoad = 0;			  
   u16 SongNrStor = 0;
   s8  SongNameChar = 0;			//Change the Songname via Encoder you select the Characters
   s8 SongNameStore[8] = {32}; //This is the Song Name that will be stored if you hit store
 u8 PCBank[17]={0,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0};   //Program-Change-Bank, Bank16 is for Trigger Channel!
 s8 SongNameLoad[8]  = {32}; //This is the load name only, once loadet we work with the STORE Variables
   char file_typeBank[4] = "TM01";	//should always be 4, and not longer then 4 chars!!! //definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header (use Text/Hex-Editor to proove)
   char filepathS[8];				//STORE-path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code	
   char filepathL[8];				//LOAD -path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code	
   s8  SongNamePointer[8] = {94,95,95,95,95,95,95,95}; //95= "_" 94=Indicator: indicate Edit Songname Character (looped via SongNamePointerCount)
   u8  MenueLoad = 0;				//LOAD FILES
   u8  MenueStore =0 ;			//STORE FILES
   s8  SongNamePointerCount=0;	//to navigate thru the 8 Character position of one Name
   u8  PCLoad;                //if 0 then load the Programchange that is currently changed (Load Button)
   s32 statusSD;					//Status of the SDCard--connected? fat?
   s32 statusDir;					//Status "is" your direction "sdcard/t" there?
   u16 SDCardCount = 0;
   u8  SongNamecount;               //to transfair data from Load to Store Songnames...
   u8  i = 0;						//only to count some things in for loops...
   u8  MenueUpdateFlag = 1;         //Flag to force the MenueUpdateCounter to count a periode of time, after the time "update the menue"
   u8  MenueUpdateCount = 0;
   //"MENUE"-Function Variable - This is the main UI Function, i do it there because i get Midi-In and DIN-IN... and both remote the same Code... so i need a common  Function... let say "Router"
   u32 menu_cc = 0;
   s32 menue_value = 0;
   s32 menue_incrementer = 0;
   s16 LCD0Page = 5;
   u8 PCLoadFlag = 0;          //Activate Timer to Load ProgramChanges from external source after a time (2seconds)
   u8 PCLoadFlagCount = 0;     //and a timer for that

//ENCODERs
    s16 enc[33] = {};
    s16 encDiv16[33] = {};
    u8 LEDDoutV = 0;				//Vertical   Matrix Dout Register 1stPin
    u8 LEDDoutH = 0;				//Horizontal Matrix Dout Register 1stPin
    u8 LEDDoutVtmp = 4;  			//Vertikal Shiftregister   Offset- 0 is the First Register!!!!!!
    u8 LEDDoutHtmp = 2;  			//Horizontal Shiftregister Offset (Differ from Hardware 2 Hardware..
    u8 LEDCount = 0;       //only to calculate
    u8 LEDCount_H = 0;     //only to calculate
    u8 LEDCount_V = 0;     //only to calculate
const mios32_enc_config_t encoders[33] = {//(SR begin with 1, ENC with 0) // setup the Pinout of Encoders
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=6 },		//Menue Encoder 0 
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=4 },		//Menue Encoder 1
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=2 },      //Menue Encoder 2
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=0 },      //Menue Encoder 3
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=6 },      //Menue Encoder 4
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=4 },      //Menue Encoder 5
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=2 },      //Menue Encoder 6	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=0 },      //Menue Encoder 7	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=6 },      //Menue Encoder 8
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=4 },      //Menue Encoder 9
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=2 },      //Menue Encoder 10
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=0 },      //Menue Encoder 11
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=6 },      //Menue Encoder 12
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=4 },      //Menue Encoder 13
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=2 },      //Menue Encoder 14
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=0 },      //Menue Encoder 15	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=6, .cfg.pos=2 },      //Menue Encoder MENUE PAGE ENCODER - JOG
  	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=7, .cfg.pos=0 },		//CC-Enc 1
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=7, .cfg.pos=2 },		//CC-Enc 2
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=7, .cfg.pos=4 },      //CC-Enc 3
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=7, .cfg.pos=6 },      //CC-Enc 4
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=8, .cfg.pos=0 },      //CC-Enc 5
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=8, .cfg.pos=2 },       //CC-Enc 6
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=8, .cfg.pos=4 },      //CC-Enc 7	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=8, .cfg.pos=6 },      //CC-Enc 8	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=9, .cfg.pos=0 },      //CC-Enc 9
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=9, .cfg.pos=2 },      //CC-Enc 10
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=9, .cfg.pos=4 },      //CC-Enc 11
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=9, .cfg.pos=6 },      //CC-Enc 12
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=10,.cfg.pos=0 },      //CC-Enc 13
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=10,.cfg.pos=2 },      //CC-Enc 14
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=10,.cfg.pos=4 },      //CC-Enc 15
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=3, .cfg.sr=10,.cfg.pos=6 },      //CC-Enc 16	  
	};

//Task Prioritys	
#define PRIORITY_TASK_Midi_Decay0	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart ---- 5highest, 1lowest Priority
#define PRIORITY_TASK_Midi_Decay1	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay2	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay3	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay4	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart

#define PRIORITY_TASK_Trigger_Decay	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart

#define PRIORITY_StoreLoad                        ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER0 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER1 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER2 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER3 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER4 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER5 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER6 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER7 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER8 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER9 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER10 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER11 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER12 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER13 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER14 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER15 	              ( tskIDLE_PRIORITY + 2 ) //3:Mios standart

#define PRIORITY_APP_NOTEPROCESS	              ( tskIDLE_PRIORITY + 3 ) //4:high
#define PRIORITY_APP_BLM_ButtonCallback           ( tskIDLE_PRIORITY + 3 ) //4:high

#define PRIORITY_TASK_BLM_CHECK    ( tskIDLE_PRIORITY + 1 )//SEQ CS BLM

// local prototype of the task function
static void TASK_Midi_Decay0(void *pvParameters);
static void TASK_Midi_Decay1(void *pvParameters);
static void TASK_Midi_Decay2(void *pvParameters);
static void TASK_Midi_Decay3(void *pvParameters);
static void TASK_Midi_Decay4(void *pvParameters);

static void TASK_Trigger_Decay(void *pvParameters);
static void StoreLoad(u8 tick, u16 order);
static void MELODY_BUFFER0(u8 velocity,  u8 note);
static void MELODY_BUFFER1(u8 velocity,  u8 note);
static void MELODY_BUFFER2(u8 velocity,  u8 note);
static void MELODY_BUFFER3(u8 velocity,  u8 note);
static void MELODY_BUFFER4(u8 velocity,  u8 note);
static void MELODY_BUFFER5(u8 velocity,  u8 note);
static void MELODY_BUFFER6(u8 velocity,  u8 note);
static void MELODY_BUFFER7(u8 velocity,  u8 note);
static void MELODY_BUFFER8(u8 velocity,  u8 note);
static void MELODY_BUFFER9(u8 velocity,  u8 note);
static void MELODY_BUFFER10(u8 velocity, u8 note);
static void MELODY_BUFFER11(u8 velocity, u8 note);
static void MELODY_BUFFER12(u8 velocity, u8 note);
static void MELODY_BUFFER13(u8 velocity, u8 note);
static void MELODY_BUFFER14(u8 velocity, u8 note);
static void MELODY_BUFFER15(u8 velocity, u8 note);

static void Router(u32 port, u32 channel, u32 control, s32 value);
static void LED(u32 function);

s8 SongStep = 0; // switch from one to the next sonstep
u8 BLMledReroute[2][16] = {{39,37,47,45, 55,53,63,61, 31,29,23,21, 15,13,7,5}, //RED LEDs the MB-SEQ-CS Panel is not 1:1...so we have to translate that.
                           {38,36,46,44, 54,52,62,60, 30,28,22,20, 14,12,6,4}};//Green LEDs
u8 SongPartBtn = 0; //select a SongPart with one of 16 Buttns under the 16 Encoders (MB-SEQ-CS-PCB)


u8 SONG[16][32] = {{0,1,2,3,4,5,6,7, 8, 9, 10,11,12,13,14,15, 15,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1},
                   {1,1,1,1,1,1,1,1, 1, 1, 1, 1, 1, 1, 1, 1,  1, 1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1}};   
u8 BeatLED = 0; //BeatIndicator LED on MB-SEQ-CS  303 noch gebraucht?

u8 Shift = 1;


void APP_Init(void){
/////////////////////////////////////////////////////////////////////////

//Init TriggerMatrix UI
MatrixUse = 3; //switch to CC Page
APP_BLM_ButtonCallback(ID, 2, 0, 0, 0); // switch to Routing 0   // id:blm, elementID, btnX, btnY,Depressed   --2 = Y-BTNs

Tic = 32 * BaseTic; //32x12=384
  u8 blm = 0; // currently only a single blm device is supported
  xMIDIOUTSemaphore = xSemaphoreCreateRecursiveMutex();   // create semaphores
  MIOS32_BOARD_LED_Init(0xffffffff);   // initialize all LEDs
  BLM_SCALAR_MASTER_Init(0);   // initialize BLM_SCALAR_MASTER communication handler	
  BLM_SCALAR_MASTER_ButtonCallback_Init(APP_BLM_ButtonCallback);   // install BLM callbacks
  BLM_SCALAR_MASTER_MIDI_PortSet(blm, UART2); // == IN3/OUT3 set MIDI port where MBHP_BLM_SCALAR is connected
  MIOS32_MIDI_SysExCallback_Init(APP_SYSEX_Parser);   // install SysEx callback
  MIOS32_MIDI_TimeOutCallback_Init(APP_MIDI_TimeOut);  // install timeout callback function
  xTaskCreate(TASK_Period1mS, (signed portCHAR *)"Period1mS", configMINIMAL_STACK_SIZE, NULL, 1, NULL);   // start tasks
//  xTaskCreate(TASK_Period1mS, (signed portCHAR *)"Period1mS", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_PERIOD1MS, NULL);   // start tasks
  BLM_SCALAR_MASTER_SendRequest(blm, 0x00);   // send layout request to MBHP_BLM_SCALAR
  	xLCDSemaphore 		= xSemaphoreCreateRecursiveMutex();														// create Mutex for LCD access
	xSDCardSemaphore 	= xSemaphoreCreateRecursiveMutex();														// create semaphores
	FILE_Init(0);																								// initialize file functions
	s32 i;																										// initialize encoders   i = counter
	for(i=0; i<33; ++i) MIOS32_ENC_ConfigSet(i, encoders[i]);										    // initialize encoders
  xTaskCreate(TASK_Midi_Decay0,  (signed portCHAR *)"Midi_Decay0",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay1,  (signed portCHAR *)"Midi_Decay1",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay2,  (signed portCHAR *)"Midi_Decay2",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay3,  (signed portCHAR *)"Midi_Decay3",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay4,  (signed portCHAR *)"Midi_Decay4",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Trigger_Decay,(signed portCHAR *)"Trigger_Decay",   64, NULL, 2, NULL);   // start task

  //Get and Set Multiple LCDs
  MIOS32_LCD_DeviceSet(0);
  MIOS32_LCD_Init(0);
  MIOS32_LCD_DeviceSet(1);
  MIOS32_LCD_Init(0);

  // SEQUENCER TASKS
  MIOS32_BOARD_LED_Set(1, 0);
  SEQ_MIDI_OUT_Init(0);   // initialize MIDI handler
  SEQ_Init(0);   // initialize sequencer
  MIOS32_MIDI_DirectRxCallback_Init(NOTIFY_MIDI_Rx);
  xTaskCreate(TASK_SEQ, (signed portCHAR *)"SEQ", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_SEQ, NULL);   // install sequencer task 
//xTaskCreate(TASK_SEQ, (signed portCHAR *)"SEQ", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_SEQ, NULL);   // install sequencer task
  
  Router(0,0,15,0);  //Dumpout LCD3 - Sequencer Menue:
  
  //BLM driver
  blm_x_config_t blm_x_conf;
  BLM_X_Init();
  blm_x_conf = BLM_X_ConfigGet();
  blm_x_conf.debounce_delay = 10;
  BLM_X_ConfigSet(blm_x_conf);
  xTaskCreate(TASK_BLM_Check, (signed portCHAR *)"BLM_Check", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_BLM_CHECK, NULL);
  
  //LED-Rings
  LEDDoutV = LEDDoutVtmp * 8; //4 calc the Matrix-Dout pins > OFFSETs...Value depends on the ammount off outputs from the shiftregister 
  LEDDoutH = LEDDoutHtmp * 8; //4 calc the Matrix-Dout pins	
  BLM_X_LEDColorSet(BLMledReroute[0][0], 1);   //Activate First Song-Part LED
}

void APP_Background(void){}

u8 SongMode(u8 action){ //Play the different Trigger-Matrix-Routings in a "Song" Routine
/*
0-15 * Multiplicaton
16: < Pendelpunkt
17: > Pendelpunkt
*/

  if(action == 1) {//action 1= BTN/User Changed Song Position, but wait in sync
    SongStep = SongPartBtn-1;}         //Set new Song Position

  if(action == 0 && PlayMode == 0) {//action 0=the main loop is one cycle older... && we are in 0:SongMODE (instead of 1: JAM-Mode)
    //Flashing SEQ-CS-Beat-LED
    BLM_X_LEDColorSet(1,1);                   

    //the whole song start with the intro...and then:
    
    if(song_step_pos_counter >= SONG[1][SongStep]) {
          SongStep++; //switch to the next SongPart
          if(SongStep <= 0)  {SongStep = 0;}
          if(SongStep >= 31) {SongStep = 31;}
          song_step_pos_counter = 0; //Reset Main-Loop-counter
          
          //Forward Loop Point ">"
          if(SONG[0][SongStep] == 17) { //Forward/ skip forward > x times ---useless?
              SongStep = ((SongStep+SONG[1][SongStep])+1); //how many times/Steps?
             if(SongStep > 31) {SongStep = 31;} }    //we have only 31 Songparts
         //Rewind  Loop Point "<"  
          if(SONG[0][SongStep] == 16) { //REWIND/ Skip back < x times
              SongStep = ((SongStep-SONG[1][SongStep])-1); //how many times/Steps?
             if(SongStep < 0) {SongStep = 0;}          //we have only 0-31 Songparts
          }
                       
          if(SONG[0][SongStep] != 18) {//dont change the Routing when a Song-Step is in JAM Mode (in Jam Mode the user can switch...)
                  //Select and Load the TriggerRouting Parts
                  if((MatrixUse == 2) || (MatrixUse==3)){//if the Matrix-Controll-Sourface is in Trigger-Matrix-Mode
                    //then switch via:
                    APP_BLM_ButtonCallback(0, 2, 0, SONG[0][SongStep], 0);  }
                    
                  else{//switch the Routing-Presets-directly    
                      MtxPartNr = SONG[0][SongStep];
                      //Load Matrix Data in the Matrix wich is interacting with incoming drum triggers---the LOAD-Matrix
                      int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MtxLoad[x][y]=MATRIX[MtxPartNr][x][y];;}}
                   }}
                      //Deactivate Song Position Step 0-15
                      BLM_X_LEDColorSet(BLMledReroute[0][0], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][1], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][2], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][3], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][4], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][5], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][6], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][7], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][8], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][9], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][10],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][11],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][12],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][13],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][14],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[0][15],0);   //Deactivate SongStep-Position-LED 
                      //Deactivate Song Position Step 16-31
                      BLM_X_LEDColorSet(BLMledReroute[1][0], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][1], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][2], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][3], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][4], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][5], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][6], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][7], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][8], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][9], 0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][10],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][11],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][12],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][13],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][14],0);   //Deactivate SongStep-Position-LED 
                      BLM_X_LEDColorSet(BLMledReroute[1][15],0);   //Deactivate SongStep-Position-LED 
                      //Activate song Position LED
                      if(SongStep <= 15){BLM_X_LEDColorSet(BLMledReroute[0][SongStep],1);}   //Activate   SongStep-Position-LED 
                      if(SongStep  > 15){BLM_X_LEDColorSet(BLMledReroute[1][SongStep-16],1);}   //Activate   SongStep-Position-LED 
}
}
  return 0; // no error,
}

static void Router(u32 port, u32 channel, u32 control, s32 value) { //DIN, ENCs, MidiCC all together, More Displays
/*
MUTEX_LCD_TAKE;        //request LCD access
MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen 
MIOS32_LCD_Clear();    //clear screen
MIOS32_LCD_CursorSet(0, 0);  MIOS32_LCD_PrintFormattedString("%d %d %d %d", port, channel, control, value);
MUTEX_LCD_GIVE;        //request LCD access
/ */
  if(port == 3) {//Midi
    if(channel == 14) {//Only TriggerMatrix depending Remote Messages
      if(value== 0) {//Only when Button Pressed (avoid double triggering)
        if(control <= 15) {//Songpart-Radio-Switch
          if((MatrixUse == 2) || (MatrixUse==3)){//if the Matrix-Controll-Sourface is in Trigger-Matrix-Mode
            //then switch via:
            APP_BLM_ButtonCallback(0, 2, 0, control, 0);  }
          else{//switch the Routing-Presets-directly    
              MtxPartNr = control;
              //Load Matrix Data in the Matrix wich is interacting with incoming drum triggers---the LOAD-Matrix
              int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MtxLoad[x][y]=MATRIX[MtxPartNr][x][y];;}}
              //LED - Feedback to Footcontroll-Box
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 0, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 1, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 2, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 3, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 4, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 5, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 6, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 7, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 8, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 9, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 10, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 11, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 12, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 13, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 14, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 15, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, control, 1);}//Activate Actual LED
  }}}}


if(port == 0) {//DIN)  //     LED(0);//update LEDs 

  if(channel == 0) {//Sequencer Stuff
      
    if(control == 37){Shift = value;} //Shift Button

    if(Shift == 1) {//1=Released   then   Switch between the Song-Parts
      if(LCD0Page == 1) {//MenuePage SongPart 0-15
          if(control == 32){SongPartBtn =  0; SongMode(1);} //SongMode = Change the Song Position entry
          if(control == 33){SongPartBtn =  1; SongMode(1);} 
          if(control == 40){SongPartBtn =  2; SongMode(1);} 
          if(control == 41){SongPartBtn =  3; SongMode(1);} 
          if(control == 48){SongPartBtn =  4; SongMode(1);} 
          if(control == 49){SongPartBtn =  5; SongMode(1);} 
          if(control == 56){SongPartBtn =  6; SongMode(1);} 
          if(control == 57){SongPartBtn =  7; SongMode(1);} 
          if(control == 24){SongPartBtn =  8; SongMode(1);} 
          if(control == 25){SongPartBtn =  9; SongMode(1);} 
          if(control == 16){SongPartBtn = 10; SongMode(1);} 
          if(control == 17){SongPartBtn = 11; SongMode(1);} 
          if(control == 8) {SongPartBtn = 12; SongMode(1);} 
          if(control == 9) {SongPartBtn = 13; SongMode(1);} 
          if(control == 0) {SongPartBtn = 14; SongMode(1);} 
          if(control == 1) {SongPartBtn = 15; SongMode(1);}    
          }  
      if(LCD0Page == 2) {//MenuePage SongPart 16-31
          if(control == 32){SongPartBtn = 16; SongMode(1);} //SongMode = Change the Song Position entry
          if(control == 33){SongPartBtn = 17; SongMode(1);} 
          if(control == 40){SongPartBtn = 18; SongMode(1);} 
          if(control == 41){SongPartBtn = 19; SongMode(1);} 
          if(control == 48){SongPartBtn = 20; SongMode(1);} 
          if(control == 49){SongPartBtn = 21; SongMode(1);} 
          if(control == 56){SongPartBtn = 22; SongMode(1);} 
          if(control == 57){SongPartBtn = 23; SongMode(1);} 
          if(control == 24){SongPartBtn = 24; SongMode(1);} 
          if(control == 25){SongPartBtn = 25; SongMode(1);} 
          if(control == 16){SongPartBtn = 26; SongMode(1);} 
          if(control == 17){SongPartBtn = 27; SongMode(1);} 
          if(control == 8) {SongPartBtn = 28; SongMode(1);} 
          if(control == 9) {SongPartBtn = 29; SongMode(1);} 
          if(control == 0) {SongPartBtn = 30; SongMode(1);} 
          if(control == 1) {SongPartBtn = 31; SongMode(1);}    
          }  
    }      
    
  if(value == 0){// only the Press is calculated, not the release = avoid double triggering events      
      if(control == 29) {SEQ_BPM_Stop(); SEQ_Init(0);}
      if(control == 20) {SEQ_BPM_Start();}
      if(control == 21) {Rec =! Rec;
          if(Rec == 0) {APP_BLM_ButtonCallback(ID, 5, 0, 0, 0);}} //after Record update BLM LEDs
    
    
      if(control == 12){direction = 0; SyncFlag = 1;}   //Play Direction & Update FLAG see "seq.c." Call BPM counter that something has to be change
      if(control == 13){direction = 1; SyncFlag = 1;}   //Play Direction & Update FLAG see "seq.c." Call BPM counter that something has to be change
      if(control ==  4){direction = 2; SyncFlag = 1;}   //Play Direction & Update FLAG see "seq.c." Call BPM counter that something has to be change
    
      if(control == 52){SyncType =! SyncType;}
    
      if(control == 45){LoopLengthBtn =! LoopLengthBtn;}
    
      if(control == 35){intro =! intro;}
    
      if(control == 43){AutQuntActive =! AutQuntActive;} //AutoRecordQuantize ACTIVE?
    
      if(control == 50){SwingSwitch =! SwingSwitch;} //AutoRecordQuantize ACTIVE?
     
    
      if(control == 22) {VelSel = 0;}
      if(control == 31) {VelSel = 1;}
      if(control == 30) {VelSel = 2;}
    
      if(control == 62) {MatrixUse = 0; APP_BLM_ButtonCallback(0, 5, 0, 0, 0);} //update Matrix - Dump Out
      if(control == 63) {MatrixUse = 1; APP_BLM_ButtonCallback(0, 5, 1, 0, 0);} //update Matrix - Dump Out
      if(control == 46) {MatrixUse = 2; APP_BLM_ButtonCallback(0, 5, 2, 0, 0);} //update Matrix - Dump Out
      if(control == 47) {MatrixUse = 3; APP_BLM_ButtonCallback(0, 5, 3, 0, 0);} //update Matrix - Dump Out
    
      if(control ==  6){VeloKill[0] =! VeloKill[0];}
      if(control == 15){VeloKill[1] =! VeloKill[1];}
      if(control == 14){VeloKill[2] =! VeloKill[2];}
      if(control == 42){SongLine  =! SongLine;}
      if(control == 44){VeloInvert =! VeloInvert;}
    
      if(control == 54){PlayMode = 0;} //Song-Mode
      if(control == 55){PlayMode = 1;} //JAM-Mode
      
     LED(0);//update LEDs

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//COPY PASTE, SEQUENCER, MATRIX.... Pages, Tracks, Routings...
  //PAGE                                             /////////////////////////////////////////
  if(control == 51){ //COPY --- Page into memory
      if(MatrixUse == 0  && SeqTicView == 0){ //Sequencer-Mode?  - Step-Entry View?    
        int y; for(y=0; y<18; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //18Tracks * 16Steps
       seqMATRIXcopy[y][x]  =  Seq[y][x+(Page*(StepPerPage))];}}} //copy steps of actual page  into clipboard memory

      if(MatrixUse == 0  && SeqTicView == 1){ //Sequencer-Mode?  - Tic-Edit- View?    
        int y; for(y=0; y<18; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //18Tracks * 16Steps
       SeqTicCopy[y][x]  =  SeqTic[y][x+(Page*(StepPerPage))];}}} //copy steps of actual page  into clipboard memory

      if(MatrixUse == 1){ //Swing-Mode?      
        int y; for(y=0; y<2; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //2SwingTracks * 16Steps
       seqMATRIXcopy[y+16][x]  =  Seq[y+16][x+(Page*(StepPerPage))];}}} //copy steps of actual page  into clipboard memory

      if(MatrixUse == 2) {//TriggerMatrix-Router-Mode? /////copy actual matrix in matrix [16]  which acts as copy paste memory
     int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MATRIX[16][x][y]=MATRIX[MtxPartNr][x][y];}}}

      if(MatrixUse == 3) {//TriggerMatrix-CC-Mode? /////copy actual matrix in matrix [16]  which acts as copy paste memory
     int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {CCMtx[16][x][y]=CCMtx[0][x][y];}}}

    }

  if(control == 58){ //PASTE --- Paste Memory into Page
      if(MatrixUse == 0  && SeqTicView == 0){ //Sequencer-Mode?  - Step-Entry View?    
        int y; for(y=0; y<18; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //18Tracks * 16Steps
         Seq[y][x+(Page*(StepPerPage))] = seqMATRIXcopy[y][x];}}} //copy steps of actual page  into clipboard memory

      if(MatrixUse == 0  && SeqTicView == 1){ //Sequencer-Mode?  - Tic-Edit- View?   
        int y; for(y=0; y<18; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //18Tracks * 16Steps
         SeqTic[y][x+(Page*(StepPerPage))] = SeqTicCopy[y][x];}}} //copy steps of actual page  into clipboard memory

      if(MatrixUse == 1){ //Swing-Mode?      
        int y; for(y=0; y<2; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //2SwingTracks * 16Steps
         Seq[y+16][x+(Page*(StepPerPage))] = seqMATRIXcopy[y+16][x];}}} //copy steps of actual page  into clipboard memory

      if(MatrixUse == 2) {//TriggerMatrix-Router-Mode? /////paste the copy-Matrix-Memory [16] to the actual Matrix
     int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MATRIX[MtxPartNr][x][y]=MATRIX[16][x][y]; MtxLoad[x][y]=MATRIX[MtxPartNr][x][y];}}
     APP_BLM_ButtonCallback(0, 5, 2, 0, 0);} //update Matrix - Dump Out}

      if(MatrixUse == 3 || MatrixUse == 3) {//TriggerMatrix-CC-Mode? /////paste the copy-Matrix-Memory [16] to the actual Matrix
     int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {CCMtx[0][x][y]=CCMtx[16][x][y];}}
     APP_BLM_ButtonCallback(0, 5, 2, 0, 0);} //update Matrix - Dump Out}
    }

  if(control == 59){ //CLEAR --- Page
      if(MatrixUse == 0  && SeqTicView == 0){ //Sequencer-Mode?  - Step-Entry View?    
        int y; for(y=0; y<18; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //18Tracks * 16Steps
         Seq[y][x+(Page*(StepPerPage))] = 0;}}} //fill Page with 0ś

      if(MatrixUse == 0  && SeqTicView == 1){ //Sequencer-Mode?  - Tic-Edit- View?   
        int y; for(y=0; y<18; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //18Tracks * 16Steps
         SeqTic[y][x+(Page*(StepPerPage))] = 0;}}} //fill Page with 0ś

      if(MatrixUse == 1){ //Swing-Mode? 
        int y; for(y=0; y<2; y++)  { int x; for(x=0; x<(StepPerPage); x++) { //2SwingTracks * 16Steps
         Seq[y+16][x+(Page*(StepPerPage))] = 0;}}} //fill Page with 0ś

      if(MatrixUse == 2) {//TriggerMatrix-Router-Mode? /////Clear Matrix Data	         
      int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MATRIX[MtxPartNr][x][y]=0; MtxLoad[x][y]=MATRIX[MtxPartNr][x][y];}}
      APP_BLM_ButtonCallback(0, 5, 2, 0, 0);} //update Matrix - Dump Out}

      if(MatrixUse == 3) {//TriggerMatrix-CC-Mode? /////Clear Matrix Data	         
      int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {CCMtx[0][x][y]=0;}}
      APP_BLM_ButtonCallback(0, 5, 2, 0, 0);} //update Matrix - Dump Out}
    }

////FOCUS/Track                                      //////////////////////////////////////
  if(control == 53){ //copy
      if(MatrixUse == 0  && SeqTicView == 0){ //Sequencer-Mode?  - Step-Entry View?  //Copy Focus Track into memory (only one PAGE)
        int x; for(x=0; x<(StepPerPage); x++) {//StepPerPage=15+1= 16Steps
         seqMATRIXfocus16[x]  =  Seq[focusMatrixUse[0]][x+(Page*(StepPerPage))];}}  //copy steps of actual page & row into memory

      if(MatrixUse == 0  && SeqTicView == 1){ //Sequencer-Mode?  - Tic-Edit- View?   //Copy Focus Track-Tics into memory (only one PAGE)
        int x; for(x=0; x<(StepPerPage); x++) {//StepPerPage=15+1= 16Steps
         SeqTicFocus16[x]  =  SeqTic[focusMatrixUse[0]][x+(Page*(StepPerPage))];}}  //copy steps of actual page & row into memory
    }

  if(control == 60){ //paste
      if(MatrixUse == 0  && SeqTicView == 0){ //Sequencer-Mode?  - Step-Entry View?  //Copy Focus Track into memory (only one PAGE)
       int x; for(x=0; x<(StepPerPage); x++) {//StepPerPage=15+1= 16Steps
        Seq[focusMatrixUse[0]][x+(Page*(StepPerPage))] = seqMATRIXfocus16[x];}}  //copy steps of actual page & row into memory

      if(MatrixUse == 0  && SeqTicView == 1){ //Sequencer-Mode?  - Tic - Edit View?  //Paste Tic Memory into Focused Track
       int x; for(x=0; x<(StepPerPage); x++) {//StepPerPage=15+1= 16Steps
        SeqTic[focusMatrixUse[0]][x+(Page*(StepPerPage))] = SeqTicFocus16[x];}}  //copy steps of actual page & row into memory
    }

  if(control == 61){ //clear
      if(MatrixUse == 0  && SeqTicView == 0){ //Sequencer-Mode?  - Step-Entry View?  //Clear NriggerTrack
       int x; for(x=0; x<(StepPerPage); x++) {
        Seq[focusMatrixUse[0]][x+(Page*(StepPerPage))] = 0;}}  //fill Focused Track of actual page with 0ś

      if(MatrixUse == 0  && SeqTicView == 1){ //Sequencer-Mode?  - Tic - Edit View?  //Clear TicTrack
       int x; for(x=0; x<(StepPerPage); x++) {
        SeqTic[focusMatrixUse[0]][x+(Page*(StepPerPage))] = 0;}}  //fill Focused Track of actual page with 0ś
    }
///////////////////////////////////////////////////////////////////////////////////////////
//TO do copy whole Focused Track - all 256 .... no problem to program but - need off hardware buttons....
//u8 seqMATRIXfocus[256] = {};    //Just a memory container to copy paste Sequencer Tracks

}//End Sequencer Stuff
}//End DIN-Midi Input
}
} //End Hook

static void LED(u32 function) { //update LEDs
  if(function == 0) {//dump-out LED-Status

    //Play Mode
    if(PlayMode == 0) {BLM_X_LEDColorSet(50, 1); //SONG
                       BLM_X_LEDColorSet(49, 0);}
    if(PlayMode == 1) {BLM_X_LEDColorSet(50, 0); //JAM
                       BLM_X_LEDColorSet(49, 1);}

    if(SEQ_BPM_IsRunning()==0) {BLM_X_LEDColorSet(18,0);}//Play LED Deactive
                          else {BLM_X_LEDColorSet(18,1);}//Play LED Active

    BLM_X_LEDColorSet(19,Rec);
    //Play Direction   
    if(direction == 0) {BLM_X_LEDColorSet(11,1); 
                        BLM_X_LEDColorSet(3, 0);
                        BLM_X_LEDColorSet(2, 0);}
    if(direction == 1) {BLM_X_LEDColorSet(11,0); 
                        BLM_X_LEDColorSet(3, 1);
                        BLM_X_LEDColorSet(2, 0);}
    if(direction == 2) {BLM_X_LEDColorSet(11,0); 
                        BLM_X_LEDColorSet(3, 0);
                        BLM_X_LEDColorSet(2, 1);}
    
    BLM_X_LEDColorSet(48,SyncType);                  
    BLM_X_LEDColorSet(40,LoopLengthBtn);
      
    if(VelSel == 0) {BLM_X_LEDColorSet(24,1); 
                     BLM_X_LEDColorSet(25,0);
                     BLM_X_LEDColorSet(26,0);}
    if(VelSel == 1) {BLM_X_LEDColorSet(24,0); 
                     BLM_X_LEDColorSet(25,1);
                     BLM_X_LEDColorSet(26,0);}
    if(VelSel == 2) {BLM_X_LEDColorSet(24,0); 
                     BLM_X_LEDColorSet(25,0);
                     BLM_X_LEDColorSet(26,1);}

    if(MatrixUse == 0) {BLM_X_LEDColorSet(59,1); 
                        BLM_X_LEDColorSet(58, 0);
                        BLM_X_LEDColorSet(57, 0);
                        BLM_X_LEDColorSet(56, 0);}
    if(MatrixUse == 1) {BLM_X_LEDColorSet(59,0); 
                        BLM_X_LEDColorSet(58, 1);
                        BLM_X_LEDColorSet(57, 0);
                        BLM_X_LEDColorSet(56, 0);}
    if(MatrixUse == 2) {BLM_X_LEDColorSet(59,0); 
                        BLM_X_LEDColorSet(58, 0);
                        BLM_X_LEDColorSet(57, 1);
                        BLM_X_LEDColorSet(56, 0);}
    if(MatrixUse == 3) {BLM_X_LEDColorSet(59,0); 
                        BLM_X_LEDColorSet(58, 0);
                        BLM_X_LEDColorSet(57, 0);
                        BLM_X_LEDColorSet(56, 1);}
              
    BLM_X_LEDColorSet(10,VeloKill[2]);
    BLM_X_LEDColorSet(9, VeloKill[1]);
    BLM_X_LEDColorSet(8, VeloKill[0]);
    BLM_X_LEDColorSet(41, VeloInvert);

    BLM_X_LEDColorSet(43, SongLine);    

    BLM_X_LEDColorSet(35, intro);   
    BLM_X_LEDColorSet(42, AutQuntActive);   
    BLM_X_LEDColorSet(51, SwingSwitch);  
}}

static void MENUE(u32 menue_cc, s32 menue_incrementer){//MENUE - PAGES
	
 //Menue Encoder (=Virtual Encoder-Bank Selector)
 if((menue_cc == 16) && (MenueEncoderMode == 0)){ // 0:Setting-Menue, 1:Edit Note Date of Step
  menue_value = LCD0Page + menue_incrementer;    // increment to virtual position and ensure that the menue_value is in range 0..127
  if(menue_value <= 0) {menue_value = 0;}        // 
  if(menue_value >= 9) {menue_value = 8;}        // 
  LCD0Page = menue_value;
  MENUE(126, 0);} //Update Menu
  
  else if((menue_cc == 16) && (MenueEncoderMode == 1)){ // 0:Setting-Menue, 1:Edit Note Date of Step
  menue_value = StepLCD + menue_incrementer;    // increment to virtual position and ensure that the menue_value is in range 0..127
  if(menue_value <= 0) {menue_value = 256;}        // 
  if(menue_value >= 256) {menue_value = 0;}        // 
  StepLCD = menue_value;
  MENUE(126, 0);} //Update Menu

  
  

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//MENU PAGE 0/////////////////////////////////////////////////////////////////////////////////////	//////////      
  if( (LCD0Page == 0  &&  menue_cc < 16) || (LCD0Page == 0 && menue_cc == 126)) { //LOAD - STORE Bank//TIMING
//LCD0
			if(menue_cc == 0){ 
				menue_value = SongNrLoad + menue_incrementer;    
				if(menue_value < 0){menue_value = 511;}
				if(menue_value > 511){menue_value = 0;}
				SongNrLoad = menue_value;
				//ReadName From File	
				MUTEX_SDCARD_GIVE;
		          sprintf(filepathL, "tm/%d.tm", SongNrLoad);
                  FILE_ReadOpen	(&midifile_fi, filepathL);
                    FILE_ReadBuffer	((u8 *)file_typeBank,	4); 	
                    FILE_ReadBuffer	((u8 *)SongNameLoad,	8); 
                  FILE_ReadClose	(&midifile_fi);
                MUTEX_SDCARD_GIVE;}
			if(menue_cc == 2){ 
				menue_value = SongNrStor + menue_incrementer;    
				if(menue_value < 0){menue_value = 511;}
				if(menue_value > 511){menue_value = 0;}
				SongNrStor= menue_value;}
			if(menue_cc == 5){
				menue_value = SongNamePointerCount + menue_incrementer; 
				if(menue_value < 0){menue_value = 7;}
				if(menue_value > 7){menue_value = 0;}
				SongNamePointerCount = menue_value;
				if(SongNamePointerCount == 0){
												SongNamePointer[0]=94;
												SongNamePointer[1]=95;
												SongNamePointer[2]=95;
												SongNamePointer[3]=95;
												SongNamePointer[4]=95;
												SongNamePointer[5]=95;
												SongNamePointer[6]=95;
												SongNamePointer[7]=95;}
				if(SongNamePointerCount == 1){
												SongNamePointer[0]=95;
												SongNamePointer[1]=94;
												SongNamePointer[2]=95;
												SongNamePointer[3]=95;
												SongNamePointer[4]=95;
												SongNamePointer[5]=95;
												SongNamePointer[6]=95;
												SongNamePointer[7]=95;}
				if(SongNamePointerCount == 2){
												SongNamePointer[0]=95;
												SongNamePointer[1]=95;
												SongNamePointer[2]=94;
												SongNamePointer[3]=95;
												SongNamePointer[4]=95;
												SongNamePointer[5]=95;
												SongNamePointer[6]=95;
												SongNamePointer[7]=95;}
				if(SongNamePointerCount == 3){
												SongNamePointer[0]=95;
												SongNamePointer[1]=95;
												SongNamePointer[2]=95;
												SongNamePointer[3]=94;
												SongNamePointer[4]=95;
												SongNamePointer[5]=95;
												SongNamePointer[6]=95;
												SongNamePointer[7]=95;}
				if(SongNamePointerCount == 4){
												SongNamePointer[0]=95;
												SongNamePointer[1]=95;
												SongNamePointer[2]=95;
												SongNamePointer[3]=95;
												SongNamePointer[4]=94;
												SongNamePointer[5]=95;
												SongNamePointer[6]=95;
												SongNamePointer[7]=95;}
				if(SongNamePointerCount == 5){
												SongNamePointer[0]=95;
												SongNamePointer[1]=95;
												SongNamePointer[2]=95;
												SongNamePointer[3]=95;
												SongNamePointer[4]=95;
												SongNamePointer[5]=94;
												SongNamePointer[6]=95;
												SongNamePointer[7]=95;}
				if(SongNamePointerCount == 6){
												SongNamePointer[0]=95;
												SongNamePointer[1]=95;
												SongNamePointer[2]=95;
												SongNamePointer[3]=95;
												SongNamePointer[4]=95;
												SongNamePointer[5]=95;
												SongNamePointer[6]=94;
												SongNamePointer[7]=95;}
				if(SongNamePointerCount == 7){
												SongNamePointer[0]=95;
												SongNamePointer[1]=95;
												SongNamePointer[2]=95;
												SongNamePointer[3]=95;
												SongNamePointer[4]=95;
												SongNamePointer[5]=95;
												SongNamePointer[6]=95;
												SongNamePointer[7]=94;}
				}
			if(menue_cc == 7){
				s32 menue_value = SongNameChar + menue_incrementer;            // increment to virtual position and ensure that the menue_value is in range 0..127
				if(menue_value < 32){menue_value = 90;}
				if(menue_value > 90){menue_value = 32;}
				SongNameChar= menue_value;
				SongNameStore[SongNamePointerCount] = SongNameChar;//write on the current Name-Position -the choosen ASCI-Caracter...
				}	
				
			if(SongNamePointerCount == 0) {SongNameChar = SongNameStore[SongNamePointerCount];}//when i surf thru the  8 letters of the name, 
			if(SongNamePointerCount == 1) {SongNameChar = SongNameStore[SongNamePointerCount];}//i want to start from the already set Character...avoid jumps...
			if(SongNamePointerCount == 2) {SongNameChar = SongNameStore[SongNamePointerCount];}
			if(SongNamePointerCount == 3) {SongNameChar = SongNameStore[SongNamePointerCount];}
			if(SongNamePointerCount == 4) {SongNameChar = SongNameStore[SongNamePointerCount];}
			if(SongNamePointerCount == 5) {SongNameChar = SongNameStore[SongNamePointerCount];}
			if(SongNamePointerCount == 6) {SongNameChar = SongNameStore[SongNamePointerCount];}
			if(SongNamePointerCount == 7) {SongNameChar = SongNameStore[SongNamePointerCount];}

//0.Menu - STORE+LOAD+RENAME
         MUTEX_LCD_TAKE;        //request LCD aCCess
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen 
            MIOS32_LCD_Clear(); //clear screen
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0, 0);  MIOS32_LCD_PrintFormattedString("%d", SongNrLoad+1);
            MIOS32_LCD_CursorSet(4, 0);  MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[0]);
            MIOS32_LCD_CursorSet(5, 0);  MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[1]);
            MIOS32_LCD_CursorSet(6, 0);  MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[2]);
            MIOS32_LCD_CursorSet(7, 0);  MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[3]);
            MIOS32_LCD_CursorSet(8, 0);  MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[4]);
            MIOS32_LCD_CursorSet(9, 0);  MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[5]);	
            MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[6]);
            MIOS32_LCD_CursorSet(11, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameLoad[7]);
            MIOS32_LCD_CursorSet(13, 0); MIOS32_LCD_PrintFormattedString("%d", SongNrStor+1);
            MIOS32_LCD_CursorSet(17, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[0]);
            MIOS32_LCD_CursorSet(18, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[1]);
            MIOS32_LCD_CursorSet(19, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[2]);
            MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[3]);
            MIOS32_LCD_CursorSet(21, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[4]);
            MIOS32_LCD_CursorSet(22, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[5]);
            MIOS32_LCD_CursorSet(23, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[6]);	
            MIOS32_LCD_CursorSet(24, 0); MIOS32_LCD_PrintFormattedString("%c", SongNameStore[7]);		
            MIOS32_LCD_CursorSet(26, 0); MIOS32_LCD_PrintFormattedString("%s %d", "<>       abc",LCD0Page);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0, 1);  MIOS32_LCD_PrintFormattedString("%s", "Load");
            MIOS32_LCD_CursorSet(13, 1);  MIOS32_LCD_PrintFormattedString("%s", "Save");
            MIOS32_LCD_CursorSet(17, 1); MIOS32_LCD_PrintFormattedString("%c%c%c%c%c%c%c%c", 
               SongNamePointer[0], SongNamePointer[1], SongNamePointer[2], SongNamePointer[3], SongNamePointer[4], SongNamePointer[5], SongNamePointer[6], SongNamePointer[7]);
            MIOS32_LCD_CursorSet(26, 1); MIOS32_LCD_PrintFormattedString("%s", "<>");	
          MUTEX_LCD_GIVE;					// release LCD aCCess for other tasks   

//LCD2            //Timing Related (BPM, StepPerPage, Divider...)
			if(menue_cc == 8){{ //RYTHM + CALC Step Per Page
				menue_value = Rythm + menue_incrementer;   
				if(menue_value  < 2)  {menue_value = 2; StepPerPage = 16;}
				if(menue_value == 3)  {                 StepPerPage = 12;}
				if(menue_value == 4)  {                 StepPerPage = 16;}
				if(menue_value == 5)  {                 StepPerPage = 10;}
				if(menue_value == 6)  {                 StepPerPage = 12;}
				if(menue_value == 7)  {                 StepPerPage = 14;}
				if(menue_value == 8)  {                 StepPerPage = 16;}
				if(menue_value == 9)  {                 StepPerPage =  9;}
				if(menue_value == 10) {                 StepPerPage = 10;}
				if(menue_value == 11) {                 StepPerPage = 11;}
				if(menue_value == 12) {                 StepPerPage = 12;}
				if(menue_value == 13) {                 StepPerPage = 13;}
				if(menue_value == 14) {                 StepPerPage = 14;}
				if(menue_value >= 15) {menue_value = 15;StepPerPage = 15;}
				Rythm = menue_value;}}
 
			if(menue_cc == 10){ //Rythm repeats...5x5? or 5x50?
				menue_value = RythmRepeat + menue_incrementer;  
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				RythmRepeat = menue_value;}

                MainLoop = Rythm * RythmRepeat;
                SyncFlag = 1;    //to give the order to change the loop...after some time it will change.

             //BPM 
			 if(menue_cc == 12){
				menue_value = BPM + menue_incrementer;  
				if(menue_value < 20){menue_value = 20;}
				if(menue_value > 255){menue_value = 255;}
				BPM = menue_value;
                SEQ_BPM_Set(BPM);}

             //BPM Divider
			 if(menue_cc == 13){
				menue_value = PpqnDividerCount + menue_incrementer;  
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 2){menue_value = 2;}
				PpqnDividerCount = menue_value;
             if(PpqnDividerCount == 0){PpqnDivider = 2;}
             if(PpqnDividerCount == 1){PpqnDivider = 4;}
             if(PpqnDividerCount == 2){PpqnDivider = 8;}
             SyncFlag = 5;} //update ClockCounter when ready...

            //Calculate TICs
			 if(menue_cc == 14){
				menue_value = BaseTicCount + menue_incrementer;  
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 2){menue_value = 2;}
				BaseTicCount = menue_value;
            if(BaseTicCount == 0){BaseTic =  8;}
       else if(BaseTicCount == 1){BaseTic = 12;}
       else if(BaseTicCount == 2){BaseTic = 18;}
       Tic = 32 * BaseTic; //32x12=384
       SyncFlag = 4;} //update ClockCounter when ready...

         MUTEX_LCD_TAKE;        //request LCD aCCess
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", Rythm);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", StepPerPage);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", RythmRepeat);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", MainLoop);				
            MIOS32_LCD_CursorSet(21, 0);MIOS32_LCD_PrintFormattedString("%d", BPM);	
            MIOS32_LCD_CursorSet(28, 0);MIOS32_LCD_PrintFormattedString("%d", PpqnDivider);
	        MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%s", ">");		
			MIOS32_LCD_CursorSet(33, 0);MIOS32_LCD_PrintFormattedString("%d", BaseTic);
	        MIOS32_LCD_CursorSet(36, 0);MIOS32_LCD_PrintFormattedString("%s", "=");	
            MIOS32_LCD_CursorSet(37, 0);MIOS32_LCD_PrintFormattedString("%d", Tic);

          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "Beat");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "Step");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "Rept");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "Loop");
            MIOS32_LCD_CursorSet(21, 1);MIOS32_LCD_PrintFormattedString("%s", "BPM");
            MIOS32_LCD_CursorSet(26, 1);MIOS32_LCD_PrintFormattedString("%s", "Tempo");
            MIOS32_LCD_CursorSet(32, 1);MIOS32_LCD_PrintFormattedString("%s", "Base");
            MIOS32_LCD_CursorSet(37, 1);MIOS32_LCD_PrintFormattedString("%s", "Tic");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			
}      

//////////////////////////////////////////////////////////////////////////////////////////////////
//MENU PAGE 1/////////////////////////////////////////////////////////////////////////////////////   NICHT MEHR VERSCHIEBEN DIE SEITEN 2-3 SIND FIX...da hängt zuviel im Hintergrund drann..
  if( (LCD0Page == 1  &&  menue_cc < 16) || (LCD0Page == 1 && menue_cc == 126))  { //Song - Steps 0-15 (SONG-PAGE 0)
     if(menu_cc <= 15) {
     if(SongLine == 0) {   //SONG[2][32] = //SET Songpart
				menue_value = SONG[SongLine][menue_cc] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 18){menue_value = 18;}
				SONG[SongLine][menue_cc] = menue_value;}

     if(SongLine == 1) {//SET SongPartMultiplicator /Roadway
				menue_value = SONG[SongLine][menue_cc] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 15){menue_value = 15;}
				SONG[SongLine][menue_cc] = menue_value;}
//LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Set-Song-Part
            if(SONG[0][0] <= 15) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-",SONG[0][0]+1);}
            if(SONG[0][0] == 16) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][0] == 17) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][0] == 18) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][1] <= 15) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][1]+1);}
            if(SONG[0][1] == 16) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][1] == 17) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][1] == 18) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][2] <= 15) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][2]+1);}
            if(SONG[0][2] == 16) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][2] == 17) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][2] == 18) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][3] <= 15) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][3]+1);}
            if(SONG[0][3] == 16) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][3] == 17) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][3] == 18) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][4] <= 15) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][4]+1);}
            if(SONG[0][4] == 16) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][4] == 17) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][4] == 18) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][5] <= 15) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][5]+1);}
            if(SONG[0][5] == 16) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][5] == 17) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][5] == 18) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][6] <= 15) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][6]+1);}
            if(SONG[0][6] == 16) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][6] == 17) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][6] == 18) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][7] <= 15) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][7]+1);}
            if(SONG[0][7] == 16) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][7] == 17) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][7] == 18) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Song Multiplcation/RoadWay
            if(SONG[1][0] <= 15) { MIOS32_LCD_CursorSet(0,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][0]);}
            if(SONG[1][1] <= 15) { MIOS32_LCD_CursorSet(5,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][1]);}
            if(SONG[1][2] <= 15) { MIOS32_LCD_CursorSet(10,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][2]);}
            if(SONG[1][3] <= 15) { MIOS32_LCD_CursorSet(15,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][3]);}
            if(SONG[1][4] <= 15) { MIOS32_LCD_CursorSet(20,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][4]);}
            if(SONG[1][5] <= 15) { MIOS32_LCD_CursorSet(25,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][5]);}
            if(SONG[1][6] <= 15) { MIOS32_LCD_CursorSet(30,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][6]);}
            if(SONG[1][7] <= 15) { MIOS32_LCD_CursorSet(35,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][7]);}
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			

//LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Set-Song-Part
            if(SONG[0][8]  <= 15) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-",SONG[0][8]+1);}
            if(SONG[0][8]  == 16) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][8]  == 17) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][8]  == 18) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][9]  <= 15) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][9]+1);}
            if(SONG[0][9]  == 16) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][9]  == 17) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][9]  == 18) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][10] <= 15) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][10]+1);}
            if(SONG[0][10] == 16) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][10] == 17) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][10] == 18) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][11] <= 15) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][11]+1);}
            if(SONG[0][11] == 16) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][11] == 17) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][11] == 18) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][12] <= 15) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][12]+1);}
            if(SONG[0][12] == 16) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][12] == 17) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][12] == 18) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][13] <= 15) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][13]+1);}
            if(SONG[0][13] == 16) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][13] == 17) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][13] == 18) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][14] <= 15) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][14]+1);}
            if(SONG[0][14] == 16) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][14] == 17) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][14] == 18) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][15] <= 15) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][15]+1);}
            if(SONG[0][15] == 16) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][15] == 17) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][15] == 18) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Song Multiplcation/RoadWay
            if(SONG[1][8]  <= 15) { MIOS32_LCD_CursorSet(0,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][8]);}
            if(SONG[1][9]  <= 15) { MIOS32_LCD_CursorSet(5,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][9]);}
            if(SONG[1][10] <= 15) { MIOS32_LCD_CursorSet(10,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][10]);}
            if(SONG[1][11] <= 15) { MIOS32_LCD_CursorSet(15,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][11]);}
            if(SONG[1][12] <= 15) { MIOS32_LCD_CursorSet(20,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][12]);}
            if(SONG[1][13] <= 15) { MIOS32_LCD_CursorSet(25,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][13]);}
            if(SONG[1][14] <= 15) { MIOS32_LCD_CursorSet(30,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][14]);}
            if(SONG[1][15] <= 15) { MIOS32_LCD_CursorSet(35,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][15]);}
          MUTEX_LCD_GIVE;				// release LCD access for other tasks 
}	
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//MENU PAGE 2/////////////////////////////////////////////////////////////////////////////////////   NICHT MEHR VERSCHIEBEN DIE SEITEN 2-3 SIND FIX...da hängt zuviel im Hintergrund drann..
  if( (LCD0Page == 2  &&  menue_cc < 16) || (LCD0Page == 2 && menue_cc == 126))  { //Song - Steps 16-31 (SONG-PAGE 1)
     if(menu_cc <= 15) {
     if(SongLine == 0) {   //SONG[2][32] = //SET Songpart
				menue_value = SONG[SongLine][menue_cc+16] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 18){menue_value = 18;}
				SONG[SongLine][menue_cc+16] = menue_value;}

     if(SongLine == 1) {//SET SongPartMultiplicator /Roadway
				menue_value = SONG[SongLine][menue_cc+16] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 15){menue_value = 15;}
				SONG[SongLine][menue_cc+16] = menue_value;}
//LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Set-Song-Part
            if(SONG[0][16] <= 15) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-",SONG[0][16]+1);}
            if(SONG[0][16] == 16) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][16] == 17) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][16] == 18) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][17] <= 15) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][17]+1);}
            if(SONG[0][17] == 16) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][17] == 17) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][17] == 18) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][18] <= 15) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][18]+1);}
            if(SONG[0][18] == 16) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][18] == 17) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][18] == 18) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][19] <= 15) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][19]+1);}
            if(SONG[0][19] == 16) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][19] == 17) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][19] == 18) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][20] <= 15) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][20]+1);}
            if(SONG[0][20] == 16) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][20] == 17) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][20] == 18) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][21] <= 15) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][21]+1);}
            if(SONG[0][21] == 16) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][21] == 17) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][21] == 18) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][22] <= 15) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][22]+1);}
            if(SONG[0][22] == 16) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][22] == 17) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][22] == 18) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][23] <= 15) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][23]+1);}
            if(SONG[0][23] == 16) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][23] == 17) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][23] == 18) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Song Multiplcation/RoadWay
            if(SONG[1][16] <= 15) { MIOS32_LCD_CursorSet(0,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][16]+1);}
            if(SONG[1][17] <= 15) { MIOS32_LCD_CursorSet(5,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][17]+1);}
            if(SONG[1][18] <= 15) { MIOS32_LCD_CursorSet(10,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][18]+1);}
            if(SONG[1][19] <= 15) { MIOS32_LCD_CursorSet(15,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][19]+1);}
            if(SONG[1][20] <= 15) { MIOS32_LCD_CursorSet(20,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][20]+1);}
            if(SONG[1][21] <= 15) { MIOS32_LCD_CursorSet(25,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][21]+1);}
            if(SONG[1][22] <= 15) { MIOS32_LCD_CursorSet(30,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][22]+1);}
            if(SONG[1][23] <= 15) { MIOS32_LCD_CursorSet(35,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][23]+1);}
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			

//LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Set-Song-Part
            if(SONG[0][24] <= 15) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-",SONG[0][24]+1);}
            if(SONG[0][24] == 16) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][24] == 17) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][24] == 18) { MIOS32_LCD_CursorSet(0,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][25] <= 15) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][25]+1);}
            if(SONG[0][25] == 16) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][25] == 17) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][25] == 18) { MIOS32_LCD_CursorSet(5,   0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][26] <= 15) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][26]+1);}
            if(SONG[0][26] == 16) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][26] == 17) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][26] == 18) { MIOS32_LCD_CursorSet(10,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][27] <= 15) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][27]+1);}
            if(SONG[0][27] == 16) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][27] == 17) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][27] == 18) { MIOS32_LCD_CursorSet(15,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][28] <= 15) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][28]+1);}
            if(SONG[0][28] == 16) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][28] == 17) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][28] == 18) { MIOS32_LCD_CursorSet(20,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][29] <= 15) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][29]+1);}
            if(SONG[0][29] == 16) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][29] == 17) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][29] == 18) { MIOS32_LCD_CursorSet(25,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][30] <= 15) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][30]+1);}
            if(SONG[0][30] == 16) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][30] == 17) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][30] == 18) { MIOS32_LCD_CursorSet(30,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            if(SONG[0][31] <= 15) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s%d", "p-", SONG[0][31]+1);}
            if(SONG[0][31] == 16) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "<");}
            if(SONG[0][31] == 17) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", ">");}
            if(SONG[0][31] == 18) { MIOS32_LCD_CursorSet(35,  0);MIOS32_LCD_PrintFormattedString("%s", "JAM");}
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Song Multiplcation/RoadWay
            if(SONG[1][24] <= 15) { MIOS32_LCD_CursorSet(0,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][24]+1);}
            if(SONG[1][25] <= 15) { MIOS32_LCD_CursorSet(5,   1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][25]+1);}
            if(SONG[1][26] <= 15) { MIOS32_LCD_CursorSet(10,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][26]+1);}
            if(SONG[1][27] <= 15) { MIOS32_LCD_CursorSet(15,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][27]+1);}
            if(SONG[1][28] <= 15) { MIOS32_LCD_CursorSet(20,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][28]+1);}
            if(SONG[1][29] <= 15) { MIOS32_LCD_CursorSet(25,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][29]+1);}
            if(SONG[1][30] <= 15) { MIOS32_LCD_CursorSet(30,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][30]+1);}
            if(SONG[1][31] <= 15) { MIOS32_LCD_CursorSet(35,  1);MIOS32_LCD_PrintFormattedString("%s%d", "x", SONG[1][31]+1);}
          MUTEX_LCD_GIVE;				// release LCD access for other tasks 
}	
}

//MENU PAGE 3/////////////////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 3  &&  menue_cc < 16) || (LCD0Page == 3 && menue_cc == 126)) { //Program Change 
			if(menue_cc == 0){{//PC MidiChannel 0
				menue_value = PCBank[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[0] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[0]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 0, 32, PCBank[0]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 0, SongNrLoad);}
				  	if(PCType[0]==1){ //1: BankChange is realized via CCNr0
					  MIOS32_MIDI_SendCC(MelPortOut, 0, 0, PCBank[0]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 0, SongNrLoad);}}}  
 
			if(menue_cc ==  1){{//PC MidiChannel 1
				menue_value = PCBank[1] + menue_incrementer;    
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[1] = menue_value;}
				if(PCLoad == 0){     
					if(PCType[1]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 1, 32, PCBank[1]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 1, SongNrLoad);}
				  	if(PCType[1]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 1, 0, PCBank[1]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 1, SongNrLoad);}}}  				      
				      
			if(menue_cc ==  2){{//PC MidiChannel 2
				menue_value = PCBank[2] + menue_incrementer;  
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[2] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[2]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 2, 32, PCBank[2]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 2, SongNrLoad);}
				    if(PCType[2]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 2, 0, PCBank[2]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 2, SongNrLoad);}}} 
				
			if(menue_cc ==  3){{//PC MidiChannel 3
				menue_value = PCBank[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[3] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[3]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 3, 32, PCBank[3]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 3, SongNrLoad);}
				    if(PCType[3]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 3, 0, PCBank[3]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 3, SongNrLoad);}}}
				
			if(menue_cc ==  4){{//PC MidiChannel 4
				menue_value = PCBank[4] + menue_incrementer;   
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[4] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[4]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 4, 32, PCBank[4]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 4, SongNrLoad);}
				    if(PCType[4]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 4, 0, PCBank[4]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 4, SongNrLoad);}}}
				
			if(menue_cc ==  5){{//PC MidiChannel 5
				menue_value = PCBank[5] + menue_incrementer;   
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[5] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[5]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 5, 32, PCBank[5]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 5, SongNrLoad);}
				    if(PCType[5]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 5, 0, PCBank[5]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 5, SongNrLoad);}}}
				
			if(menue_cc ==  6){{//PC MidiChannel 6
				menue_value = PCBank[6] + menue_incrementer;   
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[6] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[6]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 6, 32, PCBank[6]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 6, SongNrLoad);}
				    if(PCType[6]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 6, 0, PCBank[6]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 6, SongNrLoad);}}}
				
			if(menue_cc ==  7){{//PC MidiChannel 7
				menue_value = PCBank[7] + menue_incrementer;   
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[7] = menue_value;}
				if(PCLoad == 7){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[7]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 7, 32, PCBank[7]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 7, SongNrLoad);}
				    if(PCType[7]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 7, 0, PCBank[7]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 7, SongNrLoad);}}}

			if(menue_cc ==  8){{//PC MidiChannel 8
				menue_value = PCBank[8] + menue_incrementer;   
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[8] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[8]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 8, 32, PCBank[8]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 8, SongNrLoad);}
				  	if(PCType[4]==1){ //1: BankChange is realized via CCNr0
					  MIOS32_MIDI_SendCC(MelPortOut, 8, 0, PCBank[8]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 8, SongNrLoad);}}}  
 
			if(menue_cc ==  9){{//PC MidiChannel 9
				menue_value = PCBank[9] + menue_incrementer;    
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[9] = menue_value;}
				if(PCLoad == 0){     
					if(PCType[9]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 9, 32, PCBank[9]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 9, SongNrLoad);}
				  	if(PCType[5]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 9, 0, PCBank[9]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 9, SongNrLoad);}}}  				      
				      
			if(menue_cc == 10){{//PC MidiChannel 10
				menue_value = PCBank[10] + menue_incrementer;  
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[10] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[10]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 10, 32, PCBank[10]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 10, SongNrLoad);}
				    if(PCType[10]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 10, 0, PCBank[10]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 10, SongNrLoad);}}} 
				
            if(menue_cc == 11){{//PC MidiChannel 11
				menue_value = PCBank[11] + menue_incrementer;  
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[11] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[11]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 11, 32, PCBank[11]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 11, SongNrLoad);}
				    if(PCType[11]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 11, 0, PCBank[11]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 11, SongNrLoad);}}}

            if(menue_cc == 12){{//PC MidiChannel 12
				menue_value = PCBank[12] + menue_incrementer;  
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[12] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[12]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 12, 32, PCBank[12]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 12, SongNrLoad);}
				    if(PCType[12]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 12, 0, PCBank[12]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 12, SongNrLoad);}}}

            if(menue_cc == 13){{//PC MidiChannel 13
				menue_value = PCBank[13] + menue_incrementer;  
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[13] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[13]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 13, 32, PCBank[13]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 13, SongNrLoad);}
				    if(PCType[13]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 13, 0, PCBank[13]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 13, SongNrLoad);}}}

            if(menue_cc == 14){{//PC MidiChannel 14
				menue_value = PCBank[14] + menue_incrementer;  
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[14] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[14]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 14, 32, PCBank[14]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 14, SongNrLoad);}
				    if(PCType[14]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 14, 0, PCBank[14]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 14, SongNrLoad);}}}

            if(menue_cc == 15){{//PC MidiChannel 15
				menue_value = PCBank[15] + menue_incrementer;  
				if(menue_value < 0){menue_value = 128;}
				if(menue_value > 128){menue_value = 0;}
				PCBank[15] = menue_value;}
				if(PCLoad == 0){      //0: realtime Load the Programchange, 1: Load only with PatchLoad
					if(PCType[15]==0){ 
					  MIOS32_MIDI_SendCC(MelPortOut, 15, 32, PCBank[15]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 15, SongNrLoad);}
				    if(PCType[15]==1){
					  MIOS32_MIDI_SendCC(MelPortOut, 15, 0, PCBank[15]);		             
				      MIOS32_MIDI_SendProgramChange(MelPortOut, 15, SongNrLoad);}}}
         //LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCess
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", PCBank[0]);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", PCBank[1]);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[2]);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[3]);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[4]);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[5]);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[6]);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[7]);
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "Bk1");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "Bk2");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk3");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk4");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk5");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk6");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "Pk7");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "Pk8");
         MUTEX_LCD_GIVE;					// release LCD access for other tasks       
 
         //LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", PCBank[8]);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", PCBank[9]);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[10]);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[11]);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[12]);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[13]);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[14]);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", PCBank[15]);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "Bk9");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "Bk10");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk11");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk12");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk13");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "Bk14");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "Pk15");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "Pk16");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			

}

//MENU PAGE 4/////////////////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 4  &&  menue_cc < 16) || (LCD0Page == 4 && menue_cc == 126)) { //AutoQuantRate 
			if(menue_cc == 0){//Auto-Quant-Rate
				menue_value = QuantRate + menue_incrementer;   
				if(menue_value <= 0){menue_value = 0;}
				if(menue_value  > 2){menue_value = 2;}
	                QuantRate = menue_value;}
         //LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCess
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            if(QuantRate == 0)   {MIOS32_LCD_CursorSet(1,  0); MIOS32_LCD_PrintFormattedString("%s", "16");}
            if(QuantRate == 1)   {MIOS32_LCD_CursorSet(1,  0); MIOS32_LCD_PrintFormattedString("%s", "32");}
            if(QuantRate == 2)   {MIOS32_LCD_CursorSet(1,  0); MIOS32_LCD_PrintFormattedString("%s", "64");}
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "Qunt");
         MUTEX_LCD_GIVE;					// release LCD access for other tasks       
 
         //LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			

}

//MENU PAGE 5////SYSTEM////SYSTEM////SYSTEM////SYSTEM////SYSTEM////SYSTEM////SYSTEM////SYSTEM////////////////
  if( (LCD0Page == 5  &&  menue_cc < 16) || (LCD0Page == 5 && menue_cc == 126))   { //UP HERE SYSTEM SETTINGS
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "--------SYSTEM--SETTINGS-------");
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0, 1);  MIOS32_LCD_PrintFormattedString("%s", "Load");
            MIOS32_LCD_CursorSet(13, 1);  MIOS32_LCD_PrintFormattedString("%s", "Save");
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  	

        //Clear 2nd Screen not use @ the moment
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  
}

//MENU PAGE 6////////////////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 6  &&  menue_cc < 16) || (LCD0Page == 6 && menue_cc == 126))   { //Midi Ports && Programchange
    //LCD0 // PORTS
      if(menue_cc == 0){
				menue_value = ClockPortIN + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				ClockPortIN = menue_value;}
      if(menue_cc == 1){
				menue_value = TrigPortIN + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				TrigPortIN = menue_value;}
      if(menue_cc == 2){
				menue_value = TrigPortOUT + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				TrigPortOUT = menue_value;}
      if(menue_cc == 3){
				menue_value = RemotePort + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				RemotePort = menue_value;}
      if(menue_cc == 4){
				menue_value = MelPortIn + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				MelPortIn = menue_value;}
      if(menue_cc == 5){
				menue_value = MelPortIn2 + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				MelPortIn2 = menue_value;}
      if(menue_cc == 6){
				menue_value = MelPortOut + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				MelPortOut = menue_value;}
      if(menue_cc == 7){
				menue_value = BLMport + menue_incrementer;   
				if(menue_value <= 32){menue_value = 32;} //32:PortA, 33:PortB, 34:PortC, 35:Port
				if(menue_value >= 35){menue_value = 35;}
				BLMport = menue_value;}           

   //Update Menue
   MUTEX_LCD_TAKE;           //request LCD access
     MIOS32_LCD_DeviceSet (0);//2nd 2x40 LCD-screen 
     MIOS32_LCD_Clear();      //clear screen
     if(ClockPortIN == 32) {MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString("%s", "in-A");}
else if(ClockPortIN == 33) {MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString("%s", "in-B");}
else if(ClockPortIN == 34) {MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString("%s", "in-C");}
else if(ClockPortIN == 35) {MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString("%s", "in-D");}
     if(TrigPortIN  == 32) {MIOS32_LCD_CursorSet(5, 0); MIOS32_LCD_PrintFormattedString("%s", "in-A");}
else if(TrigPortIN  == 33) {MIOS32_LCD_CursorSet(5, 0); MIOS32_LCD_PrintFormattedString("%s", "in-B");}
else if(TrigPortIN  == 34) {MIOS32_LCD_CursorSet(5, 0); MIOS32_LCD_PrintFormattedString("%s", "in-C");}
else if(TrigPortIN  == 35) {MIOS32_LCD_CursorSet(5, 0); MIOS32_LCD_PrintFormattedString("%s", "in-D");}
     if(TrigPortOUT == 32) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-A");}
else if(TrigPortOUT == 33) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-B");}
else if(TrigPortOUT == 34) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-C");}
else if(TrigPortOUT == 35) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-D");}
     if(RemotePort == 32)  {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "io-A");}
else if(RemotePort == 33)  {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "io-B");}
else if(RemotePort == 34)  {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "io-C");}
else if(RemotePort == 35)  {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "io-D");}
     if(MelPortIn  == 32)  {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "in-A");}
else if(MelPortIn  == 33)  {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "in-B");}
else if(MelPortIn  == 34)  {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "in-C");}
else if(MelPortIn  == 35)  {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "in-D");}
     if(MelPortIn2 == 32)  {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "in-A");}
else if(MelPortIn2 == 33)  {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "in-B");}
else if(MelPortIn2 == 34)  {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "in-C");}
else if(MelPortIn2 == 35)  {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "in-D");}
     if(MelPortOut == 32)  {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-A");}
else if(MelPortOut == 33)  {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-B");}
else if(MelPortOut == 34)  {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-C");}
else if(MelPortOut == 35)  {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "ou-D");}
     if(BLMport    == 32)  {MIOS32_LCD_CursorSet(36, 0); MIOS32_LCD_PrintFormattedString("%s", "A");}
else if(BLMport    == 33)  {MIOS32_LCD_CursorSet(36, 0); MIOS32_LCD_PrintFormattedString("%s", "B");}
else if(BLMport    == 34)  {MIOS32_LCD_CursorSet(36, 0); MIOS32_LCD_PrintFormattedString("%s", "C");}
else if(BLMport    == 35)  {MIOS32_LCD_CursorSet(36, 0); MIOS32_LCD_PrintFormattedString("%s", "D");}
            MIOS32_LCD_CursorSet(38, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
   MUTEX_LCD_GIVE;           //request LCD access

          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "Clok");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "Trig");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "Trig");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "Rmot");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "Mel1");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "Mel2");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "Mel");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "BLM");
         MUTEX_LCD_GIVE;					// release LCD access for other tasks    

    //LCD1 // Programchange Settings
           if(menue_cc == 8){
                    menue_value  = PCPortIN  + menue_incrementer;
	                if(menue_value  <= 32) {menue_value  = 32;}   //32:PortA, 33:PortB, 34:PortC, 35:PortD
	                if(menue_value  >= 35) {menue_value  = 35;}   
	                PCPortIN  = menue_value ;}
           if(menue_cc == 9) {
                    menue_value  = PCChIN  + menue_incrementer;
	                if(menue_value  <= 0)  {menue_value  =  0;}   //MidiChannels for ProgramChange Input
	                if(menue_value  >= 15) {menue_value  = 15;}   
	                PCChIN  = menue_value ;}
           if(menue_cc == 10) {
                    menue_value  = PCSend  + menue_incrementer;
	                if(menue_value  <= 0)  {menue_value  = 0;}   //Send Programchange?
	                if(menue_value  >= 1)  {menue_value  = 1;}   
	                PCSend  = menue_value ;}
           if(menue_cc == 11) {
                    menue_value  = PCReceive  + menue_incrementer;
	                if(menue_value  <= 0)  {menue_value  = 0;}   //Receive Programchange
	                if(menue_value  >= 1)  {menue_value  = 1;}   
	                PCReceive  = menue_value ;}

           if(menue_cc == 15) {
                    menue_value  = TrigInCh  + menue_incrementer;
	                if(menue_value  <= 0)  {menue_value  =  0;}   //TriggerInputMidiChannel
	                if(menue_value  >= 15) {menue_value  = 15;}   
	                TrigInCh  = menue_value ;}
  
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            if(PCPortIN == 32) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "PrtA");}
            if(PCPortIN == 33) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "PrtB");}
            if(PCPortIN == 34) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "PrtC");}
            if(PCPortIN == 35) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "PrtD");}
                                MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", PCChIN+1);
            if(PCSend    == 0) {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PCSend    == 1) {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PCReceive == 0) {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PCReceive == 1) {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            MIOS32_LCD_CursorSet(32, 0); MIOS32_LCD_PrintFormattedString("%s%d", "Ch-",TrigInCh+1);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "InPC");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "CHPC");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "TxPC");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "RxPC");
            MIOS32_LCD_CursorSet(32, 1);MIOS32_LCD_PrintFormattedString("%s", "TrigIn");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//MENU PAGE 7/////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 7  &&  menue_cc < 16) || (LCD0Page == 7 && menue_cc == 126))  { //TRIGGER INPUT NOTE Numbers
			if(menue_cc == 0){//Trigger Input NOTE
				menue_value = TrigInNote[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[0] = menue_value;}  
 			if(menue_cc == 1){//Trigger Input NOTE
				menue_value = TrigInNote[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[1] = menue_value;}   
 			if(menue_cc == 2){//Trigger Input NOTE
				menue_value = TrigInNote[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[2] = menue_value;}   
 			if(menue_cc == 3){//Trigger Input NOTE
				menue_value = TrigInNote[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[3] = menue_value;}   
 			if(menue_cc == 4){//Trigger Input NOTE
				menue_value = TrigInNote[4] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[4] = menue_value;}   
 			if(menue_cc == 5){//Trigger Input NOTE
				menue_value = TrigInNote[5] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[5] = menue_value;}   
 			if(menue_cc == 6){//Trigger Input NOTE
				menue_value = TrigInNote[6] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[6] = menue_value;}   
 			if(menue_cc == 7){//Trigger Input NOTE
				menue_value = TrigInNote[7] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[7] = menue_value;} 
			if(menue_cc ==  8){//Trigger Input NOTE
				menue_value = TrigInNote[8] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[8] = menue_value;}  
 			if(menue_cc ==  9){//Trigger Input NOTE
				menue_value = TrigInNote[9] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[9] = menue_value;}   
 			if(menue_cc == 10){//Trigger Input NOTE
				menue_value = TrigInNote[10] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[10] = menue_value;}   
 			if(menue_cc == 11){//Trigger Input NOTE
				menue_value = TrigInNote[11] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[11] = menue_value;}   
 			if(menue_cc == 12){//Trigger Input NOTE
				menue_value = TrigInNote[12] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[12] = menue_value;}   
 			if(menue_cc == 13){//Trigger Input NOTE
				menue_value = TrigInNote[13] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[13] = menue_value;}   
 			if(menue_cc == 14){//Trigger Input NOTE
				menue_value = TrigInNote[14] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[14] = menue_value;}   
 			if(menue_cc == 15){//Trigger Input NOTE
				menue_value = TrigInNote[15] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigInNote[15] = menue_value;} 

//LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[0]);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[1]);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[2]);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[3]);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[4]);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[5]);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[6]);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[7]);
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "TIN1");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "TIN2");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN3");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN4");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN5");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN6");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN7");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN8");
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			

//LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[8]);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[9]);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[10]);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[11]);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[12]);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[13]);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[14]);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", TrigInNote[15]);;
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "TIN9");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "TIN10");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN11");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN12");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN13");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN14");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN15");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "TIN16");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			
}

//MENU PAGE 8/////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 8  &&  menue_cc < 16) || (LCD0Page == 8 && menue_cc == 126))   { //TRIGGER OUT NOTE Numbers
			if(menue_cc ==  0){
				menue_value = TrigOutNote[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[0] = menue_value;}  
 			if(menue_cc ==  1){
				menue_value = TrigOutNote[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[1] = menue_value;}   
 			if(menue_cc ==  2){
				menue_value = TrigOutNote[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[2] = menue_value;}   
 			if(menue_cc ==  3){
				menue_value = TrigOutNote[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[3] = menue_value;}   
 			if(menue_cc ==  4){
				menue_value = TrigOutNote[4] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[4] = menue_value;}   
 			if(menue_cc ==  5){
				menue_value = TrigOutNote[5] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[5] = menue_value;}   
 			if(menue_cc ==  6){
				menue_value = TrigOutNote[6] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[6] = menue_value;}   
 			if(menue_cc ==  7){
				menue_value = TrigOutNote[7] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[7] = menue_value;} 
			if(menue_cc ==  8){
				menue_value = TrigOutNote[8] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[8] = menue_value;}  
 			if(menue_cc ==  9){
				menue_value = TrigOutNote[9] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[9] = menue_value;}   
 			if(menue_cc == 10){
				menue_value = TrigOutNote[10] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[10] = menue_value;}   
 			if(menue_cc == 11){
				menue_value = TrigOutNote[11] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[11] = menue_value;}   
 			if(menue_cc == 12){
				menue_value = TrigOutNote[12] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[12] = menue_value;}   
 			if(menue_cc == 13){
				menue_value = TrigOutNote[13] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[13] = menue_value;}   
 			if(menue_cc == 14){
				menue_value = TrigOutNote[14] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[14] = menue_value;}   
 			if(menue_cc == 15){
				menue_value = TrigOutNote[15] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutNote[15] = menue_value;} 
//LCD0
         MUTEX_LCD_TAKE;        //request LCD access
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[0]);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[1]);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[2]);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[3]);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[4]);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[5]);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[6]);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[7]);
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "TON1");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "TON2");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "TON3");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "TON4");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "TON5");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "TON6");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "TON7");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "TON8");
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			
//LCD1
         MUTEX_LCD_TAKE;        //request LCD access
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[8]);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[9]);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[10]);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[11]);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[12]);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[13]);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[14]);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutNote[15]);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "TON9");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "TON10");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "TON11");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "TON12");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "TON13");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "TON14");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "TON15");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "TON16");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			

}

//MENU PAGE 9/////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 9  &&  menue_cc < 16) || (LCD0Page == 9 && menue_cc == 126))   { //TRIGGER OUT Channel Numbers
			if(menue_cc == 0){
				menue_value = TrigOutCh[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[0] = menue_value;}  
 			if(menue_cc ==  1){
				menue_value = TrigOutCh[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[1] = menue_value;}   
 			if(menue_cc ==  2){
				menue_value = TrigOutCh[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[2] = menue_value;}   
 			if(menue_cc ==  3){
				menue_value = TrigOutCh[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[3] = menue_value;}   
 			if(menue_cc ==  4){
				menue_value = TrigOutCh[4] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[4] = menue_value;}   
 			if(menue_cc ==  5){
				menue_value = TrigOutCh[5] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[5] = menue_value;}   
 			if(menue_cc ==  6){
				menue_value = TrigOutCh[6] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[6] = menue_value;}   
 			if(menue_cc ==  7){
				menue_value = TrigOutCh[7] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[7] = menue_value;} 
			if(menue_cc ==  8){
				menue_value = TrigOutCh[8] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[8] = menue_value;}  
 			if(menue_cc ==  9){
				menue_value = TrigOutCh[9] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[9] = menue_value;}   
 			if(menue_cc == 10){
				menue_value = TrigOutCh[10] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[10] = menue_value;}   
 			if(menue_cc == 11){
				menue_value = TrigOutCh[11] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[11] = menue_value;}   
 			if(menue_cc == 12){
				menue_value = TrigOutCh[12] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[12] = menue_value;}   
 			if(menue_cc == 13){
				menue_value = TrigOutCh[13] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[13] = menue_value;}   
 			if(menue_cc == 14){
				menue_value = TrigOutCh[14] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[14] = menue_value;}   
 			if(menue_cc == 15){
				menue_value = TrigOutCh[15] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				TrigOutCh[15] = menue_value;} 
//LCD 0
         MUTEX_LCD_TAKE;        //request LCD access
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[0]+1);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[1]+1);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[2]+1);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[3]+1);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[4]+1);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[5]+1);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[6]+1);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[7]+1);
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "TOC1");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "TOC2");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC3");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC4");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC5");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC6");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC7");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC8");
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			

//LCD 1
         MUTEX_LCD_TAKE;        //request LCD access
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[8]+1);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[9]+1);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[10]+1);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[11]+1);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[12]+1);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[13]+1);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[14]+1);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", TrigOutCh[15]+1);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "TOC9");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "TOC10");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC11");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC12");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC13");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC14");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC15");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "TOC16");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			

}

//MENU PAGE 10////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 10  &&  menue_cc < 16) || (LCD0Page == 10 && menue_cc == 126)) { //MELODY OUT Channel Numbers
			if(menue_cc ==  0){
				menue_value = MeloOutCh[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[0] = menue_value;}  
 			if(menue_cc ==  1){
				menue_value = MeloOutCh[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[1] = menue_value;}   
 			if(menue_cc ==  2){
				menue_value = MeloOutCh[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[2] = menue_value;}   
 			if(menue_cc ==  3){
				menue_value = MeloOutCh[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[3] = menue_value;}   
 			if(menue_cc ==  4){
				menue_value = MeloOutCh[4] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[4] = menue_value;}   
 			if(menue_cc ==  5){
				menue_value = MeloOutCh[5] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[5] = menue_value;}   
 			if(menue_cc ==  6){
				menue_value = MeloOutCh[6] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[6] = menue_value;}   
 			if(menue_cc ==  7){
				menue_value = MeloOutCh[7] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[7] = menue_value;} 
			if(menue_cc ==  8){
				menue_value = MeloOutCh[8] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[8] = menue_value;}  
 			if(menue_cc ==  9){
				menue_value = MeloOutCh[9] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[9] = menue_value;}   
 			if(menue_cc == 10){
				menue_value = MeloOutCh[10] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[10] = menue_value;}   
 			if(menue_cc == 11){
				menue_value = MeloOutCh[11] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[11] = menue_value;}   
 			if(menue_cc == 12){
				menue_value = MeloOutCh[12] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[12] = menue_value;}   
 			if(menue_cc == 13){
				menue_value = MeloOutCh[13] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[13] = menue_value;}   
 			if(menue_cc == 14){
				menue_value = MeloOutCh[14] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[14] = menue_value;}   
 			if(menue_cc == 15){
				menue_value = MeloOutCh[15] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value > 127){menue_value = 127;}
				MeloOutCh[15] = menue_value;} 

//LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[0]+1);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[1]+1);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[2]+1);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[3]+1);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[4]+1);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[5]+1);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[6]+1);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[7]+1);
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page-10);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "MOC1");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "MOC2");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC3");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC4");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC5");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC6");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC7");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC8");
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			

//LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[8]+1);
            MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[9]+1);				
	        MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[10]+1);
            MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[11]+1);				
			MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[12]+1);
            MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[13]+1);				
			MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[14]+1);
            MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%d", MeloOutCh[15]+1);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "MOC9");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "MOC10");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC11");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC12");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC13");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC14");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC15");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "MOC16");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			
}

//MENU PAGE 11////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 11  &&  menue_cc < 16) || (LCD0Page == 11 && menue_cc == 126)) { //Pitchbend-PWR
			if(menue_cc ==  0){
				menue_value = PitchbendPWR[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[0] = menue_value;}  
 			if(menue_cc ==  1){
				menue_value = PitchbendPWR[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[1] = menue_value;}   
 			if(menue_cc ==  2){
				menue_value = PitchbendPWR[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[2] = menue_value;}   
 			if(menue_cc ==  3){
				menue_value = PitchbendPWR[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[3] = menue_value;}   
 			if(menue_cc ==  4){
				menue_value = PitchbendPWR[4] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[4] = menue_value;}   
 			if(menue_cc ==  5){
				menue_value = PitchbendPWR[5] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[5] = menue_value;}   
 			if(menue_cc ==  6){
				menue_value = PitchbendPWR[6] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[6] = menue_value;}   
 			if(menue_cc ==  7){
				menue_value = PitchbendPWR[7] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[7] = menue_value;} 
			if(menue_cc ==  8){
				menue_value = PitchbendPWR[8] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[8] = menue_value;}  
 			if(menue_cc ==  9){
				menue_value = PitchbendPWR[9] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[9] = menue_value;}   
 			if(menue_cc == 10){
				menue_value = PitchbendPWR[10] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[10] = menue_value;}   
 			if(menue_cc == 11){
				menue_value = PitchbendPWR[11] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[11] = menue_value;}   
 			if(menue_cc == 12){
				menue_value = PitchbendPWR[12] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[12] = menue_value;}   
 			if(menue_cc == 13){
				menue_value = PitchbendPWR[13] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[13] = menue_value;}   
 			if(menue_cc == 14){
				menue_value = PitchbendPWR[14] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[14] = menue_value;}   
 			if(menue_cc == 15){
				menue_value = PitchbendPWR[15] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				PitchbendPWR[15] = menue_value;} 
//LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            if(PitchbendPWR[0] == 0) {MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[0] == 1) {MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[1] == 0) {MIOS32_LCD_CursorSet(5,  0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[1] == 1) {MIOS32_LCD_CursorSet(5,  0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[2] == 0) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[2] == 1) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[3] == 0) {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[3] == 1) {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[4] == 0) {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[4] == 1) {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[5] == 0) {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[5] == 1) {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[6] == 0) {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[6] == 1) {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[7] == 0) {MIOS32_LCD_CursorSet(35, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[7] == 1) {MIOS32_LCD_CursorSet(35, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page-10);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "PBd1");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "PBd2");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd3");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd4");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd5");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd6");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd7");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd8");
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			

//LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            if(PitchbendPWR[8]  == 0) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[8]  == 1) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[9]  == 0) {MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[9]  == 1) {MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[10] == 0) {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[10] == 1) {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[11] == 0) {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[11] == 1) {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[12] == 0) {MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[12] == 1) {MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[13] == 0) {MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[13] == 1) {MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[14] == 0) {MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[14] == 1) {MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(PitchbendPWR[15] == 0) {MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(PitchbendPWR[15] == 1) {MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%s", "ON"); }
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "PBd9");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "PBd10");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd11");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd12");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd13");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd14");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd15");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "PBd16");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			
}

//MENU PAGE 12////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 12 &&  menue_cc < 16) || (LCD0Page == 12 && menue_cc == 126)) { //Pitchbend-Thru //CC-Thru
//PITCHBEND - THRU
			if(menue_cc == 0){
				menue_value = CCThruPort[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[0] = menue_value;}  
 			if(menue_cc == 1){
				menue_value = CCThruPort[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[1] = menue_value;}   
 			if(menue_cc == 2){
				menue_value = CCThruPort[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[2] = menue_value;}   
 			if(menue_cc == 3){
				menue_value = CCThruPort[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[3] = menue_value;}   
 			if(menue_cc == 4){
				menue_value = CCThruPort[4] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[4] = menue_value;}   
 			if(menue_cc == 5){
				menue_value = CCThruPort[5] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[5] = menue_value;}   
 			if(menue_cc == 6){
				menue_value = CCThruPort[6] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[6] = menue_value;}   
 			if(menue_cc == 7){
				menue_value = CCThruPort[7] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[7] = menue_value;} 
//LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            if(CCThruPort[0] == 0) {MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[0] == 1) {MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[1] == 0) {MIOS32_LCD_CursorSet(5,  0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[1] == 1) {MIOS32_LCD_CursorSet(5,  0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[2] == 0) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[2] == 1) {MIOS32_LCD_CursorSet(10, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[3] == 0) {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[3] == 1) {MIOS32_LCD_CursorSet(15, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[4] == 0) {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[4] == 1) {MIOS32_LCD_CursorSet(20, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[5] == 0) {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[5] == 1) {MIOS32_LCD_CursorSet(25, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[6] == 0) {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[6] == 1) {MIOS32_LCD_CursorSet(30, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[7] == 0) {MIOS32_LCD_CursorSet(35, 0); MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[7] == 1) {MIOS32_LCD_CursorSet(35, 0); MIOS32_LCD_PrintFormattedString("%s", "ON");}
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page-10);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "CCo1");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "CCo2");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo3");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo4");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo5");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo6");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo7");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo8");
          MUTEX_LCD_GIVE;				// release LCD access for other tasks  			

//CC-THRU-Ports
			if(menue_cc ==  8){
				menue_value = CCThruPort[8] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[8] = menue_value;}  
 			if(menue_cc ==  9){
				menue_value = CCThruPort[9] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[9] = menue_value;}   
 			if(menue_cc == 10){
				menue_value = CCThruPort[10] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[10] = menue_value;}   
 			if(menue_cc == 11){
				menue_value = CCThruPort[11] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[11] = menue_value;}   
 			if(menue_cc == 12){
				menue_value = CCThruPort[12] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[12] = menue_value;}   
 			if(menue_cc == 13){
				menue_value = CCThruPort[13] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[13] = menue_value;}   
 			if(menue_cc == 14){
				menue_value = CCThruPort[14] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[14] = menue_value;}   
 			if(menue_cc == 15){
				menue_value = CCThruPort[15] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				CCThruPort[15] = menue_value;} 
//LCD 1
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            if(CCThruPort[8]  == 0) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[8]  == 1) {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[9]  == 0) {MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[9]  == 1) {MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[10] == 0) {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[10] == 1) {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[11] == 0) {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[11] == 1) {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[12] == 0) {MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[12] == 1) {MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[13] == 0) {MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[13] == 1) {MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[14] == 0) {MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[14] == 1) {MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%s", "ON");}
            if(CCThruPort[15] == 0) {MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(CCThruPort[15] == 1) {MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%s", "ON"); }
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "CCo9");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "CCo10");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo11");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo12");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo13");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo14");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo15");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "CCo16");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks  			
}

//MENU PAGE 13////////////////////////////////////////////////////////////////////////////////////
  if( (LCD0Page == 13  &&  menue_cc < 16) || (LCD0Page == 13 && menue_cc == 126)) { //Clock & Transport Thru
			if(menue_cc == 0){
				menue_value = TrigMidiThruClock[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruClock[0] = menue_value;}  
 			if(menue_cc == 1){
				menue_value = TrigMidiThruClock[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruClock[1] = menue_value;}   
 			if(menue_cc == 2){
				menue_value = TrigMidiThruClock[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruClock[2] = menue_value;}   
 			if(menue_cc == 3){
				menue_value = TrigMidiThruClock[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruClock[3] = menue_value;}   
 			if(menue_cc == 4){
				menue_value = TrigMidiThruTransport[0] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruTransport[0] = menue_value;}   
 			if(menue_cc == 5){
				menue_value = TrigMidiThruTransport[1] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruTransport[1] = menue_value;}   
 			if(menue_cc == 6){
				menue_value = TrigMidiThruTransport[2] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruTransport[2] = menue_value;}   
 			if(menue_cc == 7){
				menue_value = TrigMidiThruTransport[3] + menue_incrementer;   
				if(menue_value < 0){menue_value = 0;}
				if(menue_value >= 1){menue_value = 1;}
				TrigMidiThruTransport[3] = menue_value;} 
//LCD 0
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
          //1st Line = Encoder Variables....change something!
            if(TrigMidiThruClock[0]  == 0)     {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruClock[0]  == 1)     {MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%s", "Thru");}
            if(TrigMidiThruClock[1]  == 0)     {MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruClock[1]  == 1)     {MIOS32_LCD_CursorSet(5,  0);MIOS32_LCD_PrintFormattedString("%s", "Thru");}
            if(TrigMidiThruClock[2] == 0)     {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruClock[2] == 1)     {MIOS32_LCD_CursorSet(10, 0);MIOS32_LCD_PrintFormattedString("%s", "Thru");}
            if(TrigMidiThruClock[3] == 0)     {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruClock[3] == 1)     {MIOS32_LCD_CursorSet(15, 0);MIOS32_LCD_PrintFormattedString("%s", "Thru");}
            if(TrigMidiThruTransport[0] == 0) {MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruTransport[0] == 1) {MIOS32_LCD_CursorSet(20, 0);MIOS32_LCD_PrintFormattedString("%s", "Thru");}
            if(TrigMidiThruTransport[1] == 0) {MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruTransport[1] == 1) {MIOS32_LCD_CursorSet(25, 0);MIOS32_LCD_PrintFormattedString("%s", "Thru");}
            if(TrigMidiThruTransport[2] == 0) {MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruTransport[2] == 1) {MIOS32_LCD_CursorSet(30, 0);MIOS32_LCD_PrintFormattedString("%s", "Thru");}
            if(TrigMidiThruTransport[3] == 0) {MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%s", "OFF");}
            if(TrigMidiThruTransport[3] == 1) {MIOS32_LCD_CursorSet(35, 0);MIOS32_LCD_PrintFormattedString("%s", "Thru"); }
            MIOS32_LCD_CursorSet(39, 0);MIOS32_LCD_PrintFormattedString("%d", LCD0Page-10);
          //2nd Line = Menue Describtion
            MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%s", "CKoA");
            MIOS32_LCD_CursorSet(5,  1);MIOS32_LCD_PrintFormattedString("%s", "CKoB");
            MIOS32_LCD_CursorSet(10, 1);MIOS32_LCD_PrintFormattedString("%s", "CKoC");
            MIOS32_LCD_CursorSet(15, 1);MIOS32_LCD_PrintFormattedString("%s", "CKoD");
            MIOS32_LCD_CursorSet(20, 1);MIOS32_LCD_PrintFormattedString("%s", "TrtA");
            MIOS32_LCD_CursorSet(25, 1);MIOS32_LCD_PrintFormattedString("%s", "TrtB");
            MIOS32_LCD_CursorSet(30, 1);MIOS32_LCD_PrintFormattedString("%s", "TrtC");
            MIOS32_LCD_CursorSet(35, 1);MIOS32_LCD_PrintFormattedString("%s", "TrtD");
          MUTEX_LCD_GIVE;					// release LCD access for other tasks 
          
//LCD 1  // JUST clear the Screen (place for more menues
         MUTEX_LCD_TAKE;        //request LCD aCCes0s
            MIOS32_LCD_DeviceSet  (1); //=1st 2x40 LCD-screen
            MIOS32_LCD_Clear(); //clear screen 
         MUTEX_LCD_GIVE;					// release LCD access for other tasks 
}
}//END TASK
	
void APP_Tick(void){ // called each mS from main task which also handles DIN, ENC and AIN events. You could add more jobs here - dont do more than 300uS!

if(SEQ_BPM_IsRunning()==0) {SongStep = 0;} //Reset Step Positon is in StopMode

if(StoreFlag == 1) {  StoreCount = StoreCount + 1; 
     if(StoreCount > 250){ StoreCount = 0; StoreFlag=0; StoreLoad(1, 2); MenueUpdateFlag=0;}} //the direct imideatly Btn Action from a BLMx dont react...so delay here.

if(LoadFlag == 1) {  LoadCount = LoadCount + 1; 
     if(LoadCount > 250){  LoadCount = 0;  LoadFlag=0;  StoreLoad(1, 1); MenueUpdateFlag=0;}} //the direct imideatly Btn Action from a BLMx dont react...so delay here.


	  SDCardCount = SDCardCount + 1; if(SDCardCount > 2000){SDCardCount = 0; StoreLoad(1, 3);} //2s Counter > send Check-SDCard-Commant to StoreLoad-Function
  if(MenueUpdateFlag==0){MenueUpdateCount = MenueUpdateCount + 1; 
     if(MenueUpdateCount > 250){MenueUpdateCount = 0; //update the Menue 0,15seconds after a message like "stored" (1.time!)
		                         MenueUpdateFlag=1; //deactivate Timer
		                         MENUE(126, 0);}} //Update LCD with the currently selected Menu}}

//Programchange Load when Stopped turning the Wheel (from External Source, internal we use a LOAD-Button for that)

  if(PCLoadFlag == 1){PCLoadFlagCount = PCLoadFlagCount + 1; 
     if(PCLoadFlagCount > 250)  {LoadFlag = 1; //start Load Counter
                                 PCLoadFlagCount = 0; //init counter for the next run
                                 PCLoadFlag = 0;}}  //Kill Flag to avoid double triggering events
	  
  u8 blm = 0; // currently only a single blm device is supported
  static blm_scalar_master_connection_state_t prev_connection_state = BLM_SCALAR_MASTER_CONNECTION_STATE_IDLE;
  blm_scalar_master_connection_state_t connection_state = BLM_SCALAR_MASTER_ConnectionStateGet(blm);

  // print message on connection change and turn on/off the status LED
  if( connection_state != prev_connection_state ) {
    prev_connection_state = connection_state;
    if( connection_state == BLM_SCALAR_MASTER_CONNECTION_STATE_IDLE ) {
      MUTEX_MIDIOUT_TAKE;
      MIOS32_MIDI_SendDebugMessage("BLM has been disconnected."); // will appear ca. 10 seconds after communication is broken
      MUTEX_MIDIOUT_GIVE;
    } else {
      MUTEX_MIDIOUT_TAKE;
      MIOS32_MIDI_SendDebugMessage("BLM has been connected."); // will appear ca. 5 seconds after BLM has been connected
      MIOS32_MIDI_SendDebugMessage("Reported grid layout: %dx%d with %d colours.", BLM_SCALAR_MASTER_NumColumnsGet(blm), BLM_SCALAR_MASTER_NumRowsGet(blm), BLM_SCALAR_MASTER_NumColoursGet(blm));
      APP_BLM_ButtonCallback(10, 10, 17, 17, 0); //Send a Layout-Dumpout
      MUTEX_MIDIOUT_GIVE;
    }
  }

  //Sequencer Stuff
  MIOS32_BOARD_LED_Set(1, SEQ_BPM_IsRunning() ? 1 : 0);    // set LED depending on sequencer run state
}

void APP_MIDI_Tick(void){} //@1mS rate, dont do more then 300uS!

void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){

  //MIOS32_LCD_CursorSet(0, 0);  MIOS32_LCD_PrintFormattedString("%d %d %d %d", port, midi_package.chn, midi_package.note, midi_package.velocity);

  //Forward MidiRemote
  if(port==RemotePort && (midi_package.chn == 14 || midi_package.chn == 15)) {Router(3, midi_package.chn, midi_package.note, midi_package.velocity);}

  if(port==ClockPortIN){ //Forward Clock and Transport
    if(TrigMidiThruClock[0]==1 && TrigMidiThruTransport[0]==1 && (midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//248CLK,250Strt,251Cont,252Stp
      {MIOS32_MIDI_SendPackage(32,  midi_package);}//forwarding Midiclock & Transport only
    if(TrigMidiThruClock[0]==0 && TrigMidiThruTransport[0]==1 && (midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//NO CLOCK but Start&Stop >> use synths internal clock..
      {MIOS32_MIDI_SendPackage(32,  midi_package);}//forwarding Transport Only 
    if(TrigMidiThruClock[1]==1 && TrigMidiThruTransport[1]==1 && (midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//248CLK,250Strt,251Cont,252Stp
      {MIOS32_MIDI_SendPackage(33,  midi_package);}//forwarding Midiclock & Transport only
    if(TrigMidiThruClock[1]==0 && TrigMidiThruTransport[1]==1 && (midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//NO CLOCK but Start&Stop >> use synths internal clock..
      {MIOS32_MIDI_SendPackage(33,  midi_package);}//forwarding Transport Only  
    if(TrigMidiThruClock[2]==1 && TrigMidiThruTransport[2]==1 && (midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//248CLK,250Strt,251Cont,252Stp
      {MIOS32_MIDI_SendPackage(34,  midi_package);}//forwarding Midiclock & Transport only
    if(TrigMidiThruClock[2]==0 && TrigMidiThruTransport[2]==1 && (midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//NO CLOCK but Start&Stop >> use synths internal clock..
      {MIOS32_MIDI_SendPackage(34,  midi_package);}//forwarding Transport Only 
    if(TrigMidiThruClock[3]==1 && TrigMidiThruTransport[3]==1 && (midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//248CLK,250Strt,251Cont,252Stp
      {MIOS32_MIDI_SendPackage(35,  midi_package);}//forwarding Midiclock & Transport only
    if(TrigMidiThruClock[3]==0 && TrigMidiThruTransport[3]==1 && (midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//NO CLOCK but Start&Stop >> use synths internal clock..
      {MIOS32_MIDI_SendPackage(35,  midi_package);}//forwarding Transport Only   
   }

if(midi_package.evnt0 != 248 && midi_package.evnt0 != 187){//avoid that Midiclock DataMess
  //Receive ProgramChange Information
  if(port == PCPortIN && PCReceive == 1) {
    //Set MidiChannel && Programchange-Channel     set Song Nr with Programchange Nr  show Page PC  setLoadProgram     LOAD command   
    if(PCChIN == 0  && midi_package.evnt0 == 192) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;}
    if(PCChIN == 1  && midi_package.evnt0 == 193) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 2  && midi_package.evnt0 == 194) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;}
    if(PCChIN == 3  && midi_package.evnt0 == 195) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 4  && midi_package.evnt0 == 196) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;}
    if(PCChIN == 5  && midi_package.evnt0 == 197) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 6  && midi_package.evnt0 == 198) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 7  && midi_package.evnt0 == 199) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 8  && midi_package.evnt0 == 200) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 9  && midi_package.evnt0 == 201) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 10 && midi_package.evnt0 == 202) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 11 && midi_package.evnt0 == 203) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 12 && midi_package.evnt0 == 204) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 13 && midi_package.evnt0 == 205) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 14 && midi_package.evnt0 == 206) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;} 
    if(PCChIN == 15 && midi_package.evnt0 == 207) {SongNrLoad = midi_package.evnt1; LCD0Page = 0; MENUE(0, 0); PCLoadFlag = 1;}


//MIOS32_LCD_Clear(); //clear screen 
//MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d %d %d", midi_package.evnt0, midi_package.evnt1, midi_package.evnt2);
//MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%d %d", SongNrLoad, PCPortIN);

}
 //Forward Drum-Trigger
  if((port==TrigPortIN) && (midi_package.chn == TrigInCh) && (midi_package.type==NoteOn && midi_package.velocity > 0)  ){
      //Set  Trigger Indicate LED Color (velocity depending)
      int Color = 1;
      if(midi_package.velocity<=44)                                 {Color = 1;}
      if(midi_package.velocity >=44 && midi_package.velocity <= 89) {Color = 2;}
      if(midi_package.velocity >=90)                                {Color = 3;}

	
//give TriggerInput Notes the new numbers 0-15, and forward them to the Trigger Matrix.
if(midi_package.note == TrigInNote[0])   {APP_NOTEPROCESS(1, 0,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 0,  Color);}} //Activate Trigger LED 0
	  
if(midi_package.note == TrigInNote[1])   {APP_NOTEPROCESS(1, 1,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 1,  Color);}} //Activate Trigger LED 0
                                           	
if(midi_package.note == TrigInNote[2])   {APP_NOTEPROCESS(1, 2,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 2,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[3])   {APP_NOTEPROCESS(1, 3,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 3,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[4])   {APP_NOTEPROCESS(1, 4,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 4,  Color);}} //Activate Trigger LED 0
                                           			  
if(midi_package.note == TrigInNote[5])   {APP_NOTEPROCESS(1, 5,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 5,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[6])   {APP_NOTEPROCESS(1, 6,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 6,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[7])   {APP_NOTEPROCESS(1, 7,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 7,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[8])   {APP_NOTEPROCESS(1, 8,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 8,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[9])   {APP_NOTEPROCESS(1, 9,  midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 9,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[10])  {APP_NOTEPROCESS(1, 10, midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 10,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[11])  {APP_NOTEPROCESS(1, 11, midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 11,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[12])  {APP_NOTEPROCESS(1, 12, midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 12,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[13])  {APP_NOTEPROCESS(1, 13, midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 13,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[14])  {APP_NOTEPROCESS(1, 14, midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 14,  Color);}} //Activate Trigger LED 0
                                           		
if(midi_package.note == TrigInNote[15])  {APP_NOTEPROCESS(1, 15, midi_package.velocity, 0, 999); //port, note, velocity, step, tic
  if((MatrixUse == 2) || (MatrixUse==3)) { DrumDecayTimer[16]=70; //Deactivate Trigger LED after 70milli Seconds
                                           BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, 15,  Color);}} //Activate Trigger LED 0
}

  if(port== BLMport) {BLM_SCALAR_MASTER_MIDI_Receive(port, midi_package);} // forward to BLM master

  //ReRoute PitchBend, CC & NOTE Inputs          
  if(port==MelPortIn || port==MelPortIn2){//MELODY-INPUT-BUFFER////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
      //MIOS32_LCD_Clear(); //clear screen 
      //MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d %d %d %d", midi_package.evnt0, midi_package.chn, pitchbend[1], CCMtx[0][1][0]);
     // MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d %d %d", midi_package.evnt0, midi_package.evnt1, midi_package.evnt2);
      //MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%d %d", SongNrLoad, PCPortIN);

      //Pitchbend s16bit Value Calculation
      u8 channel = 0;
      if(midi_package.evnt0 >= 224 && midi_package.evnt0 <= 239){channel = midi_package.evnt0 - 224; //Offset to MidiChannel 0-15
      u16 msb = midi_package.evnt2 << 7;
      pitchbend[channel] = midi_package.evnt1 + msb;}

    //Melody-Buffer [0]
      if(CCMtx[0][6][0] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][0]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER0(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER0(1, midi_package.note);}
                  if(PitchbendPWR[0]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[0], pitchbend[0]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[0] == 1 && midi_package.evnt0 == 176) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[0], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][0]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER0(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER0(1, midi_package.note);}
                  if(PitchbendPWR[0]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[0], pitchbend[1]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[0] == 1 && midi_package.evnt0 == 177) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[0], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][0]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER0(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER0(1, midi_package.note);}
                  if(PitchbendPWR[0]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[0], pitchbend[2]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[0] == 1 && midi_package.evnt0 == 178) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[0], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][0]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER0(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER0(1, midi_package.note);}
                  if(PitchbendPWR[0]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[0], pitchbend[3]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[0] == 1 && midi_package.evnt0 == 179) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[0], midi_package.evnt1, midi_package.evnt2);}}


               if((midi_package.chn==4) && (CCMtx[0][4][0]==1)){  //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER0(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER0(1, midi_package.note);}
                  if(PitchbendPWR[0]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[0], pitchbend[4]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[0] == 1 && midi_package.evnt0 == 180) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[0], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][0]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER0(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER0(1, midi_package.note);}
                  if(PitchbendPWR[0]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[0], pitchbend[5]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[0] == 1 && midi_package.evnt0 == 181) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[0], midi_package.evnt1, midi_package.evnt2);}}
                          }}

      //Melody-Buffer [1]
      if(CCMtx[0][6][1] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER1(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER1(1, midi_package.note);}
                  if(PitchbendPWR[1]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[1], pitchbend[0]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[1] == 1 && midi_package.evnt0 == 176) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[1], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER1(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER1(1, midi_package.note);}
                  if(PitchbendPWR[1]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[1], pitchbend[1]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[1] == 1 && midi_package.evnt0 == 177) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[1], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER1(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER1(1, midi_package.note);}
                  if(PitchbendPWR[1]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[1], pitchbend[2]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[1] == 1 && midi_package.evnt0 == 178) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[1], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER1(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER1(1, midi_package.note);}
                  if(PitchbendPWR[1]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[1], pitchbend[3]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[1] == 1 && midi_package.evnt0 == 179) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[1], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER1(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER1(1, midi_package.note);}
                  if(PitchbendPWR[1]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[1], pitchbend[4]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[1] == 1 && midi_package.evnt0 == 180) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[1], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER1(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER1(1, midi_package.note);}
                  if(PitchbendPWR[1]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[1], pitchbend[5]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[1] == 1 && midi_package.evnt0 == 181) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[1], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [2]
      if(CCMtx[0][6][2] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][2]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER2(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER2(1, midi_package.note);}
                  if(PitchbendPWR[2]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[2], pitchbend[0]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[2] == 1 && midi_package.evnt0 == 176) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[2], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][2]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER2(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER2(1, midi_package.note);}
                  if(PitchbendPWR[2]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[2], pitchbend[1]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[2] == 1 && midi_package.evnt0 == 177) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[2], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][2]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER2(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER2(1, midi_package.note);}
                  if(PitchbendPWR[2]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[2], pitchbend[2]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[2] == 1 && midi_package.evnt0 == 178) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[2], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][2]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER2(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER2(1, midi_package.note);}
                  if(PitchbendPWR[2]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[2], pitchbend[3]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[2] == 1 && midi_package.evnt0 == 179) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[2], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][2]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER2(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER2(1, midi_package.note);}
                  if(PitchbendPWR[2]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[2], pitchbend[4]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[2] == 1 && midi_package.evnt0 == 180) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[2], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][2]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER2(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER2(1, midi_package.note);}
                  if(PitchbendPWR[2]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[2], pitchbend[5]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[2] == 1 && midi_package.evnt0 == 181) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[2], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [3]
      if(CCMtx[0][6][3] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][3]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER3(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER3(1, midi_package.note);}
                  if(PitchbendPWR[3]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[3], pitchbend[0]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[3] == 1 && midi_package.evnt0 == 176) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[3], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][3]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER3(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER3(1, midi_package.note);}
                  if(PitchbendPWR[3]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[3], pitchbend[1]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[3] == 1 && midi_package.evnt0 == 177) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[3], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][3]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER3(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER3(1, midi_package.note);}
                  if(PitchbendPWR[3]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[3], pitchbend[2]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[3] == 1 && midi_package.evnt0 == 178) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[3], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][3]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER3(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER3(1, midi_package.note);}
                  if(PitchbendPWR[3]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[3], pitchbend[3]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[3] == 1 && midi_package.evnt0 == 179) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[3], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][3]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER3(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER3(1, midi_package.note);}
                  if(PitchbendPWR[3]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[3], pitchbend[4]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[3] == 1 && midi_package.evnt0 == 180) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[3], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][3]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER3(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER3(1, midi_package.note);}
                  if(PitchbendPWR[3]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[3], pitchbend[5]);} // SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[3] == 1 && midi_package.evnt0 == 181) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[3], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [4]
      if(CCMtx[0][6][4] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][4]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER4(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER4(1, midi_package.note);}
                  if(PitchbendPWR[4]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[4], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[4] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[4], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][4]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER4(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER4(1, midi_package.note);}
                  if(PitchbendPWR[4]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[4], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[4] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[4], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][4]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER4(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER4(1, midi_package.note);}
                  if(PitchbendPWR[4]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[4], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[4] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[4], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][4]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER4(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER4(1, midi_package.note);}
                  if(PitchbendPWR[4]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[4], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[4] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[4], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][4]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER4(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER4(1, midi_package.note);}
                  if(PitchbendPWR[4]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[4], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[4] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[4], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][4]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER4(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER4(1, midi_package.note);}
                  if(PitchbendPWR[4]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[4], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[4] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[4], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [5]
      if(CCMtx[0][6][5] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][5]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER5(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER5(1, midi_package.note);}
                  if(PitchbendPWR[5]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[5], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[5] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[5], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][5]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER5(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER5(1, midi_package.note);}
                  if(PitchbendPWR[5]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[5], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[5] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[5], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][5]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER5(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER5(1, midi_package.note);}
                  if(PitchbendPWR[5]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[5], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[5] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[5], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][5]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER5(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER5(1, midi_package.note);}
                  if(PitchbendPWR[5]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[5], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[5] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[5], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][5]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER5(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER5(1, midi_package.note);}
                  if(PitchbendPWR[5]==180) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[5], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[5] == 1 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[5], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][5]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER5(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER5(1, midi_package.note);}
                  if(PitchbendPWR[5]==181) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[5], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[5] == 1 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[5], midi_package.evnt1, midi_package.evnt2);}}

                          }}          

      //Melody-Buffer [6]
      if(CCMtx[0][6][6] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][6]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER6(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER6(1, midi_package.note);}
                  if(PitchbendPWR[6]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[6], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[6] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[6], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][6]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER6(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER6(1, midi_package.note);}
                  if(PitchbendPWR[6]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[6], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[6] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[6], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][6]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER6(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER6(1, midi_package.note);}
                  if(PitchbendPWR[6]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[6], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[6] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[6], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][6]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER6(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER6(1, midi_package.note);}
                  if(PitchbendPWR[6]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[6], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[6] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[6], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][6]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER6(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER6(1, midi_package.note);}
                  if(PitchbendPWR[6]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[6], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[6] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[6], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][6]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER6(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER6(1, midi_package.note);}
                  if(PitchbendPWR[6]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[6], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[6] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[6], midi_package.evnt1, midi_package.evnt2);}}

                          }}      //Melody-Buffer [4]

      //Melody-Buffer [7]
      if(CCMtx[0][6][7] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][7]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER7(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER7(1, midi_package.note);}
                  if(PitchbendPWR[7]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[7], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[7] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[7], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][7]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER7(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER7(1, midi_package.note);}
                  if(PitchbendPWR[7]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[7], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[7] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[7], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][7]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER7(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER7(1, midi_package.note);}
                  if(PitchbendPWR[7]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[7], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[7] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[7], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][7]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER7(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER7(1, midi_package.note);}
                  if(PitchbendPWR[7]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[7], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[7] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[7], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][7]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER7(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER7(1, midi_package.note);}
                  if(PitchbendPWR[7]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[7], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[7] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[7], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][7]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER7(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER7(1, midi_package.note);}
                  if(PitchbendPWR[7]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[7], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[7] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[7], midi_package.evnt1, midi_package.evnt2);}}

                          }}      //Melody-Buffer [4]

      //Melody-Buffer [8]
      if(CCMtx[0][6][8] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][8]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER8(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER8(1, midi_package.note);}
                  if(PitchbendPWR[8]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[8], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[8] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[8], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][8]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER8(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER8(1, midi_package.note);}
                  if(PitchbendPWR[8]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[8], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[8] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[8], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][8]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER8(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER8(1, midi_package.note);}
                  if(PitchbendPWR[8]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[8], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[8] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[8], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][8]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER8(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER8(1, midi_package.note);}
                  if(PitchbendPWR[8]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[8], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[8] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[8], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][8]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER8(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER8(1, midi_package.note);}
                  if(PitchbendPWR[8]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[8], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[8] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[8], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][8]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER8(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER8(1, midi_package.note);}
                  if(PitchbendPWR[8]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[8], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[8] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[8], midi_package.evnt1, midi_package.evnt2);}}

                          }}      //Melody-Buffer [4]

      //Melody-Buffer [9]
      if(CCMtx[0][6][9] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][9]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER9(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER9(1, midi_package.note);}
                  if(PitchbendPWR[9]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[9], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[9] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[9], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][9]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER9(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER9(1, midi_package.note);}
                  if(PitchbendPWR[9]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[9], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[9] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[9], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][9]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER9(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER9(1, midi_package.note);}
                  if(PitchbendPWR[9]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[9], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[9] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[9], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][9]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER9(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER9(1, midi_package.note);}
                  if(PitchbendPWR[9]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[9], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[9] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[9], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][9]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER9(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER9(1, midi_package.note);}
                  if(PitchbendPWR[9]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[9], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[9] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[9], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][9]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER9(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER9(1, midi_package.note);}
                  if(PitchbendPWR[9]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[9], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[9] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[9], midi_package.evnt1, midi_package.evnt2);}}

                          }}      //Melody-Buffer [4]

      //Melody-Buffer [10]
      if(CCMtx[0][6][10] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][10]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER10(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER10(1, midi_package.note);}
                  if(PitchbendPWR[10]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[10], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[10] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[10], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][10]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER10(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER10(1, midi_package.note);}
                  if(PitchbendPWR[10]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[10], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[10] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[10], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][10]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER10(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER10(1, midi_package.note);}
                  if(PitchbendPWR[10]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[10], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[10] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[10], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][10]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER10(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER10(1, midi_package.note);}
                  if(PitchbendPWR[10]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[10], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[10] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[10], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][10]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER10(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER10(1, midi_package.note);}
                  if(PitchbendPWR[10]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[10], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[10] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[10], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][10]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER10(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER10(1, midi_package.note);}
                  if(PitchbendPWR[10]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[10], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[10] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[10], midi_package.evnt1, midi_package.evnt2);}}

                          }}
                          
      //Melody-Buffer [11]
      if(CCMtx[0][6][11] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][11]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER11(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER11(1, midi_package.note);}
                  if(PitchbendPWR[11]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[11], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[11] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[11], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][11]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER11(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER11(1, midi_package.note);}
                  if(PitchbendPWR[11]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[11], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[11] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[11], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][11]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER11(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER11(1, midi_package.note);}
                  if(PitchbendPWR[11]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[11], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[11] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[11], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][11]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER11(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER11(1, midi_package.note);}
                  if(PitchbendPWR[11]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[11], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[11] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[11], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][11]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER11(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER11(1, midi_package.note);}
                  if(PitchbendPWR[11]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[11], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[11] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[11], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][11]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER11(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER11(1, midi_package.note);}
                  if(PitchbendPWR[11]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[11], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[11] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[11], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [12]
      if(CCMtx[0][6][12] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][12]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER12(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER12(1, midi_package.note);}
                  if(PitchbendPWR[12]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[12], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[12] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[12], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][12]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER12(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER12(1, midi_package.note);}
                  if(PitchbendPWR[12]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[12], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[12] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[12], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][12]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER12(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER12(1, midi_package.note);}
                  if(PitchbendPWR[12]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[12], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[12] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[12], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][12]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER12(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER12(1, midi_package.note);}
                  if(PitchbendPWR[12]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[12], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[12] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[12], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][12]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER12(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER12(1, midi_package.note);}
                  if(PitchbendPWR[12]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[12], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[12] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[12], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][12]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER12(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER12(1, midi_package.note);}
                  if(PitchbendPWR[12]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[12], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[12] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[12], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [13]
      if(CCMtx[0][6][13] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][13]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER13(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER13(1, midi_package.note);}
                  if(PitchbendPWR[13]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[13], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[13] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[13], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][13]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER13(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER13(1, midi_package.note);}
                  if(PitchbendPWR[13]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[13], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[13] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[13], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][13]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER13(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER13(1, midi_package.note);}
                  if(PitchbendPWR[13]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[13], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[13] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[13], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][13]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER13(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER13(1, midi_package.note);}
                  if(PitchbendPWR[13]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[13], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[13] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[13], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][13]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER13(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER13(1, midi_package.note);}
                  if(PitchbendPWR[13]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[13], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[13] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[13], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][13]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER13(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER13(1, midi_package.note);}
                  if(PitchbendPWR[13]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[13], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[13] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[13], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [14]
      if(CCMtx[0][6][14] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][14]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER14(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER14(1, midi_package.note);}
                  if(PitchbendPWR[14]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[14], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[14] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[14], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][14]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER14(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER14(1, midi_package.note);}
                  if(PitchbendPWR[14]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[14], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[14] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[14], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][14]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER14(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER14(1, midi_package.note);}
                  if(PitchbendPWR[14]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[14], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[14] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[14], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][14]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER14(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER14(1, midi_package.note);}
                  if(PitchbendPWR[14]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[14], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[14] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[14], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][14]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER14(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER14(1, midi_package.note);}
                  if(PitchbendPWR[14]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[14], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[14] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[14], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][14]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER14(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER14(1, midi_package.note);}
                  if(PitchbendPWR[14]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[14], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[14] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[14], midi_package.evnt1, midi_package.evnt2);}}

                          }}

      //Melody-Buffer [15]
      if(CCMtx[0][6][15] == 0) { // MATRIX = Melody HOLD or "Mute Melody Input"
            if(port==MelPortIn || port==MelPortIn2)  {         //right Midi-Port?
               if((midi_package.chn==0) && (CCMtx[0][0][15]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER15(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER15(1, midi_package.note);}
                  if(PitchbendPWR[15]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[15], pitchbend[0]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[15] == 176 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[15], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==1) && (CCMtx[0][1][15]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER15(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER15(1, midi_package.note);}
                  if(PitchbendPWR[15]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[15], pitchbend[1]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[15] == 177 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[15], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==2) && (CCMtx[0][2][15]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER15(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER15(1, midi_package.note);}
                  if(PitchbendPWR[15]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[15], pitchbend[2]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[15] == 178 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[15], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==3) && (CCMtx[0][3][15]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER15(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER15(1, midi_package.note);}
                  if(PitchbendPWR[15]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[15], pitchbend[3]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[15] == 179 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[15], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==4) && (CCMtx[0][4][15]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER15(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER15(1, midi_package.note);}
                  if(PitchbendPWR[15]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[15], pitchbend[4]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[15] == 180 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[15], midi_package.evnt1, midi_package.evnt2);}}

               if((midi_package.chn==5) && (CCMtx[0][5][15]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
                  if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER15(0, midi_package.note);}
                  if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER15(1, midi_package.note);}
                  if(PitchbendPWR[15]==1) {MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[15], pitchbend[5]);} //SEND Pitchbend(port,chn, u16 val)
                  //ReRoute ControlChange
                  if(CCThruPort[15] == 181 && midi_package.evnt0 == 1) {MIOS32_MIDI_SendCC(MelPortOut, MeloOutCh[15], midi_package.evnt1, midi_package.evnt2);}}

                          }}

} //END MELODY-INPUT-BUFFER//////////////////////////////////////////////////////////////////////////////////////////         
} //END MidiClock-Filter
}

static s32 APP_SYSEX_Parser(mios32_midi_port_t port, u8 midi_in) { // parses an incoming sysex stream for MIOS32 commands
  BLM_SCALAR_MASTER_SYSEX_Parser(port, midi_in); // forward SysEx to BLM MASTER
  return 0; // no error
}

static s32 APP_MIDI_TimeOut(mios32_midi_port_t port) { // parse incoming sysex stream for MIOS32 commands
  BLM_SCALAR_MASTER_MIDI_TimeOut(port);   // forward timeout to BLM MASTER
  return 0; // no error
}

//called when a BLM button has been pressed/depressed   /// FUNCTION 4 the MAIN BLM-UI
s32 APP_BLM_ButtonCallback(u8 blm, blm_scalar_master_element_t element_id, u8 button_x, u8 button_y, u8 button_depressed){//& whole BLM UI //Bevore was static

  if(element_id == 6) {BLM_X_LEDColorSet(1,0);} //Turn OFF Beat LED... is activated on different other places...

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//SEQUENCER MODE/////////////////////////////////////////////////////////////////////////////////////////////////////////
  if(MatrixUse == 0){

   //SHIFT
   if(element_id == 3 && button_depressed == 1) {//3=Shift Btn //used to switch to SeqTic Offset View
     SeqTicView =! SeqTicView;
     //BLM LED switch
     BLM_SCALAR_MASTER_LED_Set(ID, 3, 0, 0, SeqTicView);}

   //16TH Step View
   if(SeqTicView == 0) {

      //MATRIX-BUTTONS - SET Step-Velocitys
      if(element_id == 0 && button_depressed == 0){ //Element_id0=MATRIX, depressed0 mean button is pressed!
        //check if the pressed button correspond with a Step that is switched off, then overwrite with a given Velocity
        if(button_x < StepPerPage) {//deactivate Programming the next page...
        if(Seq[button_y][button_x+(Page*(StepPerPage))] >= 1)  {Seq[button_y][button_x+(Page*(StepPerPage))] = 0;}
                                    else    {StepVelo=VelSelValue[VelSel]; //new Velocity:1 off 3 values, choosen from 3 Btns, and set via 3 Rotarys
										     Seq[button_y][button_x+(Page*(StepPerPage))] = StepVelo;}}} //write Velocity into Matrix
      //focus Track
      if(element_id == 2) {focusMatrixUse[0] = button_y; }
      if((element_id == 2) || (element_id == 5 && button_x == 0));{ //Dump Out Focus LED to BLM .... element_id 5 x0 mean: DumpOutCall from extern.
        int y; for(y=0; y<16; y++) { BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, y, 0);} //clear all extry-y LEDs      //(blm, element, x, y, color);
                                    BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, focusMatrixUse[0], 3);}   //set the Focused-Track-LED  
								     
      //Set Loop Length
      if(element_id == 1){//X-Buttons
        if(button_depressed ==0 && LoopSetCount ==1) {if(button_x < btn) {PageFirst = button_x; PageLast = button_x;}
		                                              if(button_x > btn) {PageFirst = btn; PageLast = button_x;}} //2.while holding 1. pressing 2. set Loop Point
        if(button_depressed ==0 && LoopSetCount ==0) {LoopSetCount = LoopSetCount+1;      //1. Show selected Page on BLM, set a memory Start Page "btn"
           Page = button_x; btn = button_x;}	//show selected Page on the BLM, memory button_x for 2.
        if(button_depressed == 1){LoopSetCount = 0; //Clear Counter - its all done
		    SEQ_Loop();//Send update CALL to seq.c > s32 SEQ_Loop - go make new loop length, and just do it...
            SyncFlag = 1;}   //see "seq.c." Call BPM counter that something has to be change
          //turn off All Buttons
         int x; for(x=0; x<16; x++) { BLM_SCALAR_MASTER_LED_Set(ID, 1, x, 0, 0);}
          BLM_SCALAR_MASTER_LED_Set(ID, 1, PageFirst, 0, 1); //PAGE Start
          BLM_SCALAR_MASTER_LED_Set(ID, 1, PageLast,  0, 1);} //PAGE END
        
    //SET Loop Point: press and hold first btn, press 2nd BTN, release booth.
    //is 2nd BTN greater then 1st.BTN, then LoopEndPoint will be 2ndBTN,
    //is 2nd BTN smaller then 1st.BTN then you loop only the 1stPage.
    }


   //VIEW:  Step-TIC-OFfset
   if(SeqTicView == 1) {

      //Focus 16th Step
      if(element_id == 1 && button_depressed == 0) {//X-Buttons
          SeqFocusStep = button_x + (Page*StepPerPage);  //Focused Step = X-Button + Page-Offset e.g:. 18 = 2 + (1*16)
          //Clear BLM X-Buttons
          int x;  for(x=0; x<16; x++)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, x, 0, 0);}  //+0Tics = No Delay = no Offset
          //Set Focus-LED on BLM
          BLM_SCALAR_MASTER_LED_Set(ID, 1, button_x, 0, 2);}

      //Set TIC-Offset for Each Track & Step
      if(element_id == 0 && button_depressed == 0){ //Element_id0=MATRIX Buttons
        SeqTic[button_y][SeqFocusStep] = button_x * (Tic/64);} // TicOffset = 6*(384/64=6) = 36tics (when button_x =6)

       //Clear BLM
        int y;  for(y=0; y<16; y++)  {
        int x;  for(x=0; x<16; x++)  { BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y, 0);}}

      //focus Track
      if(element_id == 2) {focusMatrixUse[0] = button_y; }
      if((element_id == 2) || (element_id == 5 && button_x == 0));{ //Dump Out Focus LED to BLM .... element_id 5 x0 mean: DumpOutCall from extern.
        int y; for(y=0; y<16; y++) { BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, y, 0);} //clear all extry-y LEDs      //(blm, element, x, y, color);
                                    BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, focusMatrixUse[0], 3);}   //set the Focused-Track-LED  
}

    //STEP-LIGHT///X...X...X...X...X...X...X...O...X...   
    if(element_id == 6) {//6: StepLight, we show the StepIndicator+Page+LoopStartStop on the Extra X Buttons
      int step = button_x; //rename button_x to step...to easyer understanding
		
      //turn off All Buttons
      int x; for(x=0; x<16; x++) { BLM_SCALAR_MASTER_LED_Set(ID, 1, x, 0, 0);}

      if(SeqTicView == 0) {//StepSequencerMode 
        //Turn on Page-Start & PageLast >> Loop Cycle
        BLM_SCALAR_MASTER_LED_Set(ID, 1, PageFirst, 0, 1);
        BLM_SCALAR_MASTER_LED_Set(ID, 1, PageLast,  0, 1);         
	    if(step >= 0             && step < StepPerPage)    {BLM_SCALAR_MASTER_LED_Set(ID, 1, step, 0, 3); //Set Step LED
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 0,    0, 2); //PAGE Indicator
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);} //Viewed Page                                                                   
	    if(step > StepPerPage    && step < StepPerPage*2)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage),    0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 1,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*2  && step <= StepPerPage*3)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, ((step-StepPerPage*2)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 2,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*3  && step <= StepPerPage*4)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*3)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 3,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}   
	    if(step > StepPerPage*4  && step <= StepPerPage*5)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*4)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 4,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*5  && step <= StepPerPage*6)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*5)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 5,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*6  && step <= StepPerPage*7)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*6)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 6,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}   
	    if(step > StepPerPage*7  && step <= StepPerPage*8)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*7)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 7,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*8  && step <= StepPerPage*9)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*8)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 8,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}   
	    if(step > StepPerPage*9  && step <= StepPerPage*10) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*9)-1),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 9,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*10 && step <= StepPerPage*11) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*10)-1), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 10,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*11 && step < StepPerPage*12) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*11)-1), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 11,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*12 && step <= StepPerPage*13) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*12)-1), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 12,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*13 && step <= StepPerPage*14) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*13)-1), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 13,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*14 && step <= StepPerPage*15) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*14)-1), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 14,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	    if(step > StepPerPage*15 && step <= StepPerPage*16) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-(StepPerPage*15)-1), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 15,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}
        }

      if(SeqTicView == 1) {//TIC-OFFSET-Mode
        //Turn on Focused Step
        BLM_SCALAR_MASTER_LED_Set(ID, 1,  (SeqFocusStep-(16*Page)), 0, 1);
        //Set Step-Seqeuncer Running LED
	    if(step >= 0             && step < StepPerPage)    {BLM_SCALAR_MASTER_LED_Set(ID, 1, step, 0, 3);} //Set Step LED 
	    if(step > StepPerPage    && step < StepPerPage*2)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage),0, 3);}  
	    if(step > StepPerPage*2  && step < StepPerPage*3)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*2),  0, 3);}  
	    if(step > StepPerPage*3  && step < StepPerPage*4)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*3),  0, 3);}   
	    if(step > StepPerPage*4  && step < StepPerPage*5)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*4),  0, 3);}  
	    if(step > StepPerPage*5  && step < StepPerPage*6)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*5),  0, 3);}  
	    if(step > StepPerPage*6  && step < StepPerPage*7)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*6),  0, 3);}   
	    if(step > StepPerPage*7  && step < StepPerPage*8)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*7),  0, 3);}  
	    if(step > StepPerPage*8  && step < StepPerPage*9)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*8),  0, 3);}   
	    if(step > StepPerPage*9  && step < StepPerPage*10) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*9),  0, 3);}  
	    if(step > StepPerPage*10 && step < StepPerPage*11) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*10), 0, 3);}  
	    if(step > StepPerPage*11 && step < StepPerPage*12) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*11), 0, 3);}  
	    if(step > StepPerPage*12 && step < StepPerPage*13) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*12), 0, 3);}  
	    if(step > StepPerPage*13 && step < StepPerPage*14) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*13), 0, 3);}  
	    if(step > StepPerPage*14 && step < StepPerPage*15) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*14), 0, 3);}  
	    if(step > StepPerPage*15 && step < StepPerPage*16) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (step-StepPerPage*15), 0, 3);}
    }
 }                              
    //Load STEP-Matrix in to BLM-LED-Matrix                                
  if((element_id == 0 && button_depressed == 0) || (element_id == 5 && button_x == 0));{
      if(SeqTicView == 0) {//StepSequencerMode 
    //Set Color      //But before we have to change the Color Pattern...
    int y; 
    int x;                      
    for(y=0; y<16; y++)    {
     for(x=0; x<StepPerPage; x++)    {                                  
      if( Seq[y][x+(Page*(StepPerPage))] ==0)  {BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y, 0);}   //(blm, element, x, y, off);
      if( Seq[y][x+(Page*(StepPerPage))] > 0
       && Seq[y][x+(Page*(StepPerPage))] <= 44) {BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y, 1);}   //(blm, element, x, y, blue);
      if( Seq[y][x+(Page*(StepPerPage))] >= 45
       && Seq[y][x+(Page*(StepPerPage))] <= 89) {BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y, 2);}   //(blm, element, x, y, green);
      if( Seq[y][x+(Page*(StepPerPage))] >= 90) {BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y, 3);}}} //(blm, element, x, y, cyan);

    //Blank out unused LEDs (when not using all 16...)
    if(StepPerPage != 16) {
    y=0; x=0;   
    int s = 16 - StepPerPage;
    for(y=0; y<16; y++)    {
     for(x=0; x<s; x++)    { if(x < 16) {BLM_SCALAR_MASTER_LED_Set(ID, 0, x+StepPerPage, y, 1);}}}}   //(blm, element, x, y, blue);
    }

      if(SeqTicView == 1) {//StepSequencerMode 
//Update BLM (show Tic-Offset)
 
        int colorO = 0; int y;  for(y=0; y<16; y++)  {
          if(Seq[y][SeqFocusStep] > 0) { colorO = 2;}
                                  else { colorO = 0;}
          if(SeqTic[y][SeqFocusStep] == 0)        {BLM_SCALAR_MASTER_LED_Set(ID, 0, 0, y, colorO);}  //+0Tics = No Delay = no Offset
          if(SeqTic[y][SeqFocusStep] >= Tic/64)   {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO );}  //+6Tics = Delay
          if(SeqTic[y][SeqFocusStep] >= Tic/64*2) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO ); //6*2=12Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO );}
          if(SeqTic[y][SeqFocusStep] >= Tic/64*3) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO ); //6*3=18Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO );
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO );}
          if(SeqTic[y][SeqFocusStep] >= Tic/64*4) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO ); //6*4=24Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO );
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO );
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO );}
          if(SeqTic[y][SeqFocusStep] >= Tic/64*5) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO ); //6*5=30Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= Tic/64*6) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*6=36Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= Tic/64*7) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*7=42Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= Tic/64*8) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*8=48Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);}
          if(SeqTic[y][SeqFocusStep] >= Tic/64*9) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*9=54Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 9, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= Tic/64*10) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*10=60Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 9, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 10, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= Tic/64*11) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*11=66Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 9, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 10, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 11, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= Tic/64*12) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*12=72Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 9, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 10, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 11, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 12, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= Tic/64*13) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*13=78Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 9, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 10, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 11, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 12, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 13, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= Tic/64*14) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*14=84Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 9, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 10, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 11, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 12, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 13, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 14, y, colorO);}
         if(SeqTic[y][SeqFocusStep] >= Tic/64*15) {BLM_SCALAR_MASTER_LED_Set(ID, 0, 1, y, colorO); //6*15=84Tics Delay
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 2, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 3, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 4, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 5, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 6, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 7, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 8, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 9, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 10, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 11, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 12, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 13, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 14, y, colorO);
                                                   BLM_SCALAR_MASTER_LED_Set(ID, 0, 15, y, colorO);}
           }
}



}} // END SEQUENCER MODE

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//SWING MODE/////////////////////////////////////////////////////////////////////////////////////////////////////////////
  if(MatrixUse == 1){

    //focus Track
    if(element_id == 2) {focusMatrixUse[1] = button_y; }


    if(element_id == 0 && button_depressed == 0) {//Matrix touched?
      if(button_y == 0) { //ROW 0   //Swing OFF ON16th ON8th///////////////////////
        //y+16 = offset, because we can only show 16 ROWS on the BLM
        if(Seq[button_y+16][button_x+(Page*(StepPerPage))] >= 2)  {Seq[button_y+16][button_x+(Page*(StepPerPage))] = 0;}  //switch   Swing OFF
   else if(Seq[button_y+16][button_x+(Page*(StepPerPage))] == 0)  {Seq[button_y+16][button_x+(Page*(StepPerPage))] = 1;}  //switch 2 16th Mode
   else if(Seq[button_y+16][button_x+(Page*(StepPerPage))] == 1)  {Seq[button_y+16][button_x+(Page*(StepPerPage))] = 2;}} //switch 2  8th Mode

      if(button_y >= 1) { //ROW 1-15 //Swing ammount///////////////////////////////
        if(button_x == 0) { //STEP0
          Seq[17][0+(Page*(StepPerPage))]  = button_y;} //[y1]CELL  [X0]STEP
        if(button_x == 1) { //STEP1
          Seq[17][1+(Page*(StepPerPage))]  = button_y;} //[y1]CELL  [X1]STEP
        if(button_x == 2) { //STEP2
          Seq[17][2+(Page*(StepPerPage))]  = button_y;} //[y1]CELL  [X2]STEP
        if(button_x == 3) { //STEP3
          Seq[17][3+(Page*(StepPerPage))]  = button_y;} //[y1]CELL  [X3]STEP
        if(button_x == 4) { //STEP4
          Seq[17][4+(Page*(StepPerPage))]  = button_y;} 
        if(button_x == 5) { //STEP5
          Seq[17][5+(Page*(StepPerPage))]  = button_y;} 
        if(button_x == 6) { //STEP6
          Seq[17][6+(Page*(StepPerPage))]  = button_y;} 
        if(button_x == 7) { //STEP7
          Seq[17][7+(Page*(StepPerPage))]  = button_y;} 
        if(button_x == 8) { //STEP8
          Seq[17][8+(Page*(StepPerPage))]  = button_y;} 
        if(button_x == 9) { //STEP9
          Seq[17][9+(Page*(StepPerPage))]  = button_y;} 
        if(button_x == 10) { //STEP10
          Seq[17][10+(Page*(StepPerPage))] = button_y;} 
        if(button_x == 11) { //STEP11
          Seq[17][11+(Page*(StepPerPage))] = button_y;} 
        if(button_x == 12) { //STEP12
          Seq[17][12+(Page*(StepPerPage))] = button_y;} 
        if(button_x == 13) { //STEP13
          Seq[17][13+(Page*(StepPerPage))] = button_y;} 
        if(button_x == 14) { //STEP14
          Seq[17][14+(Page*(StepPerPage))] = button_y;}
        if(button_x == 15) { //STEP15
          Seq[17][15+(Page*(StepPerPage))] = button_y;}
}}
        //Clear Temporar Matrix


        int y;  for(y=1; y<16; y++)    {
        int x;  for(x=0; x<16; x++)    {    SwingBLM[y][x] = 0;}} //Clear temporar Matrix

        //Save [Y1] Button State in a Temporar Matrix... to visualize it later on the GRID
        int x;  for(x=0; x<16; x++)    {  //go thru all steps  
        int y;  for(y=0; y<Seq[17][x+(Page*(StepPerPage))]; y++)    {  SwingBLM[y][x] = 3;}} //only activate number of Y-Lines cooresponding to [Y1]


     //DUMP OUT ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
     if((element_id == 0 && button_depressed == 0) || (element_id == 5 && button_x == 1));{ //button pressed? || Dumpout Call?

       //Dump Row[=y] 0 OUT to BLM  =  SWING OFF ON16th ON8th
          int x;  for(x=0; x<16; x++)  {BLM_SCALAR_MASTER_LED_Set(ID, 0, x, 0, Seq[16][x+(Page*(StepPerPage))]);} //(blm, element, x, y, color);

       //Dump SWING Value out
                     for(x=0; x<16; x++)  { //go thru all 16 Steps
              int y; for(y=0; y<15; y++)  { //go thru all 15 Rows
            BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y+1, SwingBLM[y][x]);}}} //(blm, id, x, y, color);


    //Set Loop Length
    if(element_id == 1){//X-Buttons
      if(button_depressed ==0 && LoopSetCount ==1) {if(button_x < btn) {PageFirst = button_x; PageLast = button_x;}
		                                            if(button_x > btn) {PageFirst = btn; PageLast = button_x;}} //2.while holding 1. pressing 2. set Loop Point
      if(button_depressed ==0 && LoopSetCount ==0) {LoopSetCount = LoopSetCount+1;      //1. Show selected Page on BLM, set a memory Start Page "btn"
         Page = button_x; btn = button_x;}	//show selected Page on the BLM, memory button_x for 2.
      if(button_depressed == 1){LoopSetCount = 0; //Clear Counter - its all done
		  SEQ_Loop();//Send update CALL to seq.c > s32 SEQ_Loop - go make new loop length, and just do it...
          SyncFlag = 1;}   //see "seq.c." Call BPM counter that something has to be change
        //turn off All Buttons
        int x; for(x=0; x<16; x++) { BLM_SCALAR_MASTER_LED_Set(ID, 1, x, 0, 0);}
        BLM_SCALAR_MASTER_LED_Set(ID, 1, PageFirst, 0, 1); //PAGE Start
        BLM_SCALAR_MASTER_LED_Set(ID, 1, PageLast,  0, 1);} //PAGE END
        
    //SET Loop Point: press and hold first btn, press 2nd BTN, release booth.
    //is 2nd BTN greater then 1st.BTN, then LoopEndPoint will be 2ndBTN,
    //is 2nd BTN smaller then 1st.BTN then you loop only the 1stPage.


    //STEP-LIGHT///X...X...X...X...X...X...X...O...X...   
    if(element_id == 6) {//6: StepLight, we show the StepIndicator+Page+LoopStartStop on the Extra X Buttons
		
      //turn off All Buttons
      int x; for(x=0; x<16; x++) { BLM_SCALAR_MASTER_LED_Set(ID, 1, x, 0, 0);}
      //Turn on Page-Start & PageLast >> Loop Cycle
      BLM_SCALAR_MASTER_LED_Set(ID, 1, PageFirst, 0, 1);
      BLM_SCALAR_MASTER_LED_Set(ID, 1, PageLast,  0, 1);         
	  if(button_x >= 0             && button_x <= StepPerPage)    {BLM_SCALAR_MASTER_LED_Set(ID, 1, button_x, 0, 3); //Set Step LED
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 0,    0, 2); //PAGE Indicator
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);} //Viewed Page                                                                   
	  if(button_x > StepPerPage    && button_x <= StepPerPage*2)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage),0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 1,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*2  && button_x <= StepPerPage*3)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*2),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 2,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*3  && button_x <= StepPerPage*4)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*3),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 3,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}   
	  if(button_x > StepPerPage*4  && button_x <= StepPerPage*5)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*4),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 4,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*5  && button_x <= StepPerPage*6)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*5),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 5,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*6  && button_x <= StepPerPage*7)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*6),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 6,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}   
	  if(button_x > StepPerPage*7  && button_x <= StepPerPage*8)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*7),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 7,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*8  && button_x <= StepPerPage*9)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*8),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 8,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}   
	  if(button_x > StepPerPage*9  && button_x <= StepPerPage*10) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*9),  0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 9,    0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*10 && button_x <= StepPerPage*11) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*10), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 10,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*11 && button_x <= StepPerPage*12) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*11), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 11,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*12 && button_x <= StepPerPage*13) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*12), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 12,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*13 && button_x <= StepPerPage*14) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*13), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 13,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*14 && button_x <= StepPerPage*15) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*14), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 14,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}  
	  if(button_x > StepPerPage*15 && button_x <= StepPerPage*16) {BLM_SCALAR_MASTER_LED_Set(ID, 1, (button_x-StepPerPage*15), 0, 3); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, 15,   0, 2); 
                                                                   BLM_SCALAR_MASTER_LED_Set(ID, 1, Page, 0, 3);}
}                              

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//TRIGGERMATRIX Router or CC Mode////////////////////////////////////////////////////////////////////////////////////////
if((MatrixUse == 2) || (MatrixUse==3)) {

   //SHIFT
   if(element_id == 3) {//3=Shift Btn //used to lock rolls
     RollLock = button_depressed;} //Lock Individual Rolls (normaly they are Momentarys...with this active they are toggle buttons 

   //EXTRA-Y-BUTTONS  ||||  VERTICALS |||| TRIGGER ROUTING PRESETS
   if(element_id == 2) {//1= x-extra-buttons, 2= y-extra, 0=matrix
	
     if(button_depressed == 0) { //avoid double triggering, we toggle...                                                     
       MtxPartNr = button_y;
          int e; for(e=0; e<16; e++) {EXTRA[e][0] = 0;} //Turn off all Songpart LEDs 
          EXTRA[button_y][0] = 1; //activate one of the songparts-indicators
          //Load Matrix Data in the Matrix wich is interacting with incoming drum triggers---the LOAD-Matrix
          int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MtxLoad[x][y]=MATRIX[MtxPartNr][x][y];;}}
              //LED - Feedback to Footcontroll-Box
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 0, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 1, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 2, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 3, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 4, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 5, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 6, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 7, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 8, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 9, 0);  //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 10, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 11, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 12, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 13, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 14, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, 15, 0); //Deactivate LED 
              MIOS32_MIDI_SendNoteOn(RemotePort, 14, MtxPartNr, 1);//Activate Actual LED
       }
     //Deactivate LOCKS of ROLLs
     if(button_depressed == 1) {int z; for(z=0; z<16; z++)  {BLM_SCALAR_MASTER_LED_Set(ID, 1, z, 0, 0); EXTRA[z][1] = 1;}
     //Deactivate OVER Roll
     OverRoll = 1;}
  
    } 

   //EXTRA-X-BUTTONs  ====  HORIZONTALs
   if(element_id == 1) {
     //RollBtns as Momentarys
     if(RollLock == 1) { EXTRA[button_x][1] = button_depressed;      BLM_SCALAR_MASTER_LED_Set(ID, 1, button_x, 0, 0);}
     //RollBtns are Toggle
     if(RollLock == 0 && button_depressed == 0) { EXTRA[button_x][1] = 0; BLM_SCALAR_MASTER_LED_Set(ID, 1, button_x, 0, 2);}     
  
        if(EXTRA[button_x][1] == 0) {int y; for(y=0; y<16; y++){MtxLoad[y][button_x]=MATRIX[15][y][button_x];}} //Overwrite Routing temporar Roll-rout
        else                        {int y; for(y=0; y<16; y++){MtxLoad[y][button_x]=MATRIX[MtxPartNr][y][button_x];}}}  //Change to orginal Routing

//MATRIX-BUTTONS - in Router-Mode (MatrixUse 2) 
   if(MatrixUse==2 && element_id==0 && button_depressed==0) { //lets toggle the Matrix Data 4 Songparts 
      MATRIX[MtxPartNr][button_y][button_x]   =!   MATRIX[MtxPartNr][button_y][button_x];
     //Load Saved Matrix Data in the Matrix wich is interacting with incoming drum triggers---the LOAD-Matrix
      int y; for(y=0; y<16; y++)  { int x; for(x=0; x<16; x++) {MtxLoad[x][y]=MATRIX[MtxPartNr][x][y];;}}} 

//MATRIX-BUTTONS - in CC-Mode Mode (MatrixUse 3)
if(MatrixUse==3 && element_id==0 && button_depressed == 0) { 
   //Solo - Radio-Switch-Button
  if(button_y == 14) { //Solo Collum
    if(CCMtx[0][button_y][button_x] == 1) { //was solo active before?
         int x; for(x=0; x<16; x++) { CCMtx[0][button_y][x]=0;} AnySolo = 0;} //then deactivate all solos
    else{int x; for(x=0; x<16; x++) { CCMtx[0][button_y][x]=0; CCMtx[0][button_y][button_x]=1;} AnySolo = 1;}} //if deactive then deactivate all execpt pressed one
    // All Others
    else{CCMtx[0][button_y][button_x]   =!   CCMtx[0][button_y][button_x];}} //lets toggle the Matrix Data 4 Function-Perform-Mode  

//DUMP OUT MATRIX & EXTRA-X States to BLM 
if (button_depressed ==0) {       
  //MATRIX
  if( (element_id ==0) || (element_id ==10) || (element_id==5 && ((button_x==2)||(button_x == 3)))
                       ||(element_id ==2 ) ) {//pressed MATRIX/EXTRA-X Button?

      if(MatrixUse==2){//TriggerMatrixRouter
                int y;  for(y=0; y<16; y++)    {
                int x;  for(x=0; x<16; x++)    {
                  //Dump the whole ARRAY OUT!
                  BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y, MATRIX[MtxPartNr][y][x]);}}} //(blm, id-element, x, y, color);

      if(MatrixUse==3){//TriggerMatrixCC
	            u8 color0 = 0; u8 color1 = 1; u8 colorBLM = 0; u8 NrOver = 0;    
        //Lets Load the BLM with [one of the][16][16] Matrices
        int y;  for(y=0; y<16; y++)    {
        int x;  for(x=0; x<16; x++)    {                                  //But before we have to change the Color Pattern...
                 //////COLOR-PATTERN//////////////////////
                if(COLOR[NrOver][y][x] == 0){color0 = 0; color1 =1;} //     0         0 > OFF      1 > BLUE 
                if(COLOR[NrOver][y][x] == 1){color0 = 0; color1 =2;} //     1         0 > OFF      2 > GREEN 
                if(COLOR[NrOver][y][x] == 2){color0 = 0; color1 =3;} //     2         0 > OFF      3 > CYAN 
                if(COLOR[NrOver][y][x] == 3){color0 = 1; color1 =1;} //     3         1 > BLUE     1 > BLUE 
                if(COLOR[NrOver][y][x] == 4){color0 = 1; color1 =2;} //     4         1 > BLUE     2 > GREEN 
                if(COLOR[NrOver][y][x] == 5){color0 = 1; color1 =3;} //     5         1 > BLUE     3 > CYAN
                if(COLOR[NrOver][y][x] == 6){color0 = 0; color1 =0;} //     6         0 > OFF      0 > OFF
                
			    if(CCMtx[NrOver][y][x] == 0) {colorBLM = color0;} //get the actual Matrix value/state 
			    if(CCMtx[NrOver][y][x] == 1) {colorBLM = color1;} //get the actual Matrix value/state 			
                //Dump the whole ARRAY OUT!
                BLM_SCALAR_MASTER_LED_Set(ID, 0, x, y, colorBLM);}}}} //(blm, element_id, button_x, button_y, new_colour);

   //EXTRA Y  ||||  Verticals            
   if ((element_id == 2) || (element_id ==10) || (element_id==5 && ((button_x==2)||(button_x == 3))))  {//dumpout LEDs
     u8 color0ex = 0; u8 color1ex = 1; u8 colorBLMex = 0;  int y; for(y=0; y<16; y++) {//element_id==10comes from above when a BLM has been connected.
                 //////COLOR-PATTERN//////////////////////
                if(COLORex[y][1] == 0){color0ex = 0; color1ex =1;} //     0         0 > OFF      1 > BLUE 
                if(COLORex[y][1] == 1){color0ex = 0; color1ex =2;} //     1         0 > OFF      2 > GREEN 
                if(COLORex[y][1] == 2){color0ex = 0; color1ex =3;} //     2         0 > OFF      3 > CYAN 
                if(COLORex[y][1] == 3){color0ex = 1; color1ex =1;} //     3         1 > BLUE     1 > BLUE 
                if(COLORex[y][1] == 4){color0ex = 1; color1ex =2;} //     4         1 > BLUE     2 > GREEN 
                if(COLORex[y][1] == 5){color0ex = 1; color1ex =3;} //     5         1 > BLUE     3 > CYAN
                if(COLORex[y][1] == 6){color0ex = 0; color1ex =0;} //     6         0 > OFF      0 > OFF
                
			    if(EXTRA[y][0] == 0) {colorBLMex = color0ex;} //get the actual EXTRA value/state 
			    if(EXTRA[y][0] == 1) {colorBLMex = color1ex;} //get the actual EXTRA value/state 			
                //Now Dump the whole ARRAY OUT!
                BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, y, colorBLMex);}} //(blm, element_id, button_x, button_y, new_colour);
}
} //END TRIGGER MATRIX MODE
return 0;} // no error	

void APP_SRIO_ServicePrepare(void){//called before shift register chain is scanned
  //BLM DRIVER
    BLM_X_PrepareRow(); //prepare DOUT registers to drive the row  ___BLM-X WILBA PCB SCAN MATRIX  

  //LED RINGs
    encDiv16[0]  = MeloKILL/8;
    encDiv16[1]  = MonoKILL/8;
    encDiv16[2]  = MeloDecay/8;
    encDiv16[3]  = MonoDecay/8;
    encDiv16[4]  = MeloVelo/8;
    encDiv16[5]  = MonoVelo/8;
    encDiv16[6]  = 0;
    encDiv16[7]  = TrigKILL/8;
    encDiv16[8]  = 0;
    encDiv16[9]  = Fullvelo/8;
    encDiv16[10] = MainDelay/8;
    encDiv16[11] = VelSelValue[0]/8;
    encDiv16[12] = Swing8th/8;
    encDiv16[13] = VelSelValue[1]/8;
    encDiv16[14] = Swing16th/8;
    encDiv16[15] = VelSelValue[2]/8;

    //1. Deactivate Vertical PINs (from last cycle)
    MIOS32_DOUT_PinSet( LEDDoutV,     0); //LEDDoutV= Number of HC595Register - Predefinied e.g.10
    MIOS32_DOUT_PinSet((LEDDoutV+1),  0); //HC595 OUT-PORTs=8
    MIOS32_DOUT_PinSet((LEDDoutV+2),  0); //+2 is the 3rd (starting by 0) Pin of this Register
    MIOS32_DOUT_PinSet((LEDDoutV+3),  0); //so: (10x8=80)+3 = 83.Pin
    MIOS32_DOUT_PinSet((LEDDoutV+4),  0); 
    MIOS32_DOUT_PinSet((LEDDoutV+5),  0); 
    MIOS32_DOUT_PinSet((LEDDoutV+6),  0); 
    MIOS32_DOUT_PinSet((LEDDoutV+7),  0); 
    MIOS32_DOUT_PinSet((LEDDoutV+8),  0); 
    MIOS32_DOUT_PinSet((LEDDoutV+9),  0); 
    MIOS32_DOUT_PinSet((LEDDoutV+10), 0); 
    MIOS32_DOUT_PinSet((LEDDoutV+11), 0); 
    MIOS32_DOUT_PinSet((LEDDoutV+12), 0); 
    MIOS32_DOUT_PinSet((LEDDoutV+13), 0); 
    MIOS32_DOUT_PinSet((LEDDoutV+14), 0); 
    MIOS32_DOUT_PinSet((LEDDoutV+15), 0); 

    /////DOUT-Matrix-routine/////
    //2. Deactivate the last Horizontal PIN (from last cycle)
    MIOS32_DOUT_PinSet(LEDCount_H, 0); 
    LEDCount_H = LEDDoutH+LEDCount; //LEDDoutH=Number of Connected Register*8=Pin Number

    //3. Activate Vertical Lines  
    MIOS32_DOUT_PinSet( LEDDoutV+encDiv16[LEDCount], 1); 

    //4. Activate Horizontal Line 
    MIOS32_DOUT_PinSet(LEDCount_H, 1); //Activate First Row - Negatives Side of Diodes

    //5. Counter - count from 0-15 then 0 again...
    if (LEDCount < 16) {LEDCount = LEDCount + 1;}
    if (LEDCount > 15) {LEDCount = 0;}
	} 
void APP_SRIO_ServiceFinish(void){ BLM_X_GetRow(); }   // call the BLM_GetRow function after scan is finished to capture the read DIN values
void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){}

//MENUE - PAGES +++ SD-Card STORAGE
void APP_ENC_NotifyChange(u32 encoder, s32 incrementer){
  //MENUE ENCODER
  if(encoder < 17)  {	MENUE(encoder, incrementer);}  //TriggerMatrtix-Encoders > forwarding to Function "MENUE"
  
  //CC-ENCODER
  if(encoder > 16 && encoder < 33)  {
     encoder = encoder-17; //Offset Encoder
     //Velocity Set
      if(encoder == 9) {incrementer = Fullvelo + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Full-Velocity Encoder
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     Fullvelo = incrementer;}        
     
     if(encoder == 11) {incrementer = VelSelValue[0] + incrementer;
	                 if(incrementer <= 1)   {incrementer =  1;}   //the velocity range is from 0...
	                 if(incrementer >= 44)  {incrementer = 44;}   // ...to 44
                     VelSelValue[0] = incrementer;}
                    
     if(encoder == 13) {incrementer = VelSelValue[1] + incrementer;
	                 if(incrementer <= 45)  {incrementer = 45;}   //the velocity range is from 45...
	                 if(incrementer >= 89)  {incrementer = 89;}   // ...to 89
                     VelSelValue[1] = incrementer;}          
                              
     if(encoder == 15) {incrementer = VelSelValue[2] + incrementer;
	                 if(incrementer <= 90)   {incrementer =  90;}   //the velocity range is from 90...
	                 if(incrementer >= 127)  {incrementer = 127;}   // ...to 127
                     VelSelValue[2] = incrementer;}                        
                    
     //Timing
      if(encoder == 10) {incrementer = MainDelay + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Main-Clock-Delay in TICs
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     MainDelay = incrementer;}   

      if(encoder == 12) {incrementer = Swing8th + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Swing 8 Delay in TICs
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     Swing8th  = incrementer;}  

      if(encoder == 14) {incrementer = Swing16th + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Swing 16 Delay in TICs
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     Swing16th = incrementer;}                          

     //Trigger Processing
      if(encoder == 0) {incrementer = MeloKILL + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Kill Melody
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     MeloKILL = incrementer;}  

      if(encoder == 2) {incrementer = MeloDecay+ incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Decay Melody
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     MeloDecay = incrementer;}  

      if(encoder == 4) {incrementer = MeloVelo+ incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Velocity Melody
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     MeloVelo = incrementer;}  

      if(encoder == 1) {incrementer = MonoKILL  + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Kill MonoLine
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     MonoKILL = incrementer;}  

      if(encoder == 3) {incrementer = MonoDecay + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Decay MonoLine
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     MonoDecay  = incrementer;}  

      if(encoder == 5) {incrementer = MonoVelo + incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Velocity MonoLine
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     MonoVelo  = incrementer;}  


      if(encoder == 7) {incrementer = TrigKILL+ incrementer;
	                 if(incrementer <= 0)    {incrementer =  0;}   //Kill TriggerLayer
	                 if(incrementer >= 127)  {incrementer = 127;}  
                     TrigKILL  = incrementer;}  
}
}
 
void APP_AIN_NotifyChange(u32 pin, u32 pin_value){} //called when a pot has been moved

void BLM_Button_NotifyToggle(u32 btn, u32 value){ // will be called on BLM pin changes (see TASK_BLM_Check)
if(value == 1) {
 if(btn == 18) {StoreFlag=1;}  //Store
 if(btn == 19) {LoadFlag =1;}} //Load

if(value == 0) {Router(0,0,btn,value);  //ReRoute-SEQUENCER UI
  }
}

// SEQ  This task is called periodically each mS to handle sequencer requests
static void TASK_SEQ(void *pvParameters){
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // execute sequencer handler
    SEQ_Handler();

  }
}

/////////////////////////////////////////////////////////////////////////////
// SEQ --- Installed via MIOS32_MIDI_DirectRxCallback_Init
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 midi_byte){//filter Midiclock Port and rerout it to SEQUENCER-BPM
if(port == ClockPortIN) { SEQ_BPM_NotifyMIDIRx(midi_byte); }
  return 0; // no error, no filtering
}

//TRIGGERMATRIX
u8 APP_NOTEPROCESS(u8 port, u8 note, u8 velocity, u16 step, u16 tic){ //do triggering
 //MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0);  MIOS32_LCD_PrintFormattedString("%d", step);

//Random Trigger Gate 4  "MKill"  & "DKill"
  if(tic == 0 || tic == BaseTic*4) { //avoid to much Calculations every 32n step is enough
  if(port == 0 || port == 1){ //sequencer or external Midi
    for(TMR0L=0; TMR0L<127; TMR0L++){random_tmp=random_tmp+1;} //Random-Value 4 RandomKill 
    random_tmp = random_seed_l * random_seed_h;
    random_seed_l = TMR0L + (random_tmp & 0xff); //TMR0L = Timer
    random_seed_h = 0x69 + (random_tmp >> 8);
    random_nr = random_tmp % 127; //>> 2;       // divide by 2 > bitshifting - thx2"kpete" 
    if(MeloKILL  > random_nr) {MeloRandGate = 1;} //Pass Notes   /MeloKILL  = MKill - Melody-Trigger-Kill
    if(MeloKILL  < random_nr) {MeloRandGate = 0;} //Kill Notes   /MeloKILL  = MKill - Melody-Trigger-Kill
    if(MonoKILL > random_nr) {MonoRandGate = 1;} //Pass Notes   /MonoKILL = DKill - Drum-Trigger-Kill
    if(MonoKILL < random_nr) {MonoRandGate = 0;} //Kill Notes   /MonoKILL = DKill - DRUM-Trigger-Kill
    if(TrigKILL > random_nr) {TrigRandGate = 1;} //Pass Notes   /MonoKILL = DKill - Drum-Trigger-Kill
    if(TrigKILL < random_nr) {TrigRandGate = 0;} //Kill Notes   /MonoKILL = DKill - DRUM-Trigger-Kill
   }}

//Activate "Trigger-Input-LEDS" (via Vertical Xtra Buttons aka "Router-Preset-Btns"
  if((MatrixUse == 2) || (MatrixUse==3)) { //are we in TriggerMatrix-mode?
    if(port == 0 && tic == BaseTic) { //StepSequencer Input && 12th tic of step>avoid double trigger and make place for NoteCalculation @Tic=0
      int x; for(x=0; x<16; x++) {
        if(Seq[x][step]  > 0) {
          //Get Color
          int Color = 1;
          if(Seq[x][step] <=44) {Color = 1;}
          if(Seq[x][step] >=44 && Seq[x][step] <= 89) {Color = 2;}
          if(Seq[x][step] >=90) {Color = 3;}
          BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, x, Color);}} //Activate ActiveSteps - Trigger LEDs
        DrumDecayTimer[16]=70;}        //Deactivate Trigger LED after 70milli Seconds
}

//RECORD
  if(Rec == 1) {//Record Switch Active
    if(port == 1) { //MidiTrigger-Input (Real Drummer)
      //AutoQuantize OFF?
      if(AutQuntActive == 0) {
        Seq[note][StepSend] = velocity; // Write Velocity into current Step on Triggered Note
        SeqTic[note][StepSend] = tic;}   // Write a "Time-Stemp" to realize Human Timing. (you can quantize later)

	  //AutoQuantize ON?
      else if(AutQuntActive == 1) {//Quantize while Recording is ON
          //16th Quantize Mode
          if(QuantRate == 0) { //QuantRate0:16th,1:32nd, 2:64
              SeqTic[note][StepSend] = 0;  //need no Tic Offset when we play straight 16th machine beat...

              //Write Velocity in currently played Step
              if(tic <= (BaseTic*4) )  {  //12x4=48 (Tic 0-48)
                Seq[note][StepSend] = velocity;} // Write Velocity into current sequenced Step with Triggered Note

              else { //Write Velocity into Next note   
                  //Are we on Last Step of Loop?
                  if(direction == 1) {  //when in Forward Direction Sequencing Mode
                    if(note == Last) { //when Last step is arrived
                      Seq[First][StepSend] = velocity;} //then write Velocity in First Note of Loop
                    if(note < Last)  { //If not Last Step, then simply write in next Step:
                      Seq[note][StepSend+1] = velocity;} //next step
                   }
                 if(direction == 0) {  //when in Rewind Direction Sequencing Mode
                    if(note == First) { //when First step is arrived (typical 0)
                      Seq[Last][StepSend] = velocity;} //then write Velocity in Last Note of Loop (typical 16)
                    if(note > First)  { //If not First Step, then simply write in next Step:
                      Seq[note][StepSend-1] = velocity;} //next step
                  }}
             }

          //32nd Quantize Mode
          if(QuantRate == 1) { //QuantRate0:16th,1:32nd, 2:64
              //Write Velocity in currently played Step
              if(tic <= (BaseTic*6) )  {  //12x6=72 (Tic 0-72)
                Seq[note][StepSend] = velocity; // Write Velocity into current sequenced Step with Triggered Note
                  if(tic <= BaseTic*2) {SeqTic[note][StepSend] = 0;}//Straight 16th without delay
                  if(tic > BaseTic*2 && tic <= BaseTic*4) {SeqTic[note][StepSend] = BaseTic*4;}//Delay 2 next 32nd Note
                  if(tic > BaseTic*4 && tic <= BaseTic*6) {SeqTic[note][StepSend] = BaseTic*4;}}//Delay 2 previus 32nd Note

              else { //Write Velocity into Next note
                 SeqTic[note][StepSend] = 0;  // kick back to zero > straight machine time > no delay
                  //Are we on Last Step of Loop?
                  if(direction == 1) {  //when in Forward Direction Sequencing Mode
                    if(note == Last) { //when Last step is arrived
                      Seq[First][StepSend] = velocity;} //then write Velocity in First Note of Loop
                    if(note < Last)  { //If not Last Step, then simply write in next Step:
                      Seq[note][StepSend+1] = velocity;} //next step
                   }
                 if(direction == 0) {  //when in Rewind Direction Sequencing Mode
                    if(note == First) { //when First step is arrived (typical 0)
                      Seq[Last][StepSend] = velocity;} //then write Velocity in Last Note of Loop (typical 16)
                    if(note > First)  { //If not First Step, then simply write in next Step:
                      Seq[note][StepSend-1] = velocity;} //next step
                  }}
             }

          //64 Quantize Mode
          if(QuantRate == 2) { //QuantRate0:16th,1:32nd, 2:64
              //Write Velocity in currently played Step
              if(tic <= BaseTic*7)  {  //Tic 0-84)
                Seq[note][StepSend] = velocity; // Write Velocity into current sequenced Step with Triggered Note
                  if(tic <= BaseTic) {SeqTic[note][StepSend] = 0;}//Straight 16th without delay
                  if(tic >  BaseTic && tic <= BaseTic*2) {SeqTic[note][StepSend] = BaseTic*2;}//Delay 2 next 64 Note
                  if(tic >  BaseTic*2 && tic <= BaseTic*3) {SeqTic[note][StepSend] = BaseTic*2;}//Delay 2 previus 64 Note
                  if(tic >  BaseTic*3 && tic <= BaseTic*4) {SeqTic[note][StepSend] = BaseTic*4;}//Delay 2 next 64 Note
                  if(tic >  BaseTic*4 && tic <= BaseTic*5) {SeqTic[note][StepSend] = BaseTic*4;}//Delay 2 previus 64 Note
                  if(tic >  BaseTic*5 && tic <= BaseTic*6) {SeqTic[note][StepSend] = BaseTic*6;}//Delay 2 next 64 Note
                  if(tic >  BaseTic*6 && tic <= BaseTic*7) {SeqTic[note][StepSend] = BaseTic*6;}}//Delay 2 previus 64 Note

              else { //Write Velocity into Next note
                 SeqTic[note][StepSend] = 0;  // kick back to zero > straight machine time > no delay
                  //Are we on Last Step of Loop?
                  if(direction == 1) {  //when in Forward Direction Sequencing Mode
                    if(note == Last) { //when Last step is arrived
                      Seq[First][StepSend] = velocity;} //then write Velocity in First Note of Loop
                    if(note < Last)  { //If not Last Step, then simply write in next Step:
                      Seq[note][StepSend+1] = velocity;} //next step
                   }
                 if(direction == 0) {  //when in Rewind Direction Sequencing Mode
                    if(note == First) { //when First step is arrived (typical 0)
                      Seq[Last][StepSend] = velocity;} //then write Velocity in Last Note of Loop (typical 16)
                    if(note > First)  { //If not First Step, then simply write in next Step:
                      Seq[note][StepSend-1] = velocity;} //next step
                  }}
             }
}}}


  //SWING   &   TIC STUFF
  //write the SeqTicsMatrix according to the played step, into a smaller  Array... and in Benefit we can make a TIC-OFFSET!
  int y; for(y=0; y<16; ++y){
      if(Seq[16][step] == 0  || SwingSwitch == 0) { SeqTicDelay[y] = SeqTic[y][step] + MainDelay; }            //A  NOT swinged Step
      if(Seq[16][step] == 1  && SwingSwitch == 1) { SeqTicDelay[y] = SeqTic[y][step] + Seq[17][step] + MainDelay + Swing16th; }  //A 16th swinged Step
      if(Seq[16][step] == 2  && SwingSwitch == 1) { SeqTicDelay[y] = SeqTic[y][step] + Seq[17][step] + MainDelay + Swing8th;  }}  //A 16th swinged Step
    //if SwingIsActive = ON  && SwingActiveSwitch is ON {TIC-Delay = Programmed Tic  + SwingAmmount  + MainDelay + SwingRotaryAmmount
/*
    TicCounter16 = Swing16th+MainDelay+(Seq[17][loop_step_pos]*SwingAmmountFactor16);}
*/

////////////////////////////////////////////////////////////////////                                   
//Trigger0 - Poly-Retrigger
   if(
      ( ((CCMtx[0][15][0]==1) && (AnySolo==0)) || (CCMtx[0][14][0]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [0]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0]  == tic))  || //a router cell active? && any Note in Sequencer Step? Right Tic?
            ((MtxLoad[1] [0]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1]  == tic))  ||
            ((MtxLoad[2] [0]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2]  == tic))  ||
            ((MtxLoad[3] [0]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3]  == tic))  ||
            ((MtxLoad[4] [0]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4]  == tic))  ||
            ((MtxLoad[5] [0]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5]  == tic))  ||
            ((MtxLoad[6] [0]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6]  == tic))  ||
            ((MtxLoad[7] [0]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7]  == tic))  ||
            ((MtxLoad[8] [0]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8]  == tic))  ||
            ((MtxLoad[9] [0]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9]  == tic))  ||
            ((MtxLoad[10][0]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][0]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][0]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][0]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][0]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][0]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [0]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [0]==1) && (note==1 ))   ||
            ((MtxLoad[2] [0]==1) && (note==2 ))   ||
            ((MtxLoad[3] [0]==1) && (note==3 ))   ||
            ((MtxLoad[4] [0]==1) && (note==4 ))   ||
            ((MtxLoad[5] [0]==1) && (note==5 ))   ||
            ((MtxLoad[6] [0]==1) && (note==6 ))   ||
            ((MtxLoad[7] [0]==1) && (note==7 ))   ||
            ((MtxLoad[8] [0]==1) && (note==8 ))   ||
            ((MtxLoad[9] [0]==1) && (note==9 ))   ||
            ((MtxLoad[10][0]==1) && (note==10))   ||
            ((MtxLoad[11][0]==1) && (note==11))   ||
            ((MtxLoad[12][0]==1) && (note==12))   ||
            ((MtxLoad[13][0]==1) && (note==13))   ||
            ((MtxLoad[14][0]==1) && (note==14))   ||
            ((MtxLoad[15][0]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[0][1] ==0) || (OverRoll ==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[0];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][0]==1) { //MATRIX = SWITCH FOR HIGHEST NOTE
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][0]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[0] = maximum;}

        //want to hear lowest note? get it! (since we use multiple triggers)
        if(CCMtx[0][12][0]==0) { //MATRIX = SWITCH FOR Lowest NOTE
          int Velos[16] = {}; //Array to hold all ON-Notes
		  int y;	for(y=0; y<16; ++y){
		  if(MtxLoad[y][0]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
          //find lowest velocity
          int minimum=127; int c; 
          for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
          velo[0] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[0] = velocity;}

//Kill Velocity-Ranges
      if( ( (velo[0] <=44)  && (VeloKill[0] == 1))                      ||
          (((velo[0] >=45)  && (velo[0] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[0] >=90)  && (VeloKill[2] == 1))) {                    
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[0] = velo[0] + CC; 
        if(velo[0] < 0){velo[0] = 1;}
        if(velo[0] > 127){velo[0] = 127;}      

//velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[0]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[0]   = inv; } //-97*-1 =  97

        //Send Trigger NoteOut
        if(TrigRandGate==1 || CCMtx[0][13][0]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
	    MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[0], TrigOutNote[0], velo[0]);}

		//send Poly Melody NoteOut
        if(MeloRandGate==1 || CCMtx[0][13][0]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		  int buf=0;	for(buf=0; buf<10; ++buf) {			
		  if(NoteBuff[0][buf] > 0) {
            MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[0], NoteBuff[0][buf], velo[0]); MeloDecayTIMER[0][NoteBuff[0][buf]] = Decay;}}

        //set new Trigger and Indicator DECAY-Time
        DrumDecayTimer[0]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[0] <=44)                                {Color = 1;}
          if(velo[0] >=44 && velo[0] <= 89) {Color = 2;}
          if(velo[0] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 0, 0, Color);}}}} //(blm, id, x, y, color) 


////////////////////////////////////////////////////////////////////                                   
//Trigger1 - Poly-Retrigger
   if(
      ( ((CCMtx[0][15][1]==1) && (AnySolo==0)) || (CCMtx[0][14][1]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [1]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [1]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [1]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [1]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [1]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [1]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [1]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [1]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [1]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [1]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][1]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][1]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][1]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][1]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][1]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][1]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [1]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [1]==1) && (note==1 ))   ||
            ((MtxLoad[2] [1]==1) && (note==2 ))   ||
            ((MtxLoad[3] [1]==1) && (note==3 ))   ||
            ((MtxLoad[4] [1]==1) && (note==4 ))   ||
            ((MtxLoad[5] [1]==1) && (note==5 ))   ||
            ((MtxLoad[6] [1]==1) && (note==6 ))   ||
            ((MtxLoad[7] [1]==1) && (note==7 ))   ||
            ((MtxLoad[8] [1]==1) && (note==8 ))   ||
            ((MtxLoad[9] [1]==1) && (note==9 ))   ||
            ((MtxLoad[10][1]==1) && (note==10))   ||
            ((MtxLoad[11][1]==1) && (note==11))   ||
            ((MtxLoad[12][1]==1) && (note==12))   ||
            ((MtxLoad[13][1]==1) && (note==13))   ||
            ((MtxLoad[14][1]==1) && (note==14))   ||
            ((MtxLoad[15][1]==1) && (note==15))   ||
            (OverRoll==0) ))      ))
     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[1][1] ==0) || (OverRoll ==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[1];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[1][12][1]==1) { //MATRIX = SWITCH FOR HIGHEST NOTE
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][1]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[1] = maximum;}

        //want to hear lowest note? get it! (since we use multiple triggers)
        if(CCMtx[1][12][1]==0) { //MATRIX = SWITCH FOR Lowest NOTE
          int Velos[16] = {}; //Array to hold all ON-Notes
		  int y;	for(y=0; y<16; ++y){
		  if(MtxLoad[y][1]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
          //find lowest velocity
          int minimum=127; int c; 
          for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
          velo[1] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[1] = velocity;}

//Kill Velocity-Ranges
      if( ( (velo[1] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[1] >=45)  && (velo[1] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[1] >=90)  && (VeloKill[2] == 1))) {                    
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[1] = velo[1] + CC; 
        if(velo[1] < 0){velo[1] = 1;}
        if(velo[1] > 127){velo[1] = 127;}      

//velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[1]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[1]   = inv; } //-97*-1 =  97

        //Send Trigger NoteOut
        if(TrigRandGate==1 || CCMtx[0][13][1]==0){   //CCMtx[1][13][x] = Does Random Kill have Effect?
	    MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[1], TrigOutNote[1], velo[1]);}

		//send Poly Melody NoteOut
        if(MeloRandGate==1 || CCMtx[0][13][1]==0){   //CCMtx[1][13][x] = Does Random Kill have Effect?
		  int buf=0;	for(buf=0; buf<10; ++buf) {			
		  if(NoteBuff[1][buf] > 0) {
            MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[1], NoteBuff[1][buf], velo[1]); MeloDecayTIMER[1][NoteBuff[1][buf]] = Decay;}}

        //set new Trigger and Indicator DECAY-Time
        DrumDecayTimer[1]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[1] <=44)                                {Color = 1;}
          if(velo[1] >=44 && velo[1] <= 89)               {Color = 2;}
          if(velo[1] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 1, 0, Color);}}}} //(blm, id, x, y, color) 


////////////////////////////////////////////////////////////////////                                   
//Trigger2 - Poly-Retrigger
   if(
      ( ((CCMtx[0][15][2]==1) && (AnySolo==0)) || (CCMtx[0][14][2]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [2]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [2]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [2]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [2]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [2]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [2]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [2]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [2]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [2]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [2]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][2]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][2]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][2]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][2]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][2]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][2]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [2]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [2]==1) && (note==1 ))   ||
            ((MtxLoad[2] [2]==1) && (note==2 ))   ||
            ((MtxLoad[3] [2]==1) && (note==3 ))   ||
            ((MtxLoad[4] [2]==1) && (note==4 ))   ||
            ((MtxLoad[5] [2]==1) && (note==5 ))   ||
            ((MtxLoad[6] [2]==1) && (note==6 ))   ||
            ((MtxLoad[7] [2]==1) && (note==7 ))   ||
            ((MtxLoad[8] [2]==1) && (note==8 ))   ||
            ((MtxLoad[9] [2]==1) && (note==9 ))   ||
            ((MtxLoad[10][2]==1) && (note==10))   ||
            ((MtxLoad[11][2]==1) && (note==11))   ||
            ((MtxLoad[12][2]==1) && (note==12))   ||
            ((MtxLoad[13][2]==1) && (note==13))   ||
            ((MtxLoad[14][2]==1) && (note==14))   ||
            ((MtxLoad[15][2]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[2][1] ==0) || (OverRoll ==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[2];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[2][12][2]==1) { //MATRIX = SWITCH FOR HIGHEST NOTE
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][2]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[2] = maximum;}

        //want to hear lowest note? get it! (since we use multiple triggers)
        if(CCMtx[2][12][2]==0) { //MATRIX = SWITCH FOR Lowest NOTE
          int Velos[16] = {}; //Array to hold all ON-Notes
		  int y;	for(y=0; y<16; ++y){
		  if(MtxLoad[y][2]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
          //find lowest velocity
          int minimum=127; int c; 
          for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
          velo[2] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[2] = velocity;}

//Kill Velocity-Ranges
      if( ( (velo[2] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[2] >=45)  && (velo[2] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[2] >=90)  && (VeloKill[2] == 1))) {                    
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[2] = velo[2] + CC; 
        if(velo[2] < 0){velo[2] = 1;}
        if(velo[2] > 127){velo[2] = 127;}      

//velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[2]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[2]   = inv; } //-97*-1 =  97

        //Send Trigger NoteOut
        if(TrigRandGate==1 || CCMtx[0][13][2]==0){   //CCMtx[2][13][x] = Does Random Kill have Effect?
	    MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[2], TrigOutNote[2], velo[2]);}

		//send Poly Melody NoteOut
        if(MeloRandGate==1 || CCMtx[0][13][2]==0){   //CCMtx[2][13][x] = Does Random Kill have Effect?
		  int buf=0;	for(buf=0; buf<10; ++buf) {			
		  if(NoteBuff[2][buf] > 0) {
            MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[2], NoteBuff[2][buf], velo[2]); MeloDecayTIMER[2][NoteBuff[2][buf]] = Decay;}}

        //set new Trigger and Indicator DECAY-Time
        DrumDecayTimer[2]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[2] <=44)                                {Color = 1;}
          if(velo[2] >=44 && velo[2] <= 89)               {Color = 2;}
          if(velo[2] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 2, 0, Color);}}}} //(blm, id, x, y, color) 


////////////////////////////////////////////////////////////////////                                   
//Trigger3 - Poly-Retrigger
   if(
      ( ((CCMtx[0][15][3]==1) && (AnySolo==0)) || (CCMtx[0][14][3]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [3]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [3]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [3]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [3]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [3]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [3]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [3]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [3]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [3]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [3]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][3]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][3]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][3]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][3]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][3]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][3]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [3]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [3]==1) && (note==1 ))   ||
            ((MtxLoad[2] [3]==1) && (note==2 ))   ||
            ((MtxLoad[3] [3]==1) && (note==3 ))   ||
            ((MtxLoad[4] [3]==1) && (note==4 ))   ||
            ((MtxLoad[5] [3]==1) && (note==5 ))   ||
            ((MtxLoad[6] [3]==1) && (note==6 ))   ||
            ((MtxLoad[7] [3]==1) && (note==7 ))   ||
            ((MtxLoad[8] [3]==1) && (note==8 ))   ||
            ((MtxLoad[9] [3]==1) && (note==9 ))   ||
            ((MtxLoad[10][3]==1) && (note==10))   ||
            ((MtxLoad[11][3]==1) && (note==11))   ||
            ((MtxLoad[12][3]==1) && (note==12))   ||
            ((MtxLoad[13][3]==1) && (note==13))   ||
            ((MtxLoad[14][3]==1) && (note==14))   ||
            ((MtxLoad[15][3]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[3][1] ==0) || (OverRoll ==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[3];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[3][12][3]==1) { //MATRIX = SWITCH FOR HIGHEST NOTE
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][3]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[3] = maximum;}

        //want to hear lowest note? get it! (since we use multiple triggers)
        if(CCMtx[3][12][3]==0) { //MATRIX = SWITCH FOR Lowest NOTE
          int Velos[16] = {}; //Array to hold all ON-Notes
		  int y;	for(y=0; y<16; ++y){
		  if(MtxLoad[y][3]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
          //find lowest velocity
          int minimum=127; int c; 
          for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
          velo[3] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[3] = velocity;}

//Kill Velocity-Ranges
      if( ( (velo[3] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[3] >=45)  && (velo[3] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[3] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[3] = velo[3] + CC; 
        if(velo[3] < 0){velo[3] = 1;}
        if(velo[3] > 127){velo[3] = 127;}      

//velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[3]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[3]   = inv; } //-97*-1 =  97

        //Send Trigger NoteOut
        if(TrigRandGate==1 || CCMtx[0][13][3]==0){   //CCMtx[3][13][x] = Does Random Kill have Effect?
	    MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[3], TrigOutNote[3], velo[3]);}

		//send Poly Melody NoteOut
        if(MeloRandGate==1 || CCMtx[0][13][3]==0){   //CCMtx[3][13][x] = Does Random Kill have Effect?
		  int buf=0;	for(buf=0; buf<10; ++buf) {			
		  if(NoteBuff[3][buf] > 0) {
            MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[3], NoteBuff[3][buf], velo[3]); MeloDecayTIMER[3][NoteBuff[3][buf]] = Decay;}}

        //set new Trigger and Indicator DECAY-Time
        DrumDecayTimer[3]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[3] <=44)                                {Color = 1;}
          if(velo[3] >=44 && velo[3] <= 89)               {Color = 2;}
          if(velo[3] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 3, 0, Color);}}}} //(blm, id, x, y, color) 


////////////////////////////////////////////////////////////////////                                   
//Trigger4 - Poly-Retrigger
   if(
      ( ((CCMtx[0][15][4]==1) && (AnySolo==0)) || (CCMtx[0][14][4]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [4]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [4]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [4]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [4]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [4]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [4]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [4]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [4]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [4]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [4]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][4]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][4]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][4]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][4]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][4]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][4]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [4]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [4]==1) && (note==1 ))   ||
            ((MtxLoad[2] [4]==1) && (note==2 ))   ||
            ((MtxLoad[3] [4]==1) && (note==3 ))   ||
            ((MtxLoad[4] [4]==1) && (note==4 ))   ||
            ((MtxLoad[5] [4]==1) && (note==5 ))   ||
            ((MtxLoad[6] [4]==1) && (note==6 ))   ||
            ((MtxLoad[7] [4]==1) && (note==7 ))   ||
            ((MtxLoad[8] [4]==1) && (note==8 ))   ||
            ((MtxLoad[9] [4]==1) && (note==9 ))   ||
            ((MtxLoad[10][4]==1) && (note==10))   ||
            ((MtxLoad[11][4]==1) && (note==11))   ||
            ((MtxLoad[12][4]==1) && (note==12))   ||
            ((MtxLoad[13][4]==1) && (note==13))   ||
            ((MtxLoad[14][4]==1) && (note==14))   ||
            ((MtxLoad[15][4]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[4][1] ==0) || (OverRoll ==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[4];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[4][12][4]==1) { //MATRIX = SWITCH FOR HIGHEST NOTE
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][4]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[4] = maximum;}

        //want to hear lowest note? get it! (since we use multiple triggers)
        if(CCMtx[4][12][4]==0) { //MATRIX = SWITCH FOR Lowest NOTE
          int Velos[16] = {}; //Array to hold all ON-Notes
		  int y;	for(y=0; y<16; ++y){
		  if(MtxLoad[y][4]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
          //find lowest velocity
          int minimum=127; int c; 
          for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
          velo[4] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[4] = velocity;}

//Kill Velocity-Ranges
      if( ( (velo[4] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[4] >=45)  && (velo[4] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[4] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[4] = velo[4] + CC; 
        if(velo[4] < 0){velo[4] = 1;}
        if(velo[4] > 127){velo[4] = 127;}      

//velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[4]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[4]   = inv; } //-97*-1 =  97

        //Send Trigger NoteOut
        if(TrigRandGate==1 || CCMtx[0][13][4]==0){   //CCMtx[4][13][x] = Does Random Kill have Effect?
	    MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[4], TrigOutNote[4], velo[4]);}

		//send Poly Melody NoteOut
        if(MeloRandGate==1 || CCMtx[0][13][4]==0){   //CCMtx[4][13][x] = Does Random Kill have Effect?
		  int buf=0;	for(buf=0; buf<10; ++buf) {			
		  if(NoteBuff[4][buf] > 0) {
            MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[4], NoteBuff[4][buf], velo[4]); MeloDecayTIMER[4][NoteBuff[4][buf]] = Decay;}}

        //set new Trigger and Indicator DECAY-Time
        DrumDecayTimer[4]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[4] <=44)                                {Color = 1;}
          if(velo[4] >=44 && velo[4] <= 89)               {Color = 2;}
          if(velo[4] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 4, 0, Color);}}}} //(blm, id, x, y, color) 


////////////////////////////////////////////////////////////////////                                   
//Trigger5 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][5]==1) && (AnySolo==0)) || (CCMtx[0][14][5]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [5]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [5]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [5]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [5]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [5]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [5]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [5]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [5]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [5]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [5]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][5]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][5]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][5]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][5]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][5]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][5]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [5]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [5]==1) && (note==1 ))   ||
            ((MtxLoad[2] [5]==1) && (note==2 ))   ||
            ((MtxLoad[3] [5]==1) && (note==3 ))   ||
            ((MtxLoad[4] [5]==1) && (note==4 ))   ||
            ((MtxLoad[5] [5]==1) && (note==5 ))   ||
            ((MtxLoad[6] [5]==1) && (note==6 ))   ||
            ((MtxLoad[7] [5]==1) && (note==7 ))   ||
            ((MtxLoad[8] [5]==1) && (note==8 ))   ||
            ((MtxLoad[9] [5]==1) && (note==9 ))   ||
            ((MtxLoad[10][5]==1) && (note==10))   ||
            ((MtxLoad[11][5]==1) && (note==11))   ||
            ((MtxLoad[12][5]==1) && (note==12))   ||
            ((MtxLoad[13][5]==1) && (note==13))   ||
            ((MtxLoad[14][5]==1) && (note==14))   ||
            ((MtxLoad[15][5]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[5][1]==0) || (OverRoll==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[5];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][5]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][5]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[5]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][5]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][5] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[5] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[5] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[5] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[5] >=45)  && (velo[5] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[5] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[5] = velo[5] + CC; 
        if(velo[5] < 0){velo[5] = 1;}
        if(velo[5] > 127){velo[5] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[5]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[5]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][5] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[5]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[5][n] > MeloOutNote[5]) { MeloOutNote[5] = NoteBuff[5][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][5] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[5] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[5][n] < MeloOutNote[5] && NoteBuff[5][n] > 0) { MeloOutNote[5] = NoteBuff[5][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[5] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][5]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[5], TrigOutNote[5], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[5], TrigOutNote[5], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[5], TrigOutNote[5], velo[5]);
        //set new DECAY-Time
        DrumDecayTimer[5]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][5]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], TrigOutOldNote[5], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], TrigOutOldNote[5], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[5], MeloOutNote[5], velo[5]);
        //set new DECAY-Time
        DrumDecayTimer[5]=Decay;
        
        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[5] <=44)                                {Color = 1;}
          if(velo[5] >=44 && velo[5] <= 89)               {Color = 2;}
          if(velo[5] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 5, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger6 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][6]==1) && (AnySolo==0)) || (CCMtx[0][14][6]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [6]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [6]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [6]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [6]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [6]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [6]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [6]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [6]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [6]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [6]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][6]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][6]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][6]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][6]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][6]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][6]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [6]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [6]==1) && (note==1 ))   ||
            ((MtxLoad[2] [6]==1) && (note==2 ))   ||
            ((MtxLoad[3] [6]==1) && (note==3 ))   ||
            ((MtxLoad[4] [6]==1) && (note==4 ))   ||
            ((MtxLoad[5] [6]==1) && (note==5 ))   ||
            ((MtxLoad[6] [6]==1) && (note==6 ))   ||
            ((MtxLoad[7] [6]==1) && (note==7 ))   ||
            ((MtxLoad[8] [6]==1) && (note==8 ))   ||
            ((MtxLoad[9] [6]==1) && (note==9 ))   ||
            ((MtxLoad[10][6]==1) && (note==10))   ||
            ((MtxLoad[11][6]==1) && (note==11))   ||
            ((MtxLoad[12][6]==1) && (note==12))   ||
            ((MtxLoad[13][6]==1) && (note==13))   ||
            ((MtxLoad[14][6]==1) && (note==14))   ||
            ((MtxLoad[15][6]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[6][1]==0) || (OverRoll==0)) {Decay = MonoDecay;} //EXTRA[1][0]=TrackRoll, , MonoDecay=Melody-Decay
		              else {Decay = MonoDecay * DecayMulti[6];} //No Roll - expandet Decaytime, MonoDecay=Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][6]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][6]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[6]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][6]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][6] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[6] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[6] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[6] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[6] >=45)  && (velo[6] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[6] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MonoVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[6] = velo[6] + CC; 
        if(velo[6] < 0){velo[6] = 1;}
        if(velo[6] > 127){velo[6] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[6]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[6]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][6] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[6]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[6][n] > MeloOutNote[6]) { MeloOutNote[6] = NoteBuff[6][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][6] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[6] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[6][n] < MeloOutNote[6] && NoteBuff[6][n] > 0) { MeloOutNote[6] = NoteBuff[6][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[6] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][6]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[6], TrigOutNote[6], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[6], TrigOutNote[6], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[6], TrigOutNote[6], velo[6]);
        //set new DECAY-Time
        DrumDecayTimer[6]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][6]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], TrigOutOldNote[6], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], TrigOutOldNote[6], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[6], MeloOutNote[6], velo[6]);
        //set new DECAY-Time
        DrumDecayTimer[6]=Decay;
        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[6] <=44)                                {Color = 1;}
          if(velo[6] >=44 && velo[6] <= 89)               {Color = 2;}
          if(velo[6] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 6, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger7 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][7]==1) && (AnySolo==0)) || (CCMtx[0][14][7]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [7]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [7]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [7]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [7]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [7]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [7]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [7]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [7]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [7]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [7]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][7]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][7]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][7]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][7]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][7]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][7]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [7]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [7]==1) && (note==1 ))   ||
            ((MtxLoad[2] [7]==1) && (note==2 ))   ||
            ((MtxLoad[3] [7]==1) && (note==3 ))   ||
            ((MtxLoad[4] [7]==1) && (note==4 ))   ||
            ((MtxLoad[5] [7]==1) && (note==5 ))   ||
            ((MtxLoad[6] [7]==1) && (note==6 ))   ||
            ((MtxLoad[7] [7]==1) && (note==7 ))   ||
            ((MtxLoad[8] [7]==1) && (note==8 ))   ||
            ((MtxLoad[9] [7]==1) && (note==9 ))   ||
            ((MtxLoad[10][7]==1) && (note==10))   ||
            ((MtxLoad[11][7]==1) && (note==11))   ||
            ((MtxLoad[12][7]==1) && (note==12))   ||
            ((MtxLoad[13][7]==1) && (note==13))   ||
            ((MtxLoad[14][7]==1) && (note==14))   ||
            ((MtxLoad[15][7]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[7][1]==0) || (OverRoll==0)) {Decay = MonoDecay;} //EXTRA[1][0]=TrackRoll, , MonoDecay=Melody-Decay
		              else {Decay = MonoDecay * DecayMulti[7];} //No Roll - expandet Decaytime, MonoDecay=Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][7]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][7]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[7]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][7]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][7] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[7] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[7] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[7] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[7] >=45)  && (velo[7] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[7] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MonoVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[7] = velo[7] + CC; 
        if(velo[7] < 0){velo[7] = 1;}
        if(velo[7] > 127){velo[7] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[7]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[7]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][7] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[7]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[7][n] > MeloOutNote[7]) { MeloOutNote[7] = NoteBuff[7][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][7] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[7] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[7][n] < MeloOutNote[7] && NoteBuff[7][n] > 0) { MeloOutNote[7] = NoteBuff[7][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[7] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][7]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[7], TrigOutNote[7], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[7], TrigOutNote[7], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[7], TrigOutNote[7], velo[7]);
        //set new DECAY-Time
        DrumDecayTimer[7]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][7]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], TrigOutOldNote[7], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], TrigOutOldNote[7], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[7], MeloOutNote[7], velo[7]);
        //set new DECAY-Time
        DrumDecayTimer[7]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[7] <=44)                                {Color = 1;}
          if(velo[7] >=44 && velo[7] <= 89)               {Color = 2;}
          if(velo[7] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 7, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger8 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][8]==1) && (AnySolo==0)) || (CCMtx[0][14][8]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [8]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [8]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [8]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [8]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [8]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [8]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [8]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [8]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [8]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [8]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][8]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][8]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][8]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][8]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][8]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][8]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [8]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [8]==1) && (note==1 ))   ||
            ((MtxLoad[2] [8]==1) && (note==2 ))   ||
            ((MtxLoad[3] [8]==1) && (note==3 ))   ||
            ((MtxLoad[4] [8]==1) && (note==4 ))   ||
            ((MtxLoad[5] [8]==1) && (note==5 ))   ||
            ((MtxLoad[6] [8]==1) && (note==6 ))   ||
            ((MtxLoad[7] [8]==1) && (note==7 ))   ||
            ((MtxLoad[8] [8]==1) && (note==8 ))   ||
            ((MtxLoad[9] [8]==1) && (note==9 ))   ||
            ((MtxLoad[10][8]==1) && (note==10))   ||
            ((MtxLoad[11][8]==1) && (note==11))   ||
            ((MtxLoad[12][8]==1) && (note==12))   ||
            ((MtxLoad[13][8]==1) && (note==13))   ||
            ((MtxLoad[14][8]==1) && (note==14))   ||
            ((MtxLoad[15][8]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[8][1]==0) || (OverRoll==0)) {Decay = MonoDecay;} //EXTRA[1][0]=TrackRoll, , MonoDecay=Melody-Decay
		              else {Decay = MonoDecay * DecayMulti[8];} //No Roll - expandet Decaytime, MonoDecay=Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][8]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][8]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[8]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][8]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][8] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[8] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[8] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[8] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[8] >=45)  && (velo[8] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[8] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MonoVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[8] = velo[8] + CC; 
        if(velo[8] < 0){velo[8] = 1;}
        if(velo[8] > 127){velo[8] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[8]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[8]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][8] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[8]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[8][n] > MeloOutNote[8]) { MeloOutNote[8] = NoteBuff[8][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][8] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[8] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[8][n] < MeloOutNote[8] && NoteBuff[8][n] > 0) { MeloOutNote[8] = NoteBuff[8][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[8] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][8]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[8], TrigOutNote[8], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[8], TrigOutNote[8], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[8], TrigOutNote[8], velo[8]);
        //set new DECAY-Time
        DrumDecayTimer[8]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][8]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[8], TrigOutOldNote[8], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[8], TrigOutOldNote[8], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[8], MeloOutNote[8], velo[8]);
        //set new DECAY-Time
        DrumDecayTimer[8]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[8] <=44)                                {Color = 1;}
          if(velo[8] >=44 && velo[8] <= 89)               {Color = 2;}
          if(velo[8] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 8, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger9 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][9]==1) && (AnySolo==0)) || (CCMtx[0][14][9]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [9]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [9]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [9]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [9]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [9]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [9]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [9]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [9]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [9]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [9]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][9]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][9]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][9]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][9]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][9]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][9]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [9]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [9]==1) && (note==1 ))   ||
            ((MtxLoad[2] [9]==1) && (note==2 ))   ||
            ((MtxLoad[3] [9]==1) && (note==3 ))   ||
            ((MtxLoad[4] [9]==1) && (note==4 ))   ||
            ((MtxLoad[5] [9]==1) && (note==5 ))   ||
            ((MtxLoad[6] [9]==1) && (note==6 ))   ||
            ((MtxLoad[7] [9]==1) && (note==7 ))   ||
            ((MtxLoad[8] [9]==1) && (note==8 ))   ||
            ((MtxLoad[9] [9]==1) && (note==9 ))   ||
            ((MtxLoad[10][9]==1) && (note==10))   ||
            ((MtxLoad[11][9]==1) && (note==11))   ||
            ((MtxLoad[12][9]==1) && (note==12))   ||
            ((MtxLoad[13][9]==1) && (note==13))   ||
            ((MtxLoad[14][9]==1) && (note==14))   ||
            ((MtxLoad[15][9]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[9][1]==0) || (OverRoll==0)) {Decay = MonoDecay;} //EXTRA[1][0]=TrackRoll, , MonoDecay=Melody-Decay
		              else {Decay = MonoDecay * DecayMulti[9];} //No Roll - expandet Decaytime, MonoDecay=Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][9]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][9]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[9]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][9]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][9] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[9] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[9] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[9] <=44)  && (VeloKill[0] == 1))                     ||
          (((velo[9] >=45)  && (velo[9] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[9] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MonoVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[9] = velo[9] + CC; 
        if(velo[9] < 0){velo[9] = 1;}
        if(velo[9] > 127){velo[9] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[9]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[9]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][9] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[9]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[9][n] > MeloOutNote[9]) { MeloOutNote[9] = NoteBuff[9][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][9] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[9] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[9][n] < MeloOutNote[9] && NoteBuff[9][n] > 0) { MeloOutNote[9] = NoteBuff[9][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[9] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][9]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[9], TrigOutNote[9], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[9], TrigOutNote[9], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[9], TrigOutNote[9], velo[9]);
        //set new DECAY-Time
        DrumDecayTimer[9]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][9]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[9], TrigOutOldNote[9], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[9], TrigOutOldNote[9], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[9], MeloOutNote[9], velo[9]);
        //set new DECAY-Time
        DrumDecayTimer[9]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[9] <=44)                                {Color = 1;}
          if(velo[9] >=44 && velo[9] <= 89)               {Color = 2;}
          if(velo[9] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 9, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger10 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][10]==1) && (AnySolo==0)) || (CCMtx[0][14][10]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [10]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [10]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [10]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [10]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [10]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [10]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [10]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [10]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [10]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [10]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][10]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][10]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][10]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][10]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][10]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][10]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [10]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [10]==1) && (note==1 ))   ||
            ((MtxLoad[2] [10]==1) && (note==2 ))   ||
            ((MtxLoad[3] [10]==1) && (note==3 ))   ||
            ((MtxLoad[4] [10]==1) && (note==4 ))   ||
            ((MtxLoad[5] [10]==1) && (note==5 ))   ||
            ((MtxLoad[6] [10]==1) && (note==6 ))   ||
            ((MtxLoad[7] [10]==1) && (note==7 ))   ||
            ((MtxLoad[8] [10]==1) && (note==8 ))   ||
            ((MtxLoad[9] [10]==1) && (note==9 ))   ||
            ((MtxLoad[10][10]==1) && (note==10))   ||
            ((MtxLoad[11][10]==1) && (note==11))   ||
            ((MtxLoad[12][10]==1) && (note==12))   ||
            ((MtxLoad[13][10]==1) && (note==13))   ||
            ((MtxLoad[14][10]==1) && (note==14))   ||
            ((MtxLoad[15][10]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[10][1]==0) || (OverRoll==0)) {Decay = MonoDecay;} //EXTRA[1][0]=TrackRoll, , MonoDecay=Melody-Decay
		              else {Decay = MonoDecay * DecayMulti[10];} //No Roll - expandet Decaytime, MonoDecay=Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][10]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][10]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[10]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][10]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][10] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[10] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[10] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[10] <=44)  && (VeloKill[0] == 1))                      ||
          (((velo[10] >=45)  && (velo[10] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[10] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MonoVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[10] = velo[10] + CC; 
        if(velo[10] < 0){velo[10] = 1;}
        if(velo[10] > 127){velo[10] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[10]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[10]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][10] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[10]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[10][n] > MeloOutNote[10]) { MeloOutNote[10] = NoteBuff[10][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][10] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[10] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[10][n] < MeloOutNote[10] && NoteBuff[10][n] > 0) { MeloOutNote[10] = NoteBuff[10][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[10] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][10]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[10], TrigOutNote[10], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[10], TrigOutNote[10], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[10], TrigOutNote[10], velo[10]);
        //set new DECAY-Time
        DrumDecayTimer[10]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][10]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[10], TrigOutOldNote[10], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[10], TrigOutOldNote[10], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[10], MeloOutNote[10], velo[10]);
        //set new DECAY-Time
        DrumDecayTimer[10]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[10] <=44)                                {Color = 1;}
          if(velo[10] >=44 && velo[10] <= 89)               {Color = 2;}
          if(velo[10] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 10, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger11 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][11]==1) && (AnySolo==0)) || (CCMtx[0][14][11]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [11]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [11]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [11]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [11]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [11]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [11]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [11]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [11]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [11]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [11]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][11]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][11]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][11]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][11]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][11]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][11]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [11]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [11]==1) && (note==1 ))   ||
            ((MtxLoad[2] [11]==1) && (note==2 ))   ||
            ((MtxLoad[3] [11]==1) && (note==3 ))   ||
            ((MtxLoad[4] [11]==1) && (note==4 ))   ||
            ((MtxLoad[5] [11]==1) && (note==5 ))   ||
            ((MtxLoad[6] [11]==1) && (note==6 ))   ||
            ((MtxLoad[7] [11]==1) && (note==7 ))   ||
            ((MtxLoad[8] [11]==1) && (note==8 ))   ||
            ((MtxLoad[9] [11]==1) && (note==9 ))   ||
            ((MtxLoad[10][11]==1) && (note==10))   ||
            ((MtxLoad[11][11]==1) && (note==11))   ||
            ((MtxLoad[12][11]==1) && (note==12))   ||
            ((MtxLoad[13][11]==1) && (note==13))   ||
            ((MtxLoad[14][11]==1) && (note==14))   ||
            ((MtxLoad[15][11]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[11][1]==0) || (OverRoll==0)) {Decay = MonoDecay;} //EXTRA[1][0]=TrackRoll, , MonoDecay=Melody-Decay
		              else {Decay = MonoDecay * DecayMulti[11];} //No Roll - expandet Decaytime, MonoDecay=Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][11]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][11]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[11]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][11]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][11] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[11] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[11] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[11] <=44)  && (VeloKill[0] == 1))                      ||
          (((velo[11] >=45)  && (velo[11] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[11] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MonoVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[11] = velo[11] + CC; 
        if(velo[11] < 0){velo[11] = 1;}
        if(velo[11] > 127){velo[11] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[11]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[11]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][11] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[11]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[11][n] > MeloOutNote[11]) { MeloOutNote[11] = NoteBuff[11][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][11] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[11] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[11][n] < MeloOutNote[11] && NoteBuff[11][n] > 0) { MeloOutNote[11] = NoteBuff[11][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[11] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][11]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[11], TrigOutNote[11], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[11], TrigOutNote[11], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[11], TrigOutNote[11], velo[11]);
        //set new DECAY-Time
        DrumDecayTimer[11]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][11]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[11], TrigOutOldNote[11], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[11], TrigOutOldNote[11], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[11], MeloOutNote[11], velo[11]);
        //set new DECAY-Time
        DrumDecayTimer[11]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[11] <=44)                                {Color = 1;}
          if(velo[11] >=44 && velo[11] <= 89)               {Color = 2;}
          if(velo[11] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 11, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger12 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][12]==1) && (AnySolo==0)) || (CCMtx[0][14][12]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [12]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [12]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [12]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [12]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [12]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [12]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [12]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [12]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [12]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [12]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][12]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][12]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][12]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][12]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][12]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][12]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [12]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [12]==1) && (note==1 ))   ||
            ((MtxLoad[2] [12]==1) && (note==2 ))   ||
            ((MtxLoad[3] [12]==1) && (note==3 ))   ||
            ((MtxLoad[4] [12]==1) && (note==4 ))   ||
            ((MtxLoad[5] [12]==1) && (note==5 ))   ||
            ((MtxLoad[6] [12]==1) && (note==6 ))   ||
            ((MtxLoad[7] [12]==1) && (note==7 ))   ||
            ((MtxLoad[8] [12]==1) && (note==8 ))   ||
            ((MtxLoad[9] [12]==1) && (note==9 ))   ||
            ((MtxLoad[10][12]==1) && (note==10))   ||
            ((MtxLoad[11][12]==1) && (note==11))   ||
            ((MtxLoad[12][12]==1) && (note==12))   ||
            ((MtxLoad[13][12]==1) && (note==13))   ||
            ((MtxLoad[14][12]==1) && (note==14))   ||
            ((MtxLoad[15][12]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[12][1]==0) || (OverRoll==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[12];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][12]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][12]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[12]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][12]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][12] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[12] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[12] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[12] <=44)  && (VeloKill[0] == 1))                      ||
          (((velo[12] >=45)  && (velo[12] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[12] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[12] = velo[12] + CC; 
        if(velo[12] < 0){velo[12] = 1;}
        if(velo[12] > 127){velo[12] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[12]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[12]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][12] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[12]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[12][n] > MeloOutNote[12]) { MeloOutNote[12] = NoteBuff[12][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][12] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[12] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[12][n] < MeloOutNote[12] && NoteBuff[12][n] > 0) { MeloOutNote[12] = NoteBuff[12][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[12] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][12]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[12], TrigOutNote[12], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[12], TrigOutNote[12], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[12], TrigOutNote[12], velo[12]);
        //set new DECAY-Time
        DrumDecayTimer[12]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][12]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[12], TrigOutOldNote[12], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[12], TrigOutOldNote[12], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[12], MeloOutNote[12], velo[12]);
        //set new DECAY-Time
        DrumDecayTimer[12]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[12] <=44)                                {Color = 1;}
          if(velo[12] >=44 && velo[12] <= 89)               {Color = 2;}
          if(velo[12] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 12, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger13 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][13]==1) && (AnySolo==0)) || (CCMtx[0][14][13]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [13]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [13]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [13]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [13]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [13]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [13]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [13]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [13]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [13]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [13]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][13]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][13]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][13]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][13]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][13]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][13]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [13]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [13]==1) && (note==1 ))   ||
            ((MtxLoad[2] [13]==1) && (note==2 ))   ||
            ((MtxLoad[3] [13]==1) && (note==3 ))   ||
            ((MtxLoad[4] [13]==1) && (note==4 ))   ||
            ((MtxLoad[5] [13]==1) && (note==5 ))   ||
            ((MtxLoad[6] [13]==1) && (note==6 ))   ||
            ((MtxLoad[7] [13]==1) && (note==7 ))   ||
            ((MtxLoad[8] [13]==1) && (note==8 ))   ||
            ((MtxLoad[9] [13]==1) && (note==9 ))   ||
            ((MtxLoad[10][13]==1) && (note==10))   ||
            ((MtxLoad[11][13]==1) && (note==11))   ||
            ((MtxLoad[12][13]==1) && (note==12))   ||
            ((MtxLoad[13][13]==1) && (note==13))   ||
            ((MtxLoad[14][13]==1) && (note==14))   ||
            ((MtxLoad[15][13]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[13][1]==0) || (OverRoll==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[13];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][13]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][13]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[13]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][13]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][13] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[13] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[13] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[13] <=44)  && (VeloKill[0] == 1))                      ||
          (((velo[13] >=45)  && (velo[13] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[13] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[13] = velo[13] + CC; 
        if(velo[13] < 0){velo[13] = 1;}
        if(velo[13] > 127){velo[13] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[13]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[13]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][13] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[13]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[13][n] > MeloOutNote[13]) { MeloOutNote[13] = NoteBuff[13][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][13] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[13] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[13][n] < MeloOutNote[13] && NoteBuff[13][n] > 0) { MeloOutNote[13] = NoteBuff[13][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[13] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][13]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[13], TrigOutNote[13], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[13], TrigOutNote[13], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[13], TrigOutNote[13], velo[13]);
        //set new DECAY-Time
        DrumDecayTimer[13]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][13]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[13], TrigOutOldNote[13], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[13], TrigOutOldNote[13], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[13], MeloOutNote[13], velo[13]);
        //set new DECAY-Time
        DrumDecayTimer[13]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[13] <=44)                                {Color = 1;}
          if(velo[13] >=44 && velo[13] <= 89)               {Color = 2;}
          if(velo[13] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 13, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger14 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][14]==1) && (AnySolo==0)) || (CCMtx[0][14][14]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [14]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [14]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [14]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [14]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [14]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [14]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [14]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [14]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [14]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [14]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][14]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][14]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][14]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][14]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][14]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][14]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [14]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [14]==1) && (note==1 ))   ||
            ((MtxLoad[2] [14]==1) && (note==2 ))   ||
            ((MtxLoad[3] [14]==1) && (note==3 ))   ||
            ((MtxLoad[4] [14]==1) && (note==4 ))   ||
            ((MtxLoad[5] [14]==1) && (note==5 ))   ||
            ((MtxLoad[6] [14]==1) && (note==6 ))   ||
            ((MtxLoad[7] [14]==1) && (note==7 ))   ||
            ((MtxLoad[8] [14]==1) && (note==8 ))   ||
            ((MtxLoad[9] [14]==1) && (note==9 ))   ||
            ((MtxLoad[10][14]==1) && (note==10))   ||
            ((MtxLoad[11][14]==1) && (note==11))   ||
            ((MtxLoad[12][14]==1) && (note==12))   ||
            ((MtxLoad[13][14]==1) && (note==13))   ||
            ((MtxLoad[14][14]==1) && (note==14))   ||
            ((MtxLoad[15][14]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[14][1]==0) || (OverRoll==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[14];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][14]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][14]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[14]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][14]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][14] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[14] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[14] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[14] <=44)  && (VeloKill[0] == 1))                      ||
          (((velo[14] >=45)  && (velo[14] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[14] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[14] = velo[14] + CC; 
        if(velo[14] < 0){velo[14] = 1;}
        if(velo[14] > 127){velo[14] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[14]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[14]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][14] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[14]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[14][n] > MeloOutNote[14]) { MeloOutNote[14] = NoteBuff[14][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][14] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[14] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[14][n] < MeloOutNote[14] && NoteBuff[14][n] > 0) { MeloOutNote[14] = NoteBuff[14][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[14] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][14]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[14], TrigOutNote[14], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[14], TrigOutNote[14], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[14], TrigOutNote[14], velo[14]);
        //set new DECAY-Time
        DrumDecayTimer[14]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][14]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[14], TrigOutOldNote[14], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[14], TrigOutOldNote[14], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[14], MeloOutNote[14], velo[14]);
        //set new DECAY-Time
        DrumDecayTimer[14]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[14] <=44)                                {Color = 1;}
          if(velo[14] >=44 && velo[14] <= 89)               {Color = 2;}
          if(velo[14] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 14, 0, Color);}}}}} //(blm, id, x, y, color) 

////////////////////////////////////////////////////////////////////                                   
//Trigger15 - MonoRetrigger - Bass/Pitchable Drums
   if(
      ( ((CCMtx[0][15][15]==1) && (AnySolo==0)) || (CCMtx[0][14][15]==1)) &&  
        (((port == 0) &&  //InternalStepSequencer Input
          ( ((MtxLoad[0] [15]==1) && (Seq[0] [step]>0) && (SeqTicDelay[0] == tic))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [15]==1) && (Seq[1] [step]>0) && (SeqTicDelay[1] == tic))   ||
            ((MtxLoad[2] [15]==1) && (Seq[2] [step]>0) && (SeqTicDelay[2] == tic))   ||
            ((MtxLoad[3] [15]==1) && (Seq[3] [step]>0) && (SeqTicDelay[3] == tic))   ||
            ((MtxLoad[4] [15]==1) && (Seq[4] [step]>0) && (SeqTicDelay[4] == tic))   ||
            ((MtxLoad[5] [15]==1) && (Seq[5] [step]>0) && (SeqTicDelay[5] == tic))   ||
            ((MtxLoad[6] [15]==1) && (Seq[6] [step]>0) && (SeqTicDelay[6] == tic))   ||
            ((MtxLoad[7] [15]==1) && (Seq[7] [step]>0) && (SeqTicDelay[7] == tic))   ||
            ((MtxLoad[8] [15]==1) && (Seq[8] [step]>0) && (SeqTicDelay[8] == tic))   ||
            ((MtxLoad[9] [15]==1) && (Seq[9] [step]>0) && (SeqTicDelay[9] == tic))   ||
            ((MtxLoad[10][15]==1) && (Seq[10][step]>0) && (SeqTicDelay[10] == tic))  ||
            ((MtxLoad[11][15]==1) && (Seq[11][step]>0) && (SeqTicDelay[11] == tic))  ||
            ((MtxLoad[12][15]==1) && (Seq[12][step]>0) && (SeqTicDelay[12] == tic))  ||
            ((MtxLoad[13][15]==1) && (Seq[13][step]>0) && (SeqTicDelay[13] == tic))  ||
            ((MtxLoad[14][15]==1) && (Seq[14][step]>0) && (SeqTicDelay[14] == tic))  ||
            ((MtxLoad[15][15]==1) && (Seq[15][step]>0) && (SeqTicDelay[15] == tic))  ||
            (OverRoll==0) ))
            || 
        ((port == 1) && //Midi Input
         (  ((MtxLoad[0] [15]==1) && (note==0 ))   || //a router cell active? && any Note in Sequencer Step? OR MidiInputNote?
            ((MtxLoad[1] [15]==1) && (note==1 ))   ||
            ((MtxLoad[2] [15]==1) && (note==2 ))   ||
            ((MtxLoad[3] [15]==1) && (note==3 ))   ||
            ((MtxLoad[4] [15]==1) && (note==4 ))   ||
            ((MtxLoad[5] [15]==1) && (note==5 ))   ||
            ((MtxLoad[6] [15]==1) && (note==6 ))   ||
            ((MtxLoad[7] [15]==1) && (note==7 ))   ||
            ((MtxLoad[8] [15]==1) && (note==8 ))   ||
            ((MtxLoad[9] [15]==1) && (note==9 ))   ||
            ((MtxLoad[10][15]==1) && (note==10))   ||
            ((MtxLoad[11][15]==1) && (note==11))   ||
            ((MtxLoad[12][15]==1) && (note==12))   ||
            ((MtxLoad[13][15]==1) && (note==13))   ||
            ((MtxLoad[14][15]==1) && (note==14))   ||
            ((MtxLoad[15][15]==1) && (note==15))   ||
            (OverRoll==0) ))      ))

     {  //Trigger NoteOn - Start NoteOff-timer (Decaytime)
		if((EXTRA[15][1]==0) || (OverRoll==0)) {Decay = MeloDecay ;} //EXTRA[1][0]=TrackRoll, , MeloDecay =Melody-Decay
		              else {Decay = MeloDecay  * DecayMulti[15];} //No Roll - expandet Decaytime, MeloDecay =Melody-Decay-Time

        //want to hear highest velocity? get it! (since we use multiple triggers)
        if(port == 0) {//Internal Sequencer Port
          if(CCMtx[0][12][15]==1) { //MATRIX = SWITCH FOR HIGHEST Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][15]==1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find highest velocity
            int maximum=0; int c; 
            for (c=0; c<16; c++) { if (Velos[c] > maximum) { maximum = Velos[c];}}
            velo[15]= maximum;}

  //want to hear lowest note? get it! (since we use multiple triggers)
          if(CCMtx[0][12][15]==0) { //MATRIX = SWITCH FOR Lowest Drum-Velocity
            int Velos[16] = {}; //Array to hold all ON-Notes
		    int y;	for(y=0; y<16; ++y){
		    if(MtxLoad[y][15] == 1 && Seq[y][step] > 0) {Velos[y] = Seq[y][step];}}//write all Velocitys in a Array
            //find lowest velocity
            int minimum=127; int c; 
            for (c=0; c<16; c++) { if (Velos[c] < minimum && Velos[c] > 0) { minimum = Velos[c];}}
            velo[15] = minimum;}}

        //Set Velocity from External Source
        if(port == 1) {//External Sequencer Port / Midi Port (real Drummer)
            velo[15] = velocity;}

  //Kill Velocity-Ranges
      if( ( (velo[15] <=44)  && (VeloKill[0] == 1))                      ||
          (((velo[15] >=45)  && (velo[15] <= 89)) && (VeloKill[1] == 1)) ||
          ( (velo[15] >=90)  && (VeloKill[2] == 1))) {
	
  //velocity + velocity offset
        s16 CC = ((4*MeloVelo ) - 256); //@64=orginal, @0=velo-64, @127=velo+64 //MonoVelo  = Velocity-Offset-Rotary 4 Drums
        
        velo[15] = velo[15] + CC; 
        if(velo[15] < 0){velo[15] = 1;}
        if(velo[15] > 127){velo[15] = 127;}  

  //velocity invert
        if(VeloInvert == 1) { //VeloInvert = Velocity Invert Button
		s16 VelInvCalc;          //to calculate the velocity invert Value (since unsigned velocity is 0-127, and invert have negative values...)
		s16 inv;
        VelInvCalc = velo[15]-127;    //30-127 = -97
        inv = VelInvCalc*-1;
        if(inv <= 0)  {inv = 1;}
  else if(inv > 127) {inv = 127;}
        velo[15]   = inv; } //-97*-1 =  97


//MONO NOTE HI-LO
  //highest Melody Note:
        if(CCMtx[0][11][15] == 1) { //MATRIX = SWITCH "HIGHEST NOTE"
		MeloOutNote[15]=0; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[15][n] > MeloOutNote[15]) { MeloOutNote[15] = NoteBuff[15][n];}}}

   //lowest Melody Note:
        if(CCMtx[0][11][15] == 0) { //MATRIX = SWITCH "HIGHEST NOTE"
	    MeloOutNote[15] = 127; int n; 
          for (n=0; n<10; n++) { if ( NoteBuff[15][n] < MeloOutNote[15] && NoteBuff[15][n] > 0) { MeloOutNote[15] = NoteBuff[15][n];}}}
          
  //send NoteOut		
		if(MeloOutNote[15] > 0)  {

        //TriggerChannel
        if(TrigRandGate==1 || CCMtx[0][13][15]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
        //NOTE OFFs
	    MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[15], TrigOutNote[15], 0);
	    MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[15], TrigOutNote[15], 0);
        //NOTE ON
        MIOS32_MIDI_SendNoteOn(TrigPortOUT, TrigOutCh[15], TrigOutNote[15], velo[15]);
        //set new DECAY-Time
        DrumDecayTimer[15]=Decay;}

		//MonoMelodyChannel
        if(MonoRandGate==1 || CCMtx[0][13][15]==0){   //CCMtx[0][13][x] = Does Random Kill have Effect?
		//Send the Old Note   OFF   out...
        MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[15], TrigOutOldNote[15], 0); //Port, Chn, Note, Velocity 
        MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[15], TrigOutOldNote[15], 0); //Turn OFF Trigger Notes
        //Send New Note Out
	    MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[15], MeloOutNote[15], velo[15]);
        //set new DECAY-Time
        DrumDecayTimer[15]=Decay;

        //send BLM LEDs >Trigger Indicator<
        if( MatrixUse == 2 || MatrixUse == 3 ) {
			      //Set  Trigger Indicate LED Color (velocity depending)
          int Color = 1;
          if(velo[15] <=44)                                {Color = 1;}
          if(velo[15] >=44 && velo[15] <= 89)               {Color = 2;}
          if(velo[15] >=90)                                {Color = 3;}
		  BLM_SCALAR_MASTER_LED_Set(ID, 1, 15, 0, Color);}}}}} //(blm, id, x, y, color) 

//End-drum-trigger
  return 0; // no error,
    }

static void TASK_Period1mS(void *pvParameters){    //called @1mS rate   used for BLM
  portTickType xLastExecutionTime;
  xLastExecutionTime = xTaskGetTickCount();   // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // skip delay gap if we had to wait for more than 5 ticks to avoid 
    // unnecessary repeats until xLastExecutionTime reached xTaskGetTickCount() again
    portTickType xCurrentTickCount = xTaskGetTickCount();
    if( xLastExecutionTime < (xCurrentTickCount-5) )
      xLastExecutionTime = xCurrentTickCount;

    // call BLM handler, e.g. to send LED updates
    BLM_SCALAR_MASTER_Periodic_mS();
  }
}

// Function to take/give MIDI OUT Semaphore
void TASKS_MUTEX_MIDIOUT_Take(void){               //(such as BLM_SCALAR_MASTER) mios32_defines.h provides special macros which call this function,
  if( xMIDIOUTSemaphore ) {
    while( xSemaphoreTakeRecursive(xMIDIOUTSemaphore, (portTickType)1) != pdTRUE );
  }
}

void TASKS_MUTEX_MIDIOUT_Give(void){
  if( xMIDIOUTSemaphore ) {
    xSemaphoreGiveRecursive(xMIDIOUTSemaphore);
  }
}

static void StoreLoad(u8 tick, u16 order){         //Display MENUE, Store+Load Bank & Sys-Config
if(LCD0Page <= 4) {//0-3 Song Depending,  >3:System-Setting-Mode	
	//STORE
    if(tick == 1 && order == 2){//Store Data & update the Load NR & Name													
      MUTEX_SDCARD_TAKE;  statusSD = FILE_CheckSDCard();   MUTEX_SDCARD_GIVE;      //SDC-Connected?
      if(statusSD != 0)  {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString       ("%s %d", "CANT-SAVE-Status:", statusSD);}
      if(statusSD == 0) {                                                          // YES CARD!  >>> next: check Card-content 
          MUTEX_SDCARD_TAKE; statusDir = FILE_DirExists("tm"); MUTEX_SDCARD_GIVE;   //ask/call file.c: exist a folder "t/" on the CARD?
           if(statusDir == 0) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString ("%s", "Invalid File Structure>Reconnect Card");}
           if(statusDir == 1) {
           //WRITE  Variables in Array
           CC_SD[0]=VeloKill[0];
           CC_SD[1]=VeloKill[1];
           CC_SD[2]=VeloKill[2];
           CC_SD[3]=VeloInvert;
           CC_SD[4]=PageFirst;
           CC_SD[5]=PageLast;
           CC_SD[6]=Page;
           CC_SD[7]=StepPerPage;
           CC_SD[8]=direction;
           CC_SD[9]=LoopLengthBtn;
           CC_SD[10]=SyncType;
           CC_SD[11]=SyncRate;
           CC_SD[12]=MainLoop;
           CC_SD[13]=btn ;
           CC_SD[14]=EncPage;
           CC_SD[15]=VelSel;
           CC_SD[16]=VelSelValue[0];
           CC_SD[17]=VelSelValue[1];
           CC_SD[18]=VelSelValue[2];
           CC_SD[19]=StepVelo;
           CC_SD[20]=MatrixUse ;
           CC_SD[21]=focusMatrixUse[0];
           CC_SD[22]=focusMatrixUse[1];
           CC_SD[23]=focusMatrixUse[2];
           CC_SD[24]=focusMatrixUse[3];
           CC_SD[25]=MainDelay;
           CC_SD[26]=Swing16th;
           CC_SD[27]=Swing8th;
           CC_SD[28]=SwingSwitch;
           CC_SD[29]=PpqnDividerCount;
           CC_SD[30]=BaseTicCount;
           CC_SD[31]=BPM;
           CC_SD[32]=Rythm;
           CC_SD[33]=RythmRepeat;
           CC_SD[34]=AutQuntActive;
           CC_SD[35]=QuantRate;
           CC_SD[36]=intro;
           CC_SD[37]=Fullvelo;
           CC_SD[38]=MeloKILL;
           CC_SD[39]=MeloDecay;
           CC_SD[40]=MeloVelo;
           CC_SD[41]=MonoKILL;
           CC_SD[42]=MonoDecay;
           CC_SD[43]=MonoVelo;
           CC_SD[44]=TrigKILL;

             MUTEX_SDCARD_TAKE;  
					sprintf(filepathS, "tm/%d.tm", SongNrStor);        //First Pattern --- will be later copied 511 times!	
						FILE_WriteOpen	(filepathS, 1);                //WRITE!!!!
							FILE_WriteBuffer((u8  *)file_typeBank,  4);  //"TM01" = 4 Positons
							FILE_WriteBuffer((u8  *)SongNameStore,  8);  //"A        " = 8 Positons
							FILE_WriteBuffer((u8  *)PCBank,        16);  //ProgramChangeBank
							FILE_WriteBuffer((u8  *)CCBank4,       64);  //16x4=64 Virtuel Encoders
							FILE_WriteBuffer((u8  *)EXTRA,         32);  //2x16=32 BLM-X-Y-Extra-Buttons
                            FILE_WriteBuffer((u8  *)MtxFunction, 4096);  //16x16x16=4096 - Placeholder for Future updates
                            FILE_WriteBuffer((u8  *)MATRIX,      4352);  //16x16x17 =4352 - Routing - Matrices
                            FILE_WriteBuffer((u8  *)Seq,         4608);  //18x256  =4608 - Step-Sequencer-Matrix
                            FILE_WriteBuffer((u8  *)SeqTic,      4608);  //18x256  =4608 - Step-Sequencer-TicOffset-Matrix 4 Seq[x][y]
                            FILE_WriteBuffer((u8  *)NoteBuff,     160);  //16x10    =160   - MelodyRetriggerNoteBuffer (last played notes)
                            FILE_WriteBuffer((u8  *)CC_SD,        128);  // ALL OTHER VARIABLES are saved in this ARRAY (CC_SD[128])
                            FILE_WriteBuffer((u8  *)CCMtx,       4096);  //16x16x16=4096 - Matrix as CC controller
                            FILE_WriteBuffer((u8  *)SONG,         512);  //16x32=512 - SONG-Parts
                     FILE_WriteClose	();                          //The First File named "0" is locatet @ SDCARD/t/0.tm, now its time to copy this 511 times, I want 511 Banks/files
             MUTEX_SDCARD_GIVE;                                   //SD-Card is now free 4 access
             MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString	("%s", "stored!"); MUTEX_LCD_GIVE; MenueUpdateFlag = 0;}}}//menue Updateflag 2 restore after some time the menue

    //LOAD
    if(tick == 1 && order == 1){//Load Data & update the Load NR & Name and also Store Nr & Store Name
      MUTEX_SDCARD_TAKE;  statusDir = FILE_DirExists("tm"); MUTEX_SDCARD_GIVE;
      if(statusDir != 1) {MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString	("%s %d", "CANT-LOAD-PATCH-Status:", statusDir); MUTEX_LCD_GIVE;}
      if(statusDir == 1) {
		   sprintf(filepathL, "tm/%d.tm", SongNrLoad);
           FILE_ReadOpen	(&midifile_fi, filepathL);
           FILE_ReadBuffer	((u8  *)file_typeBank,  4); 	
           FILE_ReadBuffer	((u8  *)SongNameLoad,   8); 
           FILE_ReadBuffer	((u8  *)PCBank,        16);
           FILE_ReadBuffer	((u8  *)CCBank4,       64);  //16x4=64 Virtuel Encoders
           FILE_ReadBuffer	((u8  *)EXTRA,         32);  //2x16=32 BLM-X-Y-Extra-Buttons
           FILE_ReadBuffer	((u8  *)MtxFunction, 4096);  //16x16x16=4096 - Placeholder for Future updates
           FILE_ReadBuffer	((u8  *)MATRIX,      4352);  //16x16x17=4352  - Routing - Matrices
           FILE_ReadBuffer  ((u8  *)Seq,         4608);  //18x256  =4608 - Step-Sequencer-Matrix
           FILE_ReadBuffer  ((u8  *)SeqTic,      4608);  //18x256  =4608 - Step-Sequencer-TicOffset-Matrix 4 Seq[x][y]
           FILE_ReadBuffer  ((u8  *)NoteBuff,     160);  //16x10    =160   - MelodyRetriggerNoteBuffer (last played notes)
           FILE_ReadBuffer  ((u8  *)CC_SD,        128);  // ALL OTHER VARIABLES are saved in this ARRAY (CC_SD[128])
           FILE_ReadBuffer  ((u8  *)CCMtx,       4096);  //16x16x16=4096 - Matrix as CC controller
           FILE_ReadBuffer  ((u8  *)SONG,         512);  //16x32=512 - SONG Routing-Part-Automation
           FILE_ReadClose	(&midifile_fi);
       MUTEX_SDCARD_GIVE
           //Paste  Variables from Array
           VeloKill[0]       = CC_SD[0];
           VeloKill[1]       = CC_SD[1];
           VeloKill[2]       = CC_SD[2];
           VeloInvert        = CC_SD[3];
           PageFirst         = CC_SD[4];
           PageLast          = CC_SD[5];
           Page              = CC_SD[6];
           StepPerPage       = CC_SD[7];
           direction         = CC_SD[8];
           LoopLengthBtn     = CC_SD[9];
           SyncType          = CC_SD[10];
           SyncRate          = CC_SD[11];
           MainLoop          = CC_SD[12];
           btn               = CC_SD[13];
           EncPage           = CC_SD[14];
           VelSel            = CC_SD[15];
           VelSelValue[0]    = CC_SD[16];
           VelSelValue[1]    = CC_SD[17];
           VelSelValue[2]    = CC_SD[18];
           StepVelo          = CC_SD[19];
           MatrixUse         = CC_SD[20];
           focusMatrixUse[0] = CC_SD[21];
           focusMatrixUse[1] = CC_SD[22];
           focusMatrixUse[2] = CC_SD[23];
           focusMatrixUse[3] = CC_SD[24];
           MainDelay         = CC_SD[25];
           Swing16th         = CC_SD[26];
           Swing8th          = CC_SD[27];
           SwingSwitch       = CC_SD[28];
           PpqnDividerCount  = CC_SD[29];
           BaseTicCount      = CC_SD[30];
           BPM               = CC_SD[31];
           Rythm             = CC_SD[32];
           RythmRepeat       = CC_SD[33];
           AutQuntActive     = CC_SD[34];
           QuantRate         = CC_SD[35];
           intro             = CC_SD[36];
           Fullvelo          = CC_SD[37];
           MeloKILL          = CC_SD[38];
           MeloDecay         = CC_SD[39];
           MeloVelo          = CC_SD[40];
           MonoKILL          = CC_SD[41];
           MonoDecay         = CC_SD[42];
           MonoVelo          = CC_SD[43];
           TrigKILL          = CC_SD[44];

           SEQ_BPM_Set(BPM);
            if(BaseTicCount == 0){BaseTic =  8;}
       else if(BaseTicCount == 1){BaseTic = 12;}
       else if(BaseTicCount == 2){BaseTic = 18;}
       Tic = 32 * BaseTic; //32x12=384
       SyncFlag = 1; //update ClockCounter when ready...

       MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString	("%s", "SONG loaded!"); 
       SongNrStor = SongNrLoad; //transfiar load nr 2 store nr.
       for(SongNamecount=0; SongNamecount<8; SongNamecount++){SongNameStore[SongNamecount]=SongNameLoad[SongNamecount];} //transfair loadet Filename 2 Storefilename

    if(PCSend == 1){ //Send-Programm-Change Active?   
      //Send Program Change 4 Melody Parts 0-16							
	  int l; for(l=0; l<16; ++l) {
		    if(PCType[l]==0 && PCBank[l]!=128){ //128: Dont Transmit Programchange = OFF
			MIOS32_MIDI_SendCC           (MelPortOut, MeloOutCh[l], 32, PCBank[l]);	  //PC-Bank   //Send-out-Program-Change CC32        
		    MIOS32_MIDI_SendProgramChange(MelPortOut, MeloOutCh[l], SongNrLoad);}    //PC
		    
            if(PCType[l]==1 && PCBank[l]!=128){  //128: Dont Transmit Programchange = OFF             
			MIOS32_MIDI_SendCC           (MelPortOut, MeloOutCh[l], 0, PCBank[l]);		          //Send-out-Program-Change CC0             
		    MIOS32_MIDI_SendProgramChange(MelPortOut, MeloOutCh[l], SongNrLoad);}}

	  //Send Program Change 4 Trigger-Part
	  int i; for(i=6; i<15; ++i) {
		    if(PCType[16]==0 && PCBank[16]!=128){ //128: Dont Transmit Programchange = OFF
			MIOS32_MIDI_SendCC           (TrigPortOUT, TrigOutCh[i], 32, PCBank[16]);	  //PC-Bank   //Send-out-Program-Change CC32        
		    MIOS32_MIDI_SendProgramChange(TrigPortOUT, TrigOutCh[i], SongNrLoad);}    //PC
		    
            if(PCType[16]==1 && PCBank[16]!=128){  //128: Dont Transmit Programchange = OFF             
			MIOS32_MIDI_SendCC           (TrigPortOUT, TrigOutCh[i], 0, PCBank[16]);		          //Send-out-Program-Change CC0             
		    MIOS32_MIDI_SendProgramChange(TrigPortOUT, TrigOutCh[i], SongNrLoad);}}
	   MenueUpdateFlag = 0; //Get Normal Menue Symbols (not that "loadet!")         	
       }
    LED(0); //update LED-Status (Dump out to LED-Button-Matrix
     }
    //Load Routing 0

    MatrixUse = 3; //switch to CC Page

    APP_BLM_ButtonCallback(ID, 2, 0, 0, 0); // switch to Routing 0   // id:blm, elementID, btnX, btnY,Depressed   --2 = Y-BTNs


}
    
    //SD-Card Initalize - SONG
  if(tick == 1 && order == 3){//CHECK SD-Card/Initalize Card
    MUTEX_SDCARD_TAKE;					//SD-Card is now only for the following LINES reserved:
      statusSD = FILE_CheckSDCard();
      if (statusSD == 2) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO SD-Card");} 
      if (statusSD == 3) {
         if	(!FILE_SDCardAvailable() ) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO Cord(song)");} 
         if	(!FILE_VolumeAvailable() ) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO FAT(song)");}} 
      if (statusSD == 1) {// YES CARD!  >>> next: check Card-content
         statusDir = FILE_DirExists("tm");																								//ask file.c: exist a folder "t/" on the CARD?
         if(statusDir == 1){MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "good SONG file structure");MenueUpdateFlag = 0;} 
         if(statusDir == 0){MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "create SONG filestructure.1,5 minutes!");

         //WRITE  Variables in Array
           CC_SD[0]=VeloKill[0];
           CC_SD[1]=VeloKill[1];
           CC_SD[2]=VeloKill[2];
           CC_SD[3]=VeloInvert;
           CC_SD[4]=PageFirst;
           CC_SD[5]=PageLast;
           CC_SD[6]=Page;
           CC_SD[7]=StepPerPage;
           CC_SD[8]=direction;
           CC_SD[9]=LoopLengthBtn;
           CC_SD[10]=SyncType;
           CC_SD[11]=SyncRate;
           CC_SD[12]=MainLoop;
           CC_SD[13]=btn ;
           CC_SD[14]=EncPage;
           CC_SD[15]=VelSel;
           CC_SD[16]=VelSelValue[0];
           CC_SD[17]=VelSelValue[1];
           CC_SD[18]=VelSelValue[2];
           CC_SD[19]=StepVelo;
           CC_SD[20]=MatrixUse ;
           CC_SD[21]=focusMatrixUse[0];
           CC_SD[22]=focusMatrixUse[1];
           CC_SD[23]=focusMatrixUse[2];
           CC_SD[24]=focusMatrixUse[3];
           CC_SD[25]=MainDelay;
           CC_SD[26]=Swing16th;
           CC_SD[27]=Swing8th;
           CC_SD[28]=SwingSwitch;
           CC_SD[29]=PpqnDividerCount;
           CC_SD[30]=BaseTicCount;
           CC_SD[31]=BPM;
           CC_SD[32]=Rythm;
           CC_SD[33]=RythmRepeat;
           CC_SD[34]=AutQuntActive;
           CC_SD[35]=QuantRate;
           CC_SD[36]=intro;
           CC_SD[37]=Fullvelo;
           CC_SD[38]=MeloKILL;
           CC_SD[39]=MeloDecay;
           CC_SD[40]=MeloVelo;
           CC_SD[41]=MonoKILL;
           CC_SD[42]=MonoDecay;
           CC_SD[43]=MonoVelo;
           CC_SD[44]=TrigKILL;
                      
            FILE_MakeDir("tm");                        //make a folder "tm" on the SD-Card (root/t/)
            sprintf(filepathS, "tm/0.tm");             //First Pattern --- will be later copied 511 times!	
            FILE_WriteOpen	(filepathS, 1);
              SongNameStore[0] = 65;                    //65 is ASCI means "A", the rest is "space" because i intitalised it with the value"32"
              SongNameStore[1] = 66;                    //66 is ASCI means "B"....
              SongNameStore[2] = 67;                   
              FILE_WriteBuffer((u8  *)file_typeBank, 4); //"TM01" = 4 Positons
              FILE_WriteBuffer((u8  *)SongNameStore, 8); //"A        " = 8 Positons
              FILE_WriteBuffer((u8  *)PCBank,       16);  
              FILE_WriteBuffer((u8  *)CCBank4,       64);  //16x4=64 Virtuel Encoders
              FILE_WriteBuffer((u8  *)EXTRA,         32);  //2x16=32 BLM-X-Y-Extra-Buttons
              FILE_WriteBuffer((u8  *)MtxFunction, 4096);  //16x16x16=4096 - Placeholder for Future updates
              FILE_WriteBuffer((u8  *)MATRIX,      4352);  //16x16x17=4352  - Routing - Matrices
              FILE_WriteBuffer((u8  *)Seq,         4608);  //18x256  =4608 - Step-Sequencer-Matrix
              FILE_WriteBuffer((u8  *)SeqTic,      4608);  //18x256  =4608 - Step-Sequencer-TicOffset-Matrix 4 Seq[x][y]
              FILE_WriteBuffer((u8  *)NoteBuff,     160);  //16x10   =160   - MelodyRetriggerNoteBuffer (last played notes)
              FILE_WriteBuffer((u8  *)CC_SD,        128);  // ALL OTHER VARIABLES are saved in this ARRAY (CC_SD[128])
              FILE_WriteBuffer((u8  *)CCMtx,       4096);  //16x16x16=4096 - Matrix as CC controller
              FILE_WriteBuffer((u8  *)SONG,         512);  //16x32=512 - SONG-Parts
            FILE_WriteClose	();                         //The First File named "0" is locatet @ SDCARD/t/0.tm, now its time to copy this 511 times, I want 511 Banks/files
            s16 BankCreateCounter = 0;                  //declere and set the Bank Counter inital value to 0 
            for(BankCreateCounter=0; BankCreateCounter<512; BankCreateCounter++){  //countes 2 511 and do following commandos 511 times in a loop:
            char copyfilepath[8];
            sprintf(copyfilepath, "tm/%d.tm", BankCreateCounter); //make a new filename depending on the counter value 1.tm, 2.tm, 3.tm...511.tm
            FILE_Copy ((char *)"tm/0.tm", (char *)copyfilepath);} //copy the File 0.tm to all other 511 files...
    MUTEX_SDCARD_GIVE;												//SD-Card is now free 4 access
    MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "init SDCard > done");MenueUpdateFlag = 0;}}}
}

////////////////////////////////////////////////////////////////////
//System-Setting-Mode?
if(LCD0Page >= 5 ) {
    //SD-Card Initalize - SYS
  if(tick == 1 && order == 3){//CHECK SD-Card/Initalize Card
    MUTEX_SDCARD_TAKE;					//SD-Card is now only for the following LINES reserved:
      statusSD = FILE_CheckSDCard();
      if (statusSD == 2) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO Card");} 
      if (statusSD == 3) {
         if	(!FILE_SDCardAvailable() ) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO Cord");} 
         if	(!FILE_VolumeAvailable() ) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO FAT");}} 
      if (statusSD == 1) {// YES CARD!  >>> next: check Card-content
         statusDir = FILE_DirExists("tmsys");  //ask file.c: exist a folder "tmsys/" on the CARD?
         if(statusDir == 1){MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "good file structure");MenueUpdateFlag = 0; 
          if(SYSLoadFlag == 1) {SYSLoadFlag = 0; //Avoid double Loading SYSTEM-File
			                    StoreLoad(1, 1); //Load System File "0" from SD-CARD
                                }}

         if(statusDir == 0){MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "create system filestructure...");
           //WRITE  Variables in Array
           SYS_SD[0] = ClockPortIN;
           SYS_SD[1] = TrigPortIN;
           SYS_SD[2] = TrigPortOUT;
           SYS_SD[3] = TrigInCh;
           SYS_SD[4] = MelPortIn;
           SYS_SD[5] = MelPortIn2;
           SYS_SD[6] = MelPortOut;
           SYS_SD[7] = BLMport;
           SYS_SD[8] = PCPortIN;
           SYS_SD[9] = PCSend;
           SYS_SD[10]= PCReceive;
           SYS_SD[11]= PCChIN;
           SYS_SD[12]= RemotePort;

            FILE_MakeDir("tmsys");                        //make a folder "tm" on the SD-Card (root/t/)
            sprintf(filepathSsys, "tmsys/0.sy");             //First Pattern --- will be later copied 127 times!	
            FILE_WriteOpen	(filepathSsys, 1);
              SYSNameStore[0] = 65;                    //65 is ASCI means "A", the rest is "space" because i intitalised it with the value"32"
              SYSNameStore[1] = 65;                    //66 is ASCI means "B"....
              SYSNameStore[2] = 65;                   
					sprintf(filepathSsys, "tmsys/%d.sy", SYSNrStor);      
						FILE_WriteOpen	(filepathSsys, 1);                //WRITE!!!!
							FILE_WriteBuffer((u8  *)file_typeBank,         4);  //"TM01" = 4 Positons
							FILE_WriteBuffer((u8  *)SYSNameStore,          8);  //"A        " = 8 Positons
							FILE_WriteBuffer((u8  *)TrigInNote,           16);  //ProgramChangeBank
							FILE_WriteBuffer((u8  *)TrigOutNote,          16);  //16x4=64 Virtuel Encoders
							FILE_WriteBuffer((u8  *)TrigOutCh,            16);  //2x16=32 BLM-X-Y-Extra-Buttons
                            FILE_WriteBuffer((u8  *)MeloOutCh,            16);  //16x16x16=4096 - Placeholder for Future updates
                            FILE_WriteBuffer((u8  *)TrigMidiThruClock,     4);
                            FILE_WriteBuffer((u8  *)TrigMidiThruTransport, 4); 
                            FILE_WriteBuffer((u8  *)SYS_SD,              128);   //All Other Variables
                            FILE_WriteBuffer((u8  *)PitchbendPWR,         16);   //Pitchbend - thru - Active?
                            FILE_WriteBuffer((u8  *)CCThruPort,           16);   //ControlChange - thru - Active?

            FILE_WriteClose	();                         //The First File named "0" is locatet @ SDCARD/t/0.tm, now its time to copy this 511 times, I want 511 Banks/files
            s16 BankCreateCounter = 0;                  //declere and set the Bank Counter inital value to 0 
            for(BankCreateCounter=0; BankCreateCounter<128; BankCreateCounter++){  //countes 2 128 and do following commandos 128 times in a loop:
            char copyfilepathSYS[8];
            sprintf(copyfilepathSYS, "tmsys/%d.sy", BankCreateCounter); //make a new filename depending on the counter value 1.sys, 2.sys, 3.sys...127.sys
            FILE_Copy ((char *)"tmsys/0.sy", (char *)copyfilepathSYS);} //copy the File 0.tm to all other 127 files...
    MUTEX_SDCARD_GIVE;												//SD-Card is now free 4 access
    MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "init SYS-SDCard > done");MenueUpdateFlag = 0;}}
    if(SYSLoadFlag == 1) {SYSLoadFlag = 0; StoreLoad(1, 1);}}

	//STORE	     
    if(tick == 1 && order == 2){//Store Data & update the Load NR & Name													
      MUTEX_SDCARD_TAKE;  statusSD = FILE_CheckSDCard();   MUTEX_SDCARD_GIVE;      //SDC-Connected?
      if(statusSD != 0)  {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString       ("%s %d", "CANT-SAVE-SYS-Status:", statusSD);}
      if(statusSD == 0) {                                                          // YES CARD!  >>> next: check Card-content 
          MUTEX_SDCARD_TAKE; statusDir = FILE_DirExists("tmsys"); MUTEX_SDCARD_GIVE;   //ask/call file.c: exist a folder "tmsys/" on the CARD?
           if(statusDir == 0) {MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString ("%s", "Invalid SYS-File Structure>Reconnect Card");}
           if(statusDir == 1) {
           //WRITE  Variables in Array
           SYS_SD[0]=ClockPortIN;
           SYS_SD[1]=TrigPortIN;
           SYS_SD[2]=TrigPortOUT;
           SYS_SD[3]=TrigInCh;
           SYS_SD[4]=MelPortIn;
           SYS_SD[5]=MelPortIn2;
           SYS_SD[6]=MelPortOut;
           SYS_SD[7]=BLMport;
           SYS_SD[8] = PCPortIN;
           SYS_SD[9] = PCSend;
           SYS_SD[10]= PCReceive;
           SYS_SD[11]= PCChIN;
           SYS_SD[12]= RemotePort;
             MUTEX_SDCARD_TAKE;

					sprintf(filepathSsys, "tmsys/%d.sy", SYSNrStor);      
						FILE_WriteOpen	(filepathSsys, 1);                //WRITE!!!!
							FILE_WriteBuffer((u8  *)file_typeBank,         4);  //"TM01" = 4 Positons
							FILE_WriteBuffer((u8  *)SYSNameStore,          8);  //"A        " = 8 Positons
							FILE_WriteBuffer((u8  *)TrigInNote,           16);  //ProgramChangeBank
							FILE_WriteBuffer((u8  *)TrigOutNote,          16);  //16x4=64 Virtuel Encoders
							FILE_WriteBuffer((u8  *)TrigOutCh,            16);  //2x16=32 BLM-X-Y-Extra-Buttons
                            FILE_WriteBuffer((u8  *)MeloOutCh,            16);  //16x16x16=4096 - Placeholder for Future updates
                            FILE_WriteBuffer((u8  *)TrigMidiThruClock,     4);
                            FILE_WriteBuffer((u8  *)TrigMidiThruTransport, 4); 
                            FILE_WriteBuffer((u8  *)SYS_SD,              128);   //All Other Variables
                            FILE_WriteBuffer((u8  *)PitchbendPWR,         16);   //Pitchbend - thru - Active?
                            FILE_WriteBuffer((u8  *)CCThruPort,           16);   //ControlChange - thru - Active?
                     FILE_WriteClose	();                 
             MUTEX_SDCARD_GIVE;                                   //SD-Card is now free 4 access
             MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString	("%s", "stored!"); MUTEX_LCD_GIVE; MenueUpdateFlag = 0;}}}//menue Updateflag 2 restore after some time the menue

    //LOAD	
    if(tick == 1 && order == 1){//Load Data & update the Load NR & Name and also Store Nr & Store Name
      MUTEX_SDCARD_TAKE;  statusDir = FILE_DirExists("tmsys"); MUTEX_SDCARD_GIVE;
      if(statusDir != 1) {MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString	("%s %d", "CANT-LOAD-SYS-Status:", statusDir); MUTEX_LCD_GIVE;}
      if(statusDir == 1) {
		   sprintf(filepathLsys, "tmsys/%d.sy", SYSNrLoad);
           FILE_ReadOpen	(&midifile_sy, filepathLsys);
		     FILE_ReadBuffer((u8  *)file_typeBank,         4);  //"TM01" = 4 Positons
		     FILE_ReadBuffer((u8  *)SYSNameStore,          8);  //"A        " = 8 Positons
	         FILE_ReadBuffer((u8  *)TrigInNote,           16);  //ProgramChangeBank
		     FILE_ReadBuffer((u8  *)TrigOutNote,          16);  //16x4=64 Virtuel Encoders
		     FILE_ReadBuffer((u8  *)TrigOutCh,            16);  //2x16=32 BLM-X-Y-Extra-Buttons
             FILE_ReadBuffer((u8  *)MeloOutCh,            16);  //16x16x16=4096 - Placeholder for Future updates
             FILE_ReadBuffer((u8  *)TrigMidiThruClock,     4);
             FILE_ReadBuffer((u8  *)TrigMidiThruTransport, 4); 
             FILE_ReadBuffer((u8  *)SYS_SD,              128);
             FILE_ReadBuffer((u8  *)PitchbendPWR,         16);  //Pitchbend - thru - Active?
             FILE_ReadBuffer((u8  *)CCThruPort,           16);  //Pitchbend - thru - Active?
           FILE_ReadClose	(&midifile_sy);
       MUTEX_SDCARD_GIVE
       //Dump Out Memory Container
       ClockPortIN        = SYS_SD[0];
       TrigPortIN         = SYS_SD[1];
       TrigPortOUT        = SYS_SD[2];
       TrigInCh           = SYS_SD[3];
       MelPortIn          = SYS_SD[4];
       MelPortIn2         = SYS_SD[5];
       MelPortOut         = SYS_SD[6];
       BLMport            = SYS_SD[7];
       PCPortIN           = SYS_SD[8];
       PCSend             = SYS_SD[9];
       PCReceive          = SYS_SD[10];
       PCChIN             = SYS_SD[11];
       RemotePort         = SYS_SD[12];

       MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_PrintFormattedString	("%s", "SYS loaded!");          
       SYSNrStor = SYSNrLoad; //transfair load-numberr 2 store-number.
       for(SYSNamecount=0; SYSNamecount<8; SYSNamecount++){SYSNameStore[SYSNamecount]=SYSNameLoad[SYSNamecount];} //transfair loadet Filename 2 Storefilename

       //Load Song Preset "0"
       if(SONGLoadFlag == 1) {SONGLoadFlag = 0;// When Loadet the First Time then make the way free to load Song "0"
		                      LCD0Page = 0;    //switch to the Song-Load-StorePage       
	                          MenueUpdateFlag = 0; // Show LCD0Page "0"
	   		                  StoreLoad(1, 1); //Load Song File "0" from SD-Card      	
       }
       else{	   MenueUpdateFlag = 0;} // or just update the Menu
}   
}

}
}
static void MELODY_BUFFER0(u8 velocity, u8 note){  //Melody Input buffer
	 //Ocatave Shift
     MelOctShiftFactor[0] = 0;
     if(CCMtx[0][10][0] == 1) {MelOctShiftFactor[0]=MelOctShiftFactor[0]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [0] == 1) {MelOctShiftFactor[0]=MelOctShiftFactor[0]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [0] == 1) {MelOctShiftFactor[0]=MelOctShiftFactor[0]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [0] == 1) {MelOctShiftFactor[0]=MelOctShiftFactor[0]+12;} //if(octaveshift button 3 = 1) {.....+Oct

	 NoteCalc[0] = note + MelOctShiftFactor[0];
	 if(NoteCalc[0] > 0 && NoteCalc[0] < 127){// Only Note Numbers in Midi-Range 0-127
	    if(velocity >= 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[0]==0){int i0b;for(i0b=0; i0b<10; ++i0b)NoteBuff[0][i0b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[0] == 0) {NoteBuff[0][0]  = NoteCalc[0];}
         if(NoteCount[0] == 1) {NoteBuff[0][1]  = NoteCalc[0];}          
         if(NoteCount[0] == 2) {NoteBuff[0][2]  = NoteCalc[0];}
         if(NoteCount[0] == 3) {NoteBuff[0][3]  = NoteCalc[0];}
         if(NoteCount[0] == 4) {NoteBuff[0][4]  = NoteCalc[0];}
         if(NoteCount[0] == 5) {NoteBuff[0][5]  = NoteCalc[0];}
         if(NoteCount[0] == 6) {NoteBuff[0][6]  = NoteCalc[0];}
         if(NoteCount[0] == 7) {NoteBuff[0][7]  = NoteCalc[0];}
         if(NoteCount[0] == 8) {NoteBuff[0][8]  = NoteCalc[0];} 
         if(NoteCount[0] == 9) {NoteBuff[0][9]  = NoteCalc[0];}                                                                                       
                               
      //NOTE COUNTER 
         NoteCount[0]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[0] = 0;} 
         if(velocity >= 1 && NoteCount[0] >=10){NoteCount[0] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER1(u8 velocity, u8 note){  //Melody Input buffer
     MelOctShiftFactor[1] = 0;
     if(CCMtx[0][10][1] == 1) {MelOctShiftFactor[1]=MelOctShiftFactor[1]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [1] == 1) {MelOctShiftFactor[1]=MelOctShiftFactor[1]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [1] == 1) {MelOctShiftFactor[1]=MelOctShiftFactor[1]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [1] == 1) {MelOctShiftFactor[1]=MelOctShiftFactor[1]+12;} //if(octaveshift button 3 = 1) {.....+Oct

	 NoteCalc[1] = note + MelOctShiftFactor[1];
	 if(NoteCalc[1] > 0 && NoteCalc[1] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[1]==0){int i1b;for(i1b=0; i1b<10; ++i1b)NoteBuff[1][i1b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[1] == 0) {NoteBuff[1][0]  = NoteCalc[1];}
         if(NoteCount[1] == 1) {NoteBuff[1][1]  = NoteCalc[1];}          
         if(NoteCount[1] == 2) {NoteBuff[1][2]  = NoteCalc[1];}
         if(NoteCount[1] == 3) {NoteBuff[1][3]  = NoteCalc[1];}
         if(NoteCount[1] == 4) {NoteBuff[1][4]  = NoteCalc[1];}
         if(NoteCount[1] == 5) {NoteBuff[1][5]  = NoteCalc[1];}
         if(NoteCount[1] == 6) {NoteBuff[1][6]  = NoteCalc[1];}
         if(NoteCount[1] == 7) {NoteBuff[1][7]  = NoteCalc[1];}
         if(NoteCount[1] == 8) {NoteBuff[1][8]  = NoteCalc[1];} 
         if(NoteCount[1] == 9) {NoteBuff[1][9]  = NoteCalc[1];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[1]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[1] = 0;} 
         if(velocity == 1 && NoteCount[1] >=10){NoteCount[1] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER2(u8 velocity, u8 note){  //Melody Input buffer
     MelOctShiftFactor[2] = 0;
     if(CCMtx[0][10][2] == 1) {MelOctShiftFactor[2]=MelOctShiftFactor[2]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [2] == 1) {MelOctShiftFactor[2]=MelOctShiftFactor[2]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [2] == 1) {MelOctShiftFactor[2]=MelOctShiftFactor[2]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [2] == 1) {MelOctShiftFactor[2]=MelOctShiftFactor[2]+12;} //if(octaveshift button 3 = 1) {.....+Oct

	 NoteCalc[2] = note + MelOctShiftFactor[2];
	 if(NoteCalc[2] > 0 && NoteCalc[2] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[2]==0){int i2b;for(i2b=0; i2b<10; ++i2b)NoteBuff[2][i2b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[2] == 0) {NoteBuff[2][0]  = NoteCalc[2];}
         if(NoteCount[2] == 1) {NoteBuff[2][1]  = NoteCalc[2];}          
         if(NoteCount[2] == 2) {NoteBuff[2][2]  = NoteCalc[2];}
         if(NoteCount[2] == 3) {NoteBuff[2][3]  = NoteCalc[2];}
         if(NoteCount[2] == 4) {NoteBuff[2][4]  = NoteCalc[2];}
         if(NoteCount[2] == 5) {NoteBuff[2][5]  = NoteCalc[2];}
         if(NoteCount[2] == 6) {NoteBuff[2][6]  = NoteCalc[2];}
         if(NoteCount[2] == 7) {NoteBuff[2][7]  = NoteCalc[2];}
         if(NoteCount[2] == 8) {NoteBuff[2][8]  = NoteCalc[2];} 
         if(NoteCount[2] == 9) {NoteBuff[2][9]  = NoteCalc[2];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[2]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[2] = 0;} 
         if(velocity == 1 && NoteCount[2] >=10){NoteCount[2] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER3(u8 velocity, u8 note){  //Melody Input buffer
     MelOctShiftFactor[3] = 0;
     if(CCMtx[0][10][3] == 1) {MelOctShiftFactor[3]=MelOctShiftFactor[3]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [3] == 1) {MelOctShiftFactor[3]=MelOctShiftFactor[3]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [3] == 1) {MelOctShiftFactor[3]=MelOctShiftFactor[3]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [3] == 1) {MelOctShiftFactor[3]=MelOctShiftFactor[3]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[3] = note + MelOctShiftFactor[3];
	 if(NoteCalc[3] > 0 && NoteCalc[3] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[3]==0){int i3b;for(i3b=0; i3b<10; ++i3b)NoteBuff[3][ i3b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[3] == 0) {NoteBuff[3][0]  = NoteCalc[3];}
         if(NoteCount[3] == 1) {NoteBuff[3][1]  = NoteCalc[3];}          
         if(NoteCount[3] == 2) {NoteBuff[3][2]  = NoteCalc[3];}
         if(NoteCount[3] == 3) {NoteBuff[3][3]  = NoteCalc[3];}
         if(NoteCount[3] == 4) {NoteBuff[3][4]  = NoteCalc[3];}
         if(NoteCount[3] == 5) {NoteBuff[3][5]  = NoteCalc[3];}
         if(NoteCount[3] == 6) {NoteBuff[3][6]  = NoteCalc[3];}
         if(NoteCount[3] == 7) {NoteBuff[3][7]  = NoteCalc[3];}
         if(NoteCount[3] == 8) {NoteBuff[3][8]  = NoteCalc[3];} 
         if(NoteCount[3] == 9) {NoteBuff[3][9]  = NoteCalc[3];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[3]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[3] = 0;} 
         if(velocity == 1 && NoteCount[3] >=10){NoteCount[3] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER4(u8 velocity, u8 note){  //Melody Input buffer
     MelOctShiftFactor[4] = 0;
     if(CCMtx[0][10][4] == 1) {MelOctShiftFactor[4]=MelOctShiftFactor[4]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [4] == 1) {MelOctShiftFactor[4]=MelOctShiftFactor[4]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [4] == 1) {MelOctShiftFactor[4]=MelOctShiftFactor[4]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [4] == 1) {MelOctShiftFactor[4]=MelOctShiftFactor[4]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[4] = note + MelOctShiftFactor[4];
	 if(NoteCalc[4] > 0 && NoteCalc[4] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[4]==0){int i4b;for(i4b=0; i4b<10; ++i4b)NoteBuff[4][ i4b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[4] == 0) {NoteBuff[4][0]  = NoteCalc[4];}
         if(NoteCount[4] == 1) {NoteBuff[4][1]  = NoteCalc[4];}          
         if(NoteCount[4] == 2) {NoteBuff[4][2]  = NoteCalc[4];}
         if(NoteCount[4] == 3) {NoteBuff[4][3]  = NoteCalc[4];}
         if(NoteCount[4] == 4) {NoteBuff[4][4]  = NoteCalc[4];}
         if(NoteCount[4] == 5) {NoteBuff[4][5]  = NoteCalc[4];}
         if(NoteCount[4] == 6) {NoteBuff[4][6]  = NoteCalc[4];}
         if(NoteCount[4] == 7) {NoteBuff[4][7]  = NoteCalc[4];}
         if(NoteCount[4] == 8) {NoteBuff[4][8]  = NoteCalc[4];} 
         if(NoteCount[4] == 9) {NoteBuff[4][9]  = NoteCalc[4];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[4]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[4] = 0;} 
         if(velocity == 1 && NoteCount[4] >=10){NoteCount[4] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER5(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[5] = 0; //initalize
     if(CCMtx[0][10][5] == 1) {MelOctShiftFactor[5]=MelOctShiftFactor[5]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [5] == 1) {MelOctShiftFactor[5]=MelOctShiftFactor[5]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [5] == 1) {MelOctShiftFactor[5]=MelOctShiftFactor[5]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [5] == 1) {MelOctShiftFactor[5]=MelOctShiftFactor[5]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[5] = note + MelOctShiftFactor[5];
	 if(NoteCalc[5] > 0 && NoteCalc[5] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[5]==0){int i5b;for(i5b=0; i5b<10; ++i5b)NoteBuff[5][ i5b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[5] == 0) {NoteBuff[5][0]  = NoteCalc[5];}
         if(NoteCount[5] == 1) {NoteBuff[5][1]  = NoteCalc[5];}          
         if(NoteCount[5] == 2) {NoteBuff[5][2]  = NoteCalc[5];}
         if(NoteCount[5] == 3) {NoteBuff[5][3]  = NoteCalc[5];}
         if(NoteCount[5] == 4) {NoteBuff[5][4]  = NoteCalc[5];}
         if(NoteCount[5] == 5) {NoteBuff[5][5]  = NoteCalc[5];}
         if(NoteCount[5] == 6) {NoteBuff[5][6]  = NoteCalc[5];}
         if(NoteCount[5] == 7) {NoteBuff[5][7]  = NoteCalc[5];}
         if(NoteCount[5] == 8) {NoteBuff[5][8]  = NoteCalc[5];} 
         if(NoteCount[5] == 9) {NoteBuff[5][9]  = NoteCalc[5];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[5]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[5] = 0;} 
         if(velocity == 1 && NoteCount[5] >=10){NoteCount[5] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER6(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[6] = 0; //initalize
     if(CCMtx[0][10][6] == 1) {MelOctShiftFactor[6]=MelOctShiftFactor[6]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [6] == 1) {MelOctShiftFactor[6]=MelOctShiftFactor[6]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [6] == 1) {MelOctShiftFactor[6]=MelOctShiftFactor[6]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [6] == 1) {MelOctShiftFactor[6]=MelOctShiftFactor[6]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[6] = note + MelOctShiftFactor[6];
	 if(NoteCalc[6] > 0 && NoteCalc[6] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[6]==0){int i6b;for(i6b=0; i6b<10; ++i6b)NoteBuff[6][ i6b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[6] == 0) {NoteBuff[6][0]  = NoteCalc[6];}
         if(NoteCount[6] == 1) {NoteBuff[6][1]  = NoteCalc[6];}          
         if(NoteCount[6] == 2) {NoteBuff[6][2]  = NoteCalc[6];}
         if(NoteCount[6] == 3) {NoteBuff[6][3]  = NoteCalc[6];}
         if(NoteCount[6] == 4) {NoteBuff[6][4]  = NoteCalc[6];}
         if(NoteCount[6] == 5) {NoteBuff[6][5]  = NoteCalc[6];}
         if(NoteCount[6] == 6) {NoteBuff[6][6]  = NoteCalc[6];}
         if(NoteCount[6] == 7) {NoteBuff[6][7]  = NoteCalc[6];}
         if(NoteCount[6] == 8) {NoteBuff[6][8]  = NoteCalc[6];} 
         if(NoteCount[6] == 9) {NoteBuff[6][9]  = NoteCalc[6];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[6]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[6] = 0;} 
         if(velocity == 1 && NoteCount[6] >=10){NoteCount[6] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER7(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[7] = 0; //initalize
     if(CCMtx[0][10][7] == 1) {MelOctShiftFactor[7]=MelOctShiftFactor[7]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [7] == 1) {MelOctShiftFactor[7]=MelOctShiftFactor[7]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [7] == 1) {MelOctShiftFactor[7]=MelOctShiftFactor[7]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [7] == 1) {MelOctShiftFactor[7]=MelOctShiftFactor[7]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[7] = note + MelOctShiftFactor[7];
	 if(NoteCalc[7] > 0 && NoteCalc[7] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[7]==0){int i7b;for(i7b=0; i7b<10; ++i7b)NoteBuff[7][ i7b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[7] == 0) {NoteBuff[7][0]  = NoteCalc[7];}
         if(NoteCount[7] == 1) {NoteBuff[7][1]  = NoteCalc[7];}          
         if(NoteCount[7] == 2) {NoteBuff[7][2]  = NoteCalc[7];}
         if(NoteCount[7] == 3) {NoteBuff[7][3]  = NoteCalc[7];}
         if(NoteCount[7] == 4) {NoteBuff[7][4]  = NoteCalc[7];}
         if(NoteCount[7] == 5) {NoteBuff[7][5]  = NoteCalc[7];}
         if(NoteCount[7] == 6) {NoteBuff[7][6]  = NoteCalc[7];}
         if(NoteCount[7] == 7) {NoteBuff[7][7]  = NoteCalc[7];}
         if(NoteCount[7] == 8) {NoteBuff[7][8]  = NoteCalc[7];} 
         if(NoteCount[7] == 9) {NoteBuff[7][9]  = NoteCalc[7];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[7]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[7] = 0;} 
         if(velocity == 1 && NoteCount[7] >=10){NoteCount[7] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER8(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[8] = 0; //initalize
     if(CCMtx[0][10][8] == 1) {MelOctShiftFactor[8]=MelOctShiftFactor[8]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [8] == 1) {MelOctShiftFactor[8]=MelOctShiftFactor[8]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [8] == 1) {MelOctShiftFactor[8]=MelOctShiftFactor[8]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [8] == 1) {MelOctShiftFactor[8]=MelOctShiftFactor[8]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[8] = note + MelOctShiftFactor[8];
	 if(NoteCalc[8] > 0 && NoteCalc[8] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[8]==0){int i8b;for(i8b=0; i8b<10; ++i8b)NoteBuff[8][ i8b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[8] == 0) {NoteBuff[8][0]  = NoteCalc[8];}
         if(NoteCount[8] == 1) {NoteBuff[8][1]  = NoteCalc[8];}          
         if(NoteCount[8] == 2) {NoteBuff[8][2]  = NoteCalc[8];}
         if(NoteCount[8] == 3) {NoteBuff[8][3]  = NoteCalc[8];}
         if(NoteCount[8] == 4) {NoteBuff[8][4]  = NoteCalc[8];}
         if(NoteCount[8] == 5) {NoteBuff[8][5]  = NoteCalc[8];}
         if(NoteCount[8] == 6) {NoteBuff[8][6]  = NoteCalc[8];}
         if(NoteCount[8] == 7) {NoteBuff[8][7]  = NoteCalc[8];}
         if(NoteCount[8] == 8) {NoteBuff[8][8]  = NoteCalc[8];} 
         if(NoteCount[8] == 9) {NoteBuff[8][9]  = NoteCalc[8];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[8]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[8] = 0;} 
         if(velocity == 1 && NoteCount[8] >=10){NoteCount[8] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER9(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[9] = 0; //initalize
     if(CCMtx[0][10][9] == 1) {MelOctShiftFactor[9]=MelOctShiftFactor[9]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [9] == 1) {MelOctShiftFactor[9]=MelOctShiftFactor[9]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [9] == 1) {MelOctShiftFactor[9]=MelOctShiftFactor[9]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [9] == 1) {MelOctShiftFactor[9]=MelOctShiftFactor[9]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[9] = note + MelOctShiftFactor[9];
	 if(NoteCalc[9] > 0 && NoteCalc[9] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[9]==0){int i9b;for(i9b=0; i9b<10; ++i9b)NoteBuff[9][ i9b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[9] == 0) {NoteBuff[9][0]  = NoteCalc[9];}
         if(NoteCount[9] == 1) {NoteBuff[9][1]  = NoteCalc[9];}          
         if(NoteCount[9] == 2) {NoteBuff[9][2]  = NoteCalc[9];}
         if(NoteCount[9] == 3) {NoteBuff[9][3]  = NoteCalc[9];}
         if(NoteCount[9] == 4) {NoteBuff[9][4]  = NoteCalc[9];}
         if(NoteCount[9] == 5) {NoteBuff[9][5]  = NoteCalc[9];}
         if(NoteCount[9] == 6) {NoteBuff[9][6]  = NoteCalc[9];}
         if(NoteCount[9] == 7) {NoteBuff[9][7]  = NoteCalc[9];}
         if(NoteCount[9] == 8) {NoteBuff[9][8]  = NoteCalc[9];} 
         if(NoteCount[9] == 9) {NoteBuff[9][9]  = NoteCalc[9];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[9]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[9] = 0;} 
         if(velocity == 1 && NoteCount[9] >=10){NoteCount[9] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER10(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[10] = 0; //initalize
     if(CCMtx[0][10][10] == 1) {MelOctShiftFactor[10]=MelOctShiftFactor[10]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [10] == 1) {MelOctShiftFactor[10]=MelOctShiftFactor[10]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [10] == 1) {MelOctShiftFactor[10]=MelOctShiftFactor[10]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [10] == 1) {MelOctShiftFactor[10]=MelOctShiftFactor[10]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[10] = note + MelOctShiftFactor[10];
	 if(NoteCalc[10] > 0 && NoteCalc[10] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[10]==0){int i10b;for(i10b=0; i10b<10; ++i10b)NoteBuff[10][ i10b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[10] == 0) {NoteBuff[10][0]  = NoteCalc[10];}
         if(NoteCount[10] == 1) {NoteBuff[10][1]  = NoteCalc[10];}          
         if(NoteCount[10] == 2) {NoteBuff[10][2]  = NoteCalc[10];}
         if(NoteCount[10] == 3) {NoteBuff[10][3]  = NoteCalc[10];}
         if(NoteCount[10] == 4) {NoteBuff[10][4]  = NoteCalc[10];}
         if(NoteCount[10] == 5) {NoteBuff[10][5]  = NoteCalc[10];}
         if(NoteCount[10] == 6) {NoteBuff[10][6]  = NoteCalc[10];}
         if(NoteCount[10] == 7) {NoteBuff[10][7]  = NoteCalc[10];}
         if(NoteCount[10] == 8) {NoteBuff[10][8]  = NoteCalc[10];} 
         if(NoteCount[10] == 9) {NoteBuff[10][9]  = NoteCalc[10];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[10]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[10] = 0;} 
         if(velocity == 1 && NoteCount[10] >=10){NoteCount[10] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER11(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[11] = 0; //initalize
     if(CCMtx[0][10][11] == 1) {MelOctShiftFactor[11]=MelOctShiftFactor[11]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [11] == 1) {MelOctShiftFactor[11]=MelOctShiftFactor[11]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [11] == 1) {MelOctShiftFactor[11]=MelOctShiftFactor[11]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [11] == 1) {MelOctShiftFactor[11]=MelOctShiftFactor[11]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[11] = note + MelOctShiftFactor[11];
	 if(NoteCalc[11] > 0 && NoteCalc[11] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[11]==0){int i11b;for(i11b=0; i11b<10; ++i11b)NoteBuff[11][ i11b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[11] == 0) {NoteBuff[11][0]  = NoteCalc[11];}
         if(NoteCount[11] == 1) {NoteBuff[11][1]  = NoteCalc[11];}          
         if(NoteCount[11] == 2) {NoteBuff[11][2]  = NoteCalc[11];}
         if(NoteCount[11] == 3) {NoteBuff[11][3]  = NoteCalc[11];}
         if(NoteCount[11] == 4) {NoteBuff[11][4]  = NoteCalc[11];}
         if(NoteCount[11] == 5) {NoteBuff[11][5]  = NoteCalc[11];}
         if(NoteCount[11] == 6) {NoteBuff[11][6]  = NoteCalc[11];}
         if(NoteCount[11] == 7) {NoteBuff[11][7]  = NoteCalc[11];}
         if(NoteCount[11] == 8) {NoteBuff[11][8]  = NoteCalc[11];} 
         if(NoteCount[11] == 9) {NoteBuff[11][9]  = NoteCalc[11];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[11]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[11] = 0;} 
         if(velocity == 1 && NoteCount[11] >=10){NoteCount[11] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER12(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[12] = 0; //initalize
     if(CCMtx[0][10][12] == 1) {MelOctShiftFactor[12]=MelOctShiftFactor[12]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [12] == 1) {MelOctShiftFactor[12]=MelOctShiftFactor[12]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [12] == 1) {MelOctShiftFactor[12]=MelOctShiftFactor[12]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [12] == 1) {MelOctShiftFactor[12]=MelOctShiftFactor[12]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[12] = note + MelOctShiftFactor[12];
	 if(NoteCalc[12] > 0 && NoteCalc[12] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[12]==0){int i12b;for(i12b=0; i12b<10; ++i12b)NoteBuff[12][ i12b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[12] == 0) {NoteBuff[12][0]  = NoteCalc[12];}
         if(NoteCount[12] == 1) {NoteBuff[12][1]  = NoteCalc[12];}          
         if(NoteCount[12] == 2) {NoteBuff[12][2]  = NoteCalc[12];}
         if(NoteCount[12] == 3) {NoteBuff[12][3]  = NoteCalc[12];}
         if(NoteCount[12] == 4) {NoteBuff[12][4]  = NoteCalc[12];}
         if(NoteCount[12] == 5) {NoteBuff[12][5]  = NoteCalc[12];}
         if(NoteCount[12] == 6) {NoteBuff[12][6]  = NoteCalc[12];}
         if(NoteCount[12] == 7) {NoteBuff[12][7]  = NoteCalc[12];}
         if(NoteCount[12] == 8) {NoteBuff[12][8]  = NoteCalc[12];} 
         if(NoteCount[12] == 9) {NoteBuff[12][9]  = NoteCalc[12];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[12]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[12] = 0;} 
         if(velocity == 1 && NoteCount[12] >=10){NoteCount[12] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER13(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[13] = 0; //initalize
     if(CCMtx[0][10][13] == 1) {MelOctShiftFactor[13]=MelOctShiftFactor[13]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [13] == 1) {MelOctShiftFactor[13]=MelOctShiftFactor[13]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [13] == 1) {MelOctShiftFactor[13]=MelOctShiftFactor[13]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [13] == 1) {MelOctShiftFactor[13]=MelOctShiftFactor[13]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[13] = note + MelOctShiftFactor[13];
	 if(NoteCalc[13] > 0 && NoteCalc[13] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[13]==0){int i11b;for(i11b=0; i11b<10; ++i11b)NoteBuff[13][ i11b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[13] == 0) {NoteBuff[13][0]  = NoteCalc[13];}
         if(NoteCount[13] == 1) {NoteBuff[13][1]  = NoteCalc[13];}          
         if(NoteCount[13] == 2) {NoteBuff[13][2]  = NoteCalc[13];}
         if(NoteCount[13] == 3) {NoteBuff[13][3]  = NoteCalc[13];}
         if(NoteCount[13] == 4) {NoteBuff[13][4]  = NoteCalc[13];}
         if(NoteCount[13] == 5) {NoteBuff[13][5]  = NoteCalc[13];}
         if(NoteCount[13] == 6) {NoteBuff[13][6]  = NoteCalc[13];}
         if(NoteCount[13] == 7) {NoteBuff[13][7]  = NoteCalc[13];}
         if(NoteCount[13] == 8) {NoteBuff[13][8]  = NoteCalc[13];} 
         if(NoteCount[13] == 9) {NoteBuff[13][9]  = NoteCalc[13];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[13]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[13] = 0;} 
         if(velocity == 1 && NoteCount[13] >=10){NoteCount[13] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER14(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[14] = 0; //initalize
     if(CCMtx[0][10][14] == 1) {MelOctShiftFactor[14]=MelOctShiftFactor[14]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [14] == 1) {MelOctShiftFactor[14]=MelOctShiftFactor[14]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [14] == 1) {MelOctShiftFactor[14]=MelOctShiftFactor[14]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [14] == 1) {MelOctShiftFactor[14]=MelOctShiftFactor[14]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[14] = note + MelOctShiftFactor[14];
	 if(NoteCalc[14] > 0 && NoteCalc[14] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[14]==0){int i11b;for(i11b=0; i11b<10; ++i11b)NoteBuff[14][ i11b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[14] == 0) {NoteBuff[14][0]  = NoteCalc[14];}
         if(NoteCount[14] == 1) {NoteBuff[14][1]  = NoteCalc[14];}          
         if(NoteCount[14] == 2) {NoteBuff[14][2]  = NoteCalc[14];}
         if(NoteCount[14] == 3) {NoteBuff[14][3]  = NoteCalc[14];}
         if(NoteCount[14] == 4) {NoteBuff[14][4]  = NoteCalc[14];}
         if(NoteCount[14] == 5) {NoteBuff[14][5]  = NoteCalc[14];}
         if(NoteCount[14] == 6) {NoteBuff[14][6]  = NoteCalc[14];}
         if(NoteCount[14] == 7) {NoteBuff[14][7]  = NoteCalc[14];}
         if(NoteCount[14] == 8) {NoteBuff[14][8]  = NoteCalc[14];} 
         if(NoteCount[14] == 9) {NoteBuff[14][9]  = NoteCalc[14];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[14]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[14] = 0;} 
         if(velocity == 1 && NoteCount[14] >=10){NoteCount[14] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void MELODY_BUFFER15(u8 velocity, u8 note){  //Melody Input buffer
	 MelOctShiftFactor[15] = 0; //initalize
     if(CCMtx[0][10][15] == 1) {MelOctShiftFactor[15]=MelOctShiftFactor[15]-12;} //if(octaveshift button 0 = 1) {.....-Oct
     if(CCMtx[0][9] [15] == 1) {MelOctShiftFactor[15]=MelOctShiftFactor[15]-12;} //if(octaveshift button 1 = 1) {.....-Oct
     if(CCMtx[0][8] [15] == 1) {MelOctShiftFactor[15]=MelOctShiftFactor[15]+12;} //if(octaveshift button 2 = 1) {.....+Oct
     if(CCMtx[0][7] [15] == 1) {MelOctShiftFactor[15]=MelOctShiftFactor[15]+12;} //if(octaveshift button 3 = 1) {.....+Oct
	 NoteCalc[15] = note + MelOctShiftFactor[15];
	 if(NoteCalc[15] > 0 && NoteCalc[15] < 127){      // Only Note Numbers in Midi-Range 0-127
	    if(velocity == 1){              // Only Note On Messages
                                
      //CLEAR NOTE BUFFER
         if(NoteCount[15]==0){int i11b;for(i11b=0; i11b<10; ++i11b)NoteBuff[15][ i11b] = 0;}//set to Note Nr 0, which we filter later out
         
      //FILL  NOTE BUFFER
         if(NoteCount[15] == 0) {NoteBuff[15][0]  = NoteCalc[15];}
         if(NoteCount[15] == 1) {NoteBuff[15][1]  = NoteCalc[15];}          
         if(NoteCount[15] == 2) {NoteBuff[15][2]  = NoteCalc[15];}
         if(NoteCount[15] == 3) {NoteBuff[15][3]  = NoteCalc[15];}
         if(NoteCount[15] == 4) {NoteBuff[15][4]  = NoteCalc[15];}
         if(NoteCount[15] == 5) {NoteBuff[15][5]  = NoteCalc[15];}
         if(NoteCount[15] == 6) {NoteBuff[15][6]  = NoteCalc[15];}
         if(NoteCount[15] == 7) {NoteBuff[15][7]  = NoteCalc[15];}
         if(NoteCount[15] == 8) {NoteBuff[15][8]  = NoteCalc[15];} 
         if(NoteCount[15] == 9) {NoteBuff[15][9]  = NoteCalc[15];}                                                                                      
                               
      //NOTE COUNTER 
         NoteCount[15]++;}} //(cheap Polyphony) counts from 0-12 >> this numbers route the notes in their buffers, when it reaches 12 it begins from 0 again - note overflow
         //Count Reset
         if(velocity == 0)                  {NoteCount[15] = 0;} 
         if(velocity == 1 && NoteCount[15] >=10){NoteCount[15] = 0;} //begin again from 0 when reaching max Count of 10 10Fingers on Keyboard = max.10 Polyphone  
}//END HOOK

static void TASK_Midi_Decay0(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry
  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[0][1] != 0) {
	     MeloDecayTIMER[0][1]--;
	  if(MeloDecayTIMER[0][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 1, 0);}}  
   if   (MeloDecayTIMER[0][2] != 0) {
	     MeloDecayTIMER[0][2]--;
	  if(MeloDecayTIMER[0][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 2, 0);}}   
   if   (MeloDecayTIMER[0][3] != 0) {
	     MeloDecayTIMER[0][3]--;
	  if(MeloDecayTIMER[0][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 3, 0);}}
   if   (MeloDecayTIMER[0][4] != 0) {
	     MeloDecayTIMER[0][4]--;
	  if(MeloDecayTIMER[0][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 4, 0);}} 
   if   (MeloDecayTIMER[0][5] != 0) {
	     MeloDecayTIMER[0][5]--;
	  if(MeloDecayTIMER[0][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 5, 0);}} 
   if   (MeloDecayTIMER[0][6] != 0) {
	     MeloDecayTIMER[0][6]--;
	  if(MeloDecayTIMER[0][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 6, 0);}} 
   if   (MeloDecayTIMER[0][7] != 0) {
	     MeloDecayTIMER[0][7]--;
	  if(MeloDecayTIMER[0][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 7, 0);}}   
   if   (MeloDecayTIMER[0][8] != 0) {
	     MeloDecayTIMER[0][8]--;
	  if(MeloDecayTIMER[0][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 8, 0);}}   
   if   (MeloDecayTIMER[0][9] != 0) {
	     MeloDecayTIMER[0][9]--;
	  if(MeloDecayTIMER[0][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 9, 0);}}   
   if   (MeloDecayTIMER[0][10] != 0) {
	     MeloDecayTIMER[0][10]--;
	  if(MeloDecayTIMER[0][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 10, 0);}}   
   if   (MeloDecayTIMER[0][11] != 0) {
	     MeloDecayTIMER[0][11]--;
	  if(MeloDecayTIMER[0][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 11, 0);}}   
   if   (MeloDecayTIMER[0][12] != 0) {
	     MeloDecayTIMER[0][12]--;
	  if(MeloDecayTIMER[0][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 12, 0);}}   
   if   (MeloDecayTIMER[0][13] != 0) {
	     MeloDecayTIMER[0][13]--;
	  if(MeloDecayTIMER[0][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 13, 0);}}   
   if   (MeloDecayTIMER[0][14] != 0) {
	     MeloDecayTIMER[0][14]--;
	  if(MeloDecayTIMER[0][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 14, 0);}}   
   if   (MeloDecayTIMER[0][15] != 0) {
	     MeloDecayTIMER[0][15]--;
	  if(MeloDecayTIMER[0][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 15, 0);}}   
   if   (MeloDecayTIMER[0][16] != 0) {
	     MeloDecayTIMER[0][16]--;
	  if(MeloDecayTIMER[0][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 16, 0);}}   
   if   (MeloDecayTIMER[0][17] != 0) {
	     MeloDecayTIMER[0][17]--;
	  if(MeloDecayTIMER[0][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 17, 0);}}   
   if   (MeloDecayTIMER[0][18] != 0) {
	     MeloDecayTIMER[0][18]--;
	  if(MeloDecayTIMER[0][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 18, 0);}}   
   if   (MeloDecayTIMER[0][19] != 0) {
	     MeloDecayTIMER[0][19]--;
	  if(MeloDecayTIMER[0][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 19, 0);}}   
   if   (MeloDecayTIMER[0][20] != 0) {
	     MeloDecayTIMER[0][20]--;
	  if(MeloDecayTIMER[0][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 20, 0);}}   
   if   (MeloDecayTIMER[0][21] != 0) {
	     MeloDecayTIMER[0][21]--;
	  if(MeloDecayTIMER[0][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 21, 0);}}   
   if   (MeloDecayTIMER[0][22] != 0) {
	     MeloDecayTIMER[0][22]--;
	  if(MeloDecayTIMER[0][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 22, 0);}}   
   if   (MeloDecayTIMER[0][23] != 0) {
	     MeloDecayTIMER[0][23]--;
	  if(MeloDecayTIMER[0][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 23, 0);}}   
   if   (MeloDecayTIMER[0][24] != 0) {
	     MeloDecayTIMER[0][24]--;
	  if(MeloDecayTIMER[0][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 24, 0);}}   
   if   (MeloDecayTIMER[0][25] != 0) {
	     MeloDecayTIMER[0][25]--;
	  if(MeloDecayTIMER[0][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 25, 0);}}   
   if   (MeloDecayTIMER[0][26] != 0) {
	     MeloDecayTIMER[0][26]--;
	  if(MeloDecayTIMER[0][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 26, 0);}}   
   if   (MeloDecayTIMER[0][27] != 0) {
	     MeloDecayTIMER[0][27]--;
	  if(MeloDecayTIMER[0][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 27, 0);}}   
   if   (MeloDecayTIMER[0][28] != 0) {
	     MeloDecayTIMER[0][28]--;
	  if(MeloDecayTIMER[0][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 28, 0);}}   
   if   (MeloDecayTIMER[0][29] != 0) {
	     MeloDecayTIMER[0][29]--;
	  if(MeloDecayTIMER[0][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 29, 0);}}   
   if   (MeloDecayTIMER[0][30] != 0) {
	     MeloDecayTIMER[0][30]--;
	  if(MeloDecayTIMER[0][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 30, 0);}}   
   if   (MeloDecayTIMER[0][31] != 0) {
	     MeloDecayTIMER[0][31]--;
	  if(MeloDecayTIMER[0][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 31, 0);}}   
   if   (MeloDecayTIMER[0][32] != 0) {
	     MeloDecayTIMER[0][32]--;
	  if(MeloDecayTIMER[0][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 32, 0);}}   
   if   (MeloDecayTIMER[0][33] != 0) {
	     MeloDecayTIMER[0][33]--;
	  if(MeloDecayTIMER[0][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 33, 0);}}   
   if   (MeloDecayTIMER[0][34] != 0) {
	     MeloDecayTIMER[0][34]--;
	  if(MeloDecayTIMER[0][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 34, 0);}}   
   if   (MeloDecayTIMER[0][35] != 0) {
	     MeloDecayTIMER[0][35]--;
	  if(MeloDecayTIMER[0][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 35, 0);}}   
   if   (MeloDecayTIMER[0][36] != 0) {
	     MeloDecayTIMER[0][36]--;
	  if(MeloDecayTIMER[0][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 36, 0);}}   
   if   (MeloDecayTIMER[0][37] != 0) {
	     MeloDecayTIMER[0][37]--;
	  if(MeloDecayTIMER[0][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 37, 0);}}   
   if   (MeloDecayTIMER[0][38] != 0) {
	     MeloDecayTIMER[0][38]--;
	  if(MeloDecayTIMER[0][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 38, 0);}}         
   if   (MeloDecayTIMER[0][39] != 0) {
	     MeloDecayTIMER[0][39]--;
	  if(MeloDecayTIMER[0][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 39, 0);}}              
   if   (MeloDecayTIMER[0][40] != 0) {
	     MeloDecayTIMER[0][40]--;
	  if(MeloDecayTIMER[0][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 40, 0);}}              
   if   (MeloDecayTIMER[0][41] != 0) {
	     MeloDecayTIMER[0][41]--;
	  if(MeloDecayTIMER[0][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 41, 0);}}              
   if   (MeloDecayTIMER[0][42] != 0) {
	     MeloDecayTIMER[0][42]--;
	  if(MeloDecayTIMER[0][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 42, 0);}}             
   if   (MeloDecayTIMER[0][43] != 0) {
	     MeloDecayTIMER[0][43]--;
	  if(MeloDecayTIMER[0][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 43, 0);}}              
   if   (MeloDecayTIMER[0][44] != 0) {
	     MeloDecayTIMER[0][44]--;
	  if(MeloDecayTIMER[0][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 44, 0);}}              
   if   (MeloDecayTIMER[0][45] != 0) {
	     MeloDecayTIMER[0][45]--;
	  if(MeloDecayTIMER[0][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 45, 0);}}              
   if   (MeloDecayTIMER[0][46] != 0) {
	     MeloDecayTIMER[0][46]--;
	  if(MeloDecayTIMER[0][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 46, 0);}}              
   if   (MeloDecayTIMER[0][47] != 0) {
	     MeloDecayTIMER[0][47]--;
	  if(MeloDecayTIMER[0][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 47, 0);}}              
   if   (MeloDecayTIMER[0][48] != 0) {
	     MeloDecayTIMER[0][48]--;
	  if(MeloDecayTIMER[0][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 48, 0);}}              
   if   (MeloDecayTIMER[0][49] != 0) {
	     MeloDecayTIMER[0][49]--;
	  if(MeloDecayTIMER[0][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 49, 0);}}              
   if   (MeloDecayTIMER[0][50] != 0) {
	     MeloDecayTIMER[0][50]--;
	  if(MeloDecayTIMER[0][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 50, 0);}}              
   if   (MeloDecayTIMER[0][51] != 0) {
	     MeloDecayTIMER[0][51]--;
	  if(MeloDecayTIMER[0][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 51, 0);}}              
   if   (MeloDecayTIMER[0][52] != 0) {
	     MeloDecayTIMER[0][52]--;
	  if(MeloDecayTIMER[0][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 52, 0);}}    
   if   (MeloDecayTIMER[0][53] != 0) {
	     MeloDecayTIMER[0][53]--;
	  if(MeloDecayTIMER[0][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 53, 0);}}              
   if   (MeloDecayTIMER[0][54] != 0) {
	     MeloDecayTIMER[0][54]--;
	  if(MeloDecayTIMER[0][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 54, 0);}}              
   if   (MeloDecayTIMER[0][55] != 0) {
	     MeloDecayTIMER[0][55]--;
	  if(MeloDecayTIMER[0][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 55, 0);}}              
   if   (MeloDecayTIMER[0][56] != 0) {
	     MeloDecayTIMER[0][56]--;
	  if(MeloDecayTIMER[0][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 56, 0);}}              
   if   (MeloDecayTIMER[0][57] != 0) {
	     MeloDecayTIMER[0][57]--;
	  if(MeloDecayTIMER[0][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 57, 0);}}              
   if   (MeloDecayTIMER[0][58] != 0) {
	     MeloDecayTIMER[0][58]--;
	  if(MeloDecayTIMER[0][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 58, 0);}}              
   if   (MeloDecayTIMER[0][59] != 0) {
	     MeloDecayTIMER[0][59]--;
	  if(MeloDecayTIMER[0][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 59, 0);}}              
   if   (MeloDecayTIMER[0][60] != 0) {
	     MeloDecayTIMER[0][60]--;
	  if(MeloDecayTIMER[0][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 60, 0);}}              
   if   (MeloDecayTIMER[0][61] != 0) {
	     MeloDecayTIMER[0][61]--;
	  if(MeloDecayTIMER[0][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 61, 0);}}              
   if   (MeloDecayTIMER[0][62] != 0) {
	     MeloDecayTIMER[0][62]--;
	  if(MeloDecayTIMER[0][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 62, 0);}}              
   if   (MeloDecayTIMER[0][63] != 0) {
	     MeloDecayTIMER[0][63]--;
	  if(MeloDecayTIMER[0][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 63, 0);}}              
   if   (MeloDecayTIMER[0][64] != 0) {
	     MeloDecayTIMER[0][64]--;
	  if(MeloDecayTIMER[0][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 64, 0);}}              
   if   (MeloDecayTIMER[0][65] != 0) {
	     MeloDecayTIMER[0][65]--;
	  if(MeloDecayTIMER[0][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 65, 0);}}              
   if   (MeloDecayTIMER[0][66] != 0) {
	     MeloDecayTIMER[0][66]--;
	  if(MeloDecayTIMER[0][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 66, 0);}}              
   if   (MeloDecayTIMER[0][67] != 0) {
	     MeloDecayTIMER[0][67]--;
	  if(MeloDecayTIMER[0][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 67, 0);}}              
   if   (MeloDecayTIMER[0][68] != 0) {
	     MeloDecayTIMER[0][68]--;
	  if(MeloDecayTIMER[0][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 68, 0);}}              
   if   (MeloDecayTIMER[0][69] != 0) {
	     MeloDecayTIMER[0][69]--;
	  if(MeloDecayTIMER[0][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 69, 0);}}              
   if   (MeloDecayTIMER[0][70] != 0) {
	     MeloDecayTIMER[0][70]--;
	  if(MeloDecayTIMER[0][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 70, 0);}}              
   if   (MeloDecayTIMER[0][71] != 0) {
	     MeloDecayTIMER[0][71]--;
	  if(MeloDecayTIMER[0][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 71, 0);}}              
   if   (MeloDecayTIMER[0][72] != 0) {
	     MeloDecayTIMER[0][72]--;
	  if(MeloDecayTIMER[0][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 72, 0);}}              
   if   (MeloDecayTIMER[0][73] != 0) {
	     MeloDecayTIMER[0][73]--;
	  if(MeloDecayTIMER[0][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 73, 0);}}              
   if   (MeloDecayTIMER[0][74] != 0) {
	     MeloDecayTIMER[0][74]--;
	  if(MeloDecayTIMER[0][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 74, 0);}}              
   if   (MeloDecayTIMER[0][75] != 0) {
	     MeloDecayTIMER[0][75]--;
	  if(MeloDecayTIMER[0][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 75, 0);}}              
   if   (MeloDecayTIMER[0][76] != 0) {
	     MeloDecayTIMER[0][76]--;
	  if(MeloDecayTIMER[0][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 76, 0);}}              
   if   (MeloDecayTIMER[0][77] != 0) {
	     MeloDecayTIMER[0][77]--;
	  if(MeloDecayTIMER[0][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 77, 0);}}              
   if   (MeloDecayTIMER[0][78] != 0) {
	     MeloDecayTIMER[0][78]--;
	  if(MeloDecayTIMER[0][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 78, 0);}}              
   if   (MeloDecayTIMER[0][79] != 0) {
	     MeloDecayTIMER[0][79]--;
	  if(MeloDecayTIMER[0][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 79, 0);}}              
   if   (MeloDecayTIMER[0][80] != 0) {
	     MeloDecayTIMER[0][80]--;
	  if(MeloDecayTIMER[0][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 80, 0);}}              
   if   (MeloDecayTIMER[0][81] != 0) {
	     MeloDecayTIMER[0][81]--;
	  if(MeloDecayTIMER[0][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 81, 0);}}              
   if   (MeloDecayTIMER[0][82] != 0) {
	     MeloDecayTIMER[0][82]--;
	  if(MeloDecayTIMER[0][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 82, 0);}}              
   if   (MeloDecayTIMER[0][83] != 0) {
	     MeloDecayTIMER[0][83]--;
	  if(MeloDecayTIMER[0][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 83, 0);}}              
   if   (MeloDecayTIMER[0][84] != 0) {
	     MeloDecayTIMER[0][84]--;
	  if(MeloDecayTIMER[0][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 84, 0);}}              
   if   (MeloDecayTIMER[0][85] != 0) {
	     MeloDecayTIMER[0][85]--;
	  if(MeloDecayTIMER[0][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 85, 0);}}              
   if   (MeloDecayTIMER[0][86] != 0) {
	     MeloDecayTIMER[0][86]--;
	  if(MeloDecayTIMER[0][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 86, 0);}}              
   if   (MeloDecayTIMER[0][87] != 0) {
	     MeloDecayTIMER[0][87]--;
	  if(MeloDecayTIMER[0][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 87, 0);}}              
   if   (MeloDecayTIMER[0][88] != 0) {
	     MeloDecayTIMER[0][88]--;
	  if(MeloDecayTIMER[0][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 88, 0);}}              
   if   (MeloDecayTIMER[0][89] != 0) {
	     MeloDecayTIMER[0][89]--;
	  if(MeloDecayTIMER[0][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 89, 0);}}                    
   if   (MeloDecayTIMER[0][90] != 0) {
	     MeloDecayTIMER[0][90]--;
	  if(MeloDecayTIMER[0][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 90, 0);}}              
   if   (MeloDecayTIMER[0][91] != 0) {
	     MeloDecayTIMER[0][91]--;
	  if(MeloDecayTIMER[0][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 91, 0);}}              
   if   (MeloDecayTIMER[0][92] != 0) {
	     MeloDecayTIMER[0][92]--;
	  if(MeloDecayTIMER[0][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 92, 0);}}              
   if   (MeloDecayTIMER[0][93] != 0) {
	     MeloDecayTIMER[0][93]--;
	  if(MeloDecayTIMER[0][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 93, 0);}}   
   if   (MeloDecayTIMER[0][94] != 0) {
	     MeloDecayTIMER[0][94]--;
	  if(MeloDecayTIMER[0][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 94, 0);}}               
   if   (MeloDecayTIMER[0][95] != 0) {
	     MeloDecayTIMER[0][95]--;
	  if(MeloDecayTIMER[0][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 95, 0);}}              
   if   (MeloDecayTIMER[0][96] != 0) {
	     MeloDecayTIMER[0][96]--;
	  if(MeloDecayTIMER[0][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 96, 0);}}              
   if   (MeloDecayTIMER[0][97] != 0) {
	     MeloDecayTIMER[0][97]--;
	  if(MeloDecayTIMER[0][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 97, 0);}}              
   if   (MeloDecayTIMER[0][98] != 0) {
	     MeloDecayTIMER[0][98]--;
	  if(MeloDecayTIMER[0][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 98, 0);}}              
   if   (MeloDecayTIMER[0][99] != 0) {
	     MeloDecayTIMER[0][99]--;
	  if(MeloDecayTIMER[0][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 99, 0);}}              
   if   (MeloDecayTIMER[0][100] != 0) {
	     MeloDecayTIMER[0][100]--;
	  if(MeloDecayTIMER[0][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 100, 0);}}              
   if   (MeloDecayTIMER[0][101] != 0) {
	     MeloDecayTIMER[0][101]--;
	  if(MeloDecayTIMER[0][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 101, 0);}}              
   if   (MeloDecayTIMER[0][102] != 0) {
	     MeloDecayTIMER[0][102]--;
	  if(MeloDecayTIMER[0][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 102, 0);}}              
   if   (MeloDecayTIMER[0][103] != 0) {
	     MeloDecayTIMER[0][103]--;
	  if(MeloDecayTIMER[0][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 103, 0);}}              
   if   (MeloDecayTIMER[0][104] != 0) {
	     MeloDecayTIMER[0][104]--;
	  if(MeloDecayTIMER[0][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 104, 0);}}              
   if   (MeloDecayTIMER[0][105] != 0) {
	     MeloDecayTIMER[0][105]--;
	  if(MeloDecayTIMER[0][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 105, 0);}}              
   if   (MeloDecayTIMER[0][106] != 0) {
	     MeloDecayTIMER[0][106]--;
	  if(MeloDecayTIMER[0][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 106, 0);}}              
   if   (MeloDecayTIMER[0][107] != 0) {
	     MeloDecayTIMER[0][107]--;
	  if(MeloDecayTIMER[0][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 107, 0);}}              
   if   (MeloDecayTIMER[0][108] != 0) {
	     MeloDecayTIMER[0][108]--;
	  if(MeloDecayTIMER[0][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 108, 0);}}              
   if   (MeloDecayTIMER[0][109] != 0) {
	     MeloDecayTIMER[0][109]--;
	  if(MeloDecayTIMER[0][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 109, 0);}}              
   if   (MeloDecayTIMER[0][110] != 0) {
	     MeloDecayTIMER[0][110]--;
	  if(MeloDecayTIMER[0][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 110, 0);}}              
   if   (MeloDecayTIMER[0][111] != 0) {
	     MeloDecayTIMER[0][111]--;
	  if(MeloDecayTIMER[0][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 111, 0);}}              
   if   (MeloDecayTIMER[0][112] != 0) {
	     MeloDecayTIMER[0][112]--;
	  if(MeloDecayTIMER[0][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 112, 0);}}              
   if   (MeloDecayTIMER[0][113] != 0) {
	     MeloDecayTIMER[0][113]--;
	  if(MeloDecayTIMER[0][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 113, 0);}}              
   if   (MeloDecayTIMER[0][114] != 0) {
	     MeloDecayTIMER[0][114]--;
	  if(MeloDecayTIMER[0][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 114, 0);}}              
   if   (MeloDecayTIMER[0][115] != 0) {
	     MeloDecayTIMER[0][115]--;
	  if(MeloDecayTIMER[0][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 115, 0);}}              
   if   (MeloDecayTIMER[0][116] != 0) {
	     MeloDecayTIMER[0][116]--;
	  if(MeloDecayTIMER[0][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 116, 0);}}              
   if   (MeloDecayTIMER[0][117] != 0) {
	     MeloDecayTIMER[0][117]--;
	  if(MeloDecayTIMER[0][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 117, 0);}}              
   if   (MeloDecayTIMER[0][118] != 0) {
	     MeloDecayTIMER[0][118]--;
	  if(MeloDecayTIMER[0][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 118, 0);}}              
   if   (MeloDecayTIMER[0][119] != 0) {
	     MeloDecayTIMER[0][119]--;
	  if(MeloDecayTIMER[0][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 119, 0);}}              
   if   (MeloDecayTIMER[0][120] != 0) {
	     MeloDecayTIMER[0][120]--;
	  if(MeloDecayTIMER[0][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 120, 0);}}              
   if   (MeloDecayTIMER[0][121] != 0) {
	     MeloDecayTIMER[0][121]--;
	  if(MeloDecayTIMER[0][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 121, 0);}}              
   if   (MeloDecayTIMER[0][122] != 0) {
	     MeloDecayTIMER[0][122]--;
	  if(MeloDecayTIMER[0][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 122, 0);}}              
   if   (MeloDecayTIMER[0][123] != 0) {
	     MeloDecayTIMER[0][123]--;
	  if(MeloDecayTIMER[0][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 123, 0);}}              
   if   (MeloDecayTIMER[0][124] != 0) {
	     MeloDecayTIMER[0][124]--;
	  if(MeloDecayTIMER[0][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 124, 0);}}              
   if   (MeloDecayTIMER[0][125] != 0) {
	     MeloDecayTIMER[0][125]--;
	  if(MeloDecayTIMER[0][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 125, 0);}}              
   if   (MeloDecayTIMER[0][126] != 0) {
	     MeloDecayTIMER[0][126]--;
	  if(MeloDecayTIMER[0][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 126, 0);}}              
   if   (MeloDecayTIMER[0][127] != 0) {
	     MeloDecayTIMER[0][127]--;
	  if(MeloDecayTIMER[0][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay1(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[1][1] != 0) {
	     MeloDecayTIMER[1][1]--;
	  if(MeloDecayTIMER[1][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 1, 0);}}  
   if   (MeloDecayTIMER[1][2] != 0) {
	     MeloDecayTIMER[1][2]--;
	  if(MeloDecayTIMER[1][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 2, 0);}}   
   if   (MeloDecayTIMER[1][3] != 0) {
	     MeloDecayTIMER[1][3]--;
	  if(MeloDecayTIMER[1][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 3, 0);}}
   if   (MeloDecayTIMER[1][4] != 0) {
	     MeloDecayTIMER[1][4]--;
	  if(MeloDecayTIMER[1][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 4, 0);}} 
   if   (MeloDecayTIMER[1][5] != 0) {
	     MeloDecayTIMER[1][5]--;
	  if(MeloDecayTIMER[1][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 5, 0);}} 
   if   (MeloDecayTIMER[1][6] != 0) {
	     MeloDecayTIMER[1][6]--;
	  if(MeloDecayTIMER[1][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 6, 0);}} 
   if   (MeloDecayTIMER[1][7] != 0) {
	     MeloDecayTIMER[1][7]--;
	  if(MeloDecayTIMER[1][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 7, 0);}}   
   if   (MeloDecayTIMER[1][8] != 0) {
	     MeloDecayTIMER[1][8]--;
	  if(MeloDecayTIMER[1][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 8, 0);}}   
   if   (MeloDecayTIMER[1][9] != 0) {
	     MeloDecayTIMER[1][9]--;
	  if(MeloDecayTIMER[1][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 9, 0);}}   
   if   (MeloDecayTIMER[1][10] != 0) {
	     MeloDecayTIMER[1][10]--;
	  if(MeloDecayTIMER[1][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 10, 0);}}   
   if   (MeloDecayTIMER[1][11] != 0) {
	     MeloDecayTIMER[1][11]--;
	  if(MeloDecayTIMER[1][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 11, 0);}}   
   if   (MeloDecayTIMER[1][12] != 0) {
	     MeloDecayTIMER[1][12]--;
	  if(MeloDecayTIMER[1][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 12, 0);}}   
   if   (MeloDecayTIMER[1][13] != 0) {
	     MeloDecayTIMER[1][13]--;
	  if(MeloDecayTIMER[1][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 13, 0);}}   
   if   (MeloDecayTIMER[1][14] != 0) {
	     MeloDecayTIMER[1][14]--;
	  if(MeloDecayTIMER[1][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 14, 0);}}   
   if   (MeloDecayTIMER[1][15] != 0) {
	     MeloDecayTIMER[1][15]--;
	  if(MeloDecayTIMER[1][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 15, 0);}}   
   if   (MeloDecayTIMER[1][16] != 0) {
	     MeloDecayTIMER[1][16]--;
	  if(MeloDecayTIMER[1][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 16, 0);}}   
   if   (MeloDecayTIMER[1][17] != 0) {
	     MeloDecayTIMER[1][17]--;
	  if(MeloDecayTIMER[1][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 17, 0);}}   
   if   (MeloDecayTIMER[1][18] != 0) {
	     MeloDecayTIMER[1][18]--;
	  if(MeloDecayTIMER[1][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 18, 0);}}   
   if   (MeloDecayTIMER[1][19] != 0) {
	     MeloDecayTIMER[1][19]--;
	  if(MeloDecayTIMER[1][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 19, 0);}}   
   if   (MeloDecayTIMER[1][20] != 0) {
	     MeloDecayTIMER[1][20]--;
	  if(MeloDecayTIMER[1][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 20, 0);}}   
   if   (MeloDecayTIMER[1][21] != 0) {
	     MeloDecayTIMER[1][21]--;
	  if(MeloDecayTIMER[1][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 21, 0);}}   
   if   (MeloDecayTIMER[1][22] != 0) {
	     MeloDecayTIMER[1][22]--;
	  if(MeloDecayTIMER[1][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 22, 0);}}   
   if   (MeloDecayTIMER[1][23] != 0) {
	     MeloDecayTIMER[1][23]--;
	  if(MeloDecayTIMER[1][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 23, 0);}}   
   if   (MeloDecayTIMER[1][24] != 0) {
	     MeloDecayTIMER[1][24]--;
	  if(MeloDecayTIMER[1][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 24, 0);}}   
   if   (MeloDecayTIMER[1][25] != 0) {
	     MeloDecayTIMER[1][25]--;
	  if(MeloDecayTIMER[1][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 25, 0);}}   
   if   (MeloDecayTIMER[1][26] != 0) {
	     MeloDecayTIMER[1][26]--;
	  if(MeloDecayTIMER[1][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 26, 0);}}   
   if   (MeloDecayTIMER[1][27] != 0) {
	     MeloDecayTIMER[1][27]--;
	  if(MeloDecayTIMER[1][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 27, 0);}}   
   if   (MeloDecayTIMER[1][28] != 0) {
	     MeloDecayTIMER[1][28]--;
	  if(MeloDecayTIMER[1][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 28, 0);}}   
   if   (MeloDecayTIMER[1][29] != 0) {
	     MeloDecayTIMER[1][29]--;
	  if(MeloDecayTIMER[1][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 29, 0);}}   
   if   (MeloDecayTIMER[1][30] != 0) {
	     MeloDecayTIMER[1][30]--;
	  if(MeloDecayTIMER[1][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 30, 0);}}   
   if   (MeloDecayTIMER[1][31] != 0) {
	     MeloDecayTIMER[1][31]--;
	  if(MeloDecayTIMER[1][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 31, 0);}}   
   if   (MeloDecayTIMER[1][32] != 0) {
	     MeloDecayTIMER[1][32]--;
	  if(MeloDecayTIMER[1][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 32, 0);}}   
   if   (MeloDecayTIMER[1][33] != 0) {
	     MeloDecayTIMER[1][33]--;
	  if(MeloDecayTIMER[1][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 33, 0);}}   
   if   (MeloDecayTIMER[1][34] != 0) {
	     MeloDecayTIMER[1][34]--;
	  if(MeloDecayTIMER[1][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 34, 0);}}   
   if   (MeloDecayTIMER[1][35] != 0) {
	     MeloDecayTIMER[1][35]--;
	  if(MeloDecayTIMER[1][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 35, 0);}}   
   if   (MeloDecayTIMER[1][36] != 0) {
	     MeloDecayTIMER[1][36]--;
	  if(MeloDecayTIMER[1][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 36, 0);}}   
   if   (MeloDecayTIMER[1][37] != 0) {
	     MeloDecayTIMER[1][37]--;
	  if(MeloDecayTIMER[1][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 37, 0);}}   
   if   (MeloDecayTIMER[1][38] != 0) {
	     MeloDecayTIMER[1][38]--;
	  if(MeloDecayTIMER[1][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 38, 0);}}         
   if   (MeloDecayTIMER[1][39] != 0) {
	     MeloDecayTIMER[1][39]--;
	  if(MeloDecayTIMER[1][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 39, 0);}}              
   if   (MeloDecayTIMER[1][40] != 0) {
	     MeloDecayTIMER[1][40]--;
	  if(MeloDecayTIMER[1][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 40, 0);}}              
   if   (MeloDecayTIMER[1][41] != 0) {
	     MeloDecayTIMER[1][41]--;
	  if(MeloDecayTIMER[1][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 41, 0);}}              
   if   (MeloDecayTIMER[1][42] != 0) {
	     MeloDecayTIMER[1][42]--;
	  if(MeloDecayTIMER[1][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 42, 0);}}             
   if   (MeloDecayTIMER[1][43] != 0) {
	     MeloDecayTIMER[1][43]--;
	  if(MeloDecayTIMER[1][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 43, 0);}}              
   if   (MeloDecayTIMER[1][44] != 0) {
	     MeloDecayTIMER[1][44]--;
	  if(MeloDecayTIMER[1][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 44, 0);}}              
   if   (MeloDecayTIMER[1][45] != 0) {
	     MeloDecayTIMER[1][45]--;
	  if(MeloDecayTIMER[1][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 45, 0);}}              
   if   (MeloDecayTIMER[1][46] != 0) {
	     MeloDecayTIMER[1][46]--;
	  if(MeloDecayTIMER[1][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 46, 0);}}              
   if   (MeloDecayTIMER[1][47] != 0) {
	     MeloDecayTIMER[1][47]--;
	  if(MeloDecayTIMER[1][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 47, 0);}}              
   if   (MeloDecayTIMER[1][48] != 0) {
	     MeloDecayTIMER[1][48]--;
	  if(MeloDecayTIMER[1][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 48, 0);}}              
   if   (MeloDecayTIMER[1][49] != 0) {
	     MeloDecayTIMER[1][49]--;
	  if(MeloDecayTIMER[1][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 49, 0);}}              
   if   (MeloDecayTIMER[1][50] != 0) {
	     MeloDecayTIMER[1][50]--;
	  if(MeloDecayTIMER[1][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 50, 0);}}              
   if   (MeloDecayTIMER[1][51] != 0) {
	     MeloDecayTIMER[1][51]--;
	  if(MeloDecayTIMER[1][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 51, 0);}}              
   if   (MeloDecayTIMER[1][52] != 0) {
	     MeloDecayTIMER[1][52]--;
	  if(MeloDecayTIMER[1][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 52, 0);}}    
   if   (MeloDecayTIMER[1][53] != 0) {
	     MeloDecayTIMER[1][53]--;
	  if(MeloDecayTIMER[1][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 53, 0);}}              
   if   (MeloDecayTIMER[1][54] != 0) {
	     MeloDecayTIMER[1][54]--;
	  if(MeloDecayTIMER[1][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 54, 0);}}              
   if   (MeloDecayTIMER[1][55] != 0) {
	     MeloDecayTIMER[1][55]--;
	  if(MeloDecayTIMER[1][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 55, 0);}}              
   if   (MeloDecayTIMER[1][56] != 0) {
	     MeloDecayTIMER[1][56]--;
	  if(MeloDecayTIMER[1][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 56, 0);}}              
   if   (MeloDecayTIMER[1][57] != 0) {
	     MeloDecayTIMER[1][57]--;
	  if(MeloDecayTIMER[1][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 57, 0);}}              
   if   (MeloDecayTIMER[1][58] != 0) {
	     MeloDecayTIMER[1][58]--;
	  if(MeloDecayTIMER[1][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 58, 0);}}              
   if   (MeloDecayTIMER[1][59] != 0) {
	     MeloDecayTIMER[1][59]--;
	  if(MeloDecayTIMER[1][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 59, 0);}}              
   if   (MeloDecayTIMER[1][60] != 0) {
	     MeloDecayTIMER[1][60]--;
	  if(MeloDecayTIMER[1][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 60, 0);}}              
   if   (MeloDecayTIMER[1][61] != 0) {
	     MeloDecayTIMER[1][61]--;
	  if(MeloDecayTIMER[1][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 61, 0);}}              
   if   (MeloDecayTIMER[1][62] != 0) {
	     MeloDecayTIMER[1][62]--;
	  if(MeloDecayTIMER[1][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 62, 0);}}              
   if   (MeloDecayTIMER[1][63] != 0) {
	     MeloDecayTIMER[1][63]--;
	  if(MeloDecayTIMER[1][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 63, 0);}}              
   if   (MeloDecayTIMER[1][64] != 0) {
	     MeloDecayTIMER[1][64]--;
	  if(MeloDecayTIMER[1][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 64, 0);}}              
   if   (MeloDecayTIMER[1][65] != 0) {
	     MeloDecayTIMER[1][65]--;
	  if(MeloDecayTIMER[1][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 65, 0);}}              
   if   (MeloDecayTIMER[1][66] != 0) {
	     MeloDecayTIMER[1][66]--;
	  if(MeloDecayTIMER[1][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 66, 0);}}              
   if   (MeloDecayTIMER[1][67] != 0) {
	     MeloDecayTIMER[1][67]--;
	  if(MeloDecayTIMER[1][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 67, 0);}}              
   if   (MeloDecayTIMER[1][68] != 0) {
	     MeloDecayTIMER[1][68]--;
	  if(MeloDecayTIMER[1][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 68, 0);}}              
   if   (MeloDecayTIMER[1][69] != 0) {
	     MeloDecayTIMER[1][69]--;
	  if(MeloDecayTIMER[1][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 69, 0);}}              
   if   (MeloDecayTIMER[1][70] != 0) {
	     MeloDecayTIMER[1][70]--;
	  if(MeloDecayTIMER[1][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 70, 0);}}              
   if   (MeloDecayTIMER[1][71] != 0) {
	     MeloDecayTIMER[1][71]--;
	  if(MeloDecayTIMER[1][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 71, 0);}}              
   if   (MeloDecayTIMER[1][72] != 0) {
	     MeloDecayTIMER[1][72]--;
	  if(MeloDecayTIMER[1][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 72, 0);}}              
   if   (MeloDecayTIMER[1][73] != 0) {
	     MeloDecayTIMER[1][73]--;
	  if(MeloDecayTIMER[1][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 73, 0);}}              
   if   (MeloDecayTIMER[1][74] != 0) {
	     MeloDecayTIMER[1][74]--;
	  if(MeloDecayTIMER[1][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 74, 0);}}              
   if   (MeloDecayTIMER[1][75] != 0) {
	     MeloDecayTIMER[1][75]--;
	  if(MeloDecayTIMER[1][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 75, 0);}}              
   if   (MeloDecayTIMER[1][76] != 0) {
	     MeloDecayTIMER[1][76]--;
	  if(MeloDecayTIMER[1][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 76, 0);}}              
   if   (MeloDecayTIMER[1][77] != 0) {
	     MeloDecayTIMER[1][77]--;
	  if(MeloDecayTIMER[1][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 77, 0);}}              
   if   (MeloDecayTIMER[1][78] != 0) {
	     MeloDecayTIMER[1][78]--;
	  if(MeloDecayTIMER[1][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 78, 0);}}              
   if   (MeloDecayTIMER[1][79] != 0) {
	     MeloDecayTIMER[1][79]--;
	  if(MeloDecayTIMER[1][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 79, 0);}}              
   if   (MeloDecayTIMER[1][80] != 0) {
	     MeloDecayTIMER[1][80]--;
	  if(MeloDecayTIMER[1][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 80, 0);}}              
   if   (MeloDecayTIMER[1][81] != 0) {
	     MeloDecayTIMER[1][81]--;
	  if(MeloDecayTIMER[1][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 81, 0);}}              
   if   (MeloDecayTIMER[1][82] != 0) {
	     MeloDecayTIMER[1][82]--;
	  if(MeloDecayTIMER[1][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 82, 0);}}              
   if   (MeloDecayTIMER[1][83] != 0) {
	     MeloDecayTIMER[1][83]--;
	  if(MeloDecayTIMER[1][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 83, 0);}}              
   if   (MeloDecayTIMER[1][84] != 0) {
	     MeloDecayTIMER[1][84]--;
	  if(MeloDecayTIMER[1][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 84, 0);}}              
   if   (MeloDecayTIMER[1][85] != 0) {
	     MeloDecayTIMER[1][85]--;
	  if(MeloDecayTIMER[1][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 85, 0);}}              
   if   (MeloDecayTIMER[1][86] != 0) {
	     MeloDecayTIMER[1][86]--;
	  if(MeloDecayTIMER[1][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 86, 0);}}              
   if   (MeloDecayTIMER[1][87] != 0) {
	     MeloDecayTIMER[1][87]--;
	  if(MeloDecayTIMER[1][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 87, 0);}}              
   if   (MeloDecayTIMER[1][88] != 0) {
	     MeloDecayTIMER[1][88]--;
	  if(MeloDecayTIMER[1][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 88, 0);}}              
   if   (MeloDecayTIMER[1][89] != 0) {
	     MeloDecayTIMER[1][89]--;
	  if(MeloDecayTIMER[1][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 89, 0);}}                    
   if   (MeloDecayTIMER[1][90] != 0) {
	     MeloDecayTIMER[1][90]--;
	  if(MeloDecayTIMER[1][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 90, 0);}}              
   if   (MeloDecayTIMER[1][91] != 0) {
	     MeloDecayTIMER[1][91]--;
	  if(MeloDecayTIMER[1][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 91, 0);}}              
   if   (MeloDecayTIMER[1][92] != 0) {
	     MeloDecayTIMER[1][92]--;
	  if(MeloDecayTIMER[1][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 92, 0);}}              
   if   (MeloDecayTIMER[1][93] != 0) {
	     MeloDecayTIMER[1][93]--;
	  if(MeloDecayTIMER[1][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 93, 0);}}   
   if   (MeloDecayTIMER[1][94] != 0) {
	     MeloDecayTIMER[1][94]--;
	  if(MeloDecayTIMER[1][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 94, 0);}}               
   if   (MeloDecayTIMER[1][95] != 0) {
	     MeloDecayTIMER[1][95]--;
	  if(MeloDecayTIMER[1][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 95, 0);}}              
   if   (MeloDecayTIMER[1][96] != 0) {
	     MeloDecayTIMER[1][96]--;
	  if(MeloDecayTIMER[1][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 96, 0);}}              
   if   (MeloDecayTIMER[1][97] != 0) {
	     MeloDecayTIMER[1][97]--;
	  if(MeloDecayTIMER[1][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 97, 0);}}              
   if   (MeloDecayTIMER[1][98] != 0) {
	     MeloDecayTIMER[1][98]--;
	  if(MeloDecayTIMER[1][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 98, 0);}}              
   if   (MeloDecayTIMER[1][99] != 0) {
	     MeloDecayTIMER[1][99]--;
	  if(MeloDecayTIMER[1][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 99, 0);}}              
   if   (MeloDecayTIMER[1][100] != 0) {
	     MeloDecayTIMER[1][100]--;
	  if(MeloDecayTIMER[1][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 100, 0);}}              
   if   (MeloDecayTIMER[1][101] != 0) {
	     MeloDecayTIMER[1][101]--;
	  if(MeloDecayTIMER[1][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 101, 0);}}              
   if   (MeloDecayTIMER[1][102] != 0) {
	     MeloDecayTIMER[1][102]--;
	  if(MeloDecayTIMER[1][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 102, 0);}}              
   if   (MeloDecayTIMER[1][103] != 0) {
	     MeloDecayTIMER[1][103]--;
	  if(MeloDecayTIMER[1][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 103, 0);}}              
   if   (MeloDecayTIMER[1][104] != 0) {
	     MeloDecayTIMER[1][104]--;
	  if(MeloDecayTIMER[1][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 104, 0);}}              
   if   (MeloDecayTIMER[1][105] != 0) {
	     MeloDecayTIMER[1][105]--;
	  if(MeloDecayTIMER[1][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 105, 0);}}              
   if   (MeloDecayTIMER[1][106] != 0) {
	     MeloDecayTIMER[1][106]--;
	  if(MeloDecayTIMER[1][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 106, 0);}}              
   if   (MeloDecayTIMER[1][107] != 0) {
	     MeloDecayTIMER[1][107]--;
	  if(MeloDecayTIMER[1][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 107, 0);}}              
   if   (MeloDecayTIMER[1][108] != 0) {
	     MeloDecayTIMER[1][108]--;
	  if(MeloDecayTIMER[1][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 108, 0);}}              
   if   (MeloDecayTIMER[1][109] != 0) {
	     MeloDecayTIMER[1][109]--;
	  if(MeloDecayTIMER[1][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 109, 0);}}              
   if   (MeloDecayTIMER[1][110] != 0) {
	     MeloDecayTIMER[1][110]--;
	  if(MeloDecayTIMER[1][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 110, 0);}}              
   if   (MeloDecayTIMER[1][111] != 0) {
	     MeloDecayTIMER[1][111]--;
	  if(MeloDecayTIMER[1][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 111, 0);}}              
   if   (MeloDecayTIMER[1][112] != 0) {
	     MeloDecayTIMER[1][112]--;
	  if(MeloDecayTIMER[1][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 112, 0);}}              
   if   (MeloDecayTIMER[1][113] != 0) {
	     MeloDecayTIMER[1][113]--;
	  if(MeloDecayTIMER[1][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 113, 0);}}              
   if   (MeloDecayTIMER[1][114] != 0) {
	     MeloDecayTIMER[1][114]--;
	  if(MeloDecayTIMER[1][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 114, 0);}}              
   if   (MeloDecayTIMER[1][115] != 0) {
	     MeloDecayTIMER[1][115]--;
	  if(MeloDecayTIMER[1][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 115, 0);}}              
   if   (MeloDecayTIMER[1][116] != 0) {
	     MeloDecayTIMER[1][116]--;
	  if(MeloDecayTIMER[1][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 116, 0);}}              
   if   (MeloDecayTIMER[1][117] != 0) {
	     MeloDecayTIMER[1][117]--;
	  if(MeloDecayTIMER[1][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 117, 0);}}              
   if   (MeloDecayTIMER[1][118] != 0) {
	     MeloDecayTIMER[1][118]--;
	  if(MeloDecayTIMER[1][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 118, 0);}}              
   if   (MeloDecayTIMER[1][119] != 0) {
	     MeloDecayTIMER[1][119]--;
	  if(MeloDecayTIMER[1][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 119, 0);}}              
   if   (MeloDecayTIMER[1][120] != 0) {
	     MeloDecayTIMER[1][120]--;
	  if(MeloDecayTIMER[1][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 120, 0);}}              
   if   (MeloDecayTIMER[1][121] != 0) {
	     MeloDecayTIMER[1][121]--;
	  if(MeloDecayTIMER[1][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 121, 0);}}              
   if   (MeloDecayTIMER[1][122] != 0) {
	     MeloDecayTIMER[1][122]--;
	  if(MeloDecayTIMER[1][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 122, 0);}}              
   if   (MeloDecayTIMER[1][123] != 0) {
	     MeloDecayTIMER[1][123]--;
	  if(MeloDecayTIMER[1][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 123, 0);}}              
   if   (MeloDecayTIMER[1][124] != 0) {
	     MeloDecayTIMER[1][124]--;
	  if(MeloDecayTIMER[1][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 124, 0);}}              
   if   (MeloDecayTIMER[1][125] != 0) {
	     MeloDecayTIMER[1][125]--;
	  if(MeloDecayTIMER[1][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 125, 0);}}              
   if   (MeloDecayTIMER[1][126] != 0) {
	     MeloDecayTIMER[1][126]--;
	  if(MeloDecayTIMER[1][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 126, 0);}}              
   if   (MeloDecayTIMER[1][127] != 0) {
	     MeloDecayTIMER[1][127]--;
	  if(MeloDecayTIMER[1][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 1, 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 1, 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay2(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[2][1] != 0) {
	     MeloDecayTIMER[2][1]--;
	  if(MeloDecayTIMER[2][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 1, 0);}}  
   if   (MeloDecayTIMER[2][2] != 0) {
	     MeloDecayTIMER[2][2]--;
	  if(MeloDecayTIMER[2][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 2, 0);}}   
   if   (MeloDecayTIMER[2][3] != 0) {
	     MeloDecayTIMER[2][3]--;
	  if(MeloDecayTIMER[2][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 3, 0);}}
   if   (MeloDecayTIMER[2][4] != 0) {
	     MeloDecayTIMER[2][4]--;
	  if(MeloDecayTIMER[2][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 4, 0);}} 
   if   (MeloDecayTIMER[2][5] != 0) {
	     MeloDecayTIMER[2][5]--;
	  if(MeloDecayTIMER[2][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 5, 0);}} 
   if   (MeloDecayTIMER[2][6] != 0) {
	     MeloDecayTIMER[2][6]--;
	  if(MeloDecayTIMER[2][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 6, 0);}} 
   if   (MeloDecayTIMER[2][7] != 0) {
	     MeloDecayTIMER[2][7]--;
	  if(MeloDecayTIMER[2][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 7, 0);}}   
   if   (MeloDecayTIMER[2][8] != 0) {
	     MeloDecayTIMER[2][8]--;
	  if(MeloDecayTIMER[2][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 8, 0);}}   
   if   (MeloDecayTIMER[2][9] != 0) {
	     MeloDecayTIMER[2][9]--;
	  if(MeloDecayTIMER[2][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 9, 0);}}   
   if   (MeloDecayTIMER[2][10] != 0) {
	     MeloDecayTIMER[2][10]--;
	  if(MeloDecayTIMER[2][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 10, 0);}}   
   if   (MeloDecayTIMER[2][11] != 0) {
	     MeloDecayTIMER[2][11]--;
	  if(MeloDecayTIMER[2][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 11, 0);}}   
   if   (MeloDecayTIMER[2][12] != 0) {
	     MeloDecayTIMER[2][12]--;
	  if(MeloDecayTIMER[2][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 12, 0);}}   
   if   (MeloDecayTIMER[2][13] != 0) {
	     MeloDecayTIMER[2][13]--;
	  if(MeloDecayTIMER[2][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 13, 0);}}   
   if   (MeloDecayTIMER[2][14] != 0) {
	     MeloDecayTIMER[2][14]--;
	  if(MeloDecayTIMER[2][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 14, 0);}}   
   if   (MeloDecayTIMER[2][15] != 0) {
	     MeloDecayTIMER[2][15]--;
	  if(MeloDecayTIMER[2][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 15, 0);}}   
   if   (MeloDecayTIMER[2][16] != 0) {
	     MeloDecayTIMER[2][16]--;
	  if(MeloDecayTIMER[2][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 16, 0);}}   
   if   (MeloDecayTIMER[2][17] != 0) {
	     MeloDecayTIMER[2][17]--;
	  if(MeloDecayTIMER[2][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 17, 0);}}   
   if   (MeloDecayTIMER[2][18] != 0) {
	     MeloDecayTIMER[2][18]--;
	  if(MeloDecayTIMER[2][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 18, 0);}}   
   if   (MeloDecayTIMER[2][19] != 0) {
	     MeloDecayTIMER[2][19]--;
	  if(MeloDecayTIMER[2][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 19, 0);}}   
   if   (MeloDecayTIMER[2][20] != 0) {
	     MeloDecayTIMER[2][20]--;
	  if(MeloDecayTIMER[2][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 20, 0);}}   
   if   (MeloDecayTIMER[2][21] != 0) {
	     MeloDecayTIMER[2][21]--;
	  if(MeloDecayTIMER[2][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 21, 0);}}   
   if   (MeloDecayTIMER[2][22] != 0) {
	     MeloDecayTIMER[2][22]--;
	  if(MeloDecayTIMER[2][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 22, 0);}}   
   if   (MeloDecayTIMER[2][23] != 0) {
	     MeloDecayTIMER[2][23]--;
	  if(MeloDecayTIMER[2][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 23, 0);}}   
   if   (MeloDecayTIMER[2][24] != 0) {
	     MeloDecayTIMER[2][24]--;
	  if(MeloDecayTIMER[2][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 24, 0);}}   
   if   (MeloDecayTIMER[2][25] != 0) {
	     MeloDecayTIMER[2][25]--;
	  if(MeloDecayTIMER[2][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 25, 0);}}   
   if   (MeloDecayTIMER[2][26] != 0) {
	     MeloDecayTIMER[2][26]--;
	  if(MeloDecayTIMER[2][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 26, 0);}}   
   if   (MeloDecayTIMER[2][27] != 0) {
	     MeloDecayTIMER[2][27]--;
	  if(MeloDecayTIMER[2][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 27, 0);}}   
   if   (MeloDecayTIMER[2][28] != 0) {
	     MeloDecayTIMER[2][28]--;
	  if(MeloDecayTIMER[2][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 28, 0);}}   
   if   (MeloDecayTIMER[2][29] != 0) {
	     MeloDecayTIMER[2][29]--;
	  if(MeloDecayTIMER[2][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 29, 0);}}   
   if   (MeloDecayTIMER[2][30] != 0) {
	     MeloDecayTIMER[2][30]--;
	  if(MeloDecayTIMER[2][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 30, 0);}}   
   if   (MeloDecayTIMER[2][31] != 0) {
	     MeloDecayTIMER[2][31]--;
	  if(MeloDecayTIMER[2][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 31, 0);}}   
   if   (MeloDecayTIMER[2][32] != 0) {
	     MeloDecayTIMER[2][32]--;
	  if(MeloDecayTIMER[2][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 32, 0);}}   
   if   (MeloDecayTIMER[2][33] != 0) {
	     MeloDecayTIMER[2][33]--;
	  if(MeloDecayTIMER[2][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 33, 0);}}   
   if   (MeloDecayTIMER[2][34] != 0) {
	     MeloDecayTIMER[2][34]--;
	  if(MeloDecayTIMER[2][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 34, 0);}}   
   if   (MeloDecayTIMER[2][35] != 0) {
	     MeloDecayTIMER[2][35]--;
	  if(MeloDecayTIMER[2][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 35, 0);}}   
   if   (MeloDecayTIMER[2][36] != 0) {
	     MeloDecayTIMER[2][36]--;
	  if(MeloDecayTIMER[2][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 36, 0);}}   
   if   (MeloDecayTIMER[2][37] != 0) {
	     MeloDecayTIMER[2][37]--;
	  if(MeloDecayTIMER[2][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 37, 0);}}   
   if   (MeloDecayTIMER[2][38] != 0) {
	     MeloDecayTIMER[2][38]--;
	  if(MeloDecayTIMER[2][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 38, 0);}}         
   if   (MeloDecayTIMER[2][39] != 0) {
	     MeloDecayTIMER[2][39]--;
	  if(MeloDecayTIMER[2][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 39, 0);}}              
   if   (MeloDecayTIMER[2][40] != 0) {
	     MeloDecayTIMER[2][40]--;
	  if(MeloDecayTIMER[2][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 40, 0);}}              
   if   (MeloDecayTIMER[2][41] != 0) {
	     MeloDecayTIMER[2][41]--;
	  if(MeloDecayTIMER[2][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 41, 0);}}              
   if   (MeloDecayTIMER[2][42] != 0) {
	     MeloDecayTIMER[2][42]--;
	  if(MeloDecayTIMER[2][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 42, 0);}}             
   if   (MeloDecayTIMER[2][43] != 0) {
	     MeloDecayTIMER[2][43]--;
	  if(MeloDecayTIMER[2][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 43, 0);}}              
   if   (MeloDecayTIMER[2][44] != 0) {
	     MeloDecayTIMER[2][44]--;
	  if(MeloDecayTIMER[2][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 44, 0);}}              
   if   (MeloDecayTIMER[2][45] != 0) {
	     MeloDecayTIMER[2][45]--;
	  if(MeloDecayTIMER[2][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 45, 0);}}              
   if   (MeloDecayTIMER[2][46] != 0) {
	     MeloDecayTIMER[2][46]--;
	  if(MeloDecayTIMER[2][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 46, 0);}}              
   if   (MeloDecayTIMER[2][47] != 0) {
	     MeloDecayTIMER[2][47]--;
	  if(MeloDecayTIMER[2][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 47, 0);}}              
   if   (MeloDecayTIMER[2][48] != 0) {
	     MeloDecayTIMER[2][48]--;
	  if(MeloDecayTIMER[2][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 48, 0);}}              
   if   (MeloDecayTIMER[2][49] != 0) {
	     MeloDecayTIMER[2][49]--;
	  if(MeloDecayTIMER[2][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 49, 0);}}              
   if   (MeloDecayTIMER[2][50] != 0) {
	     MeloDecayTIMER[2][50]--;
	  if(MeloDecayTIMER[2][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 50, 0);}}              
   if   (MeloDecayTIMER[2][51] != 0) {
	     MeloDecayTIMER[2][51]--;
	  if(MeloDecayTIMER[2][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 51, 0);}}              
   if   (MeloDecayTIMER[2][52] != 0) {
	     MeloDecayTIMER[2][52]--;
	  if(MeloDecayTIMER[2][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 52, 0);}}    
   if   (MeloDecayTIMER[2][53] != 0) {
	     MeloDecayTIMER[2][53]--;
	  if(MeloDecayTIMER[2][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 53, 0);}}              
   if   (MeloDecayTIMER[2][54] != 0) {
	     MeloDecayTIMER[2][54]--;
	  if(MeloDecayTIMER[2][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 54, 0);}}              
   if   (MeloDecayTIMER[2][55] != 0) {
	     MeloDecayTIMER[2][55]--;
	  if(MeloDecayTIMER[2][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 55, 0);}}              
   if   (MeloDecayTIMER[2][56] != 0) {
	     MeloDecayTIMER[2][56]--;
	  if(MeloDecayTIMER[2][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 56, 0);}}              
   if   (MeloDecayTIMER[2][57] != 0) {
	     MeloDecayTIMER[2][57]--;
	  if(MeloDecayTIMER[2][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 57, 0);}}              
   if   (MeloDecayTIMER[2][58] != 0) {
	     MeloDecayTIMER[2][58]--;
	  if(MeloDecayTIMER[2][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 58, 0);}}              
   if   (MeloDecayTIMER[2][59] != 0) {
	     MeloDecayTIMER[2][59]--;
	  if(MeloDecayTIMER[2][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 59, 0);}}              
   if   (MeloDecayTIMER[2][60] != 0) {
	     MeloDecayTIMER[2][60]--;
	  if(MeloDecayTIMER[2][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 60, 0);}}              
   if   (MeloDecayTIMER[2][61] != 0) {
	     MeloDecayTIMER[2][61]--;
	  if(MeloDecayTIMER[2][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 61, 0);}}              
   if   (MeloDecayTIMER[2][62] != 0) {
	     MeloDecayTIMER[2][62]--;
	  if(MeloDecayTIMER[2][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 62, 0);}}              
   if   (MeloDecayTIMER[2][63] != 0) {
	     MeloDecayTIMER[2][63]--;
	  if(MeloDecayTIMER[2][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 63, 0);}}              
   if   (MeloDecayTIMER[2][64] != 0) {
	     MeloDecayTIMER[2][64]--;
	  if(MeloDecayTIMER[2][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 64, 0);}}              
   if   (MeloDecayTIMER[2][65] != 0) {
	     MeloDecayTIMER[2][65]--;
	  if(MeloDecayTIMER[2][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 65, 0);}}              
   if   (MeloDecayTIMER[2][66] != 0) {
	     MeloDecayTIMER[2][66]--;
	  if(MeloDecayTIMER[2][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 66, 0);}}              
   if   (MeloDecayTIMER[2][67] != 0) {
	     MeloDecayTIMER[2][67]--;
	  if(MeloDecayTIMER[2][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 67, 0);}}              
   if   (MeloDecayTIMER[2][68] != 0) {
	     MeloDecayTIMER[2][68]--;
	  if(MeloDecayTIMER[2][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 68, 0);}}              
   if   (MeloDecayTIMER[2][69] != 0) {
	     MeloDecayTIMER[2][69]--;
	  if(MeloDecayTIMER[2][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 69, 0);}}              
   if   (MeloDecayTIMER[2][70] != 0) {
	     MeloDecayTIMER[2][70]--;
	  if(MeloDecayTIMER[2][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 70, 0);}}              
   if   (MeloDecayTIMER[2][71] != 0) {
	     MeloDecayTIMER[2][71]--;
	  if(MeloDecayTIMER[2][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 71, 0);}}              
   if   (MeloDecayTIMER[2][72] != 0) {
	     MeloDecayTIMER[2][72]--;
	  if(MeloDecayTIMER[2][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 72, 0);}}              
   if   (MeloDecayTIMER[2][73] != 0) {
	     MeloDecayTIMER[2][73]--;
	  if(MeloDecayTIMER[2][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 73, 0);}}              
   if   (MeloDecayTIMER[2][74] != 0) {
	     MeloDecayTIMER[2][74]--;
	  if(MeloDecayTIMER[2][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 74, 0);}}              
   if   (MeloDecayTIMER[2][75] != 0) {
	     MeloDecayTIMER[2][75]--;
	  if(MeloDecayTIMER[2][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 75, 0);}}              
   if   (MeloDecayTIMER[2][76] != 0) {
	     MeloDecayTIMER[2][76]--;
	  if(MeloDecayTIMER[2][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 76, 0);}}              
   if   (MeloDecayTIMER[2][77] != 0) {
	     MeloDecayTIMER[2][77]--;
	  if(MeloDecayTIMER[2][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 77, 0);}}              
   if   (MeloDecayTIMER[2][78] != 0) {
	     MeloDecayTIMER[2][78]--;
	  if(MeloDecayTIMER[2][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 78, 0);}}              
   if   (MeloDecayTIMER[2][79] != 0) {
	     MeloDecayTIMER[2][79]--;
	  if(MeloDecayTIMER[2][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 79, 0);}}              
   if   (MeloDecayTIMER[2][80] != 0) {
	     MeloDecayTIMER[2][80]--;
	  if(MeloDecayTIMER[2][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 80, 0);}}              
   if   (MeloDecayTIMER[2][81] != 0) {
	     MeloDecayTIMER[2][81]--;
	  if(MeloDecayTIMER[2][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 81, 0);}}              
   if   (MeloDecayTIMER[2][82] != 0) {
	     MeloDecayTIMER[2][82]--;
	  if(MeloDecayTIMER[2][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 82, 0);}}              
   if   (MeloDecayTIMER[2][83] != 0) {
	     MeloDecayTIMER[2][83]--;
	  if(MeloDecayTIMER[2][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 83, 0);}}              
   if   (MeloDecayTIMER[2][84] != 0) {
	     MeloDecayTIMER[2][84]--;
	  if(MeloDecayTIMER[2][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 84, 0);}}              
   if   (MeloDecayTIMER[2][85] != 0) {
	     MeloDecayTIMER[2][85]--;
	  if(MeloDecayTIMER[2][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 85, 0);}}              
   if   (MeloDecayTIMER[2][86] != 0) {
	     MeloDecayTIMER[2][86]--;
	  if(MeloDecayTIMER[2][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 86, 0);}}              
   if   (MeloDecayTIMER[2][87] != 0) {
	     MeloDecayTIMER[2][87]--;
	  if(MeloDecayTIMER[2][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 87, 0);}}              
   if   (MeloDecayTIMER[2][88] != 0) {
	     MeloDecayTIMER[2][88]--;
	  if(MeloDecayTIMER[2][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 88, 0);}}              
   if   (MeloDecayTIMER[2][89] != 0) {
	     MeloDecayTIMER[2][89]--;
	  if(MeloDecayTIMER[2][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 89, 0);}}                    
   if   (MeloDecayTIMER[2][90] != 0) {
	     MeloDecayTIMER[2][90]--;
	  if(MeloDecayTIMER[2][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 90, 0);}}              
   if   (MeloDecayTIMER[2][91] != 0) {
	     MeloDecayTIMER[2][91]--;
	  if(MeloDecayTIMER[2][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 91, 0);}}              
   if   (MeloDecayTIMER[2][92] != 0) {
	     MeloDecayTIMER[2][92]--;
	  if(MeloDecayTIMER[2][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 92, 0);}}              
   if   (MeloDecayTIMER[2][93] != 0) {
	     MeloDecayTIMER[2][93]--;
	  if(MeloDecayTIMER[2][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 93, 0);}}   
   if   (MeloDecayTIMER[2][94] != 0) {
	     MeloDecayTIMER[2][94]--;
	  if(MeloDecayTIMER[2][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 94, 0);}}               
   if   (MeloDecayTIMER[2][95] != 0) {
	     MeloDecayTIMER[2][95]--;
	  if(MeloDecayTIMER[2][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 95, 0);}}              
   if   (MeloDecayTIMER[2][96] != 0) {
	     MeloDecayTIMER[2][96]--;
	  if(MeloDecayTIMER[2][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 96, 0);}}              
   if   (MeloDecayTIMER[2][97] != 0) {
	     MeloDecayTIMER[2][97]--;
	  if(MeloDecayTIMER[2][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 97, 0);}}              
   if   (MeloDecayTIMER[2][98] != 0) {
	     MeloDecayTIMER[2][98]--;
	  if(MeloDecayTIMER[2][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 98, 0);}}              
   if   (MeloDecayTIMER[2][99] != 0) {
	     MeloDecayTIMER[2][99]--;
	  if(MeloDecayTIMER[2][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 99, 0);}}              
   if   (MeloDecayTIMER[2][100] != 0) {
	     MeloDecayTIMER[2][100]--;
	  if(MeloDecayTIMER[2][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 100, 0);}}              
   if   (MeloDecayTIMER[2][101] != 0) {
	     MeloDecayTIMER[2][101]--;
	  if(MeloDecayTIMER[2][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 101, 0);}}              
   if   (MeloDecayTIMER[2][102] != 0) {
	     MeloDecayTIMER[2][102]--;
	  if(MeloDecayTIMER[2][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 102, 0);}}              
   if   (MeloDecayTIMER[2][103] != 0) {
	     MeloDecayTIMER[2][103]--;
	  if(MeloDecayTIMER[2][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 103, 0);}}              
   if   (MeloDecayTIMER[2][104] != 0) {
	     MeloDecayTIMER[2][104]--;
	  if(MeloDecayTIMER[2][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 104, 0);}}              
   if   (MeloDecayTIMER[2][105] != 0) {
	     MeloDecayTIMER[2][105]--;
	  if(MeloDecayTIMER[2][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 105, 0);}}              
   if   (MeloDecayTIMER[2][106] != 0) {
	     MeloDecayTIMER[2][106]--;
	  if(MeloDecayTIMER[2][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 106, 0);}}              
   if   (MeloDecayTIMER[2][107] != 0) {
	     MeloDecayTIMER[2][107]--;
	  if(MeloDecayTIMER[2][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 107, 0);}}              
   if   (MeloDecayTIMER[2][108] != 0) {
	     MeloDecayTIMER[2][108]--;
	  if(MeloDecayTIMER[2][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 108, 0);}}              
   if   (MeloDecayTIMER[2][109] != 0) {
	     MeloDecayTIMER[2][109]--;
	  if(MeloDecayTIMER[2][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 109, 0);}}              
   if   (MeloDecayTIMER[2][110] != 0) {
	     MeloDecayTIMER[2][110]--;
	  if(MeloDecayTIMER[2][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 110, 0);}}              
   if   (MeloDecayTIMER[2][111] != 0) {
	     MeloDecayTIMER[2][111]--;
	  if(MeloDecayTIMER[2][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 111, 0);}}              
   if   (MeloDecayTIMER[2][112] != 0) {
	     MeloDecayTIMER[2][112]--;
	  if(MeloDecayTIMER[2][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 112, 0);}}              
   if   (MeloDecayTIMER[2][113] != 0) {
	     MeloDecayTIMER[2][113]--;
	  if(MeloDecayTIMER[2][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 113, 0);}}              
   if   (MeloDecayTIMER[2][114] != 0) {
	     MeloDecayTIMER[2][114]--;
	  if(MeloDecayTIMER[2][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 114, 0);}}              
   if   (MeloDecayTIMER[2][115] != 0) {
	     MeloDecayTIMER[2][115]--;
	  if(MeloDecayTIMER[2][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 115, 0);}}              
   if   (MeloDecayTIMER[2][116] != 0) {
	     MeloDecayTIMER[2][116]--;
	  if(MeloDecayTIMER[2][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 116, 0);}}              
   if   (MeloDecayTIMER[2][117] != 0) {
	     MeloDecayTIMER[2][117]--;
	  if(MeloDecayTIMER[2][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 117, 0);}}              
   if   (MeloDecayTIMER[2][118] != 0) {
	     MeloDecayTIMER[2][118]--;
	  if(MeloDecayTIMER[2][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 118, 0);}}              
   if   (MeloDecayTIMER[2][119] != 0) {
	     MeloDecayTIMER[2][119]--;
	  if(MeloDecayTIMER[2][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 119, 0);}}              
   if   (MeloDecayTIMER[2][120] != 0) {
	     MeloDecayTIMER[2][120]--;
	  if(MeloDecayTIMER[2][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 120, 0);}}              
   if   (MeloDecayTIMER[2][121] != 0) {
	     MeloDecayTIMER[2][121]--;
	  if(MeloDecayTIMER[2][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 121, 0);}}              
   if   (MeloDecayTIMER[2][122] != 0) {
	     MeloDecayTIMER[2][122]--;
	  if(MeloDecayTIMER[2][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 122, 0);}}              
   if   (MeloDecayTIMER[2][123] != 0) {
	     MeloDecayTIMER[2][123]--;
	  if(MeloDecayTIMER[2][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 123, 0);}}              
   if   (MeloDecayTIMER[2][124] != 0) {
	     MeloDecayTIMER[2][124]--;
	  if(MeloDecayTIMER[2][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 124, 0);}}              
   if   (MeloDecayTIMER[2][125] != 0) {
	     MeloDecayTIMER[2][125]--;
	  if(MeloDecayTIMER[2][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 125, 0);}}              
   if   (MeloDecayTIMER[2][126] != 0) {
	     MeloDecayTIMER[2][126]--;
	  if(MeloDecayTIMER[2][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 126, 0);}}              
   if   (MeloDecayTIMER[2][127] != 0) {
	     MeloDecayTIMER[2][127]--;
	  if(MeloDecayTIMER[2][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 2, 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 2, 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay3(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[3][1] != 0) {
	     MeloDecayTIMER[3][1]--;
	  if(MeloDecayTIMER[3][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 1, 0);}}  
   if   (MeloDecayTIMER[3][2] != 0) {
	     MeloDecayTIMER[3][2]--;
	  if(MeloDecayTIMER[3][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 2, 0);}}   
   if   (MeloDecayTIMER[3][3] != 0) {
	     MeloDecayTIMER[3][3]--;
	  if(MeloDecayTIMER[3][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 3, 0);}}
   if   (MeloDecayTIMER[3][4] != 0) {
	     MeloDecayTIMER[3][4]--;
	  if(MeloDecayTIMER[3][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 4, 0);}} 
   if   (MeloDecayTIMER[3][5] != 0) {
	     MeloDecayTIMER[3][5]--;
	  if(MeloDecayTIMER[3][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 5, 0);}} 
   if   (MeloDecayTIMER[3][6] != 0) {
	     MeloDecayTIMER[3][6]--;
	  if(MeloDecayTIMER[3][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 6, 0);}} 
   if   (MeloDecayTIMER[3][7] != 0) {
	     MeloDecayTIMER[3][7]--;
	  if(MeloDecayTIMER[3][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 7, 0);}}   
   if   (MeloDecayTIMER[3][8] != 0) {
	     MeloDecayTIMER[3][8]--;
	  if(MeloDecayTIMER[3][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 8, 0);}}   
   if   (MeloDecayTIMER[3][9] != 0) {
	     MeloDecayTIMER[3][9]--;
	  if(MeloDecayTIMER[3][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 9, 0);}}   
   if   (MeloDecayTIMER[3][10] != 0) {
	     MeloDecayTIMER[3][10]--;
	  if(MeloDecayTIMER[3][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 10, 0);}}   
   if   (MeloDecayTIMER[3][11] != 0) {
	     MeloDecayTIMER[3][11]--;
	  if(MeloDecayTIMER[3][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 11, 0);}}   
   if   (MeloDecayTIMER[3][12] != 0) {
	     MeloDecayTIMER[3][12]--;
	  if(MeloDecayTIMER[3][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 12, 0);}}   
   if   (MeloDecayTIMER[3][13] != 0) {
	     MeloDecayTIMER[3][13]--;
	  if(MeloDecayTIMER[3][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 13, 0);}}   
   if   (MeloDecayTIMER[3][14] != 0) {
	     MeloDecayTIMER[3][14]--;
	  if(MeloDecayTIMER[3][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 14, 0);}}   
   if   (MeloDecayTIMER[3][15] != 0) {
	     MeloDecayTIMER[3][15]--;
	  if(MeloDecayTIMER[3][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 15, 0);}}   
   if   (MeloDecayTIMER[3][16] != 0) {
	     MeloDecayTIMER[3][16]--;
	  if(MeloDecayTIMER[3][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 16, 0);}}   
   if   (MeloDecayTIMER[3][17] != 0) {
	     MeloDecayTIMER[3][17]--;
	  if(MeloDecayTIMER[3][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 17, 0);}}   
   if   (MeloDecayTIMER[3][18] != 0) {
	     MeloDecayTIMER[3][18]--;
	  if(MeloDecayTIMER[3][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 18, 0);}}   
   if   (MeloDecayTIMER[3][19] != 0) {
	     MeloDecayTIMER[3][19]--;
	  if(MeloDecayTIMER[3][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 19, 0);}}   
   if   (MeloDecayTIMER[3][20] != 0) {
	     MeloDecayTIMER[3][20]--;
	  if(MeloDecayTIMER[3][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 20, 0);}}   
   if   (MeloDecayTIMER[3][21] != 0) {
	     MeloDecayTIMER[3][21]--;
	  if(MeloDecayTIMER[3][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 21, 0);}}   
   if   (MeloDecayTIMER[3][22] != 0) {
	     MeloDecayTIMER[3][22]--;
	  if(MeloDecayTIMER[3][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 22, 0);}}   
   if   (MeloDecayTIMER[3][23] != 0) {
	     MeloDecayTIMER[3][23]--;
	  if(MeloDecayTIMER[3][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 23, 0);}}   
   if   (MeloDecayTIMER[3][24] != 0) {
	     MeloDecayTIMER[3][24]--;
	  if(MeloDecayTIMER[3][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 24, 0);}}   
   if   (MeloDecayTIMER[3][25] != 0) {
	     MeloDecayTIMER[3][25]--;
	  if(MeloDecayTIMER[3][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 25, 0);}}   
   if   (MeloDecayTIMER[3][26] != 0) {
	     MeloDecayTIMER[3][26]--;
	  if(MeloDecayTIMER[3][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 26, 0);}}   
   if   (MeloDecayTIMER[3][27] != 0) {
	     MeloDecayTIMER[3][27]--;
	  if(MeloDecayTIMER[3][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 27, 0);}}   
   if   (MeloDecayTIMER[3][28] != 0) {
	     MeloDecayTIMER[3][28]--;
	  if(MeloDecayTIMER[3][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 28, 0);}}   
   if   (MeloDecayTIMER[3][29] != 0) {
	     MeloDecayTIMER[3][29]--;
	  if(MeloDecayTIMER[3][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 29, 0);}}   
   if   (MeloDecayTIMER[3][30] != 0) {
	     MeloDecayTIMER[3][30]--;
	  if(MeloDecayTIMER[3][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 30, 0);}}   
   if   (MeloDecayTIMER[3][31] != 0) {
	     MeloDecayTIMER[3][31]--;
	  if(MeloDecayTIMER[3][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 31, 0);}}   
   if   (MeloDecayTIMER[3][32] != 0) {
	     MeloDecayTIMER[3][32]--;
	  if(MeloDecayTIMER[3][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 32, 0);}}   
   if   (MeloDecayTIMER[3][33] != 0) {
	     MeloDecayTIMER[3][33]--;
	  if(MeloDecayTIMER[3][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 33, 0);}}   
   if   (MeloDecayTIMER[3][34] != 0) {
	     MeloDecayTIMER[3][34]--;
	  if(MeloDecayTIMER[3][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 34, 0);}}   
   if   (MeloDecayTIMER[3][35] != 0) {
	     MeloDecayTIMER[3][35]--;
	  if(MeloDecayTIMER[3][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 35, 0);}}   
   if   (MeloDecayTIMER[3][36] != 0) {
	     MeloDecayTIMER[3][36]--;
	  if(MeloDecayTIMER[3][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 36, 0);}}   
   if   (MeloDecayTIMER[3][37] != 0) {
	     MeloDecayTIMER[3][37]--;
	  if(MeloDecayTIMER[3][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 37, 0);}}   
   if   (MeloDecayTIMER[3][38] != 0) {
	     MeloDecayTIMER[3][38]--;
	  if(MeloDecayTIMER[3][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 38, 0);}}         
   if   (MeloDecayTIMER[3][39] != 0) {
	     MeloDecayTIMER[3][39]--;
	  if(MeloDecayTIMER[3][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 39, 0);}}              
   if   (MeloDecayTIMER[3][40] != 0) {
	     MeloDecayTIMER[3][40]--;
	  if(MeloDecayTIMER[3][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 40, 0);}}              
   if   (MeloDecayTIMER[3][41] != 0) {
	     MeloDecayTIMER[3][41]--;
	  if(MeloDecayTIMER[3][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 41, 0);}}              
   if   (MeloDecayTIMER[3][42] != 0) {
	     MeloDecayTIMER[3][42]--;
	  if(MeloDecayTIMER[3][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 42, 0);}}             
   if   (MeloDecayTIMER[3][43] != 0) {
	     MeloDecayTIMER[3][43]--;
	  if(MeloDecayTIMER[3][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 43, 0);}}              
   if   (MeloDecayTIMER[3][44] != 0) {
	     MeloDecayTIMER[3][44]--;
	  if(MeloDecayTIMER[3][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 44, 0);}}              
   if   (MeloDecayTIMER[3][45] != 0) {
	     MeloDecayTIMER[3][45]--;
	  if(MeloDecayTIMER[3][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 45, 0);}}              
   if   (MeloDecayTIMER[3][46] != 0) {
	     MeloDecayTIMER[3][46]--;
	  if(MeloDecayTIMER[3][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 46, 0);}}              
   if   (MeloDecayTIMER[3][47] != 0) {
	     MeloDecayTIMER[3][47]--;
	  if(MeloDecayTIMER[3][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 47, 0);}}              
   if   (MeloDecayTIMER[3][48] != 0) {
	     MeloDecayTIMER[3][48]--;
	  if(MeloDecayTIMER[3][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 48, 0);}}              
   if   (MeloDecayTIMER[3][49] != 0) {
	     MeloDecayTIMER[3][49]--;
	  if(MeloDecayTIMER[3][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 49, 0);}}              
   if   (MeloDecayTIMER[3][50] != 0) {
	     MeloDecayTIMER[3][50]--;
	  if(MeloDecayTIMER[3][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 50, 0);}}              
   if   (MeloDecayTIMER[3][51] != 0) {
	     MeloDecayTIMER[3][51]--;
	  if(MeloDecayTIMER[3][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 51, 0);}}              
   if   (MeloDecayTIMER[3][52] != 0) {
	     MeloDecayTIMER[3][52]--;
	  if(MeloDecayTIMER[3][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 52, 0);}}    
   if   (MeloDecayTIMER[3][53] != 0) {
	     MeloDecayTIMER[3][53]--;
	  if(MeloDecayTIMER[3][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 53, 0);}}              
   if   (MeloDecayTIMER[3][54] != 0) {
	     MeloDecayTIMER[3][54]--;
	  if(MeloDecayTIMER[3][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 54, 0);}}              
   if   (MeloDecayTIMER[3][55] != 0) {
	     MeloDecayTIMER[3][55]--;
	  if(MeloDecayTIMER[3][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 55, 0);}}              
   if   (MeloDecayTIMER[3][56] != 0) {
	     MeloDecayTIMER[3][56]--;
	  if(MeloDecayTIMER[3][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 56, 0);}}              
   if   (MeloDecayTIMER[3][57] != 0) {
	     MeloDecayTIMER[3][57]--;
	  if(MeloDecayTIMER[3][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 57, 0);}}              
   if   (MeloDecayTIMER[3][58] != 0) {
	     MeloDecayTIMER[3][58]--;
	  if(MeloDecayTIMER[3][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 58, 0);}}              
   if   (MeloDecayTIMER[3][59] != 0) {
	     MeloDecayTIMER[3][59]--;
	  if(MeloDecayTIMER[3][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 59, 0);}}              
   if   (MeloDecayTIMER[3][60] != 0) {
	     MeloDecayTIMER[3][60]--;
	  if(MeloDecayTIMER[3][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 60, 0);}}              
   if   (MeloDecayTIMER[3][61] != 0) {
	     MeloDecayTIMER[3][61]--;
	  if(MeloDecayTIMER[3][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 61, 0);}}              
   if   (MeloDecayTIMER[3][62] != 0) {
	     MeloDecayTIMER[3][62]--;
	  if(MeloDecayTIMER[3][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 62, 0);}}              
   if   (MeloDecayTIMER[3][63] != 0) {
	     MeloDecayTIMER[3][63]--;
	  if(MeloDecayTIMER[3][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 63, 0);}}              
   if   (MeloDecayTIMER[3][64] != 0) {
	     MeloDecayTIMER[3][64]--;
	  if(MeloDecayTIMER[3][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 64, 0);}}              
   if   (MeloDecayTIMER[3][65] != 0) {
	     MeloDecayTIMER[3][65]--;
	  if(MeloDecayTIMER[3][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 65, 0);}}              
   if   (MeloDecayTIMER[3][66] != 0) {
	     MeloDecayTIMER[3][66]--;
	  if(MeloDecayTIMER[3][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 66, 0);}}              
   if   (MeloDecayTIMER[3][67] != 0) {
	     MeloDecayTIMER[3][67]--;
	  if(MeloDecayTIMER[3][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 67, 0);}}              
   if   (MeloDecayTIMER[3][68] != 0) {
	     MeloDecayTIMER[3][68]--;
	  if(MeloDecayTIMER[3][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 68, 0);}}              
   if   (MeloDecayTIMER[3][69] != 0) {
	     MeloDecayTIMER[3][69]--;
	  if(MeloDecayTIMER[3][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 69, 0);}}              
   if   (MeloDecayTIMER[3][70] != 0) {
	     MeloDecayTIMER[3][70]--;
	  if(MeloDecayTIMER[3][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 70, 0);}}              
   if   (MeloDecayTIMER[3][71] != 0) {
	     MeloDecayTIMER[3][71]--;
	  if(MeloDecayTIMER[3][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 71, 0);}}              
   if   (MeloDecayTIMER[3][72] != 0) {
	     MeloDecayTIMER[3][72]--;
	  if(MeloDecayTIMER[3][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 72, 0);}}              
   if   (MeloDecayTIMER[3][73] != 0) {
	     MeloDecayTIMER[3][73]--;
	  if(MeloDecayTIMER[3][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 73, 0);}}              
   if   (MeloDecayTIMER[3][74] != 0) {
	     MeloDecayTIMER[3][74]--;
	  if(MeloDecayTIMER[3][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 74, 0);}}              
   if   (MeloDecayTIMER[3][75] != 0) {
	     MeloDecayTIMER[3][75]--;
	  if(MeloDecayTIMER[3][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 75, 0);}}              
   if   (MeloDecayTIMER[3][76] != 0) {
	     MeloDecayTIMER[3][76]--;
	  if(MeloDecayTIMER[3][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 76, 0);}}              
   if   (MeloDecayTIMER[3][77] != 0) {
	     MeloDecayTIMER[3][77]--;
	  if(MeloDecayTIMER[3][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 77, 0);}}              
   if   (MeloDecayTIMER[3][78] != 0) {
	     MeloDecayTIMER[3][78]--;
	  if(MeloDecayTIMER[3][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 78, 0);}}              
   if   (MeloDecayTIMER[3][79] != 0) {
	     MeloDecayTIMER[3][79]--;
	  if(MeloDecayTIMER[3][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 79, 0);}}              
   if   (MeloDecayTIMER[3][80] != 0) {
	     MeloDecayTIMER[3][80]--;
	  if(MeloDecayTIMER[3][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 80, 0);}}              
   if   (MeloDecayTIMER[3][81] != 0) {
	     MeloDecayTIMER[3][81]--;
	  if(MeloDecayTIMER[3][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 81, 0);}}              
   if   (MeloDecayTIMER[3][82] != 0) {
	     MeloDecayTIMER[3][82]--;
	  if(MeloDecayTIMER[3][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 82, 0);}}              
   if   (MeloDecayTIMER[3][83] != 0) {
	     MeloDecayTIMER[3][83]--;
	  if(MeloDecayTIMER[3][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 83, 0);}}              
   if   (MeloDecayTIMER[3][84] != 0) {
	     MeloDecayTIMER[3][84]--;
	  if(MeloDecayTIMER[3][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 84, 0);}}              
   if   (MeloDecayTIMER[3][85] != 0) {
	     MeloDecayTIMER[3][85]--;
	  if(MeloDecayTIMER[3][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 85, 0);}}              
   if   (MeloDecayTIMER[3][86] != 0) {
	     MeloDecayTIMER[3][86]--;
	  if(MeloDecayTIMER[3][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 86, 0);}}              
   if   (MeloDecayTIMER[3][87] != 0) {
	     MeloDecayTIMER[3][87]--;
	  if(MeloDecayTIMER[3][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 87, 0);}}              
   if   (MeloDecayTIMER[3][88] != 0) {
	     MeloDecayTIMER[3][88]--;
	  if(MeloDecayTIMER[3][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 88, 0);}}              
   if   (MeloDecayTIMER[3][89] != 0) {
	     MeloDecayTIMER[3][89]--;
	  if(MeloDecayTIMER[3][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 89, 0);}}                    
   if   (MeloDecayTIMER[3][90] != 0) {
	     MeloDecayTIMER[3][90]--;
	  if(MeloDecayTIMER[3][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 90, 0);}}              
   if   (MeloDecayTIMER[3][91] != 0) {
	     MeloDecayTIMER[3][91]--;
	  if(MeloDecayTIMER[3][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 91, 0);}}              
   if   (MeloDecayTIMER[3][92] != 0) {
	     MeloDecayTIMER[3][92]--;
	  if(MeloDecayTIMER[3][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 92, 0);}}              
   if   (MeloDecayTIMER[3][93] != 0) {
	     MeloDecayTIMER[3][93]--;
	  if(MeloDecayTIMER[3][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 93, 0);}}   
   if   (MeloDecayTIMER[3][94] != 0) {
	     MeloDecayTIMER[3][94]--;
	  if(MeloDecayTIMER[3][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 94, 0);}}               
   if   (MeloDecayTIMER[3][95] != 0) {
	     MeloDecayTIMER[3][95]--;
	  if(MeloDecayTIMER[3][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 95, 0);}}              
   if   (MeloDecayTIMER[3][96] != 0) {
	     MeloDecayTIMER[3][96]--;
	  if(MeloDecayTIMER[3][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 96, 0);}}              
   if   (MeloDecayTIMER[3][97] != 0) {
	     MeloDecayTIMER[3][97]--;
	  if(MeloDecayTIMER[3][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 97, 0);}}              
   if   (MeloDecayTIMER[3][98] != 0) {
	     MeloDecayTIMER[3][98]--;
	  if(MeloDecayTIMER[3][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 98, 0);}}              
   if   (MeloDecayTIMER[3][99] != 0) {
	     MeloDecayTIMER[3][99]--;
	  if(MeloDecayTIMER[3][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 99, 0);}}              
   if   (MeloDecayTIMER[3][100] != 0) {
	     MeloDecayTIMER[3][100]--;
	  if(MeloDecayTIMER[3][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 100, 0);}}              
   if   (MeloDecayTIMER[3][101] != 0) {
	     MeloDecayTIMER[3][101]--;
	  if(MeloDecayTIMER[3][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 101, 0);}}              
   if   (MeloDecayTIMER[3][102] != 0) {
	     MeloDecayTIMER[3][102]--;
	  if(MeloDecayTIMER[3][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 102, 0);}}              
   if   (MeloDecayTIMER[3][103] != 0) {
	     MeloDecayTIMER[3][103]--;
	  if(MeloDecayTIMER[3][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 103, 0);}}              
   if   (MeloDecayTIMER[3][104] != 0) {
	     MeloDecayTIMER[3][104]--;
	  if(MeloDecayTIMER[3][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 104, 0);}}              
   if   (MeloDecayTIMER[3][105] != 0) {
	     MeloDecayTIMER[3][105]--;
	  if(MeloDecayTIMER[3][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 105, 0);}}              
   if   (MeloDecayTIMER[3][106] != 0) {
	     MeloDecayTIMER[3][106]--;
	  if(MeloDecayTIMER[3][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 106, 0);}}              
   if   (MeloDecayTIMER[3][107] != 0) {
	     MeloDecayTIMER[3][107]--;
	  if(MeloDecayTIMER[3][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 107, 0);}}              
   if   (MeloDecayTIMER[3][108] != 0) {
	     MeloDecayTIMER[3][108]--;
	  if(MeloDecayTIMER[3][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 108, 0);}}              
   if   (MeloDecayTIMER[3][109] != 0) {
	     MeloDecayTIMER[3][109]--;
	  if(MeloDecayTIMER[3][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 109, 0);}}              
   if   (MeloDecayTIMER[3][110] != 0) {
	     MeloDecayTIMER[3][110]--;
	  if(MeloDecayTIMER[3][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 110, 0);}}              
   if   (MeloDecayTIMER[3][111] != 0) {
	     MeloDecayTIMER[3][111]--;
	  if(MeloDecayTIMER[3][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 111, 0);}}              
   if   (MeloDecayTIMER[3][112] != 0) {
	     MeloDecayTIMER[3][112]--;
	  if(MeloDecayTIMER[3][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 112, 0);}}              
   if   (MeloDecayTIMER[3][113] != 0) {
	     MeloDecayTIMER[3][113]--;
	  if(MeloDecayTIMER[3][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 113, 0);}}              
   if   (MeloDecayTIMER[3][114] != 0) {
	     MeloDecayTIMER[3][114]--;
	  if(MeloDecayTIMER[3][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 114, 0);}}              
   if   (MeloDecayTIMER[3][115] != 0) {
	     MeloDecayTIMER[3][115]--;
	  if(MeloDecayTIMER[3][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 115, 0);}}              
   if   (MeloDecayTIMER[3][116] != 0) {
	     MeloDecayTIMER[3][116]--;
	  if(MeloDecayTIMER[3][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 116, 0);}}              
   if   (MeloDecayTIMER[3][117] != 0) {
	     MeloDecayTIMER[3][117]--;
	  if(MeloDecayTIMER[3][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 117, 0);}}              
   if   (MeloDecayTIMER[3][118] != 0) {
	     MeloDecayTIMER[3][118]--;
	  if(MeloDecayTIMER[3][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 118, 0);}}              
   if   (MeloDecayTIMER[3][119] != 0) {
	     MeloDecayTIMER[3][119]--;
	  if(MeloDecayTIMER[3][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 119, 0);}}              
   if   (MeloDecayTIMER[3][120] != 0) {
	     MeloDecayTIMER[3][120]--;
	  if(MeloDecayTIMER[3][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 120, 0);}}              
   if   (MeloDecayTIMER[3][121] != 0) {
	     MeloDecayTIMER[3][121]--;
	  if(MeloDecayTIMER[3][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 121, 0);}}              
   if   (MeloDecayTIMER[3][122] != 0) {
	     MeloDecayTIMER[3][122]--;
	  if(MeloDecayTIMER[3][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 122, 0);}}              
   if   (MeloDecayTIMER[3][123] != 0) {
	     MeloDecayTIMER[3][123]--;
	  if(MeloDecayTIMER[3][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 123, 0);}}              
   if   (MeloDecayTIMER[3][124] != 0) {
	     MeloDecayTIMER[3][124]--;
	  if(MeloDecayTIMER[3][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 124, 0);}}              
   if   (MeloDecayTIMER[3][125] != 0) {
	     MeloDecayTIMER[3][125]--;
	  if(MeloDecayTIMER[3][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 125, 0);}}              
   if   (MeloDecayTIMER[3][126] != 0) {
	     MeloDecayTIMER[3][126]--;
	  if(MeloDecayTIMER[3][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 126, 0);}}              
   if   (MeloDecayTIMER[3][127] != 0) {
	     MeloDecayTIMER[3][127]--;
	  if(MeloDecayTIMER[3][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 3, 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 3, 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay4(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[4][1] != 0) {
	     MeloDecayTIMER[4][1]--;
	  if(MeloDecayTIMER[4][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 1, 0);}}  
   if   (MeloDecayTIMER[4][2] != 0) {
	     MeloDecayTIMER[4][2]--;
	  if(MeloDecayTIMER[4][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 2, 0);}}   
   if   (MeloDecayTIMER[4][3] != 0) {
	     MeloDecayTIMER[4][3]--;
	  if(MeloDecayTIMER[4][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 3, 0);}}
   if   (MeloDecayTIMER[4][4] != 0) {
	     MeloDecayTIMER[4][4]--;
	  if(MeloDecayTIMER[4][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 4, 0);}} 
   if   (MeloDecayTIMER[4][5] != 0) {
	     MeloDecayTIMER[4][5]--;
	  if(MeloDecayTIMER[4][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 5, 0);}} 
   if   (MeloDecayTIMER[4][6] != 0) {
	     MeloDecayTIMER[4][6]--;
	  if(MeloDecayTIMER[4][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 6, 0);}} 
   if   (MeloDecayTIMER[4][7] != 0) {
	     MeloDecayTIMER[4][7]--;
	  if(MeloDecayTIMER[4][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 7, 0);}}   
   if   (MeloDecayTIMER[4][8] != 0) {
	     MeloDecayTIMER[4][8]--;
	  if(MeloDecayTIMER[4][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 8, 0);}}   
   if   (MeloDecayTIMER[4][9] != 0) {
	     MeloDecayTIMER[4][9]--;
	  if(MeloDecayTIMER[4][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 9, 0);}}   
   if   (MeloDecayTIMER[4][10] != 0) {
	     MeloDecayTIMER[4][10]--;
	  if(MeloDecayTIMER[4][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 10, 0);}}   
   if   (MeloDecayTIMER[4][11] != 0) {
	     MeloDecayTIMER[4][11]--;
	  if(MeloDecayTIMER[4][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 11, 0);}}   
   if   (MeloDecayTIMER[4][12] != 0) {
	     MeloDecayTIMER[4][12]--;
	  if(MeloDecayTIMER[4][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 12, 0);}}   
   if   (MeloDecayTIMER[4][13] != 0) {
	     MeloDecayTIMER[4][13]--;
	  if(MeloDecayTIMER[4][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 13, 0);}}   
   if   (MeloDecayTIMER[4][14] != 0) {
	     MeloDecayTIMER[4][14]--;
	  if(MeloDecayTIMER[4][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 14, 0);}}   
   if   (MeloDecayTIMER[4][15] != 0) {
	     MeloDecayTIMER[4][15]--;
	  if(MeloDecayTIMER[4][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 15, 0);}}   
   if   (MeloDecayTIMER[4][16] != 0) {
	     MeloDecayTIMER[4][16]--;
	  if(MeloDecayTIMER[4][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 16, 0);}}   
   if   (MeloDecayTIMER[4][17] != 0) {
	     MeloDecayTIMER[4][17]--;
	  if(MeloDecayTIMER[4][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 17, 0);}}   
   if   (MeloDecayTIMER[4][18] != 0) {
	     MeloDecayTIMER[4][18]--;
	  if(MeloDecayTIMER[4][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 18, 0);}}   
   if   (MeloDecayTIMER[4][19] != 0) {
	     MeloDecayTIMER[4][19]--;
	  if(MeloDecayTIMER[4][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 19, 0);}}   
   if   (MeloDecayTIMER[4][20] != 0) {
	     MeloDecayTIMER[4][20]--;
	  if(MeloDecayTIMER[4][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 20, 0);}}   
   if   (MeloDecayTIMER[4][21] != 0) {
	     MeloDecayTIMER[4][21]--;
	  if(MeloDecayTIMER[4][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 21, 0);}}   
   if   (MeloDecayTIMER[4][22] != 0) {
	     MeloDecayTIMER[4][22]--;
	  if(MeloDecayTIMER[4][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 22, 0);}}   
   if   (MeloDecayTIMER[4][23] != 0) {
	     MeloDecayTIMER[4][23]--;
	  if(MeloDecayTIMER[4][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 23, 0);}}   
   if   (MeloDecayTIMER[4][24] != 0) {
	     MeloDecayTIMER[4][24]--;
	  if(MeloDecayTIMER[4][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 24, 0);}}   
   if   (MeloDecayTIMER[4][25] != 0) {
	     MeloDecayTIMER[4][25]--;
	  if(MeloDecayTIMER[4][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 25, 0);}}   
   if   (MeloDecayTIMER[4][26] != 0) {
	     MeloDecayTIMER[4][26]--;
	  if(MeloDecayTIMER[4][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 26, 0);}}   
   if   (MeloDecayTIMER[4][27] != 0) {
	     MeloDecayTIMER[4][27]--;
	  if(MeloDecayTIMER[4][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 27, 0);}}   
   if   (MeloDecayTIMER[4][28] != 0) {
	     MeloDecayTIMER[4][28]--;
	  if(MeloDecayTIMER[4][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 28, 0);}}   
   if   (MeloDecayTIMER[4][29] != 0) {
	     MeloDecayTIMER[4][29]--;
	  if(MeloDecayTIMER[4][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 29, 0);}}   
   if   (MeloDecayTIMER[4][30] != 0) {
	     MeloDecayTIMER[4][30]--;
	  if(MeloDecayTIMER[4][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 30, 0);}}   
   if   (MeloDecayTIMER[4][31] != 0) {
	     MeloDecayTIMER[4][31]--;
	  if(MeloDecayTIMER[4][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 31, 0);}}   
   if   (MeloDecayTIMER[4][32] != 0) {
	     MeloDecayTIMER[4][32]--;
	  if(MeloDecayTIMER[4][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 32, 0);}}   
   if   (MeloDecayTIMER[4][33] != 0) {
	     MeloDecayTIMER[4][33]--;
	  if(MeloDecayTIMER[4][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 33, 0);}}   
   if   (MeloDecayTIMER[4][34] != 0) {
	     MeloDecayTIMER[4][34]--;
	  if(MeloDecayTIMER[4][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 34, 0);}}   
   if   (MeloDecayTIMER[4][35] != 0) {
	     MeloDecayTIMER[4][35]--;
	  if(MeloDecayTIMER[4][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 35, 0);}}   
   if   (MeloDecayTIMER[4][36] != 0) {
	     MeloDecayTIMER[4][36]--;
	  if(MeloDecayTIMER[4][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 36, 0);}}   
   if   (MeloDecayTIMER[4][37] != 0) {
	     MeloDecayTIMER[4][37]--;
	  if(MeloDecayTIMER[4][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 37, 0);}}   
   if   (MeloDecayTIMER[4][38] != 0) {
	     MeloDecayTIMER[4][38]--;
	  if(MeloDecayTIMER[4][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 38, 0);}}         
   if   (MeloDecayTIMER[4][39] != 0) {
	     MeloDecayTIMER[4][39]--;
	  if(MeloDecayTIMER[4][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 39, 0);}}              
   if   (MeloDecayTIMER[4][40] != 0) {
	     MeloDecayTIMER[4][40]--;
	  if(MeloDecayTIMER[4][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 40, 0);}}              
   if   (MeloDecayTIMER[4][41] != 0) {
	     MeloDecayTIMER[4][41]--;
	  if(MeloDecayTIMER[4][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 41, 0);}}              
   if   (MeloDecayTIMER[4][42] != 0) {
	     MeloDecayTIMER[4][42]--;
	  if(MeloDecayTIMER[4][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 42, 0);}}             
   if   (MeloDecayTIMER[4][43] != 0) {
	     MeloDecayTIMER[4][43]--;
	  if(MeloDecayTIMER[4][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 43, 0);}}              
   if   (MeloDecayTIMER[4][44] != 0) {
	     MeloDecayTIMER[4][44]--;
	  if(MeloDecayTIMER[4][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 44, 0);}}              
   if   (MeloDecayTIMER[4][45] != 0) {
	     MeloDecayTIMER[4][45]--;
	  if(MeloDecayTIMER[4][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 45, 0);}}              
   if   (MeloDecayTIMER[4][46] != 0) {
	     MeloDecayTIMER[4][46]--;
	  if(MeloDecayTIMER[4][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 46, 0);}}              
   if   (MeloDecayTIMER[4][47] != 0) {
	     MeloDecayTIMER[4][47]--;
	  if(MeloDecayTIMER[4][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 47, 0);}}              
   if   (MeloDecayTIMER[4][48] != 0) {
	     MeloDecayTIMER[4][48]--;
	  if(MeloDecayTIMER[4][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 48, 0);}}              
   if   (MeloDecayTIMER[4][49] != 0) {
	     MeloDecayTIMER[4][49]--;
	  if(MeloDecayTIMER[4][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 49, 0);}}              
   if   (MeloDecayTIMER[4][50] != 0) {
	     MeloDecayTIMER[4][50]--;
	  if(MeloDecayTIMER[4][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 50, 0);}}              
   if   (MeloDecayTIMER[4][51] != 0) {
	     MeloDecayTIMER[4][51]--;
	  if(MeloDecayTIMER[4][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 51, 0);}}              
   if   (MeloDecayTIMER[4][52] != 0) {
	     MeloDecayTIMER[4][52]--;
	  if(MeloDecayTIMER[4][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 52, 0);}}    
   if   (MeloDecayTIMER[4][53] != 0) {
	     MeloDecayTIMER[4][53]--;
	  if(MeloDecayTIMER[4][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 53, 0);}}              
   if   (MeloDecayTIMER[4][54] != 0) {
	     MeloDecayTIMER[4][54]--;
	  if(MeloDecayTIMER[4][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 54, 0);}}              
   if   (MeloDecayTIMER[4][55] != 0) {
	     MeloDecayTIMER[4][55]--;
	  if(MeloDecayTIMER[4][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 55, 0);}}              
   if   (MeloDecayTIMER[4][56] != 0) {
	     MeloDecayTIMER[4][56]--;
	  if(MeloDecayTIMER[4][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 56, 0);}}              
   if   (MeloDecayTIMER[4][57] != 0) {
	     MeloDecayTIMER[4][57]--;
	  if(MeloDecayTIMER[4][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 57, 0);}}              
   if   (MeloDecayTIMER[4][58] != 0) {
	     MeloDecayTIMER[4][58]--;
	  if(MeloDecayTIMER[4][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 58, 0);}}              
   if   (MeloDecayTIMER[4][59] != 0) {
	     MeloDecayTIMER[4][59]--;
	  if(MeloDecayTIMER[4][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 59, 0);}}              
   if   (MeloDecayTIMER[4][60] != 0) {
	     MeloDecayTIMER[4][60]--;
	  if(MeloDecayTIMER[4][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 60, 0);}}              
   if   (MeloDecayTIMER[4][61] != 0) {
	     MeloDecayTIMER[4][61]--;
	  if(MeloDecayTIMER[4][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 61, 0);}}              
   if   (MeloDecayTIMER[4][62] != 0) {
	     MeloDecayTIMER[4][62]--;
	  if(MeloDecayTIMER[4][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 62, 0);}}              
   if   (MeloDecayTIMER[4][63] != 0) {
	     MeloDecayTIMER[4][63]--;
	  if(MeloDecayTIMER[4][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 63, 0);}}              
   if   (MeloDecayTIMER[4][64] != 0) {
	     MeloDecayTIMER[4][64]--;
	  if(MeloDecayTIMER[4][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 64, 0);}}              
   if   (MeloDecayTIMER[4][65] != 0) {
	     MeloDecayTIMER[4][65]--;
	  if(MeloDecayTIMER[4][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 65, 0);}}              
   if   (MeloDecayTIMER[4][66] != 0) {
	     MeloDecayTIMER[4][66]--;
	  if(MeloDecayTIMER[4][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 66, 0);}}              
   if   (MeloDecayTIMER[4][67] != 0) {
	     MeloDecayTIMER[4][67]--;
	  if(MeloDecayTIMER[4][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 67, 0);}}              
   if   (MeloDecayTIMER[4][68] != 0) {
	     MeloDecayTIMER[4][68]--;
	  if(MeloDecayTIMER[4][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 68, 0);}}              
   if   (MeloDecayTIMER[4][69] != 0) {
	     MeloDecayTIMER[4][69]--;
	  if(MeloDecayTIMER[4][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 69, 0);}}              
   if   (MeloDecayTIMER[4][70] != 0) {
	     MeloDecayTIMER[4][70]--;
	  if(MeloDecayTIMER[4][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 70, 0);}}              
   if   (MeloDecayTIMER[4][71] != 0) {
	     MeloDecayTIMER[4][71]--;
	  if(MeloDecayTIMER[4][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 71, 0);}}              
   if   (MeloDecayTIMER[4][72] != 0) {
	     MeloDecayTIMER[4][72]--;
	  if(MeloDecayTIMER[4][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 72, 0);}}              
   if   (MeloDecayTIMER[4][73] != 0) {
	     MeloDecayTIMER[4][73]--;
	  if(MeloDecayTIMER[4][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 73, 0);}}              
   if   (MeloDecayTIMER[4][74] != 0) {
	     MeloDecayTIMER[4][74]--;
	  if(MeloDecayTIMER[4][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 74, 0);}}              
   if   (MeloDecayTIMER[4][75] != 0) {
	     MeloDecayTIMER[4][75]--;
	  if(MeloDecayTIMER[4][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 75, 0);}}              
   if   (MeloDecayTIMER[4][76] != 0) {
	     MeloDecayTIMER[4][76]--;
	  if(MeloDecayTIMER[4][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 76, 0);}}              
   if   (MeloDecayTIMER[4][77] != 0) {
	     MeloDecayTIMER[4][77]--;
	  if(MeloDecayTIMER[4][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 77, 0);}}              
   if   (MeloDecayTIMER[4][78] != 0) {
	     MeloDecayTIMER[4][78]--;
	  if(MeloDecayTIMER[4][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 78, 0);}}              
   if   (MeloDecayTIMER[4][79] != 0) {
	     MeloDecayTIMER[4][79]--;
	  if(MeloDecayTIMER[4][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 79, 0);}}              
   if   (MeloDecayTIMER[4][80] != 0) {
	     MeloDecayTIMER[4][80]--;
	  if(MeloDecayTIMER[4][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 80, 0);}}              
   if   (MeloDecayTIMER[4][81] != 0) {
	     MeloDecayTIMER[4][81]--;
	  if(MeloDecayTIMER[4][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 81, 0);}}              
   if   (MeloDecayTIMER[4][82] != 0) {
	     MeloDecayTIMER[4][82]--;
	  if(MeloDecayTIMER[4][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 82, 0);}}              
   if   (MeloDecayTIMER[4][83] != 0) {
	     MeloDecayTIMER[4][83]--;
	  if(MeloDecayTIMER[4][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 83, 0);}}              
   if   (MeloDecayTIMER[4][84] != 0) {
	     MeloDecayTIMER[4][84]--;
	  if(MeloDecayTIMER[4][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 84, 0);}}              
   if   (MeloDecayTIMER[4][85] != 0) {
	     MeloDecayTIMER[4][85]--;
	  if(MeloDecayTIMER[4][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 85, 0);}}              
   if   (MeloDecayTIMER[4][86] != 0) {
	     MeloDecayTIMER[4][86]--;
	  if(MeloDecayTIMER[4][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 86, 0);}}              
   if   (MeloDecayTIMER[4][87] != 0) {
	     MeloDecayTIMER[4][87]--;
	  if(MeloDecayTIMER[4][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 87, 0);}}              
   if   (MeloDecayTIMER[4][88] != 0) {
	     MeloDecayTIMER[4][88]--;
	  if(MeloDecayTIMER[4][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 88, 0);}}              
   if   (MeloDecayTIMER[4][89] != 0) {
	     MeloDecayTIMER[4][89]--;
	  if(MeloDecayTIMER[4][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 89, 0);}}                    
   if   (MeloDecayTIMER[4][90] != 0) {
	     MeloDecayTIMER[4][90]--;
	  if(MeloDecayTIMER[4][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 90, 0);}}              
   if   (MeloDecayTIMER[4][91] != 0) {
	     MeloDecayTIMER[4][91]--;
	  if(MeloDecayTIMER[4][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 91, 0);}}              
   if   (MeloDecayTIMER[4][92] != 0) {
	     MeloDecayTIMER[4][92]--;
	  if(MeloDecayTIMER[4][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 92, 0);}}              
   if   (MeloDecayTIMER[4][93] != 0) {
	     MeloDecayTIMER[4][93]--;
	  if(MeloDecayTIMER[4][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 93, 0);}}   
   if   (MeloDecayTIMER[4][94] != 0) {
	     MeloDecayTIMER[4][94]--;
	  if(MeloDecayTIMER[4][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 94, 0);}}               
   if   (MeloDecayTIMER[4][95] != 0) {
	     MeloDecayTIMER[4][95]--;
	  if(MeloDecayTIMER[4][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 95, 0);}}              
   if   (MeloDecayTIMER[4][96] != 0) {
	     MeloDecayTIMER[4][96]--;
	  if(MeloDecayTIMER[4][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 96, 0);}}              
   if   (MeloDecayTIMER[4][97] != 0) {
	     MeloDecayTIMER[4][97]--;
	  if(MeloDecayTIMER[4][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 97, 0);}}              
   if   (MeloDecayTIMER[4][98] != 0) {
	     MeloDecayTIMER[4][98]--;
	  if(MeloDecayTIMER[4][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 98, 0);}}              
   if   (MeloDecayTIMER[4][99] != 0) {
	     MeloDecayTIMER[4][99]--;
	  if(MeloDecayTIMER[4][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 99, 0);}}              
   if   (MeloDecayTIMER[4][100] != 0) {
	     MeloDecayTIMER[4][100]--;
	  if(MeloDecayTIMER[4][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 100, 0);}}              
   if   (MeloDecayTIMER[4][101] != 0) {
	     MeloDecayTIMER[4][101]--;
	  if(MeloDecayTIMER[4][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 101, 0);}}              
   if   (MeloDecayTIMER[4][102] != 0) {
	     MeloDecayTIMER[4][102]--;
	  if(MeloDecayTIMER[4][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 102, 0);}}              
   if   (MeloDecayTIMER[4][103] != 0) {
	     MeloDecayTIMER[4][103]--;
	  if(MeloDecayTIMER[4][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 103, 0);}}              
   if   (MeloDecayTIMER[4][104] != 0) {
	     MeloDecayTIMER[4][104]--;
	  if(MeloDecayTIMER[4][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 104, 0);}}              
   if   (MeloDecayTIMER[4][105] != 0) {
	     MeloDecayTIMER[4][105]--;
	  if(MeloDecayTIMER[4][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 105, 0);}}              
   if   (MeloDecayTIMER[4][106] != 0) {
	     MeloDecayTIMER[4][106]--;
	  if(MeloDecayTIMER[4][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 106, 0);}}              
   if   (MeloDecayTIMER[4][107] != 0) {
	     MeloDecayTIMER[4][107]--;
	  if(MeloDecayTIMER[4][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 107, 0);}}              
   if   (MeloDecayTIMER[4][108] != 0) {
	     MeloDecayTIMER[4][108]--;
	  if(MeloDecayTIMER[4][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 108, 0);}}              
   if   (MeloDecayTIMER[4][109] != 0) {
	     MeloDecayTIMER[4][109]--;
	  if(MeloDecayTIMER[4][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 109, 0);}}              
   if   (MeloDecayTIMER[4][110] != 0) {
	     MeloDecayTIMER[4][110]--;
	  if(MeloDecayTIMER[4][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 110, 0);}}              
   if   (MeloDecayTIMER[4][111] != 0) {
	     MeloDecayTIMER[4][111]--;
	  if(MeloDecayTIMER[4][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 111, 0);}}              
   if   (MeloDecayTIMER[4][112] != 0) {
	     MeloDecayTIMER[4][112]--;
	  if(MeloDecayTIMER[4][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 112, 0);}}              
   if   (MeloDecayTIMER[4][113] != 0) {
	     MeloDecayTIMER[4][113]--;
	  if(MeloDecayTIMER[4][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 113, 0);}}              
   if   (MeloDecayTIMER[4][114] != 0) {
	     MeloDecayTIMER[4][114]--;
	  if(MeloDecayTIMER[4][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 114, 0);}}              
   if   (MeloDecayTIMER[4][115] != 0) {
	     MeloDecayTIMER[4][115]--;
	  if(MeloDecayTIMER[4][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 115, 0);}}              
   if   (MeloDecayTIMER[4][116] != 0) {
	     MeloDecayTIMER[4][116]--;
	  if(MeloDecayTIMER[4][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 116, 0);}}              
   if   (MeloDecayTIMER[4][117] != 0) {
	     MeloDecayTIMER[4][117]--;
	  if(MeloDecayTIMER[4][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 117, 0);}}              
   if   (MeloDecayTIMER[4][118] != 0) {
	     MeloDecayTIMER[4][118]--;
	  if(MeloDecayTIMER[4][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 118, 0);}}              
   if   (MeloDecayTIMER[4][119] != 0) {
	     MeloDecayTIMER[4][119]--;
	  if(MeloDecayTIMER[4][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 119, 0);}}              
   if   (MeloDecayTIMER[4][120] != 0) {
	     MeloDecayTIMER[4][120]--;
	  if(MeloDecayTIMER[4][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 120, 0);}}              
   if   (MeloDecayTIMER[4][121] != 0) {
	     MeloDecayTIMER[4][121]--;
	  if(MeloDecayTIMER[4][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 121, 0);}}              
   if   (MeloDecayTIMER[4][122] != 0) {
	     MeloDecayTIMER[4][122]--;
	  if(MeloDecayTIMER[4][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 122, 0);}}              
   if   (MeloDecayTIMER[4][123] != 0) {
	     MeloDecayTIMER[4][123]--;
	  if(MeloDecayTIMER[4][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 123, 0);}}              
   if   (MeloDecayTIMER[4][124] != 0) {
	     MeloDecayTIMER[4][124]--;
	  if(MeloDecayTIMER[4][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 124, 0);}}              
   if   (MeloDecayTIMER[4][125] != 0) {
	     MeloDecayTIMER[4][125]--;
	  if(MeloDecayTIMER[4][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 125, 0);}}              
   if   (MeloDecayTIMER[4][126] != 0) {
	     MeloDecayTIMER[4][126]--;
	  if(MeloDecayTIMER[4][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 126, 0);}}              
   if   (MeloDecayTIMER[4][127] != 0) {
	     MeloDecayTIMER[4][127]--;
	  if(MeloDecayTIMER[4][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 4, 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 4, 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Trigger_Decay(void *pVParameters){//DRUM > DecayTime > Note OFF
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

   if   (DrumDecayTimer[0] != 0) { //Count "-"until 0
	     DrumDecayTimer[0]--;     
	  if(DrumDecayTimer[0] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[0], TrigOutNote[0], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[0], TrigOutNote[0], 0); //Turn OFF Trigger Notes
        //BLM-Trigger-Indicator OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[0][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 0, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 0, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[1] != 0) {             
	     DrumDecayTimer[1]--;
	  if(DrumDecayTimer[1] == 0){ //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[1], TrigOutNote[1], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[1], TrigOutNote[1], 0); //Turn OFF Trigger Notes
        //BLM-Trigger-Indicator OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[1][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 1, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 1, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[2] != 0) {
	     DrumDecayTimer[2]--;
	  if(DrumDecayTimer[2] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[2], TrigOutNote[2], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[2], TrigOutNote[2], 0); //Turn OFF Trigger Notes
        //BLM-Trigger-Indicator OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[2][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 2, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 2, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[3] != 0) {
	     DrumDecayTimer[3]--;
	  if(DrumDecayTimer[3] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[3], TrigOutNote[3], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[3], TrigOutNote[3], 0); //Turn OFF Trigger Notes
        //BLM-Trigger-Indicator OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[3][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 3, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 3, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[4] != 0) {
	     DrumDecayTimer[4]--;
	  if(DrumDecayTimer[4] == 0){ //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[4], TrigOutNote[4], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[4], TrigOutNote[4], 0); //Turn OFF Trigger Notes
        //BLM-Trigger-Indicator OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[4][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 4, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 4, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[5] != 0) {
	     DrumDecayTimer[5]--;
	  if(DrumDecayTimer[5] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[5], TrigOutNote[5], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[5], TrigOutNote[5], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], MeloOutNote[5], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], MeloOutNote[5], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[5][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 5, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 5, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[6] != 0) {
	     DrumDecayTimer[6]--;
	  if(DrumDecayTimer[6] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[6], TrigOutNote[6], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[6], TrigOutNote[6], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], MeloOutNote[6], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], MeloOutNote[6], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[6][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 6, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 6, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[7] != 0) {
	     DrumDecayTimer[7]--;
	  if(DrumDecayTimer[7] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[7], TrigOutNote[7], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[7], TrigOutNote[7], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], MeloOutNote[7], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], MeloOutNote[7], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[7][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 7, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 7, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[8] != 0) {
	     DrumDecayTimer[8]--;
	  if(DrumDecayTimer[8] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[8], TrigOutNote[8], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[8], TrigOutNote[8], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[8], MeloOutNote[8], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[8], MeloOutNote[8], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[8][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 8, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 8, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[9] != 0) {
	     DrumDecayTimer[9]--;
	  if(DrumDecayTimer[9] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[9], TrigOutNote[9], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[9], TrigOutNote[9], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[9], MeloOutNote[9], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[9], MeloOutNote[9], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[9][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 9, 0, 2);} //Make Green instead "OFF"
                           else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 9, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters
   if   (DrumDecayTimer[10] != 0) {
	     DrumDecayTimer[10]--;
	  if(DrumDecayTimer[10] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[10], TrigOutNote[10], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[10], TrigOutNote[10], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[10], MeloOutNote[10], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[10], MeloOutNote[10], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[10][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 10, 0, 2);} //Make Green instead "OFF"
                            else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 10, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[11] != 0) {
	     DrumDecayTimer[11]--;
	  if(DrumDecayTimer[11] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[11], TrigOutNote[11], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[11], TrigOutNote[11], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[11], MeloOutNote[11], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[11], MeloOutNote[11], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[11][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 11, 0, 2);} //Make Green instead "OFF"
                            else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 11, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[12] != 0) {
	     DrumDecayTimer[12]--;
	  if(DrumDecayTimer[12] == 0) { //If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[12], TrigOutNote[12], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[12], TrigOutNote[12], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[12], MeloOutNote[12], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[12], MeloOutNote[12], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[12][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 12, 0, 2);} //Make Green instead "OFF"
                            else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 12, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[13] != 0) {
	     DrumDecayTimer[13]--; 
	  if(DrumDecayTimer[13] == 0) {//If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[13], TrigOutNote[13], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[13], TrigOutNote[13], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[13], MeloOutNote[13], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[13], MeloOutNote[13], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[13][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 13, 0, 2);} //Make Green instead "OFF"
                            else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 13, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[14] != 0) {
	     DrumDecayTimer[14]--;
	  if(DrumDecayTimer[14] == 0) {//If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[14], TrigOutNote[14], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[14], TrigOutNote[14], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[14], MeloOutNote[14], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[14], MeloOutNote[14], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[14][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 14, 0, 2);} //Make Green instead "OFF"
                            else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 14, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[15] != 0) {
	     DrumDecayTimer[15]--;
	  if(DrumDecayTimer[15] == 0) {//If 0:
        //Trigger Note OFF
		      MIOS32_MIDI_SendNoteOff(TrigPortOUT, TrigOutCh[15], TrigOutNote[15], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (TrigPortOUT, TrigOutCh[15], TrigOutNote[15], 0); //Turn OFF Trigger Notes
        //Mono-Melody Note OFFs
		      MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[15], MeloOutNote[15], 0); //Port, Chn, Note, Velocity 
              MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[15], MeloOutNote[15], 0); //Turn OFF Trigger Notes
        //Turn LEDs OFF
        if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
          if(EXTRA[15][1] == 0) {BLM_SCALAR_MASTER_LED_Set(ID, 1, 15, 0, 2);} //Make Green instead "OFF"
                            else{BLM_SCALAR_MASTER_LED_Set(ID, 1, 15, 0, 0);}}}} //Make "OFF" (blm, id, x, y, colour) TOff BLM-Trigger-Indicaters

   if   (DrumDecayTimer[16] != 0) {//TRIGGER INDICATORS
	     DrumDecayTimer[16]--;
	  if(DrumDecayTimer[16] == 0) {
              if( MatrixUse == 2 || MatrixUse == 3 ) {  //TriggermatrixMode?
                int x; for(x=0; x<16; x++) {BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, x, 0);} //Deactivate Trigger LEDs
                                            BLM_SCALAR_MASTER_LED_Set(ID, 2, 0, MtxPartNr, 2);} //Activate MtxPartNr Again
         }}

}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_BLM_Check(void *pvParameters){
  portTickType xLastExecutionTime;
    // Initialize the xLastExecutionTime variable on task entry
    xLastExecutionTime = xTaskGetTickCount();
    while( 1 ) {
     vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
      // check for BLM pin changes, call BLM_Button_NotifyToggle on each toggled pin
      BLM_X_BtnHandler(BLM_Button_NotifyToggle);
      }
  }

