//this file allows to re-configure default functions of MIOS32
//available switches are listed in $MIOS32_PATH/modules/mios32/MIOS32_CONFIG.txt

#ifndef _MIOS32_CONFIG_H
#define _MIOS32_CONFIG_H

// map MIDI mutex to BLM_SCALAR master
// located in tasks.c to access MIDI IN/OUT mutex from external
extern void TASKS_MUTEX_MIDIOUT_Take(void);
extern void TASKS_MUTEX_MIDIOUT_Give(void);
#define BLM_SCALAR_MASTER_MUTEX_MIDIOUT_TAKE { TASKS_MUTEX_MIDIOUT_Take(); }
#define BLM_SCALAR_MASTER_MUTEX_MIDIOUT_GIVE { TASKS_MUTEX_MIDIOUT_Give(); }

#define MIOS32_USE_MIDI
#define MIOS32_USE_UART
#define MIOS32_USE_UART_MIDI
#define MIOS32_UART_NUM 4
#define MIOS32_UART0_ASSIGNMENT 1 //1=Midi, 0= Disabled, 2= COM
#define MIOS32_UART1_ASSIGNMENT 1
#define MIOS32_UART2_ASSIGNMENT 1
#define MIOS32_UART3_ASSIGNMENT 1

//BLM WILBA SEQ PCB
#define BLM_X_NUM_ROWS 8
#define BLM_X_BTN_NUM_COLS 8
#define BLM_X_LED_NUM_COLS 8
#define BLM_X_LED_NUM_COLORS 1
#define BLM_X_ROWSEL_DOUT_SR	1
#define BLM_X_LED_FIRST_DOUT_SR	2
#define BLM_X_BTN_FIRST_DIN_SR	2
#define BLM_X_ROWSEL_INV_MASK	0x00
#define BLM_X_DEBOUNCE_MODE 0 //1
#define BLM_X_COLOR_MODE 0

// LCD-Boot-Message
#define MIOS32_LCD_BOOT_MSG_LINE1 "TRIGGER-MATRIX_16x16"
#define MIOS32_LCD_BOOT_MSG_LINE2 "TM 4 BLM"

// AIN Activate J5A
//#define MIOS32_AIN_CHANNEL_MASK 0x000f

// AIN define the deadband (min. difference to report a change to the application hook)
//#define MIOS32_AIN_DEADBAND 31 //7Bit
#endif /* _MIOS32_CONFIG_H */
