#include <mios32.h>
#include <seq_bpm.h>
#include <seq_midi_out.h>
#include "seq.h"
#include "app.h"

s32 APP_BLM_ButtonCallback(u8 blm, u8 element_type, u8 button_x, u8 button_y, u8 button_depressed);
static s32 SEQ_Tick(u32 bpm_tick);
static s32 MakeStep(u16 ticer);

static u16 main_step_pos = 1; // the Main - Song position (you dont hear that, that is only for SYNC.
static u16 loop_step_pos = 1; // straight step position bevore swing
   u16 song_step_pos_counter = 0;
   u16 Last = 16; //calculated Last Step
   u16 First = 0; //calculated First Step
static u8 seq_pause = 0; // pause mode (will be controlled from user interface)
static u8 direct = 1; //calculatet direction
static u8 directFwRwFlag = 1; // toggle between upwards und downwards loop counter
static s16 SwingTics = 0; //calculated swing on every Step before sent out to app.c
static s16 TicCounter = 0; //to count the SwingTime
static s16 step = 0; //swinged step position after swing
static u8 StepBuffer8 = 0; //memory swinged step position since we mix them
static u8 StepBuffer16 = 0; //memory swinged step position

static s16 TicCounterMain   = 0; //To count Main Delay
static s16 TicCounterNorm   = 0; //To count Normal/NotSwinged Steps Delay
        s16 StepSend = 0; //Memorized StepNr
static s16 TicCounter8      = 0; //To Count 8th swinged Steps Delay
static s16 TicCount8Step    = 0; //Memorized StepNr
static s16 TicCounter16     = 0; //To Count 8th swinged Steps Delay
static s16 TicCount16Step   = 0; //Memorized StepNr
static u8 FirstTicFlag      = 1;//to initalize the device to midiclock

static u16 setPpqnDivider = 4; //to be shure that the 16th-PPQM-divider is changed in main-sync
       s16 TicSend = 0;
  u8 StepOffset = 0; //Number off steps to delayd (in Order to get better in sync with other hardware)
  u8 intro = 0;
  s8 SongStep;


s32 SEQ_Init(u32 mode){
    SEQ_Reset();  // reset sequencer
    SEQ_BPM_Init(0);  // init BPM generator
    SEQ_BPM_PPQN_Set(Tic);
    SEQ_BPM_Set(BPM);
    SEQ_BPM_TickSet(0); 
  return 0; // no error
}

s32 SEQ_Handler(void){ // this sequencer handler is called periodically to check for new requests from BPM generator
  // handle requests

  u8 num_loops = 0;
  u8 again = 0;
  do {
    ++num_loops;

    // note: don't remove any request check - clocks won't be propagated
    // so long any Stop/Cont/Start/SongPos event hasn't been flagged to the sequencer
    if( SEQ_BPM_ChkReqStop() ) {
     // SEQ_PlayOffEvents();
    }

    if( SEQ_BPM_ChkReqCont() ) {
      // release pause mode
      seq_pause = 0;
    }

    if( SEQ_BPM_ChkReqStart() ) {
      SEQ_Reset();
    }

    u16 new_song_pos;
    if( SEQ_BPM_ChkReqSongPos(&new_song_pos) ) {
   //   SEQ_PlayOffEvents();
    }

    u32 bpm_tick;
    if( SEQ_BPM_ChkReqClk(&bpm_tick) > 0 ) {
      again = 1; // check all requests again after execution of this part

      SEQ_Tick(bpm_tick);
    }
  } while( again && num_loops < 10 );

  return 0; // no error
}

s32 SEQ_Reset(void){
  seq_pause = 0;   // release pause mode
  SEQ_BPM_TickSet(0);   // reset BPM tick
  return 0; // no error
}

s32 SEQ_Loop(void){return 0;}


static s32 SEQ_Tick(u32 bpm_tick){  // performs a single bpm tick
  //MAIN RESET ON FIRST TIC EVER... (PLAY-Button)
  if( bpm_tick == 0 ) { main_step_pos = -1; directFwRwFlag = 1; TicCounterNorm = 1; TicCounter16 = 1; TicCounter8 = 1; FirstTicFlag = 1; SyncFlag = 1; song_step_pos_counter = 0; SongStep=0;//303

     if(direct == 0){loop_step_pos = Last-StepOffset;}     //<<< Loop Posi @ REWIND mode 
     if(direct == 1){    //<<< Loop Posi @ FORWARD mode
	   if(intro == 0){ loop_step_pos = First+StepOffset;}   // start immediatly @ Loop Point
	   if(intro == 1){ loop_step_pos = 0+StepOffset;}}   // start @ Step0 and then step forwared to Loop Point, and then Loop
   }


  //96tic loop
  TicSend = (bpm_tick % (SEQ_BPM_PPQN_Get()/setPpqnDivider));

  //Forward Step-Count --Running Light-- 2 BLM BTNs
  if(TicSend == BaseTic) {APP_BLM_ButtonCallback(0,6,StepSend,0,0);} //tic == Basetic 4 > let time for mostly triggered @ 0Tic-Offset Notes! (e.g.12tics)
 
  if(TicSend == 0 ) { // whenever we reach a new 16th note (e.g 96 tics @384 ppqn):
         //MAIN LOOP COUNTER
         if( ++main_step_pos >= MainLoop ) main_step_pos = 0; // increment step number until it reaches the mainloop length of e.g. 64, encrease song steps

         //Set new Loop (in Main Sync)static u8 FirstTicFlag      = 1;//to initalize the device to midiclock
         //    if(SyncType == 1){ //0 Bar-Sync, 1 Main-Sync
         if(main_step_pos == 0) {
            song_step_pos_counter++; SongMode(0); //Update SongPosition counter
            //NOOO Intro/Outro Automation
			if(intro == 0){  
                if(SyncFlag  == 1){//Something has changed, Set new Loop point when MainLoop is finished
                   First = (PageFirst*StepPerPage); //First step in loop = 0Page*16Perpage=0...
                   Last  = (PageLast*StepPerPage)+StepPerPage; //Last step in loop = (0Page*16Perpage)+16=16
                   direct = direction; // 0<< 1>> 2<> PLAY DIRECTION 
                   SyncFlag = 3; //New SyncFlag to avoid double triggering events.
                   //set new step position
                   if(direct == 0) {loop_step_pos = (PageLast*StepPerPage)+StepPerPage;} //@Rewind Direction
                   if(direct == 1) {loop_step_pos = PageFirst*StepPerPage;} //@Forward Direction     StepPerPAge = 0-15, PageFirst 0-15 > 0x0=0 1x15= 15
                   if(direct == 2) {loop_step_pos = First; directFwRwFlag = 1;}} //@Forward><Rewind Direction
              if(SyncFlag == 4) {
                 SEQ_BPM_PPQN_Set(Tic); //set TICs (normally 384)
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.

              if(SyncFlag == 5) {
                 setPpqnDivider = PpqnDivider; //set PPQN Divider in time
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.
             }

            //Intro/Outro Automation
			if(intro == 1){
                if(FirstTicFlag == 0) {// We are in the middle of Program
                  if(SyncFlag  == 1){//Something has changed, Set new Loop point when MainLoop is finished
                     First = (PageFirst*StepPerPage); //First step in loop = 0Page*16Perpage=0...
                     Last  = (PageLast*StepPerPage)+StepPerPage; //Last step in loop = (0Page*16Perpage)+16=16
                     direct = direction; // 0<< 1>> 2<> PLAY DIRECTION 
                     SyncFlag = 3; //New SyncFlag to avoid double triggering events.
                     //set new step position
                     if(direct == 0) {loop_step_pos = (PageLast*StepPerPage)+StepPerPage;} //@Rewind Direction
                     if(direct == 1) {loop_step_pos = PageFirst*StepPerPage;} //@Forward Direction     StepPerPAge = 0-15, PageFirst 0-15 > 0x0=0 1x15= 15
                     if(direct == 2) {loop_step_pos = First; directFwRwFlag = 1;}} //@Forward><Rewind Direction
                 }
                if(FirstTicFlag == 1) {//We have started the Sequencer right now... now do something
                     First = (PageFirst*StepPerPage); //First step in loop = 0Page*16Perpage=0...
                     Last  = (PageLast*StepPerPage)+StepPerPage; //Last step in loop = (0Page*16Perpage)+16=16
                     direct = direction; // 0<< 1>> 2<> PLAY DIRECTION 
                     SyncFlag = 3; //New SyncFlag to avoid double triggering events.
                     //set new step position
                     if(direct == 0) {loop_step_pos = (PageLast*StepPerPage)+StepPerPage;} //@Rewind Direction
                     if(direct == 1) {loop_step_pos = 0;} //@Forward Direction - start with 0 = usefull wehn Loop is set a few Pages later...
                     if(direct == 2) {loop_step_pos = First; directFwRwFlag = 1;}} //@Forward><Rewind Direction
                     FirstTicFlag = 0; //disable Flag to avoid double triggering of events..ö
                 }


              if(SyncFlag == 4) {
                 SEQ_BPM_PPQN_Set(Tic); //set TICs (normally 384)
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.

              if(SyncFlag == 5) {
                 setPpqnDivider = PpqnDivider; //set PPQN Divider in time
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.
             }


         //Stop on OUTRO-Position (Forwared direction)
         if(intro == 1) {
           if(direct == 1){//when in ForWard Direction
             if(loop_step_pos == Last-1) {//when Last Step has arrived
               if(MtxPartNr == 14) {//Outro-Song-Part has been selected
                 SEQ_BPM_Stop(); SEQ_Init(0);}}}//Stop Sequencer
	      }

         //Stop on OUTRO-Position (Backward direction
         if(intro == 1) {
           if(direct == 0){//when in BackWard Direction
             if(loop_step_pos == First+1) {//when Last Step has arrived
               if(MtxPartNr == 14) {//Outro-Song-Part has been selected
                 SEQ_BPM_Stop(); SEQ_Init(0);}}}//Stop Sequencer
	      } 

        if(direct == 0){  //<<< REWIND 
           //Avoid Additional Counter ++ after giving new Loop Step Positions
	       if(SyncFlag != 3) { if( --loop_step_pos <= First) loop_step_pos = Last;}
           //Reset Syncflac
	       if(SyncFlag == 3) { SyncFlag = 0;}}

        if(direct == 1){  //>>> FORWARD 
           //Avoid Additional Counter ++ after giving new Loop Step Positions
	       if(SyncFlag != 3) { if( ++loop_step_pos >= Last) loop_step_pos = First;}
           //Reset Syncflac
	       if(SyncFlag == 3) { SyncFlag = 0;}}

        if(direct == 2){  //>>> FORWARD <<< REWIND 
           //Avoid Additional Counter ++ after giving new Loop Step Positions
	       if(SyncFlag != 3) {
              if(directFwRwFlag == 1){//1=Forward Mode
                if( ++loop_step_pos >= Last)  {loop_step_pos = Last+1;  directFwRwFlag = 0;} }//count++ until last step then switch to RW-Mode (Flag)

             if(directFwRwFlag == 0){//0=Rewind Mode
                if( --loop_step_pos <= First) {loop_step_pos = First; directFwRwFlag = 1;} }//count-- until last step then switch to FF-Mode (Flag)
            }
           //Reset Syncflac
	       if(SyncFlag == 3) { SyncFlag = 0;}
	  }

      StepSend = loop_step_pos;
           
     } //END "If Tic=0"...
     
//send 96th Tics to Triggermatrix to trigger Notes between 16th notes (human feel)
APP_NOTEPROCESS(0, 127, 0, StepSend, TicSend); //(u8 port, u8 note, u16 velocity, u8 step) Back to APP.c

//End-drum-trigger
  return 0; // no error,
}

