#include <mios32.h>
#include <seq_bpm.h>
#include <seq_midi_out.h>
#include "app.h"

static s32 SEQ_Tick(u32 bpm_tick);

static s16 main_step_pos = 1; //  the Main - Song position (you dont hear that, that is only for SYNC.
static u16 loop_step_pos = 1; //  straight step position bevore swing

 u16 Last = 16; // calculated Last Step
 u16 First = 0; // calculated First Step

static s16 StepSend = 0; // Memorized StepNr
static s16 TicSend  = 0;
  
static u8 StepOffset = 0; // Number off steps to delayd (in Order to get better in sync with other hardware)
static u8 TicOffset  = 0;
  
static u8 seq_pause = 0; 


s32 SEQ_Init(u32 mode){
    SEQ_Reset();  //  reset sequencer
    SEQ_BPM_Init(0);  //  init BPM generator
    SEQ_BPM_PPQN_Set(384);
    SEQ_BPM_Set(beat.bpm);
    SEQ_BPM_TickSet(0); 
  return 0; //  no error
}

s32 SEQ_Handler(void){ //  this sequencer handler is called periodically to check for new requests from BPM generator
  //  handle requests

  u8 num_loops = 0;
  u8 again = 0;
  do {
    ++num_loops;

    //  note: don't remove any request check - clocks won't be propagated
    //  so long any Stop/Cont/Start/SongPos event hasn't been flagged to the sequencer
    if( SEQ_BPM_ChkReqStop() ) {
     //  SEQ_PlayOffEvents();
    }

    if( SEQ_BPM_ChkReqCont() ) {
      //  release pause mode
      seq_pause = 0;
    }

    if( SEQ_BPM_ChkReqStart() ) {
      SEQ_Reset();
    }

    u16 new_song_pos;
    if( SEQ_BPM_ChkReqSongPos(&new_song_pos) ) {
   //    SEQ_PlayOffEvents();
    }

    u32 bpm_tick;
    if( SEQ_BPM_ChkReqClk(&bpm_tick) > 0 ) {
      again = 1; //  check all requests again after execution of this part

      SEQ_Tick(bpm_tick);
    }
  } while( again && num_loops < 10 );

  return 0; //  no error
}

s32 SEQ_Reset(void){
  seq_pause = 0;   //  release pause mode
  SEQ_BPM_TickSet(0);   //  reset BPM tick
  return 0; //  no error
}

s32 SEQ_Loop(void){return 0;}


static s32 SEQ_Tick(u32 bpm_tick){  //  performs a single bpm tick
    
  // MAIN RESET ON FIRST TIC EVER... (PLAY-Button)
  if( bpm_tick == 0 ) {        // 303 not so clear
            flag.FirstTic =  1;
            main_step_pos = -2;
            loop_step_pos =  0 + StepOffset; //  start @ Step0 and then step forwared to Loop Point, and then Loop
            flag.NeedSync =  1;}  

  // 32th tic calculation/generation
  TicSend = (bpm_tick % (SEQ_BPM_PPQN_Get()/8));


  //  Forward Step-Count --Running Light-- 2 BLM BTNs
  if(   ( (TicSend == 12) && (flag.shiftvalue == 1) )   &&   ( (MatrixUse == 0) || (MatrixUse == 1) || (MatrixUse == 2) )  )
                {  Router(6, 0, StepSend , 2);  }
 
 
  if(TicSend == TicOffset) { //  whenever we reach a new 32th note (e.g 48tics @384 ppqn):
      
         //  MAIN LOOP COUNTER
         if( ++main_step_pos >= beat.MainLoop ) {main_step_pos = 0;} //  increment step number until it reaches the mainloop length

         //  Set new Loop (in Main Sync)s
         if(main_step_pos == 0) {

                // We are in the middle of Program
                if(flag.FirstTic == 0) { 
                    if(flag.NeedSync  == 1 ) { // Something has changed, Set new Loop point when beat.MainLoop is finished
                        First = (beat.PAGE_loop[0] * beat.PAGE_Steps);                    // First step in loop =  0beat.PAGE_actual*16Perpage=0...
                        Last  = (beat.PAGE_loop[1] * beat.PAGE_Steps) + beat.PAGE_Steps;  // Last  step in loop = (0beat.PAGE_actual*16Perpage)+16=16
                        flag.NeedSync = 0; } } // New flag.NeedSync to avoid double triggering events.
                   
                    
                // We have started the Sequencer right now... now do something
                if(flag.FirstTic == 1) {
                     First = (beat.PAGE_loop[0]*beat.PAGE_Steps); // First step in loop = 0beat.PAGE_actual*16Perpage=0...
                     Last  = (beat.PAGE_loop[1]*beat.PAGE_Steps)+beat.PAGE_Steps; // Last step in loop = (0beat.PAGE_actual*16Perpage)+16=16
                     // set new step position
                     loop_step_pos = 0;   // start with 0 = usefull wehn Loop is set a few PAGEs later...
                     flag.FirstTic = 0; } // disable Flag to avoid double triggering of events..
            }

        if( ++loop_step_pos >= Last) loop_step_pos = First;   // increment step number until it reaches the loop length
        StepSend = loop_step_pos;
        
 // MIOS32_MIDI_SendDebugMessage("beat.MainLoop:%d: main_step_pos:%d loop_step_pos:%d first:%d last:%d", beat.MainLoop, main_step_pos, loop_step_pos, First, Last);
            
  }
     
// send 96th Tics to Triggermatrix to trigger Notes between 16th notes (human feel)
Trigger_Matrix(0, 127, 0, StepSend, TicSend); // (u8 port, u8 note, u16 velocity, u8 step, u8 tic) Back to APP.c

// End-drum-trigger
  return 0; //  no error,
}
