// Track Position Display - Test App
#include <mios32.h>
#include "app.h"
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <wchar.h> // to copy pattern-memory

void TPD(u16 ID, u16 H, u16 V, s16 value);

int   	TPD_SEG[8][8]  =  {{}}; 	// pre calculated Code for faster transport to the shiftregisters
int   	Tact = 4; 				// for Example for Digit 4 5 6 --- As Tact Display > 3/4 Tact 4/4 5/4....
float 	BPM  = 128.5; 			// for Example for Digit 0 1 2 3 --- As BPM Display
int   	TPD_MTX1[2][8][16] =  {	  {	{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//0
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//1
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//2
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//3
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//4
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//5
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//6
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0} },//7
								{	{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//0
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//0
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//2
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//3
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//4
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//5
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//6
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0} }//7
								};
int   	TPD_MTX2[2][8][16] =  {	  {	{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//0
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//1
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//2
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//3
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//4
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//5
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//6
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0} },//7
								{	{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//0
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//1
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//2
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//3
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//4
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//5
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//6
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1} }//7
};
int   	TPD_MTX3[2][8][16] =  {	  {	{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//1
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//1
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//2
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//3
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//4
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//5
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1},//6
									{1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1} },//7
								{	{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//0
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//0
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//2
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//3
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//4
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//5
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0},//6
									{0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0} }//7
};

int   	Button[5] = {};
int   	VPage = 1;	// what doe the Buttons, what doe the encoders?
int 	MTX = 0;
int 	Pix = 0;

	// TPD-Hardware Setup
	#define TPD_DOUT 0 // number of DOUT-Shiftregister in The Siftregister Chain (J8/9), if it is the first then WRITE "0"
	#define TPD_DIN  0 // number of DIN -Shiftregister in The Siftregister Chain (J8/9), if it is the first then WRITE "0"
	
// ENCODER            SR begin with 1, ENC with 0)   //    setup the Pinout of Encoders
    const mios32_enc_config_t encoders[1] = {{ .cfg.type=DETENTED2, .cfg.speed=NORMAL, .cfg.speed_par=3, .cfg.sr=1, .cfg.pos=0 }};


void APP_Init(void){ MIOS32_ENC_ConfigSet(0, encoders[0]);}

 
void APP_Background(void){
	
	// Calculate 7 Segment Patterns, for faster Transfair to Shiftregistors

	// Re-Arrange Digits to TPD Hardware according:
	//	[2]	[1]	[0]	[7]
	//		[5]	[4]	[3]
	static char buf[8] =  {0,1,2,4,4,11,6,7}; //11 means NOTHING - CLEAR Digit!
	
	// TACT
	if (Tact < 10)  { buf[5] = Tact; 	// TACT
					  buf[4] = 10; 		// "-" seperator
					  buf[3] = 4;	}	// we always think in x/4
	if (Tact > 9) 	{ buf[5] = 1; 		// 1
					  buf[4] = Tact-10;	// print Tact
					  buf[3] = 4;	}	// we always think in x/4
					  
	if(VPage == 3 || VPage == 4)	{	// Matrix Checker - Pixel Shower
										u16 value=	Pix;
										buf[7]	=	value % 10;
										value	=	value / 10;
										buf[0]	=	value % 10;
										value	=	value / 10;
										buf[1]	=	value % 10;
										if (value == 0) { buf[1] = 11; } //Dont Print 0, just print nothing!
										value	=	value / 10;
										buf[2]	=	value % 10;
										if (value == 0) { buf[2] = 11; } //Dont Print 0, just print nothing!
									}
	if(VPage == 1 || VPage == 2)	{	// BPM
										u16 value=	BPM*10;
										buf[7]	=	value % 10;
										value	=	value / 10;
										buf[0]	=	value % 10;
										value	=	value / 10;
										buf[1]	=	value % 10;
										if (value == 0) { buf[1] = 11; } //Dont Print 0, just print nothing!
										value	=	value / 10;
										buf[2]	=	value % 10;
										if (value == 0) { buf[2] = 11; } //Dont Print 0, just print nothing!
									}


	// Transcode To Shiftregister-Friendly Array
	static u8 x=0;
	for (x=0; x<8; x++) {
	//	Re-Arrange 7 Segment PINOUT to TPD Hardware according
	//		[6]	
	//	[1]		[5]
	//		[0]
	//	[2]		[4]
	//		[3]		[7]
	//	
							switch (buf[x]) {
												case 0:	TPD_SEG[x][0] = 0;
														TPD_SEG[x][1] = 1;
														TPD_SEG[x][2] = 1;
														TPD_SEG[x][3] = 1;
														TPD_SEG[x][4] = 1;
														TPD_SEG[x][5] = 1;
														TPD_SEG[x][6] = 1;break;
												case 1:	TPD_SEG[x][0] = 0;
														TPD_SEG[x][1] = 0;
														TPD_SEG[x][2] = 0;
														TPD_SEG[x][3] = 0;	
														TPD_SEG[x][4] = 1;
														TPD_SEG[x][5] = 1;
														TPD_SEG[x][6] = 0;break;	
												case 2:	TPD_SEG[x][0] = 1;	
														TPD_SEG[x][1] = 0;	
														TPD_SEG[x][2] = 1;	
														TPD_SEG[x][3] = 1;	
														TPD_SEG[x][4] = 0;	
														TPD_SEG[x][5] = 1;	
														TPD_SEG[x][6] = 1;break;	
												case 3:	TPD_SEG[x][0] = 1;	
														TPD_SEG[x][1] = 0;	
														TPD_SEG[x][2] = 0;	
														TPD_SEG[x][3] = 1;	
														TPD_SEG[x][4] = 1;	
														TPD_SEG[x][5] = 1;	
														TPD_SEG[x][6] = 1;break;	
												case 4:	TPD_SEG[x][0] = 1;	
														TPD_SEG[x][1] = 1;	
														TPD_SEG[x][2] = 0;	
														TPD_SEG[x][3] = 0;	
														TPD_SEG[x][4] = 1;	
														TPD_SEG[x][5] = 1;	
														TPD_SEG[x][6] = 0;break;	
												case 5:	TPD_SEG[x][0] = 1;	
														TPD_SEG[x][1] = 1;	
														TPD_SEG[x][2] = 0;	
														TPD_SEG[x][3] = 1;	
														TPD_SEG[x][4] = 1;	
														TPD_SEG[x][5] = 0;	
														TPD_SEG[x][6] = 1;break;	
												case 6:	TPD_SEG[x][0] = 1;	
														TPD_SEG[x][1] = 1;	
														TPD_SEG[x][2] = 1;	
														TPD_SEG[x][3] = 1;	
														TPD_SEG[x][4] = 1;	
														TPD_SEG[x][5] = 0;	
														TPD_SEG[x][6] = 1;break;	
												case 7:	TPD_SEG[x][0] = 0;	
														TPD_SEG[x][1] = 0;	
														TPD_SEG[x][2] = 0;	
														TPD_SEG[x][3] = 0;	
														TPD_SEG[x][4] = 1;	
														TPD_SEG[x][5] = 1;	
														TPD_SEG[x][6] = 1;break;	
												case 8:	TPD_SEG[x][0] = 1;	
														TPD_SEG[x][1] = 1;	
														TPD_SEG[x][2] = 1;	
														TPD_SEG[x][3] = 1;	
														TPD_SEG[x][4] = 1;	
														TPD_SEG[x][5] = 1;	
														TPD_SEG[x][6] = 1;break;
												case 9:	TPD_SEG[x][0] = 1;	
														TPD_SEG[x][1] = 1;	
														TPD_SEG[x][2] = 0;	
														TPD_SEG[x][3] = 1;	
														TPD_SEG[x][4] = 1;	
														TPD_SEG[x][5] = 1;	
														TPD_SEG[x][6] = 1;break;	
												case 10:TPD_SEG[x][0] = 1;	// "-"
														TPD_SEG[x][1] = 0;	
														TPD_SEG[x][2] = 0;	
														TPD_SEG[x][3] = 0;	
														TPD_SEG[x][4] = 0;	
														TPD_SEG[x][5] = 0;	
														TPD_SEG[x][6] = 0;break;	
												default:TPD_SEG[x][0] = 0;	
														TPD_SEG[x][1] = 0;	
														TPD_SEG[x][2] = 0;	
														TPD_SEG[x][3] = 0;	
														TPD_SEG[x][4] = 0;	
														TPD_SEG[x][5] = 0;	
														TPD_SEG[x][6] = 0;break;	
							}			
		
	}
	// Print the DOT of "x.4" which means x/4 or 4/4... when haveing 3 Digits i write 4.4 because there could be a 11.4 Tact!
	if(Tact < 10) 	{ TPD_SEG[4][7] = 0;}
	if(Tact > 9)	{ TPD_SEG[4][7] = 1;}
	// Print the dot of the BPM > 127.5 BPM
	TPD_SEG[0][7] = 1;

}

                                   
void APP_Tick(void){} // @ mS rate, from main task which also handles DIN, ENC and AIN events.  dont do more than 300uS!        


void APP_MIDI_NotifyPackage( mios32_midi_port_t port, mios32_midi_package_t midi_package ){} // End Hook


void APP_SRIO_ServicePrepare(void)  {
	
	// T R A C K  P O S I T I O N  D I S P L A Y ////////////////////////////////////////////////////////////////

	// 7 Segment Display "BPM" & "TACT"
		u8 Segment =  TPD_DOUT * 8;
		u8 Digit   = (TPD_DOUT + 1) * 8;
		u8 BtnLED  = (TPD_DOUT + 8) * 8;
		u8 Matrix  = (TPD_DOUT + 2) * 8;
		
		static u8 CountSeg = 0; // Init Counter once
		static u8 CountDig = 0; // Init Counter once
		
		static u8 x = 0;             // set LED      // sel Segment  // set value
		for (x=0; x<8; x++) { MIOS32_DOUT_PinSet( Segment+x, TPD_SEG[CountDig][x]); }
				
		// Count thru the Digits
		MIOS32_DOUT_PinSet( CountDig + Digit, 1);	// turn off last Digit
		CountDig++;									// Count thru4
		if (CountDig > 7) { CountDig = 0; } 		// reset/clip Counter
		MIOS32_DOUT_PinSet( CountDig + Digit, 0); 	// Turn on next Digit
		
	// Showing Button LEDs
		// Button [0] is the Encoders Built in Pushbutton --- which doesnt have a LED
		if (Button[4] == 0) {	MIOS32_DOUT_PinSet( BtnLED+0, 0); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+4, 0); }	// Show Button Status	- its dualcolor!								
		if (Button[4] == 1) {	MIOS32_DOUT_PinSet( BtnLED+0, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+4, 0); }	// Show Button Status	- its dualcolor!									
		if (Button[4] == 2) {	MIOS32_DOUT_PinSet( BtnLED+0, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+4, 1); }	// Show Button Status	- its dualcolor!
								
		if (Button[3] == 0) {	MIOS32_DOUT_PinSet( BtnLED+1, 0); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+5, 0); }	// Show Button Status	- its dualcolor!
		if (Button[3] == 1) {	MIOS32_DOUT_PinSet( BtnLED+1, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+5, 0); }	// Show Button Status	- its dualcolor!
		if (Button[3] == 2) {	MIOS32_DOUT_PinSet( BtnLED+1, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+5, 1); }	// Show Button Status	- its dualcolor!
								
		if (Button[2] == 0) {	MIOS32_DOUT_PinSet( BtnLED+2, 0); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+6, 0); }	// Show Button Status	- its dualcolor!
		if (Button[2] == 1) {	MIOS32_DOUT_PinSet( BtnLED+2, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+6, 0); }	// Show Button Status	- its dualcolor!
		if (Button[2] == 2) {	MIOS32_DOUT_PinSet( BtnLED+2, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+6, 1); }	// Show Button Status	- its dualcolor!
								
		if (Button[1] == 0) {	MIOS32_DOUT_PinSet( BtnLED+3, 0); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+7, 0); }	// Show Button Status	- its dualcolor!
		if (Button[1] == 1) {	MIOS32_DOUT_PinSet( BtnLED+3, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+7, 0); }	// Show Button Status	- its dualcolor!
		if (Button[1] == 2) {	MIOS32_DOUT_PinSet( BtnLED+3, 1); 	// Show Button Status
								MIOS32_DOUT_PinSet( BtnLED+7, 1); }	// Show Button Status	- its dualcolor!	
		
		
		
	// Ledmatrix - Test Pattern
	if (VPage == 1) {
		static u8 CountMtx = 0; // Init Counter once
		x = 0;             // set LED      // sel Segment  // set value
		if (CountMtx <  8 ) {
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+x,   	TPD_MTX1[0][CountMtx][x]); // Green
														MIOS32_DOUT_PinSet( Matrix+8+x, 	TPD_MTX1[1][CountMtx][x]); }// RED
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+24+x,   	TPD_MTX1[0][CountMtx][x+8]); // Green
														MIOS32_DOUT_PinSet( Matrix+32+x, 	TPD_MTX1[1][CountMtx][x+8]); }// RED
							}
							
		if (CountMtx >  7 ) {
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+x,   	TPD_MTX1[0][CountMtx-8][x]); // Green
														MIOS32_DOUT_PinSet( Matrix+8+x, 	TPD_MTX1[1][CountMtx-8][x]); }// RED
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+24+x,   	TPD_MTX1[0][CountMtx-8][x+8]); // Green
														MIOS32_DOUT_PinSet( Matrix+32+x, 	TPD_MTX1[1][CountMtx-8][x+8]); }// RED
							}
							
		// Count thru the Digits
		if (CountMtx <  8 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+16, 0);}	// turn off last Digit
		if (CountMtx >  7 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+32, 0);}	// turn off last Digit
		CountMtx++;										// Count thru4
		if (CountMtx > 15) { CountMtx = 0; } 			// reset/clip Counter
		if (CountMtx <  8 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+16, 1);} 	// Turn on next Digit
		if (CountMtx >  7 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+32, 1);}	// Turn on next Digit	
	}
	
	
	// Ledmatrix - Test Pattern
	if (VPage == 2) {
		static u8 CountMtx = 0; // Init Counter once
		x = 0;             // set LED      // sel Segment  // set value
		if (CountMtx <  8 ) {
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+x,   	TPD_MTX2[0][CountMtx][x]); // Green
														MIOS32_DOUT_PinSet( Matrix+8+x, 	TPD_MTX2[1][CountMtx][x]); }// RED
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+24+x,   	TPD_MTX2[0][CountMtx][x+8]); // Green
														MIOS32_DOUT_PinSet( Matrix+32+x, 	TPD_MTX2[1][CountMtx][x+8]); }// RED
							}
							
		if (CountMtx >  7 ) {
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+x,   	TPD_MTX2[0][CountMtx-8][x]); // Green
														MIOS32_DOUT_PinSet( Matrix+8+x, 	TPD_MTX2[1][CountMtx-8][x]); }// RED
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+24+x,   	TPD_MTX2[0][CountMtx-8][x+8]); // Green
														MIOS32_DOUT_PinSet( Matrix+32+x, 	TPD_MTX2[1][CountMtx-8][x+8]); }// RED
							}
							
		// Count thru the Digits
		if (CountMtx <  8 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+16, 0);}	// turn off last Digit
		if (CountMtx >  7 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+32, 0);}	// turn off last Digit
		CountMtx++;										// Count thru4
		if (CountMtx > 15) { CountMtx = 0; } 			// reset/clip Counter
		if (CountMtx <  8 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+16, 1);} 	// Turn on next Digit
		if (CountMtx >  7 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+32, 1);}	// Turn on next Digit	
	}

	// Ledmatrix - Test Pattern
	if (VPage == 3) {
		static u8 CountMtx = 0; // Init Counter once
		x = 0;             // set LED      // sel Segment  // set value
		if (CountMtx <  8 ) {
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+x,   	TPD_MTX3[0][CountMtx][x]); // Green
														MIOS32_DOUT_PinSet( Matrix+8+x, 	TPD_MTX3[1][CountMtx][x]); }// RED
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+24+x,   	TPD_MTX3[0][CountMtx][x+8]); // Green
														MIOS32_DOUT_PinSet( Matrix+32+x, 	TPD_MTX3[1][CountMtx][x+8]); }// RED
							}
							
		if (CountMtx >  7 ) {
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+x,   	TPD_MTX3[0][CountMtx-8][x]); // Green
														MIOS32_DOUT_PinSet( Matrix+8+x, 	TPD_MTX3[1][CountMtx-8][x]); }// RED
								for (x=0; x<8; x++) {   MIOS32_DOUT_PinSet( Matrix+24+x,   	TPD_MTX3[0][CountMtx-8][x+8]); // Green
														MIOS32_DOUT_PinSet( Matrix+32+x, 	TPD_MTX3[1][CountMtx-8][x+8]); }// RED
							}
							
		// Count thru the Digits
		if (CountMtx <  8 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+16, 0);}	// turn off last Digit
		if (CountMtx >  7 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+32, 0);}	// turn off last Digit
		CountMtx++;										// Count thru4
		if (CountMtx > 15) { CountMtx = 0; } 			// reset/clip Counter
		if (CountMtx <  8 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+16, 1);} 	// Turn on next Digit
		if (CountMtx >  7 ) { MIOS32_DOUT_PinSet( CountMtx + Matrix+32, 1);}	// Turn on next Digit	
	}
		
	
					
	// Ledmatrix - Pin-Test
	if (VPage ==4) {
		
		// Deactivate all LEDs
		u8 x; for (x=0; x<48; x++)	{ MIOS32_DOUT_PinSet( 16+x, 0); }

		// Activate a Single Pin
		switch (Pix) {
						// 1st Row from Left to Right
						case 0:		MIOS32_DOUT_PinSet(31+16, 1); break;
						case 1:		MIOS32_DOUT_PinSet(39+16, 1); break;
						case 2:		MIOS32_DOUT_PinSet(47+16, 1); break;
						case 3:		MIOS32_DOUT_PinSet(30+16, 1); break;
						case 4:		MIOS32_DOUT_PinSet(38+16, 1); break;
						case 5:		MIOS32_DOUT_PinSet(46+16, 1); break;
						case 6:		MIOS32_DOUT_PinSet(29+16, 1); break;
						case 7:		MIOS32_DOUT_PinSet(37+16, 1); break;
						case 8:		MIOS32_DOUT_PinSet(45+16, 1); break;
						case 9:		MIOS32_DOUT_PinSet(28+16, 1); break;
						case 10:	MIOS32_DOUT_PinSet(36+16, 1); break;
						case 11:	MIOS32_DOUT_PinSet(44+16, 1); break;
						case 12:	MIOS32_DOUT_PinSet(7+16,  1); break;
						case 13:	MIOS32_DOUT_PinSet(15+16, 1); break;
						case 14:	MIOS32_DOUT_PinSet(23+16, 1); break;
						case 15:	MIOS32_DOUT_PinSet(6+16,  1); break;
						case 16:	MIOS32_DOUT_PinSet(14+16, 1); break;
						case 17:	MIOS32_DOUT_PinSet(22+16, 1); break;
						case 18:	MIOS32_DOUT_PinSet(5+16,  1); break;
						case 19:	MIOS32_DOUT_PinSet(13+16, 1); break;
						case 20:	MIOS32_DOUT_PinSet(21+16, 1); break;
						case 21:	MIOS32_DOUT_PinSet(4+16,  1); break;
						case 22:	MIOS32_DOUT_PinSet(12+16, 1); break;
						case 23:	MIOS32_DOUT_PinSet(20+16, 1); break;
						// 2nd Row from Left to Right
						case 24:	MIOS32_DOUT_PinSet(27+16, 1); break;
						case 25:	MIOS32_DOUT_PinSet(35+16, 1); break;
						case 26:	MIOS32_DOUT_PinSet(43+16, 1); break;
						case 27:	MIOS32_DOUT_PinSet(26+16, 1); break;
						case 28:	MIOS32_DOUT_PinSet(34+16, 1); break;
						case 29:	MIOS32_DOUT_PinSet(42+16, 1); break;
						case 30:	MIOS32_DOUT_PinSet(25+16, 1); break;
						case 31:	MIOS32_DOUT_PinSet(33+16, 1); break;
						case 32:	MIOS32_DOUT_PinSet(41+16, 1); break;
						case 33:	MIOS32_DOUT_PinSet(24+16, 1); break;
						case 34:	MIOS32_DOUT_PinSet(32+16, 1); break;
						case 35:	MIOS32_DOUT_PinSet(40+16, 1); break;
						case 36:	MIOS32_DOUT_PinSet(3+16,  1); break;
						case 37:	MIOS32_DOUT_PinSet(11+16, 1); break;
						case 38:	MIOS32_DOUT_PinSet(19+16, 1); break;
						case 39:	MIOS32_DOUT_PinSet(2+16,  1); break;
						case 40:	MIOS32_DOUT_PinSet(10+16, 1); break; 
						case 41:	MIOS32_DOUT_PinSet(18+16, 1); break;
						case 42:	MIOS32_DOUT_PinSet(1+16,  1); break;
						case 43:	MIOS32_DOUT_PinSet(9+16,  1); break;
						case 44:	MIOS32_DOUT_PinSet(17+16, 1); break;
						case 45:	MIOS32_DOUT_PinSet(0+16,  1); break;
						case 46:	MIOS32_DOUT_PinSet(8+16,  1); break;
						case 47:	MIOS32_DOUT_PinSet(16+16, 1); break;
					}

			}
}

 
void APP_SRIO_ServiceFinish(void)   {}
      
void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){

	if (pin_value == 0) {	u8 off = (TPD_DIN * 8) + pin - 3;
							Button[off] = Button[off]+1;
							if (Button[off] > 2) {Button[off] = 0;}
							MIOS32_MIDI_SendDebugMessage("button: %d:", off);
							
							VPage = off;
						}
	}
                                
void APP_ENC_NotifyChange(u32 encoder, s32 incrementer){
	
	// Use the Pushbuttons as VPage Selectors, and change the Encoders  V-Enc
	if (VPage == 1) {	BPM = BPM + incrementer;
						if (BPM > 998) 	{ BPM = 998;}
						if (BPM < 1)	{ BPM = 1;}
						int show = BPM*10;
						MIOS32_MIDI_SendDebugMessage("bpm: %d:", show);
					}
					
	if (VPage == 2) {	Tact = Tact + incrementer;
						if (Tact > 14) 	{ Tact = 15;}
						if (Tact < 4)	{ Tact = 3;}
						MIOS32_MIDI_SendDebugMessage("Tact: %d/4:", Tact);
					}
				
	if (VPage == 3 || VPage == 4)	{	Pix = Pix + incrementer;
										if (Pix > 46) 	{ Pix = 47;}
										if (Pix < 1)	{ Pix =  0;}
										MIOS32_MIDI_SendDebugMessage("Pix: %d", Pix);
									}
								
}
 
void APP_AIN_NotifyChange(u32 pin, u32 pin_value){}
