/** \file types.h
 * defines complex data types for our program
 * if the data types differ between bankstick and ram, the bankstick types can be found in the comments
 */

/*
typedef struct t_extremum {
	int max;
	int min;
}extremum;
*/

/**
 * this data structur is being placed into the dynamic memory.
 * it is adresed through one of the parameters of the device which belongs to this part of the dynamic memory
 */
typedef struct SysexStruct_s {
	unsigned char convert_func;			//!< points to convert function to convert the data from the potis[] array to sysex string
	unsigned char convert_func_addr;	//!< adress where the converted data has to be put into the sysex string
	unsigned char length;				//!< length of the sysexstring that follows up in bankstick
}SysexStruct;

/**
 * to request and process an edit buffer, different informations are required, that are collected in this struct
 */
typedef struct DumpStruct_s {
	/**
	 * \todo <b>'dump' is a confusing labelling, as in this program it means sending a small sysexstring to the synthesizer to get back an edit buffer dump. please rename it in future releases to dump_request or...<b>
	 * 2bit typ
	 * - 00 editbuffer request
	 * - 01 send sysex
	 * 4bit timeout (10ms/500ms)
	 * 1bit prev
	 * 1bit next
	 */
	unsigned char typ;
	unsigned char checksum_func;		//!< points to eb_convert function to convert the data from the potis[] array to edit buffer
	unsigned char wrong_header_length;	//!< length of received header, that has to be discarded
	unsigned int  edit_buffer_length;	//!< length of edit buffer that will be received
	unsigned char length;				//!< length of the sysexstring that follows up in bankstick
	unsigned char header_length;		//!< length of the new header that will be placed in front of the outgoing edit buffer (follows up in bankstick)
}DumpStruct;

//Parameter @ BankStick
/*
typedef struct t_parameter {
	char name[10];
	unsigned char messageChannel;
	unsigned char modeSelect;
	unsigned char number[2];	//wenn sysex dann adresse fuer sysex-struktur im dyn speicher
	unsigned char valueMin[2];
	unsigned char valueMax[2];
	unsigned char value[2];
	unsigned char scale;
	unsigned int edit;
	unsigned int sswitch_addr;
}parameter;
*/

/**
 * to process parameters, different informations are required, that are collected in this struct
 */
typedef struct t_parameter {
	char name[10];		//!< parameter name which is displayed
	/**
	 * messagetype includes different informations
	 *
	 * x111xxxx - "MIDI DATA TYPE"
	 * - 000 = OFF
	 * - 001 = NOTE, AFTERTOUCH, PITCHBEND
	 * - 010 = ***free***
	 * - 011 = CONTROL CHANGE + CMM
	 * - 100 = PROGRAM CHANGE
	 * - 101 = NRPN
	 * - 110 = RPN
	 * - 111 = SYSEX
	 *
	 * xxxx1111 - "MIDI CHANNEL"
	 * - 0-15 = MIDI CHANNEL 1-16
	 */
	unsigned char messageChannel;
	/**
	 * modechannel includes different informations
	 *
	 * x111xxxx - "CONTROLLER MODE"  "MIDI DATA TYPE 001"   "MIDI DATA TYPE 100"
	 * - 000 = ABSOLUTE                000 = NOTE             000 = BANKSELECT OFF
	 * - 001 = RELATIVE1               001 = AFTERTOUCH       001 = BANKSELECT MSB
	 * - 010 = RELATIVE2               010 = PITCHBEND        010 = BANKSELECT LSB
	 * - 011 = RELATIVE3                                      011 = BANKSELECT MSB+LSB
	 * - 100 = INC/DEC
	 *
	 * xxxx1xxx - "ENC/SWITCH-MODE"
	 * - 0 = ENC
	 * - 1 = SWITCH
	 *
	 * xxxxx1xx - "ACCELERATION" - "TOGGLE" - "INC/DEC"
	 * - 0 = OFF
	 * - 1 = ON
	 *
	 * xxxxxx1x - "7BIT/14BIT-MODE"
	 * - 0 = 7BIT
	 * - 1 = 14BIT
	 *
	 * xxxxxxx1 - "MIN POSITIV / NEGATIV"
	 * - 0 = POSITIV
	 * - 1 = NEGATIV
	 */
	unsigned char modeSelect;
	unsigned char number[2];      //!< controller/key/nrpn number, if sysex, pointer to dynamic ram where optional sysex structure lies. no structure available if 0\n 14Bit: 0 MSB, 1 LSB; 7Bit: MSB
	unsigned char valueMin[2];		//!< minimum value \n14Bit: 0 MSB, 1 LSB; 7Bit: MSB
	unsigned char valueMax[2];		//!< maximum value \n14Bit: 0 MSB, 1 LSB; 7Bit: MSB
	unsigned char value[2];			//!< value \n14Bit: 0 MSB, 1 LSB; 7Bit: MSB -- if editbufferaddr=0 value[0]=eb_convert_func
	/**
	 * scale of value
	 * - 0 complete midi scale is used and mapped to user scale
	 * - 1,2,4,8,16,32,64 stepwith in midiscale per user step
	 * \todo possible: continous scale factors from 1-255
	 */
	unsigned char scale;
	/**
	 * - 12bit editbufferaddr
	 * - 1bit  send editbuffer
	 * - 1bit with switch
	 */
	unsigned int edit;
	/**
	 * <b>adress in dynamic ram where optional textual descriptions for the parameter values lie
	 * this structure in the dynamic part of the bankstick is of the following design:
	 * - 6 byte static characters for the name are one cell
	 * - the number of cells is (max-min)/scale</b>
	 */
	unsigned int sswitch_addr;
	SysexStruct sysex;			//!< this field is not contained in the bankstick but is generated during loading the parameter. it contains a sysex struct, if parameter is of type sysex
}parameter;

/**
 * to process moduls, different informations are required, that are collected in this struct
 */
typedef struct Modul_s {
	char name[20];			//!< name of modul
	unsigned int dump_addr;	//!< 16 bit adress in dynamic memory, no dump if 0
	DumpStruct dump;		//!< if dump in dynamic memory is available for modul, it will be loaded into this data structure
}Modul;

/**
 * to process devices, different informations are required, that are collected in this struct
 */
typedef struct Device_s {
	char name[20];			//!< name of device
	unsigned int dump_addr;	//!< 16 bit adress in dynamic memory, no dump if 0
	DumpStruct dump;		//!< if dump in dynamic memory is available for device, it will be loaded into this data structure
}Device;

/*struct status {
	unsigned char bankchip:4;	//active bankchip
	unsigned char bank:2;		//module banks
	unsigned char update:2;		//display update flags
	unsigned char knobs:4;		//knobs
	unsigned char device:4;		//active chosen preset
	unsigned char modul:4;		//active chosen bank
	unsigned char modus:2;		//operation mode
	unsigned char display:1;	//active display
};*/

/**
 * this structure exists only once in RAM. It administrates the requesting of a dump and stores information about the actual loaded edit buffer
 */
typedef struct EB_request_s {
	unsigned char active:1;		//!< true when edit buffer request sent. stays true as long as timeout timer hasnt run out, or the number of bytes (data_counter) from the edit buffer did not arrive
	unsigned char error:1;		//!< true when error in transmission has ocurred. (e.g. timer runs out)
	unsigned char checksum_func;//!< number of convert function (to be found in func.c)
	unsigned int data_counter;	//!< number of bytes to receive (length of edit buffer)
	unsigned int timer;			//!< is started when sending Edit buffer request. produces error if synthesizer did not answer before timer runs out. also: time to wait between different sysex messages (e.g. first message to MIDI crossbar, second message to synth...)
	unsigned int dump_addr;		//!< adress of dump in the dynamic memory
	DumpStruct dump;			//!< adressed dump is being loaded into RAM here.
}EB_request;
