/*
 * MIOS32 Wavedrum MIDI
 * Header file for adc.c
 * Version 1.0
 * ==========================================================================
 *
 *  Copyright (C) 2013 Ingo Debus (<your email address>)
 *  Licensed for personal non-commercial use only.
 *  All other rights reserved.
 * 
 * ==========================================================================
 */

#ifndef __ADC_H 
#define __ADC_H


#define ADC_OFFSET		0x10
#define ADC_INDEX		4

#define ADC_DONE		0x80000000
#define ADC_OVERRUN		0x40000000
#define ADC_ADINT		0x00010000

#define ADC_NUM			2
#define ADC_CLK			1000000		/* set to 1Mhz */

#define ADCMIN			0
#define ADCMID			2048
#define ADCMAX			4095

#define WAIT			0	//processing buffer in main routine
#define READY			1	//waiting for trigger
#define TRIGD			2	//recording signal into buffer
#define ADCOFF			3	//ADC channel inactive

#define BUF_SIZE		64
#define START_ZONE		10		//zone in the beginning of sample in which glitches are detected by counting the below-threshold values

extern void ADCInit( u32 ADC_Clk );
#endif /* end __ADC_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
