;; app_include.inc
;; ========================================================================

;; ----[NOTE ON to AY TONE FREQ Hz CONVERSATION]----------------------------
#include "ay_chip_note_on_to_hz_tab.inc"

;; ----[APPLICATION VARIABLES, ETC. INI]------------------------------------
#include "midibox_ay_ini.inc"

;; ---[simplifies the handling with MIDI events ]---------------------------
;; NOTE: NOT USED YET
;; #include "midi_evnt.inc"

;; ----[INTERCONNECTION TO THE AY CHIP]-------------------------------------
#include "ay_chip_serial_data_interfacing.inc"


;; ----[BTN HANDLING]-------------------------------------------------------
#include "button_jumptable.inc"

;; ----[AY MAIN MENU 0-8]---------------------------------------------------
#include "main_menu_functions.inc"

#include "main_menu_00_menu_choice.inc"

#include "main_menu_01_patch.inc"

#include "main_menu_01_patch_subroutines.inc"

#include "main_menu_02_detune.inc"

#include "main_menu_03_mixer.inc"

#include "main_menu_04_amplitude.inc"

#include "main_menu_05_envelope.inc"

#include "main_menu_06_midi_ch.inc"

#include "main_menu_07_velocity_conf.inc"

#include "main_menu_08_fx.inc"


;; ----[BTN SUB ROUTINES]---------------------------------------------------
#include "sub_routine_button_select.inc"

#include "sub_routine_button_up.inc"

#include "sub_routine_button_down.inc"

#include "sub_routine_button_a.inc"

#include "sub_routine_button_b.inc"

#include "sub_routine_button_c.inc"

#include "sub_routine_button_plus.inc"

#include "sub_routine_button_plus_menu_0.inc"

#include "sub_routine_button_plus_menu_1.inc"

#include "sub_routine_button_plus_menu_2.inc"

#include "sub_routine_button_plus_menu_3.inc"

#include "sub_routine_button_plus_menu_4.inc"

#include "sub_routine_button_plus_menu_5.inc"

#include "sub_routine_button_plus_menu_6.inc"

#include "sub_routine_button_plus_menu_7.inc"

#include "sub_routine_button_plus_menu_8.inc"

#include "sub_routine_button_minus.inc"

#include "sub_routine_button_minus_menu_0.inc"

#include "sub_routine_button_minus_menu_1.inc"

#include "sub_routine_button_minus_menu_2.inc"

#include "sub_routine_button_minus_menu_3.inc"

#include "sub_routine_button_minus_menu_4.inc"

#include "sub_routine_button_minus_menu_5.inc"

#include "sub_routine_button_minus_menu_6.inc"

#include "sub_routine_button_minus_menu_7.inc"

#include "sub_routine_button_minus_menu_8.inc"

#include "sub_routine_button_left.inc"

#include "sub_routine_button_right.inc"

#include "sub_routine_button_f1_f8.inc"

#include "sub_routine_button_shortcuts_menu8.inc"

;; ----[PATCH]--------------------------------------------------------------
#include "patch_write.inc"

#include "patch_load.inc"

#include "patch_name_edit.inc"

#include "patch_format_bankstick.inc"

#include "patch_state_set_flags.inc"

#include "patch_load_subroutines.inc"

#include "patch_write_subroutines.inc"


;; ----[USER Tick]----------------------------------------------------------
#include "user_tick_lcd_redraw.inc"

#include "user_tick_btn_auto_repeat.inc"

#include "user_tick_blinking_cursor.inc"


;; ----[MIDI FUNCTIONS - NOTE ON, NOTE OFF, etc.]---------------------------
#include "midi_event_jump_table.inc"			;; MIDI EVENT SWITCH BOARD

#include "note_off.inc"							;; Note OFF Event HAndling

#include "note_on.inc"							;; Note On Switch Board

#include "midi_controller.inc" 					;; MIDI CC Handling

#include "midi_event_pitch_wheel.inc"			;; Pitch Wheel Handling

#include "midi_evnt_handling.inc"				;; NOT USED MIDI EVENT HERE

#include "note_on_pipeline_a.inc"				;; Note ON Handling

#include "note_on_pipeline_b.inc"				;; Note ON Handling

#include "note_on_pipeline_c.inc"				;; Note ON Handling

#include "note_on_write_ay_reg7.inc"			;; Note ON Handling

#include "midi_patch_change_request.inc"		;; MIDI IN Program Change Handling



;; ---[Fx Timer Polling]----------------------------------------------------
#include "fx_timer.inc"

;; ---[Fx Pipeline]---------------------------------------------------------
#include "fx_pipeline.inc"

;; ---[DOUT (LED)]----------------------------------------------------------
#include "dout_calls.inc"

