;; --------------------------------[MENU 01 = PATCH MENUE ]-------------------

;; ###########################################################################
;; # functions:                                                              #
;; # * REFRESH & CHECK PATCH MENU STATE (FLAGS)                              #
;; # * WRITE MAIN MENU1 = PATCH MENU on LCD                                  #
;; ###########################################################################

MENU_01_PATCH
	;; -------[CS: F1-F8 LED CONTROL]-----------------------------------------
	;; -----------------------------------------------------------------------
	;; RESET LED @ F1-F8 BTN 
	;; F1-8 LED'S ALL = OFF
	call	LED_F1_off
	call	LED_F2_off
	call	LED_F3_off
	call	LED_F4_off
	call	LED_F5_off
	call	LED_F6_off
	call	LED_F7_off
	call	LED_F8_off

	;; -----------------------------------------------------------------------------------------
	;; -----------------------------------------------------------------------------------------
	;; - UPDATE/WRITE SOME PATCH STATE FLAGS (STATES)                                          -
	;; - AND WRITE THE FLAGS TO: BNKD_VAR_PATCH_STATE_FLAGS	                           -
	;; -----------------------------------------------------------------------------------------
	;; -----------------------------------------------------------------------------------------
	
	;; -----------------------------------------------------------------------------------------
	;; ----[DO: REFRESH  BNKD_VAR_PATCH_STATE_FLAGS	               ]--------------------
	;;
	;; BANKSTICK AVAILABLE?
	call 	WRITE_FLAG_BANKSTICK_AVAILABLE
	;;
	;; BANKSTICK FORMATTED?
	;; CHECK IF BANKSTICK FINGERPRINT WAS WRITTEN 
	;; AT THE CURRENT BS PATCH & WRITE STATE FLAG
	call	WRITE_FLAG_CURRENT_PATCH_FINGERPRINT
	;;
	;; NOTE:
	;; INTERNAL PATCH (PIC EEPROM) IS ALWAYS AVAILABLE
	;; IF INTERNAL PATCH HAS NEVER BEEN WRITTEN OR HAS NO FINGERPRINT
	;; A DEFAULT PATCH WILL BE WRITTEN AT THE START UP
	;; SEE: WRITE_PIC_EEPROM_PATCH_0_INI @ midibox_ay_ini.inc and main.asm > USER_Init
	;; THERFORE THERE IS ALWAYS A INTERNAL PATCH 0 WITH A FINGERPRINT
	
	;; CURRENT PATCH = PIC EEPROM or BANKSTICK PATCH?
	;; WRITE BANKSTICK OR PIC EEPROM PATCH FLAG
	;; CHECK IF PATCH NUMBER = EEPROM (INTERNAL) or BANKSTICK Patch
	call 	WRITE_FLAG_SELECTED_PATCH_IS_EEPROM_OR_BANKSTICK
	;;
	;; ----[END: REFRESH  BNKD_VAR_PATCH_STATE_FLAGS	              ]---------------------
	;; -----------------------------------------------------------------------------------------
	
	;; -----------------------------------------------------------------------------------------
	;; ----[DO: CLEAR LCD ROW 1 to 4                                      ]---------------------
	call    MIOS_LCD_Clear
	
	;; -----------------------------------------------------------------------------------------
	;; ----[DO: RESET PATCH NAME CURSOR POS = 1                           ]---------------------
	clrf 	VAR_TMP_PATCH_DATA_CLIPBOARD
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_POS_CURSOR_PATCH_NAME

	
	
	;; ----[DO CHECK: WAS THE PATCH NAME EDITED BY THE USER ?             ]---------------------
	;; -----------------------------------------------------------------------------------------
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT5_PATCH_NAME_WAS_EDITED_BY_USER
				;; ---[STATE: BIT5_PATCH_NAME_WAS_EDITED_BY_USER = SET    ]---------------------
				;; ---[STATE: PATCH NAME WAS EDITED BY USER               ]---------------------
				;; ---[DO NOT OVERWRITE THE NEW PATCH NAME ON LCD         ]---------------------
				goto MENU_01_WRITE_PATCH_NAME_ON_LCD_ROW1

	;; ---------------[STATE: BIT5_PATCH_NAME_WAS_EDITED_BY_USER = CLR    ]---------------------
	;; ---------------[STATE: THE PATCH NAME WAS NOT EDITED BY THE USER   ]---------------------
	;; ---------------[DO RELOAD PATCH NAME FROM PATCH                    ]---------------------
	;; LOAD PATCH NAME (8 x ASC) from EEPROM or BANKSTICK (SUB ROUTINE)
	;; SEE: patch_load_subroutines.inc
	call SUB_ROUTINE_LOAD_PATCH_NAME


MENU_01_WRITE_PATCH_NAME_ON_LCD_ROW1
	;; ---------------[DO: WRITE LCD ROW1                                 ]---------------------
   	;; ---------------[DO PRINT "NAME:   --------" @ LCD ROW1             ]---------------------
   	TABLE_ADDR TEXT_AY_MB_AY_PATCH_NAME
	call    MIOS_LCD_PrintString
	
	;; ---------------[DO: WRITE @ LCD ROW1: 8xASC PATCH NAME             ]---------------------
	;; see @ main_menu_01_patch_subroutines.inc
	call SUB_ROUTINE_WRITE_PATCH_NAME_ON_LCD


;; -----[CHECK: DO WE HAVE TO WRITE A "!" ON LCD ROW1 (BEFORE PATCH NAME)?]---------------------
;; ---------------------------------------------------------------------------------------------
	;; CKECK:
	;; CURREND PATCH < > BROWSE PATCH?
	;; WRITE: ! [PATCH NAME] ON LCD ROW1 IF < >
	;; WRITE:   [PATCH NAME] ON LCD ROW1 IF = =
	movff	BNKD_VAR_CURRENT_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff	BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2
	movf  	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2
			
			;; NO
			;; < >
			rgoto MENU1_WRITE_EXCLAMATION_MARK_BEFORE_PATCH_NAME

	;; YES
	;; = =
	;; -----------------[STATE: CURREND PATCH = = BROWSE PATCH  ]--------------------------------
	;; -----------------[DO CHECK: HAS A PATCH BEEN LOADED YET? ]--------------------------------
	;; MEMO - NO PATCH IS LOADED AFTER STARTUP
	;; NOW WE CHECK IF WE HAVE THIS CASE 
	;; BIT4 = CLEAR?
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT4_PATCH_HAS_BEEN_LOADED_OR_WRITTEN

					;; NO
					;; BIT4 is SET
					;; A PATCH HAS BEEN LOADED
					;; -[STATE: CURREND PATCH = = BROWSE PATCH  ]--------------------------------
					;; -[STATE: A PATCH HAS BEEN LOADED         ]--------------------------------
					;; -[DO *NOT* WRITE A  "!" on LCD           ]--------------------------------
					goto MENU_1_CHK_SELECTED_ITEM_POS1

			;; YES
			;; BIT4 IS CLEAR
			;; ---[STATE: CURREND PATCH = = BROWSE PATCH  ]--------------------------------------
			;; ---[STATE: *NO* PATCH HAS BEEN LOADED YET  ]--------------------------------------
MENU1_WRITE_EXCLAMATION_MARK_BEFORE_PATCH_NAME
			;; ---[STATE: CURRENT PATCH <> BROWNSE PATCH *OR*    ]-------------------------------
			;; ---[       CURRENT PATCH = BROWNSE PATCH BUT      ]-------------------------------
			;; ---[       NO PATCH HAS BEEN LOADED YET           ]-------------------------------
			;; ---[DO WRITE A "!" BEFORE [PATCH NAME] ON LCD ROW1]-------------------------------
			movlw   LCD_ROW1 + 6
			call    MIOS_LCD_CursorSet
			movlw   '!'
			call    MIOS_LCD_PrintChar		
;; ------------------------[END OF "!" PROOF @ LCD ROW1          ]--------------------------------
;; ------------------------[END: LCD ROW 1 (PATCH NAME)          ]--------------------------------
;; -----------------------------------------------------------------------------------------------


;; -----------------------------------------------------------------------------------------------
;; ------------------------[DO: CURRENT CURSOR POS HANDLING         ]-----------------------------
;; ------------------------[CHECK: CURRENT POS = ROW1 = PATCH NAME? ]-----------------------------
MENU_1_CHK_SELECTED_ITEM_POS1
	;; ---[CHECK: CURSOR POS = 1 = LCD ROW1 = PATCH NAME ITEM ?     ]-----------------------------
	movff  	BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw  	CONST_MENU_ITEM_POS1
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			
			;; NO
			;; ----[ITEM POS < > 1]---------------------------------
			rgoto MENU_1_WRITE_ITEM_POS2

		;; YES
		;; --------[ITEM POS = = 1]---------------------------------
		;; PRINT ">" ON EDIT POSITION1 = PATCH NAME EDITING
		movlw 	CSR_POS_MENU1_ITEM1
		call    MIOS_LCD_CursorSet
		movlw   '~'
       	call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		;; SET BLINKING CSR
		movlw 	CSR_POS_MENU1_ITEM1
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR

;; ------------------------[DO: WRITE LCD ROW2 ]-----------------------
MENU_1_WRITE_ITEM_POS2
	;; WRITE MENU 1 LCD ROW 2 
	TABLE_ADDR TEXT_AY_MB_AY_PATCH_NR
	call    MIOS_LCD_PrintString
		
	;; ----[CHECK: PATCH NR = 0 = INTERNAL (PIC EEPROM PATCH)]-----------------
	;; ----[DO: CHECK VAR_BROWSE_PATCH_NR = = 0              ]-----------------
	;; Note: IF PATCH NR: = 0: WRITE "INT" on LCD for INTernal PATCH (PIC EEPROM)
	movff	BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw	CONST_INTERNAL_EEPROM_PATCH_0
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			
		;; NO
		;; VAR_BROWSE_PATCH_NR < > 0
		;; SO PATCH = BANKSTICK PATCH (1-128)
		;; -----[STATE: VAR_BROWSE_PATCH_NR = BS PATCH]------------------------------
		rgoto MENU_01_POS2_PATCH_IS_BANKSTICK_PATCH
	
	;; YES
	;; VAR_BROWSE_PATCH_NR = 0
	;; PATCH = INTERNAL (PIC EEPROM PATCH)
	;; --------[STATE: VAR_BROWSE_PATCH_NR = PIC INT PATCH]--------------------------
	;; --------[DO:    PRINT "INTERNAL" on LCD  ROW2  ]--------------------------
	TABLE_ADDR 	LCD_CLEAR_ROW2
	call    	MIOS_LCD_PrintString
	TABLE_ADDR 	TEXT_AY_MB_AY_PATCH_NR 
	call    	MIOS_LCD_PrintString
	TABLE_ADDR 	TEXT_AY_MB_AY_PATCH_INT_PATCH
	call    	MIOS_LCD_PrintString
	;; ------------------------------------------------------------------------
	;; -------[DO: PRINT PATCH NUMBER on LCD ROW2   ]--------------------------
	movlw   LCD_ROW2 + 0x09
	call    MIOS_LCD_CursorSet
	movff	BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movf    VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
	call    MIOS_LCD_PrintBCD3
    ;; -------[DO: PRINT "[" on LCD ROW2            ]--------------------------    	
	movlw 	LCD_ROW2 + 8
	call    MIOS_LCD_CursorSet
	movlw   '['
	call    MIOS_LCD_PrintChar
	;; -------[DO: PRINT "]" on LCD ROW2            ]--------------------------    	
	movlw 	LCD_ROW2 + 12
	call    MIOS_LCD_CursorSet
	movlw   ']'
	call    MIOS_LCD_PrintChar
	;; ------------------------------------------------------------------------
	;; ------[GO AND CHECK IF POS2 IS CURRENT ITEM  ]--------------------------
	rgoto 	MENU1_CHK_SELECTED_ITEM_POS2
	

	;; ----[PRINT B.STICK PATCH ROW2 on LCD]-----------------------------------
MENU_01_POS2_PATCH_IS_BANKSTICK_PATCH
	;; PATCH = BANKSTICK PATCH (1-128)
	;; PRINT "BS1" on LCD ROW 2
	TABLE_ADDR TEXT_AY_MB_AY_PATCH_BS_PATCH
	call    MIOS_LCD_PrintString
		
	;; ------------------------------------------------------------------------
	;; -------[DO: PRINT PATCH NUMBER on LCD ROW2   ]--------------------------
	movlw   LCD_ROW2 + 0x09
	call    MIOS_LCD_CursorSet
	movff	BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movf    VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
	call    MIOS_LCD_PrintBCD3
    ;; -------[DO: PRINT "[" on LCD ROW2            ]--------------------------    	
	movlw 	LCD_ROW2 + 8
	call    MIOS_LCD_CursorSet
	movlw   '['
	call    MIOS_LCD_PrintChar
	;; -------[DO: PRINT "]" on LCD ROW2            ]--------------------------    	
	movlw 	LCD_ROW2 + 12
	call    MIOS_LCD_CursorSet
	movlw   ']'
	call    MIOS_LCD_PrintChar
	;; --------------------------------------------------------------------------

	;; --------------------------------------------------------------------------
	;; ----[END: PRINT B.STICK PATCH ROW2 on LCD]--------------------------------
	;; --------------------------------------------------------------------------


	;; ----[START: CHECKING SELECTED ITEM @ PATCH NUMBER (ROW2 on LCD)]----------
MENU1_CHK_SELECTED_ITEM_POS2
	;; SELECTED ITEM = PATCH NUMBER?
	;; IS BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO = CURSOR POS 2?
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS2
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD ;; COMPARE F WITH WREG
			;; NO
			;; POS < > 2
			;; ITEM 2 IS NOT SELECTED
			rgoto MENU1_GO_ON_WITH_LCD_ROW3_AND_ROW4
		
		;; YES
		;; ITEM 2 IS SELECTED
		movlw 	CSR_POS_MENU1_ITEM2
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU1_ITEM2
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
	
;; -------------------------------[START ROW3+4]--------------------------------------
MENU1_GO_ON_WITH_LCD_ROW3_AND_ROW4
	;; NOTE:
	;; LCD ROW 3+4 ARE NO MENU "ITEMS" JUST PATCH STATUS & INFORMATION
	
	;; -----------------[CHECK IF PATCH = INTERNAL]-----------------------------------
	;; WRITE "----" [NO FORMAT] for INTernal PATCH (PIC EEPROM)
	;; ON LCD IF INTERNAL PIC PATCH IS SELECTED 
	movff	BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw 	CONST_INTERNAL_EEPROM_PATCH_0
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 
			
			;; NO,
			;; VAR_BROWSE_PATCH_NR < > 0
			;; SO PATCH MUST BE A BANKSTICK PATCH
			;; LET'S CHECK IF THE BS AVAILABLE
			rgoto MENU1_CHK_BANKSTICK_AVAILABLE
	
		;; YES
		;; VAR_BROWSE_PATCH_NR = 0
		;; ------[STATE: PATCH = INTERNAL PIC PATCH     ]------------------------------
		;; WRITE F1 F2 ON LCD ROW3
		TABLE_ADDR TEXT_AY_MB_AY_PATCH_F1
		call    MIOS_LCD_PrintString
		TABLE_ADDR TEXT_AY_MB_AY_PATCH_F2
		call    MIOS_LCD_PrintString
		;; ;; PRINT "Load Write ------" on LCD	(NO BS, NO FORMAT NEEDED)
		TABLE_ADDR TEXT_MENU_1_PATCH_LOAD_SAFE
		call    MIOS_LCD_PrintString

		call	LED_F1_on
		call	LED_F2_on

		;; INTERNAL PATCH, no need for checking BANKSTICK status
		;; EXIT HERE
		return
	
MENU1_CHK_BANKSTICK_AVAILABLE
	;; --------------------[STATE: BROWSED PATCH = BS PATCH ]------------------------------
	;; --------------------[CHECK: BANKSTICK AVAILABLE?     ]------------------------------
	;; 1) CHECK IF BANKSTICK IS AVAILABLE
	;; ------------------------------------------------------
	;; 1a) PREPARE THE: "IS THE BANKSTICK FORMATTED?" HANDLING
	;; ------------------------------------------------------
	;; DO: READ BANKSTICK ADR0 (BANKSTICK PATCH Nr.1 FINGERPRINT)
	;; ------------------------------------------------------
	;; call MIOS_BANKSTICK_Read
	;; DESCRIPTION: reads a byte from BankStick.
	;; IN 	address in MIOS_PARAMETER[12] (0x0000-0xffff)
	;; OUT	BankStick content in WREG MIOS_PARAMETER[12] will be incremented
	clrf MIOS_PARAMETER1
	clrf MIOS_PARAMETER2
	call MIOS_BANKSTICK_Read
		
		;; ------------------------------------------
		;; Save BANKSTICK1 PATCH1 Fingerprint (Byte)
		;; FOR "IS THE BANKSTICK FORMATTED?" HANDLING
		;; ------------------------------------------
		movwf	VAR_TMP_PATCH_DATA_CLIPBOARD
		
	;; NOW (AFTER READING BS ADR 0) WE CAN CHECK IF BANKSTICK1 IS AVAILABLE
	;; BRANCH IF BANKSTICK1 IS NOT PRESENT
	;; ----------------------------------------------------------------------------------------------------
	;; -----------------------[JUMP: IF BANKSTICK IST *NOT* AVAILABLE]-------------------------------------
	;; ----------------------------------------------------------------------------------------------------
	BRA_IFCLR MIOS_BOX_STAT, MIOS_BOX_STAT_BS_AVAILABLE, ACCESS, MENU1_BANKSTICK_NOT_AVAILABLE
		
		;; --------------------[STATE: BROWSED PATCH = BS PATCH ]------------------------------
		;; --------------------[STATE: BANKSTICK AVAILABLE      ]------------------------------
		;; GO ON WITH BANKSTICK HANDLING
		rgoto MENU1_BANKSTICK_AVAILABLE

;; ---------------------------[END: CHECK BANKSTICK AVAILABLE]------------------------------------------
;; -----------------------------------------------------------------------------------------------------
	
;; -----------------------------------------------------------------------------------------------------
;; ---------------------------[HANDLING: BANKSTICK NOT AVAILABLE       ]--------------------------------
MENU1_BANKSTICK_NOT_AVAILABLE
	;; PRINT "[-NO BANSTICK-]" on LCD ROW1 (!)
	TABLE_ADDR TEXT_AY_MB_AY_PATCH_NO_BS
	call    MIOS_LCD_PrintString

	;; REDRAW ROW2 on LCD
	TABLE_ADDR LCD_CLEAR_ROW2
	call    MIOS_LCD_PrintString
		
	;; PRINT "NR." ON LCD ROW2
	TABLE_ADDR TEXT_AY_MB_AY_PATCH_NR
	call    MIOS_LCD_PrintString
				
	;; ITEM PATCH NAME SELECTED BY THE USER?
	;; IS BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO = 1?
	;; FOR "[-NO BANSTICK1-]" on LCD ROW1 (!)
	;; POS1 IS NOT A VALID POS for EDITING MODE WHEN A BANKSTICK1 IS *NOT* AVAILABLE
	movff 	BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw 	CONST_MENU_ITEM_POS1
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD ;; COMPARE F WITH WREG
			;; NO
			;; POS < > 1
			;; OK, GO ON AND CHECK POS2
			rgoto MENU1_BANKSTICK_NOT_AVAILABLE_CHK_POS2

		;; YES
		;; POS = 1
		;; EDITING MODE @ PATCH NAME
		;; ITS NOT A VALID POS
		;; SO SET POS TO POS2
		movlw  CONST_MENU_ITEM_POS2
		movwf  VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff  VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO
		
		;; PRINT EDITING MODE ">" ON POS2
		movlw 	CSR_POS_MENU1_ITEM2
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU1_ITEM2
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
				
		;; GO AND REWRITE PATCH NUMBER @ POS2 on LCD
		goto  MENU1_BANKSTICK_NOT_AVAILABLE_PRINT_PATCH_NUMBER
		
		;; ------------------[HANDLING: BANKSTICK NOT AVAILABLE - POS2]-------------------------
		;; ------------------[CHECK: POS2 (PATCH NUMBER) = in EDITING MODE?]--------------------
MENU1_BANKSTICK_NOT_AVAILABLE_CHK_POS2
	;; EDITING MODE @ PATCH NUMBER? (POS2)
	;; IS BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO = 2?
	;; IF POS = ITEM2
	;; WE MUST PRINT ACTIVE POS = ">" @ ITEM2 (PATCH NUMBER)
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw 	CONST_MENU_ITEM_POS2
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD ;; COMPARE F WITH WREG
			
			;; NO
			;; POS < > 2
			;; PATCH NUMBER IS NOT in EDITING MODE
			rgoto MENU1_BANKSTICK_NOT_AVAILABLE_PRINT_PATCH_NUMBER

		;; YES
		;; POS = 2
		;; ITEM: PATCH NUMBER is in EDITING MODE
		;; PRINT ">" ON POS2
		movlw 	CSR_POS_MENU1_ITEM2
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU1_ITEM2
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR

		
		;; -----------------[STATE: EDITING MODE @ POS2 (PATCH NUMBER)         ]----------------
		;; -----------------[STATE: NO BANKSTICK AVAILABLE                     ]----------------
MENU1_BANKSTICK_NOT_AVAILABLE_PRINT_PATCH_NUMBER
		;; -----------------[DO   : PRINT PATCH NUMBER on LCD ROW2             ]----------------
		movlw   LCD_ROW2 + 9
		call    MIOS_LCD_CursorSet
		movff	BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movf    VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
		call    MIOS_LCD_PrintBCD3
        
        ;; -----------------[DO   : PRINT [ ] on LCD ROW2                      ]----------------	
		movlw 	LCD_ROW2 + 8
		call    MIOS_LCD_CursorSet
		movlw   '['
		call    MIOS_LCD_PrintChar

		movlw 	LCD_ROW2 + 12
		call    MIOS_LCD_CursorSet
		movlw   ']'
		call    MIOS_LCD_PrintChar

		;; -----------------[DO   : DELITE [LOAD WRITE FORMAT] @ LCD ROW4    ]----------------		
		;; LCD ROW 4 @ MAIN MENU1 = PATCH STATUS INFORMATION
		;; THERE IS NOTHING THE USER CAN DO, IF THERE IS NO BANKSTICK
		;; DEL [LOAD WRITE FORMAT] on LCD ROW4 
		TABLE_ADDR TEXT_MENU_1_PATCH_NO_LT_SAV_FMT
		call    MIOS_LCD_PrintString

		;; ALL DONE - EXIT HERE
		return
		

;; --------------------[END - HANDLING: NO BANKSTICK                               ]-------------------
;; ----------------------------------------------------------------------------------------------------
		

;; ----------------------------------------------------------------------------------------------------
;; --------------------[HANDLING BANKSTICK FOUND                                   ]-------------------			
MENU1_BANKSTICK_AVAILABLE				
;; --------------------------------[STATE: BANKSTICK IS AVAILABLE                  ]-------------------
;; --------------------------------[DO   : CHECK: FINGERPRINT                      ]-------------------
			;; CHECK IF THERE IS THE BANKSTICK FINGERPRINT
			;; BIT1 = 1 = CURRENT PATCH FINGERPRINT FOUND
			;; BIT1 = 0 = CURRENT PATCH FINGERPRINT NOT FOUND
			movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
					;; -------------------------------------------------
					;; ----[STATE: BANKSTICK IS *NOT* FORMATTED]--------
					;; -------------------------------------------------
					;; NO
					;; BANKSTICK_EEPROM_FINGERPRINT < > VAR_TMP_PATCH_DATA_CLIPBOARD
					;; SO THE BANKSTICK IS NOT FORMETTED!
					rgoto	MENU1_BANKSTICK_AVAILABLE_NO_FINGERPRINT
				
				;; YES
				;; ----------------------------------------------------
				;; -----[STATE: BANKSTICK IS FORMATTED     ]-----------
				;; -----[STATE: BANKSTICK PATCH IS OK      ]-----------
				;; -----[STATE: USER CAN WRITE LOAD FORMAT ]-----------
				;; ----------------------------------------------------
				;; WRITE F1 F2 F3 ON LCD ROW3
				TABLE_ADDR TEXT_AY_MB_AY_PATCH_F1
				call    MIOS_LCD_PrintString
				TABLE_ADDR TEXT_AY_MB_AY_PATCH_F2
				call    MIOS_LCD_PrintString
				TABLE_ADDR TEXT_AY_MB_AY_PATCH_F8
				call    MIOS_LCD_PrintString
				;; PRINT "Load Write Format" on LCD ROW4	
				TABLE_ADDR TEXT_MENU_1_PATCH_LOAD_SAFE_FORMAT
				call    MIOS_LCD_PrintString

				;; CS HANDLING
				call	LED_F1_on
				call	LED_F2_on
				call	LED_F8_on
				
				;; EXIT HERE
				return


;; --------------------[END: CHECKING BANKSTICK FINGERPRINT]-------------------------------------------			
;; ----------------------------------------------------------------------------------------------------


;; ----------------------------------------------------------------------------------------------------
;; --------------------[STATE: BANKSTICK IS AVAILABLE BUT NOT FORMATTED ]------------------------------
MENU1_BANKSTICK_AVAILABLE_NO_FINGERPRINT
				;; IF BS IS NOT FORMATTED ROW1 IS NOT A VALID CURSOR POS (!)
				;; BECAUSE THERE WILL BE A "DO FORMAT BANKSTICK" MASSAGE on LCD @ ROW1
				;; ----[DO CHECK: CURRENT CURSOR POS = 1? ]--------------------------------------------
				movff 	BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
				movlw 	CONST_MENU_ITEM_POS1
				cpfsgt 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD ;; EDITING MODE ITEM  = 1?

							;; NO
							;; CURSOR POS = 1 
							;; CURSOR POS NOT VALID
							rgoto MENU1_POS_1_NOT_VALID_GO_POS_2
						
						;; YES
						;; POS > 1
						;; CURSOR POS IS VALID
						rgoto MENU1_BANKSTICK_AVAILABLE_BUT_NOT_FORMATED
						

		;; ----------------[STATE: BANKSTICK IS AVAILABLE BUT NOT FORMATTED]---------------------------
MENU1_POS_1_NOT_VALID_GO_POS_2		
		;; ----------------[STATE: POS = POS1                              ]---------------------------
		;; ----------------[STATE: POS1 IS NOT VALID                       ]---------------------------
		;; ----------------[DO   : SET CURSOR POS = 2                      ]---------------------------
		movlw	CONST_MENU_ITEM_POS2
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO
		
		;; ----------------[DO   : PRINT ">" CURSOR POS @ LCD ROW 2        ]---------------------------
		movlw 	CSR_POS_MENU1_ITEM2
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU1_ITEM2
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
				
		;; ---------------[DO: UPDATE LCD - JUST BS FORMATTING POSSIBLE    ]---------------------------
MENU1_BANKSTICK_AVAILABLE_BUT_NOT_FORMATED
		;; ---------------[STATE: BANKSTICK IS AVAILABLE BUT NOT FORMATTED ]---------------------------
		;; ---------------[STATE: NO PATCH WRITING POSSIBLE                ]---------------------------
		;; ---------------[STATE: NO PATCH LOADING POSSIBLE                ]---------------------------
		;; ---------------[STATE: JUST BANKSTICK FORMATTING POSSIBLE       ]---------------------------
				;; PRINT [-FORMATTING?!-] on LCD ROW1
				TABLE_ADDR TEXT_AY_MB_AY_BANKSTICK_NOT_FORMATED
				call    MIOS_LCD_PrintString
				;; -[STATE: NOW ROW1 is NOT a ITEM anymore                 ]--------------------------- 
				;; -[(NOW THERE IS JUST A INFO MASSAGE ON LCD ROW1)        ]---------------------------
				;; -[STATE: NO PATCH LOADING POSSIBLE                      ]---------------------------
				;; -[STATE: NO PATCH WRITING POSSIBLE                      ]---------------------------
				;; -[STATE: JUST FORMATING BS IS POSSIBLE                  ]---------------------------	
				
				;; CLEAR LCD ROW3
				TABLE_ADDR LCD_CLEAR_ROW3
				call    MIOS_LCD_PrintString			
				;; -[DO:  PRINT "---- ---- F3    " on LCD ROW3             ]---------------------------
				TABLE_ADDR TEXT_AY_MB_AY_PATCH_F8
				call    MIOS_LCD_PrintString
				;; -[DO:  PRINT "---- ---- Format" on LCD ROW4             ]---------------------------
				TABLE_ADDR TEXT_MENU_1_JUST_FORMAT
				call    MIOS_LCD_PrintString
				
				;; CS LED HANDLING
				call	LED_F1_off
				call	LED_F2_off
				call	LED_F8_on

				
				;; EXIT HERE					
				return
				
;; ----------------------------------------------------------------------------------------------------
;; ------------------------[END: BANKSTICK IS AVAILABLE BUT NOT FORMATTED]-----------------------------
;; ----------------------------------------------------------------------------------------------------
