
MINUS_BTN_MENU7
	;; FUNCTION
	;; VALUE MINUS BTN HAS BEEN PRESSED @ MENU 7
	;; HANDLE VELOCITY @ TONE ABC ON/OFF
	;; HANDLE VELOCITY @ NOISE FREQUENCY = OFF/A/B/C
	
	;; CHECK SELECTED ITEM POS
	;; AND JUMP TO ITEM HANDLING
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_VELOCITY_CONFIG, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movf  VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
	JUMPTABLE_4BYTES 5 ;; [ITEM 1 to 4 JUMP, ITEM 0 = NOT VALID]
		goto MENUE_SWITCH_DO										;; POS0 - NOT VALID - EXIT HERE TO MAIN MENU
		goto MINUS_BTN_MENU7_CLR_VELOCITY_TO_A				;; POS1 - SWITCH OFF VELOCITY TO TONE A
		goto MINUS_BTN_MENU7_CLR_VELOCITY_TO_B				;; POS2 - SWITCH OFF VELOCITY TO TONE B
		goto MINUS_BTN_MENU7_CLR_VELOCITY_TO_C				;; POS1 - SWITCH OFF VELOCITY TO TONE C
		goto MINUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_PERIOD 	;; POS4 - SWITCH OFF VELOCITY NOISE PERIOD


MINUS_BTN_MENU7_CLR_VELOCITY_TO_A	
	;; ITEM POS1 - SET VELOCITY TO TONE A (MIDI VELOCITY DATA TO VOLUME OF TONE A)
	;; CLR VELOCITY TO TONE A BIT
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT0_TONE_A_ON_OFF
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO


MINUS_BTN_MENU7_CLR_VELOCITY_TO_B	
	;; POS2 - SET VELOCITY TO TONE B
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT1_TONE_B_ON_OFF
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO


MINUS_BTN_MENU7_CLR_VELOCITY_TO_C
	;; POS1 - SET VELOCITY TO TONE C
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT2_TONE_C_ON_OFF
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO

;; ---- [VELOCITY TO NOISE PERIOD - SWITCH VELOCITY NOISE PERIOD TO TONE C to B to A]-------
MINUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_PERIOD
	;; MEMO
	;; VELOCITY 			=> NOISE PERIOD:
	;; VELOCITY 	      	=> NOISE PERID is OFF	==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=0, BIT5=0,BIT6=0,BIT7=0
	;; VELOCITY of TONE A 	=> NOISE PERIOD 		==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=1, BIT5=1,BIT6=0,BIT7=0 
	;; VELOCITY of TONE B 	=> NOISE PERIOD 		==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=1, BIT5=0,BIT6=1,BIT7=0 
	;; VELOCITY of TONE C 	=> NOISE PERIOD 		==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=1, BIT5=0,BIT6=0,BIT7=1 
	
	;; CHECK IF BIT3 is SET
	;; IS VELOCITY TO NOISE PERIOD = ON?
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF
		;; NO, BIT3 IS NOT SET
		;; NOTHIG TO DO
		;; EXIT HERE
		return
	
		;; YES - BIT3 IS SET - CHECK IF NOISE PERID VELOCITY @ TONE A IS SET
		rgoto MINUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_A


MINUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_A
		;; VELOCITY TO NOISE PERID = ON
		;; CHECK IF BIT5 [TONE A] is SET
		btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF
			;; NO, BIT5 IS NOT SET - CHECK IF VELOCITY @ TONE B BIT6 IS SET
			rgoto MINUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_B
	
			;; YES - BIT5 IS SET, SO SWITCH OFF VELOCITY @ NOISE RATE
			rgoto MINUS_BTN_MENU7_VELOCITY_TO_NOISE_OFF


MINUS_BTN_MENU7_VELOCITY_TO_NOISE_OFF
	;; VELOCITY TONE A to NOISE PERID was SET
	;; BUT THERE HAD BEEN A [-] KEY EVENT SO SWITCH OFF
	;; VELOCITY to NOISE PERIOD
	;; MEMO:
	;; VELOCITY => NOISE PERIOD:
	;; VELOCITY 	      => NOISE PERID is OFF	==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=0, BIT5=0,BIT6=0,BIT7=0
	;; VELOCITY of TONE A => NOISE PERIOD 		==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=1, BIT5=1,BIT6=0,BIT7=0 
	;; VELOCITY of TONE B => NOISE PERIOD 		==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=1, BIT5=0,BIT6=1,BIT7=0 
	;; VELOCITY of TONE C => NOISE PERIOD 		==> VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF: BIT3=1, BIT5=0,BIT6=0,BIT7=1 
	;; SWITCH OFF VELOCITY @ NOISE RATE
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF
	;; SWITCH OFF VELOCITY TONE A
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF
	;; SWITCH OFF VELOCITY TONE B
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF
	;; SWITCH OFF VELOCITY TONE C
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_VELOCITY_C_TO_NOISE_PERIOD_ON_OFF
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO


MINUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_B
	;; CHECK IF BIT6 [TONE B] is SET
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF
		;; NO, BIT6 IS NOT SET - ITS MUST BE TONE C 
		;; MUST BE BIT 7 - TONE C 
		rgoto MINUS_BTN_MENU7_VELOCITY_IS_NOISE_CH_B
	
		;; YES - BIT6 IS SET, SO IT IS TONE B @ NOISE PERIOD
		;; TONE A MUST BE VELOCITY FOR NOISE PERIOD 
		rgoto MINUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_A

MINUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_A
	;; SET VELOCITY TONE B TO NOISE PERIOD
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH ON VELOCITY TONE A
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE B
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_VELOCITY_C_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE C
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO

MINUS_BTN_MENU7_VELOCITY_IS_NOISE_CH_B
	;; SET VELOCITY TONE B TO NOISE PERIOD
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE A
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH ON  VELOCITY TONE B
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_VELOCITY_C_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE C
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO
