;; -------------[SET VELOCITY TO TONE ABC + NOISE PERIOD @ MAIN MENU7 - VELOCITY CONTROL]-------------
PLUS_BTN_MENU7
	;; FUNCTION
	;; VALUE PLUS BTN HAS BEEN PRESSED @ MENU 7
	;; HANDLE VELOCITY @ TONE ABC ON/OFF
	;; HANDLE VELOCITY @ NOISE FREQUENCY = OFF/A/B/C

	;; CHECK SELECTED ITEM
	;; AND JUMP TO THE ITEM HANDLING
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_VELOCITY_CONFIG, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movf  VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
	JUMPTABLE_4BYTES 5 ;; [ITEM 1 to 4 JUMP, ITEM 0 = NOT VALID]
		goto MENUE_SWITCH_DO												;; POS0 - EXIT HERE TO MAIN MENU
		goto PLUS_BTN_MENU7_SET_VELOCITY_TO_A				;; POS1 - SET VELOCITY TO TONE A
		goto PLUS_BTN_MENU7_SET_VELOCITY_TO_B				;; POS2 - SET VELOCITY TO TONE B
		goto PLUS_BTN_MENU7_SET_VELOCITY_TO_C				;; POS3 - SET VELOCITY TO TONE C
		goto PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_PERIOD 	;; POS4 - SET VELOCITY NOISE PERIOD


PLUS_BTN_MENU7_SET_VELOCITY_TO_A	
	;; ITEM POS1 - SET VELOCITY TO TONE A (MIDI VELOCITY DATA TO VOLUME OF TONE A)
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT0_VELOCITY_ON_OFF_TONE_A
	;; RELOAD MENU 7
	goto MENUE_SWITCH_DO


PLUS_BTN_MENU7_SET_VELOCITY_TO_B	
	;; POS2 - SET VELOCITY TO TONE B
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT1_VELOCITY_ON_OFF_TONE_B
	;; RELOAD MENU 7
	goto MENUE_SWITCH_DO

PLUS_BTN_MENU7_SET_VELOCITY_TO_C
	;; POS1 - SET VELOCITY TO TONE C
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT2_VELOCITY_ON_OFF_TONE_C
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO


;; ---- [VELOCITY TO NOISE PERIOD - SWITCH VELOCITY NOISE PERIOD TO VELOCITY FROM TONE AB or C]-------
PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_PERIOD
	;; CHECK IF BIT3 is SET
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF
		;; NO, BIT3 IS NOT SET
		;; SO SET BIT3 AND BIT5 => SET VELOCITY = TONE A  
		rgoto PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_A
	
		;; YES - BIT3 IS SET - CHECK IF VELOCITY IS TONE A
		rgoto PLUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_A

PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_A
	;; SET VELOCITY TONE A TO NOISE PERIOD
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF  ;; VELOCITY TO NOISE RATE ON
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF;; Take VELOCITY from A
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_VELOCITY_C_TO_NOISE_PERIOD_ON_OFF
	;; RELOAD MENU 7
	goto MENUE_SWITCH_DO

PLUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_A
	;; IS BIT5 [TONE A] = SET?
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF
		;; NO, BIT5 IS NOT SET - VELOCITY IS NOT TONE A @ NIOSE PERIOD
		rgoto PLUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_B
	
		;; YES - BIT5 IS SET, SO IT IS TONE A @ NOISE PERIOD
		;; SWITCH TO TONE B - TONE B MUST BE VELOCITY FOR NOISE PERIOD 
		rgoto PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_B

PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_B
	;; VELOCITY TO NOISE RATE ON
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF  
	;; SET VELOCITY TONE B TO NOISE PERIOD
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE A
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH ON  VELOCITY TONE B
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_VELOCITY_C_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE C
	;; RELOAD MENU 7
	goto MENUE_SWITCH_DO

PLUS_BTN_MENU7_CHK_VELOCITY_NOISE_CH_B
	;; CHECK IF BIT6 [TONE B] is SET
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, 6
		;; NO, BIT6 IS NOT SET - BIT7 WAS ALREADY SET
		;; NOTHIG TO DIO ANYMORE
		return
	
		;; YES - BIT6 IS SET, SO IT IS TONE B @ NOISE PERIOD
		;; SET THE TONE C VELOCITY = NOISE PERIOD BIT 
		rgoto PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_C

PLUS_BTN_MENU7_SET_VELOCITY_TO_NOISE_CH_C
	;; VELOCITY TO NOISE RATE ON
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF  
	;; SET VELOCITY TONE C TO NOISE PERIOD
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE A
	bcf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH OFF VELOCITY TONE B
	bsf	VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_VELOCITY_C_TO_NOISE_PERIOD_ON_OFF  ;; SWITCH ON  VELOCITY TONE C
	;; WORK IS DONE BACK TO MAIN MENU
	goto MENUE_SWITCH_DO



